/*
 * Decompiled with CFR 0.152.
 */
package org.beangle.commons.lang.time;

import java.io.Serializable;
import org.beangle.commons.lang.time.TimerNode;
import org.beangle.commons.lang.time.TimerStack;
import org.beangle.commons.logging.Logger$;
import org.beangle.commons.logging.Logging;
import org.slf4j.Logger;
import scala.Function0;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.Statics;

public final class TimerTrace$
implements Logging,
Serializable {
    private static Logger logger;
    private static ThreadLocal curStack;
    private static final String ACTIVATE_PROPERTY;
    private static final String MIN_TIME;
    private static boolean active;
    private static int mintime;
    public static final TimerTrace$ MODULE$;

    private TimerTrace$() {
    }

    static {
        MODULE$ = new TimerTrace$();
        Logging.$init$(MODULE$);
        curStack = new ThreadLocal();
        ACTIVATE_PROPERTY = "beangle.profile.activate";
        MIN_TIME = "beangle.profile.mintime";
        active = "true".equalsIgnoreCase(System.getProperty(MODULE$.ACTIVATE_PROPERTY()));
        try {
            mintime = Integer.parseInt(System.getProperty(MODULE$.MIN_TIME(), "0"));
        }
        catch (NumberFormatException numberFormatException) {}
        Statics.releaseFence();
    }

    @Override
    public Logger logger() {
        return logger;
    }

    @Override
    public void org$beangle$commons$logging$Logging$_setter_$logger_$eq(Logger x$0) {
        logger = x$0;
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(TimerTrace$.class);
    }

    public ThreadLocal<TimerStack> curStack() {
        return curStack;
    }

    public void curStack_$eq(ThreadLocal<TimerStack> x$1) {
        curStack = x$1;
    }

    public String ACTIVATE_PROPERTY() {
        return ACTIVATE_PROPERTY;
    }

    public String MIN_TIME() {
        return MIN_TIME;
    }

    public boolean active() {
        return active;
    }

    public void active_$eq(boolean x$1) {
        active = x$1;
    }

    public void start(String name) {
        if (!this.active()) {
            return;
        }
        TimerNode root = new TimerNode(name, System.currentTimeMillis());
        TimerStack stack = this.curStack().get();
        if (stack == null) {
            this.curStack().set(new TimerStack(root));
            return;
        }
        stack.push(root);
    }

    public void end() {
        if (!this.active()) {
            return;
        }
        TimerStack stack = this.curStack().get();
        if (stack == null) {
            return;
        }
        TimerNode currentNode = stack.pop();
        if (currentNode != null) {
            TimerNode parent = stack.peek();
            long total = currentNode.end();
            if (parent == null) {
                this.printTimes(currentNode);
                this.curStack().set(null);
                return;
            }
            if (total > (long)mintime) {
                parent.children().$plus$eq((Object)currentNode);
                return;
            }
            return;
        }
    }

    private void printTimes(TimerNode currentTimer) {
        Logger$.MODULE$.info$extension(this.logger(), (Function0<String>)((Function0 & Serializable)() -> TimerTrace$.printTimes$$anonfun$1(currentTimer)));
    }

    public int getMinTime() {
        return mintime;
    }

    public void setMinTime(int mintime) {
        System.setProperty(this.MIN_TIME(), String.valueOf(mintime));
        TimerTrace$.mintime = mintime;
    }

    public void setActive(boolean active) {
        String string = active ? System.setProperty(this.ACTIVATE_PROPERTY(), "true") : System.clearProperty(this.ACTIVATE_PROPERTY());
        this.active_$eq(active);
    }

    public boolean isActive() {
        return this.active();
    }

    public void clear() {
        this.curStack().set(null);
    }

    private static final String printTimes$$anonfun$1(TimerNode currentTimer$1) {
        return currentTimer$1.getPrintable();
    }
}

