/*
 * Decompiled with CFR 0.152.
 */
package org.beangle.commons.lang.time;

import java.io.Serializable;
import java.time.LocalDate;
import org.beangle.commons.lang.time.HourMinute;
import org.beangle.commons.lang.time.WeekDay;
import org.beangle.commons.lang.time.WeekDay$;
import org.beangle.commons.lang.time.WeekState;
import org.beangle.commons.lang.time.WeekState$;
import org.beangle.commons.lang.time.WeekTime;
import org.beangle.commons.lang.time.Weeks$;
import scala.Int$;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.collection.mutable.HashMap;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ObjectRef;

public final class WeekTime$
implements Serializable {
    public static final WeekTime$ MODULE$ = new WeekTime$();

    private WeekTime$() {
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(WeekTime$.class);
    }

    public WeekTime of(LocalDate startOn, HourMinute beginAt, HourMinute endAt) {
        WeekTime time = this.of(startOn);
        time.beginAt_$eq(beginAt);
        time.endAt_$eq(endAt);
        return time;
    }

    public WeekTime of(LocalDate ld) {
        LocalDate yearStartOn = this.getStartOn(ld.getYear(), WeekDay$.MODULE$.of(ld));
        WeekTime weektime = new WeekTime();
        weektime.startOn_$eq(yearStartOn);
        weektime.weekstate_$eq(WeekState$.MODULE$.of(Weeks$.MODULE$.between(yearStartOn, ld) + 1));
        return weektime;
    }

    public LocalDate getStartOn(int year, WeekDay weekday) {
        LocalDate startDate = LocalDate.of(year, 1, 1);
        while (startDate.getDayOfWeek().getValue() != weekday.id()) {
            startDate = startDate.plusDays(1L);
        }
        return startDate;
    }

    public WeekTime.Builder newBuilder(LocalDate startOn, WeekDay firstDay) {
        LocalDate endOn = startOn;
        WeekDay weekendDay = firstDay.previous();
        while (endOn.getDayOfWeek().getValue() != weekendDay.id()) {
            endOn = endOn.plusDays(1L);
        }
        return new WeekTime.Builder(startOn, endOn);
    }

    public static final /* synthetic */ boolean org$beangle$commons$lang$time$WeekTime$Builder$$_$build$$anonfun$1(IntRef minWeek$1, int week) {
        return week >= minWeek$1.elem;
    }

    public static final /* synthetic */ void org$beangle$commons$lang$time$WeekTime$Builder$$_$build$$anonfun$2(ObjectRef startDate$1, WeekDay weekday$1, HashMap times$1, int week) {
        WeekTime weekTime;
        LocalDate oneday = ((LocalDate)startDate$1.elem).plusWeeks(Int$.MODULE$.int2long(week - 1));
        int year = oneday.getYear();
        LocalDate yearStartOn = MODULE$.getStartOn(year, weekday$1);
        Option option = times$1.get((Object)BoxesRunTime.boxToInteger((int)year));
        if (None$.MODULE$.equals(option)) {
            WeekTime wt = new WeekTime();
            times$1.put((Object)BoxesRunTime.boxToInteger((int)year), (Object)wt);
            wt.startOn_$eq(yearStartOn);
            wt.weekstate_$eq(new WeekState(0L));
            weekTime = wt;
        } else if (option instanceof Some) {
            WeekTime wt;
            weekTime = wt = (WeekTime)((Some)option).value();
        } else {
            throw new MatchError((Object)option);
        }
        WeekTime weektime = weekTime;
        weektime.weekstate_$eq(weektime.weekstate().$bar(WeekState$.MODULE$.of(Weeks$.MODULE$.between(yearStartOn, oneday) + 1)));
    }
}

