/*
 * Decompiled with CFR 0.152.
 */
package org.beangle.commons.net.http;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import org.beangle.commons.codec.binary.Base64$;
import org.beangle.commons.io.IOs$;
import org.beangle.commons.lang.Charsets$;
import org.beangle.commons.logging.Logger$;
import org.beangle.commons.logging.Logging;
import org.beangle.commons.net.http.HttpMethods$;
import org.beangle.commons.net.http.Https$;
import org.beangle.commons.net.http.ResourceStatus;
import org.beangle.commons.net.http.ResourceStatus$;
import org.beangle.commons.net.http.Response;
import org.beangle.commons.net.http.Response$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some$;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.immutable.Seq;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.function.JProcedure1;

public final class HttpUtils$
implements Logging,
Serializable {
    private static Logger logger;
    private static final int Timeout;
    private static final scala.collection.immutable.Map<Object, String> statusMap;
    public static final HttpUtils$ MODULE$;

    private HttpUtils$() {
    }

    static {
        MODULE$ = new HttpUtils$();
        Logging.$init$(MODULE$);
        Timeout = 10000;
        Object[] objectArray = new Tuple2[4];
        Integer n = (Integer)Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)200));
        objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)n, (Object)"OK");
        Integer n2 = (Integer)Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)403));
        objectArray[1] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)n2, (Object)"Access denied!");
        Integer n3 = (Integer)Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)404));
        objectArray[2] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)n3, (Object)"Not Found");
        Integer n4 = (Integer)Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)401));
        objectArray[3] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)n4, (Object)"Access denied");
        statusMap = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
        Statics.releaseFence();
    }

    @Override
    public Logger logger() {
        return logger;
    }

    @Override
    public void org$beangle$commons$logging$Logging$_setter_$logger_$eq(Logger x$0) {
        logger = x$0;
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(HttpUtils$.class);
    }

    public String toString(int httpCode) {
        return (String)statusMap.getOrElse((Object)BoxesRunTime.boxToInteger((int)httpCode), () -> HttpUtils$.toString$$anonfun$1(httpCode));
    }

    public boolean isAlive(String url) {
        return this.access(url).isOk();
    }

    public ResourceStatus access(String url) {
        return this.access(URI.create(url).toURL());
    }

    public ResourceStatus access(URL url) {
        ResourceStatus resourceStatus;
        block3: {
            try {
                int rc;
                HttpURLConnection hc = this.followRedirect(url.openConnection(), HttpMethods$.MODULE$.HEAD());
                int n = rc = hc.getResponseCode();
                if (200 == n) {
                    boolean supportRange = "bytes".equals(hc.getHeaderField("Accept-Ranges"));
                    resourceStatus = ResourceStatus$.MODULE$.apply(rc, hc.getURL(), hc.getHeaderFieldLong("Content-Length", 0L), hc.getLastModified(), supportRange);
                    break block3;
                }
                resourceStatus = ResourceStatus$.MODULE$.apply(rc, hc.getURL(), -1L, -1L, false);
            }
            catch (Exception exception) {
                resourceStatus = ResourceStatus$.MODULE$.apply(404, url, -1L, -1L, false);
            }
        }
        return resourceStatus;
    }

    public HttpURLConnection followRedirect(URLConnection c, String method) {
        HttpURLConnection conn;
        block4: while (true) {
            int rc;
            conn = (HttpURLConnection)c;
            this.requestBy(conn, method);
            conn.setInstanceFollowRedirects(false);
            Https$.MODULE$.noverify(conn);
            int n = rc = conn.getResponseCode();
            switch (n) {
                case 200: {
                    return conn;
                }
                case 301: 
                case 302: {
                    String newLoc = conn.getHeaderField("location");
                    c = URI.create(newLoc).toURL().openConnection();
                    continue block4;
                }
            }
            break;
        }
        return conn;
    }

    public Response getData(String urlString, String method) {
        return this.getData(URI.create(urlString).toURL(), method, (Option<Function1<HttpURLConnection, BoxedUnit>>)None$.MODULE$);
    }

    public String getData$default$2() {
        return HttpMethods$.MODULE$.GET();
    }

    public Response getData(URL url, String method, String username, String password) {
        return this.getData(url, method, (Option<Function1<HttpURLConnection, BoxedUnit>>)Some$.MODULE$.apply((JProcedure1 & Serializable)x -> x.addRequestProperty("Authorization", "Basic " + Base64$.MODULE$.encode((username + ":" + password).getBytes()))));
    }

    public Response getData(URL url, String method, Option<Function1<HttpURLConnection, BoxedUnit>> f) {
        Response response;
        block7: {
            ObjectRef conn = ObjectRef.create(null);
            try {
                try {
                    conn.elem = (HttpURLConnection)url.openConnection();
                    this.requestBy((HttpURLConnection)conn.elem, method);
                    ((HttpURLConnection)conn.elem).setUseCaches(false);
                    ((HttpURLConnection)conn.elem).setDoOutput(false);
                    Https$.MODULE$.noverify((HttpURLConnection)conn.elem);
                    f.foreach((Function1)(JProcedure1 & Serializable)x -> x.apply((Object)((HttpURLConnection)conn$1.elem)));
                    if (((HttpURLConnection)conn.elem).getResponseCode() == 200) {
                        ByteArrayOutputStream bos = new ByteArrayOutputStream();
                        IOs$.MODULE$.copy(((HttpURLConnection)conn.elem).getInputStream(), bos);
                        response = Response$.MODULE$.apply(((HttpURLConnection)conn.elem).getResponseCode(), bos.toByteArray());
                        break block7;
                    }
                    response = Response$.MODULE$.apply(((HttpURLConnection)conn.elem).getResponseCode(), ((HttpURLConnection)conn.elem).getResponseMessage());
                }
                catch (Exception e) {
                    response = this.error(url, e);
                }
            }
            finally {
                if ((HttpURLConnection)conn.elem != null) {
                    ((HttpURLConnection)conn.elem).disconnect();
                }
            }
        }
        return response;
    }

    public Response getText(String urlString) {
        return this.getText(URI.create(urlString).toURL(), HttpMethods$.MODULE$.GET(), Charsets$.MODULE$.UTF_8(), (Option<Function1<URLConnection, BoxedUnit>>)None$.MODULE$);
    }

    public Response getText(URL url, String method, Charset encoding) {
        return this.getText(url, method, encoding, (Option<Function1<URLConnection, BoxedUnit>>)None$.MODULE$);
    }

    public Response getText(URL url, String method, Charset encoding, String username, String password) {
        return this.getText(url, method, encoding, (Option<Function1<URLConnection, BoxedUnit>>)Some$.MODULE$.apply((JProcedure1 & Serializable)x -> x.addRequestProperty("Authorization", "Basic " + Base64$.MODULE$.encode((username + ":" + password).getBytes()))));
    }

    public Response getText(URL url, String method, Charset encoding, Option<Function1<URLConnection, BoxedUnit>> f) {
        Response response;
        block9: {
            ObjectRef conn = ObjectRef.create(null);
            BufferedReader in = null;
            try {
                try {
                    conn.elem = (HttpURLConnection)url.openConnection();
                    this.requestBy((HttpURLConnection)conn.elem, method);
                    ((HttpURLConnection)conn.elem).setDoOutput(false);
                    ((HttpURLConnection)conn.elem).setUseCaches(false);
                    Https$.MODULE$.noverify((HttpURLConnection)conn.elem);
                    f.foreach((Function1)(JProcedure1 & Serializable)x -> x.apply((Object)((HttpURLConnection)conn$2.elem)));
                    if (((HttpURLConnection)conn.elem).getResponseCode() == 200) {
                        in = new BufferedReader(new InputStreamReader(((HttpURLConnection)conn.elem).getInputStream(), encoding));
                        String line = in.readLine();
                        StringBuilder sb = new StringBuilder(255);
                        while (line != null) {
                            sb.append(line);
                            sb.append("\n");
                            line = in.readLine();
                        }
                        response = Response$.MODULE$.apply(200, sb.toString());
                        break block9;
                    }
                    response = Response$.MODULE$.apply(((HttpURLConnection)conn.elem).getResponseCode(), ((HttpURLConnection)conn.elem).getResponseMessage());
                }
                catch (Exception e) {
                    response = this.error(url, e);
                }
            }
            finally {
                if (in != null) {
                    in.close();
                }
                if ((HttpURLConnection)conn.elem != null) {
                    ((HttpURLConnection)conn.elem).disconnect();
                }
            }
        }
        return response;
    }

    public Response invoke(URL url, Object body, String contentType) {
        return this.invoke(url, body, contentType, (Option<Function1<URLConnection, BoxedUnit>>)None$.MODULE$);
    }

    public Response invoke(URL url, Object body, String contentType, String username, String password) {
        return this.invoke(url, body, contentType, (Option<Function1<URLConnection, BoxedUnit>>)Some$.MODULE$.apply((JProcedure1 & Serializable)x -> x.addRequestProperty("Authorization", "Basic " + Base64$.MODULE$.encode((username + ":" + password).getBytes()))));
    }

    public Response invoke(URL url, Object body, String contentType, Option<Function1<URLConnection, BoxedUnit>> f) {
        Response response;
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        Https$.MODULE$.noverify(conn);
        conn.setDoOutput(true);
        this.requestBy(conn, HttpMethods$.MODULE$.POST());
        conn.setRequestProperty("Content-Type", contentType);
        f.foreach((Function1)(JProcedure1 & Serializable)x -> x.apply((Object)conn));
        OutputStream os = conn.getOutputStream();
        Object object = body;
        if (object instanceof byte[]) {
            byte[] ba = (byte[])object;
            os.write(ba);
        } else if (object instanceof Map) {
            Map params = (Map)object;
            ArrayBuffer paramBuffer = new ArrayBuffer();
            params.foreach((Function1)(JProcedure1 & Serializable)e -> {
                if (e._2() != null) {
                    paramBuffer.addOne((Object)(e._1().toString() + "=" + URLEncoder.encode(e._2().toString(), Charsets$.MODULE$.UTF_8())));
                    return;
                }
            });
            OutputStreamWriter osw = new OutputStreamWriter(os, "UTF-8");
            osw.write(paramBuffer.mkString("&"));
            osw.close();
        } else {
            OutputStreamWriter osw = new OutputStreamWriter(os, "UTF-8");
            osw.write(body.toString());
            osw.flush();
            osw.close();
        }
        os.close();
        try {
            try {
                conn.connect();
                String lines = IOs$.MODULE$.readString(conn.getInputStream(), IOs$.MODULE$.readString$default$2());
                response = Response$.MODULE$.apply(conn.getResponseCode(), lines);
            }
            catch (Exception e2) {
                response = this.error(url, e2);
            }
        }
        finally {
            if (conn != null) {
                conn.disconnect();
            }
        }
        return response;
    }

    public void download(URLConnection c, File location) {
        HttpURLConnection conn = this.followRedirect(c, "GET");
        InputStream input = null;
        FileOutputStream output = null;
        try {
            try {
                File file = new File(location.toString() + ".part");
                file.delete();
                byte[] buffer = new byte[4096];
                input = conn.getInputStream();
                output = new FileOutputStream(file);
                int n = input.read(buffer);
                while (-1 != n) {
                    ((OutputStream)output).write(buffer, 0, n);
                    n = input.read(buffer);
                }
                IOs$.MODULE$.close((Seq<AutoCloseable>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AutoCloseable[]{input, output}));
                input = null;
                output = null;
                if (location.exists()) {
                    location.delete();
                }
                file.renameTo(location);
            }
            catch (Throwable e) {
                Logger$.MODULE$.warn$extension(this.logger(), (Function0<String>)((Function0 & Serializable)() -> HttpUtils$.download$$anonfun$1(location)));
            }
        }
        catch (Throwable throwable) {
            IOs$.MODULE$.close((Seq<AutoCloseable>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AutoCloseable[]{input, output}));
            throw throwable;
        }
        IOs$.MODULE$.close((Seq<AutoCloseable>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AutoCloseable[]{input, output}));
    }

    private Response error(URL url, Exception e) {
        Logger$.MODULE$.info$extension(this.logger(), (Function0<String>)((Function0 & Serializable)() -> HttpUtils$.error$$anonfun$1(url, e)));
        return Response$.MODULE$.apply(404, e.getMessage());
    }

    private void requestBy(HttpURLConnection conn, String method) {
        conn.setConnectTimeout(Timeout);
        conn.setReadTimeout(Timeout);
        conn.setRequestMethod(method);
    }

    private static final String toString$$anonfun$1(int httpCode$1) {
        return String.valueOf(httpCode$1);
    }

    private static final String download$$anonfun$1(File location$1) {
        return "Cannot download file " + location$1;
    }

    private static final String error$$anonfun$1(URL url$1, Exception e$1) {
        return "Cannot open url " + url$1 + " " + e$1.getMessage();
    }
}

