/*
 * Decompiled with CFR 0.152.
 */
package org.beangle.commons.text.i18n;

import java.io.Serializable;
import java.util.Locale;
import org.beangle.commons.text.i18n.TextBundleRegistry;
import org.beangle.commons.text.i18n.TextFormatter;
import org.beangle.commons.text.i18n.TextResource;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Some$;
import scala.collection.immutable.Seq;
import scala.runtime.ObjectRef;

public class DefaultTextResource
implements TextResource {
    private final Locale locale;
    private final TextBundleRegistry registry;
    private final TextFormatter formatter;
    private boolean keyAsDefault;

    public DefaultTextResource(Locale locale, TextBundleRegistry registry, TextFormatter formatter) {
        this.locale = locale;
        this.registry = registry;
        this.formatter = formatter;
        this.keyAsDefault = true;
    }

    @Override
    public Locale locale() {
        return this.locale;
    }

    public TextBundleRegistry registry() {
        return this.registry;
    }

    public TextFormatter formatter() {
        return this.formatter;
    }

    public boolean keyAsDefault() {
        return this.keyAsDefault;
    }

    public void keyAsDefault_$eq(boolean x$1) {
        this.keyAsDefault = x$1;
    }

    @Override
    public String apply(String key, String defaultValue, Seq<Object> args) {
        String text = (String)this.get(key).getOrElse(() -> this.$anonfun$1(defaultValue, key));
        if (text != null && args.nonEmpty()) {
            return this.formatter().format(text, this.locale(), args);
        }
        return text;
    }

    @Override
    public Option<String> apply(String key) {
        Option<String> msg = this.get(key);
        if (msg.isEmpty() && this.keyAsDefault()) {
            return Some$.MODULE$.apply((Object)key);
        }
        return msg;
    }

    public Option<String> get(String key) {
        ObjectRef msg = ObjectRef.create((Object)None$.MODULE$);
        this.registry().getBundles(this.locale()).find((Function1 & Serializable)bundle -> {
            msg$1.elem = bundle.get(key);
            return ((Option)msg$1.elem).isDefined();
        });
        return (Option)msg.elem;
    }

    private final String $anonfun$1(String defaultValue$1, String key$1) {
        if (defaultValue$1 == null && this.keyAsDefault()) {
            return key$1;
        }
        return defaultValue$1;
    }
}

