/*
 * Decompiled with CFR 0.152.
 */
package org.beangle.commons.text.seq;

import java.io.Serializable;
import org.beangle.commons.lang.Numbers$;
import org.beangle.commons.lang.Strings$;
import org.beangle.commons.text.seq.MultiLevelSeqGenerator;
import org.beangle.commons.text.seq.SeqNumStyle;
import scala.Function1;
import scala.collection.immutable.List;
import scala.collection.mutable.ListBuffer;
import scala.math.Ordering;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.java8.JFunction1;

public class SeqPattern {
    private final SeqNumStyle seqNumStyle;
    private final String pattern;
    private MultiLevelSeqGenerator generator;
    private int level;
    private int seq;
    private final List<Object> params;

    public SeqPattern(SeqNumStyle seqNumStyle, String pattern) {
        this.seqNumStyle = seqNumStyle;
        this.pattern = pattern;
        this.level = 0;
        this.seq = 0;
        this.params = this.buildParams(pattern);
    }

    public SeqNumStyle seqNumStyle() {
        return this.seqNumStyle;
    }

    public String pattern() {
        return this.pattern;
    }

    public MultiLevelSeqGenerator generator() {
        return this.generator;
    }

    public void generator_$eq(MultiLevelSeqGenerator x$1) {
        this.generator = x$1;
    }

    public int level() {
        return this.level;
    }

    public void level_$eq(int x$1) {
        this.level = x$1;
    }

    private List<Object> buildParams(String pattern) {
        String remainder = pattern;
        ListBuffer paramBuffer = new ListBuffer();
        boolean hasNext = true;
        while (hasNext && Strings$.MODULE$.isNotEmpty(remainder)) {
            String p = Strings$.MODULE$.substringBetween(remainder, "{", "}");
            if (Strings$.MODULE$.isEmpty(p)) {
                hasNext = false;
            } else if (Numbers$.MODULE$.isDigits(p)) {
                paramBuffer.$plus$eq((Object)BoxesRunTime.boxToInteger((int)Numbers$.MODULE$.toInt(p, Numbers$.MODULE$.toInt$default$2())));
            }
            remainder = Strings$.MODULE$.substringAfter(remainder, "{" + p + "}");
        }
        ListBuffer rs = (ListBuffer)paramBuffer.sorted((Ordering)Ordering.Int$.MODULE$);
        this.level_$eq(BoxesRunTime.unboxToInt((Object)rs.last()));
        return ((ListBuffer)rs.take(rs.size() - 1)).toList();
    }

    public String curSeqText() {
        return this.seqNumStyle().build(this.seq);
    }

    public String next() {
        ++this.seq;
        ObjectRef text = ObjectRef.create((Object)this.pattern());
        this.params.foreach((Function1)(JFunction1.mcVI.sp & Serializable)paramLevel -> {
            text$1.elem = Strings$.MODULE$.replace((String)text$1.elem, "{" + paramLevel + "}", this.generator().getPattern(paramLevel).curSeqText());
        });
        return Strings$.MODULE$.replace((String)text.elem, "{" + this.level() + "}", this.seqNumStyle().build(this.seq));
    }

    public void reset() {
        this.seq = 0;
    }
}

