/*
 * Decompiled with CFR 0.152.
 */
package org.beangle.commons.xml;

import java.io.Serializable;
import org.beangle.commons.collection.Collections$;
import org.beangle.commons.xml.XmlNode$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.StringBuilder;
import scala.runtime.function.JProcedure1;
import scala.xml.Utility$;

public class XmlNode {
    private final String name;
    private final Buffer attributes;
    private final Buffer children;
    private Option text;

    public static XmlNode apply(String string, Seq<Tuple2<String, String>> seq) {
        return XmlNode$.MODULE$.apply(string, seq);
    }

    public XmlNode(String name) {
        this.name = name;
        this.attributes = Collections$.MODULE$.newBuffer();
        this.children = Collections$.MODULE$.newBuffer();
        this.text = None$.MODULE$;
    }

    public String name() {
        return this.name;
    }

    private Buffer<Tuple2<String, String>> attributes() {
        return this.attributes;
    }

    private Buffer<XmlNode> children() {
        return this.children;
    }

    private Option<String> text() {
        return this.text;
    }

    private void text_$eq(Option<String> x$0) {
        this.text = x$0;
    }

    public XmlNode attr(String key, String value2) {
        String string = (String)Predef$.MODULE$.ArrowAssoc((Object)key);
        this.attributes().$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)Utility$.MODULE$.escape(value2)));
        return this;
    }

    public XmlNode attr(String key, Option<String> value2) {
        value2.foreach((Function1 & Serializable)_$1 -> this.attr(key, (String)_$1));
        return this;
    }

    public XmlNode createChild(String name, Seq<Tuple2<String, String>> attrs) {
        XmlNode node = new XmlNode(name);
        attrs.foreach((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                String k = (String)tuple2._1();
                String v = (String)tuple2._2();
                return node.attr(k, v);
            }
            throw new MatchError((Object)tuple2);
        });
        this.children().$plus$eq((Object)node);
        return node;
    }

    public String toXml() {
        StringBuilder buf = new StringBuilder("<?xml version=\"1.0\"?>");
        buf.append("\n");
        this.appendXml(this, buf);
        return buf.toString();
    }

    public String toString() {
        StringBuilder buf = new StringBuilder("\n");
        this.appendXml(this, buf);
        return buf.toString();
    }

    private void appendXml(XmlNode node, StringBuilder buf) {
        buf.$plus$plus$eq("<" + node.name());
        node.attributes().foreach((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                String k = (String)tuple2._1();
                String v = (String)tuple2._2();
                return buf.$plus$plus$eq(" " + k + "=\"" + v + "\"");
            }
            throw new MatchError((Object)tuple2);
        });
        Option<String> option = node.text();
        if (None$.MODULE$.equals(option)) {
            if (node.children().isEmpty()) {
                buf.$plus$plus$eq("/>\n");
                return;
            }
            buf.$plus$plus$eq(">\n");
            node.children().foreach((Function1)(JProcedure1 & Serializable)_$2 -> this.appendXml((XmlNode)_$2, buf));
            buf.$plus$plus$eq("</" + node.name() + ">\n");
            return;
        }
        if (option instanceof Some) {
            String t = (String)((Some)option).value();
            buf.$plus$plus$eq(">\n");
            buf.$plus$plus$eq("<![CDATA[" + t + "]]>");
            node.children().foreach((Function1)(JProcedure1 & Serializable)_$3 -> this.appendXml((XmlNode)_$3, buf));
            buf.$plus$plus$eq("</" + node.name() + ">\n");
            return;
        }
        throw new MatchError(option);
    }

    public XmlNode inner(String text) {
        this.text_$eq((Option<String>)Some$.MODULE$.apply((Object)text));
        return this;
    }
}

