/*
 * Decompiled with CFR 0.152.
 */
package org.beangle.data.conversion.impl;

import java.util.concurrent.LinkedBlockingQueue;
import org.beangle.commons.collection.page.PageLimit;
import org.beangle.commons.lang.ThreadTasks$;
import org.beangle.commons.lang.time.Stopwatch;
import org.beangle.commons.logging.Logging;
import org.beangle.data.conversion.Converter;
import org.beangle.data.conversion.DataWrapper;
import org.beangle.data.conversion.impl.DataConverter$;
import org.beangle.data.jdbc.meta.Table;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function2;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.immutable.List$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ListBuffer;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;

@ScalaSignature(bytes="\u0006\u0001\u0005Ud\u0001B\u0001\u0003\u00015\u0011Q\u0002R1uC\u000e{gN^3si\u0016\u0014(BA\u0002\u0005\u0003\u0011IW\u000e\u001d7\u000b\u0005\u00151\u0011AC2p]Z,'o]5p]*\u0011q\u0001C\u0001\u0005I\u0006$\u0018M\u0003\u0002\n\u0015\u00059!-Z1oO2,'\"A\u0006\u0002\u0007=\u0014xm\u0001\u0001\u0014\t\u0001qA\u0003\u0007\t\u0003\u001fIi\u0011\u0001\u0005\u0006\u0002#\u0005)1oY1mC&\u00111\u0003\u0005\u0002\u0007\u0003:L(+\u001a4\u0011\u0005U1R\"\u0001\u0003\n\u0005]!!!C\"p]Z,'\u000f^3s!\tIb$D\u0001\u001b\u0015\tYB$A\u0004m_\u001e<\u0017N\\4\u000b\u0005uA\u0011aB2p[6|gn]\u0005\u0003?i\u0011q\u0001T8hO&tw\r\u0003\u0005\"\u0001\t\u0015\r\u0011\"\u0001#\u0003\u0019\u0019x.\u001e:dKV\t1\u0005\u0005\u0002\u0016I%\u0011Q\u0005\u0002\u0002\f\t\u0006$\u0018m\u0016:baB,'\u000f\u0003\u0005(\u0001\t\u0005\t\u0015!\u0003$\u0003\u001d\u0019x.\u001e:dK\u0002B\u0001\"\u000b\u0001\u0003\u0006\u0004%\tAI\u0001\u0007i\u0006\u0014x-\u001a;\t\u0011-\u0002!\u0011!Q\u0001\n\r\nq\u0001^1sO\u0016$\b\u0005\u0003\u0005.\u0001\t\u0015\r\u0011\"\u0001/\u0003\u001d!\bN]3bIN,\u0012a\f\t\u0003\u001fAJ!!\r\t\u0003\u0007%sG\u000f\u0003\u00054\u0001\t\u0005\t\u0015!\u00030\u0003!!\bN]3bIN\u0004\u0003\"B\u001b\u0001\t\u00031\u0014A\u0002\u001fj]&$h\b\u0006\u00038siZ\u0004C\u0001\u001d\u0001\u001b\u0005\u0011\u0001\"B\u00115\u0001\u0004\u0019\u0003\"B\u00155\u0001\u0004\u0019\u0003bB\u00175!\u0003\u0005\ra\f\u0005\b{\u0001\u0011\r\u0011\"\u0001?\u0003\u0019!\u0018M\u00197fgV\tq\bE\u0002A\u000b\u001ek\u0011!\u0011\u0006\u0003\u0005\u000e\u000bq!\\;uC\ndWM\u0003\u0002E!\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\u0005\u0019\u000b%A\u0003'jgR\u0014UO\u001a4feB!q\u0002\u0013&K\u0013\tI\u0005C\u0001\u0004UkBdWM\r\t\u0003\u0017Bk\u0011\u0001\u0014\u0006\u0003\u001b:\u000bA!\\3uC*\u0011qJB\u0001\u0005U\u0012\u00147-\u0003\u0002R\u0019\n)A+\u00192mK\"11\u000b\u0001Q\u0001\n}\nq\u0001^1cY\u0016\u001c\b\u0005C\u0003V\u0001\u0011Ea+\u0001\u0005bI\u0012$\u0016M\u00197f)\t9&\f\u0005\u0002\u00101&\u0011\u0011\f\u0005\u0002\u0005+:LG\u000fC\u0003\\)\u0002\u0007q)\u0001\u0003qC&\u0014\b\"B/\u0001\t\u0003q\u0016AB1eI\u0006cG\u000e\u0006\u0002X?\")\u0001\r\u0018a\u0001C\u0006)\u0001/Y5sgB\u0019!M[$\u000f\u0005\rDgB\u00013h\u001b\u0005)'B\u00014\r\u0003\u0019a$o\\8u}%\t\u0011#\u0003\u0002j!\u00059\u0001/Y2lC\u001e,\u0017BA6m\u0005\r\u0019V-\u001d\u0006\u0003SBAQA\u001c\u0001\u0005\u0002=\fQA]3tKR$\u0012a\u0016\u0005\u0006c\u0002!\ta\\\u0001\u0006gR\f'\u000f\u001e\u0004\u0005g\u0002\u0001AOA\u0006D_:4XM\u001d;UCN\\7c\u0001:v{B\u0011ao_\u0007\u0002o*\u0011\u00010_\u0001\u0005Y\u0006twMC\u0001{\u0003\u0011Q\u0017M^1\n\u0005q<(AB(cU\u0016\u001cG\u000f\u0005\u0002w}&\u0011qp\u001e\u0002\t%Vtg.\u00192mK\"A\u0011E\u001dBC\u0002\u0013\u0005!\u0005\u0003\u0005(e\n\u0005\t\u0015!\u0003$\u0011!I#O!b\u0001\n\u0003\u0011\u0003\u0002C\u0016s\u0005\u0003\u0005\u000b\u0011B\u0012\t\u0015\u0005-!O!b\u0001\n\u0003\ti!\u0001\u0004ck\u001a4WM]\u000b\u0003\u0003\u001f\u0001R!!\u0005\u0002\u001c\u001dk!!a\u0005\u000b\t\u0005U\u0011qC\u0001\u000bG>t7-\u001e:sK:$(bAA\rs\u0006!Q\u000f^5m\u0013\u0011\ti\"a\u0005\u0003'1Kgn[3e\u00052|7m[5oOF+X-^3\t\u0015\u0005\u0005\"O!A!\u0002\u0013\ty!A\u0004ck\u001a4WM\u001d\u0011\t\rU\u0012H\u0011AA\u0013)!\t9#a\u000b\u0002.\u0005=\u0002cAA\u0015e6\t\u0001\u0001\u0003\u0004\"\u0003G\u0001\ra\t\u0005\u0007S\u0005\r\u0002\u0019A\u0012\t\u0011\u0005-\u00111\u0005a\u0001\u0003\u001fAa!a\rs\t\u0003y\u0017a\u0001:v]\"9\u0011q\u0007:\u0005\n\u0005e\u0012\u0001F2sK\u0006$Xm\u0014:SKBd\u0017mY3UC\ndW\r\u0006\u0003\u0002<\u0005\u0005\u0003cA\b\u0002>%\u0019\u0011q\b\t\u0003\u000f\t{w\u000e\\3b]\"9\u00111IA\u001b\u0001\u0004Q\u0015!\u0002;bE2,\u0007bBA$e\u0012\u0005\u0011\u0011J\u0001\bG>tg/\u001a:u)\r9\u00161\n\u0005\u00077\u0006\u0015\u0003\u0019A$\b\u0013\u0005=#!!A\t\u0002\u0005E\u0013!\u0004#bi\u0006\u001cuN\u001c<feR,'\u000fE\u00029\u0003'2\u0001\"\u0001\u0002\u0002\u0002#\u0005\u0011QK\n\u0004\u0003'r\u0001bB\u001b\u0002T\u0011\u0005\u0011\u0011\f\u000b\u0003\u0003#B!\"!\u0018\u0002TE\u0005I\u0011AA0\u0003m!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%gU\u0011\u0011\u0011\r\u0016\u0004_\u0005\r4FAA3!\u0011\t9'!\u001d\u000e\u0005\u0005%$\u0002BA6\u0003[\n\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005=\u0004#\u0001\u0006b]:|G/\u0019;j_:LA!a\u001d\u0002j\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3")
public class DataConverter
implements Converter,
Logging {
    private final DataWrapper source;
    private final DataWrapper target;
    private final int threads;
    private final ListBuffer<Tuple2<Table, Table>> tables;
    private final Logger org$beangle$commons$logging$Logging$$logger;

    public static int $lessinit$greater$default$3() {
        return DataConverter$.MODULE$.$lessinit$greater$default$3();
    }

    public Logger org$beangle$commons$logging$Logging$$logger() {
        return this.org$beangle$commons$logging$Logging$$logger;
    }

    public void org$beangle$commons$logging$Logging$_setter_$org$beangle$commons$logging$Logging$$logger_$eq(Logger x$1) {
        this.org$beangle$commons$logging$Logging$$logger = x$1;
    }

    public final boolean debugEnabled() {
        return Logging.class.debugEnabled((Logging)this);
    }

    public final void trace(Function0<String> msg) {
        Logging.class.trace((Logging)this, msg);
    }

    public final void trace(Function0<String> msg, Function0<Throwable> t) {
        Logging.class.trace((Logging)this, msg, t);
    }

    public final void debug(Function0<String> msg) {
        Logging.class.debug((Logging)this, msg);
    }

    public final void debug(Function0<String> msg, Function0<Throwable> t) {
        Logging.class.debug((Logging)this, msg, t);
    }

    public final void info(Function0<String> msg) {
        Logging.class.info((Logging)this, msg);
    }

    public final void info(Function0<String> msg, Function0<Throwable> t) {
        Logging.class.info((Logging)this, msg, t);
    }

    public final void warn(Function0<String> msg) {
        Logging.class.warn((Logging)this, msg);
    }

    public final void warn(Function0<String> msg, Function0<Throwable> t) {
        Logging.class.warn((Logging)this, msg, t);
    }

    public final void error(Function0<String> msg) {
        Logging.class.error((Logging)this, msg);
    }

    public final void error(Function0<String> msg, Function0<Throwable> t) {
        Logging.class.error((Logging)this, msg, t);
    }

    @Override
    public DataWrapper source() {
        return this.source;
    }

    @Override
    public DataWrapper target() {
        return this.target;
    }

    public int threads() {
        return this.threads;
    }

    public ListBuffer<Tuple2<Table, Table>> tables() {
        return this.tables;
    }

    public void addTable(Tuple2<Table, Table> pair) {
        this.tables().$plus$eq(pair);
    }

    public void addAll(Seq<Tuple2<Table, Table>> pairs) {
        this.tables().$plus$plus$eq(pairs);
    }

    @Override
    public void reset() {
    }

    @Override
    public void start() {
        Stopwatch watch = new Stopwatch(true);
        int tableCount = this.tables().length();
        LinkedBlockingQueue<Tuple2<Table, Table>> buffer = new LinkedBlockingQueue<Tuple2<Table, Table>>();
        buffer.addAll(JavaConversions$.MODULE$.asJavaCollection((Iterable)this.tables().sortWith((Function2)new Serializable(this){

            public final boolean apply(Tuple2<Table, Table> x$1, Tuple2<Table, Table> x$2) {
                String string = ((Table)x$1._1()).name();
                Predef$ predef$ = Predef$.MODULE$;
                return new StringOps(string).$greater((Object)((Table)x$2._1()).name());
            }
        })));
        this.info((Function0<String>)new Serializable(this, tableCount){
            private final /* synthetic */ DataConverter $outer;
            private final int tableCount$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Start ", " tables data replication in ", " threads..."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.tableCount$1), BoxesRunTime.boxToInteger((int)this.$outer.threads())}));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.tableCount$1 = tableCount$1;
            }
        });
        ThreadTasks$.MODULE$.start((Runnable)new ConvertTask(this, this.source(), this.target(), buffer), this.threads(), ThreadTasks$.MODULE$.start$default$3());
        this.info((Function0<String>)new Serializable(this, watch, tableCount){
            private final Stopwatch watch$1;
            private final int tableCount$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"End ", " tables data replication,using ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.tableCount$1), this.watch$1}));
            }
            {
                this.watch$1 = watch$1;
                this.tableCount$1 = tableCount$1;
            }
        });
    }

    public DataConverter(DataWrapper source, DataWrapper target, int threads) {
        this.source = source;
        this.target = target;
        this.threads = threads;
        Logging.class.$init$((Logging)this);
        this.tables = new ListBuffer();
    }

    public class ConvertTask
    implements Runnable {
        private final DataWrapper source;
        private final DataWrapper target;
        private final LinkedBlockingQueue<Tuple2<Table, Table>> buffer;
        public final /* synthetic */ DataConverter $outer;

        public DataWrapper source() {
            return this.source;
        }

        public DataWrapper target() {
            return this.target;
        }

        public LinkedBlockingQueue<Tuple2<Table, Table>> buffer() {
            return this.buffer;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            while (!this.buffer().isEmpty()) {
                try {
                    Tuple2<Table, Table> p = this.buffer().poll();
                    if (p == null) continue;
                    this.convert(p);
                    continue;
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    continue;
                }
                catch (Exception exception) {
                    this.org$beangle$data$conversion$impl$DataConverter$ConvertTask$$$outer().error((Function0<String>)new Serializable(this){

                        public final String apply() {
                            return "Error in convertion ";
                        }
                    }, (Function0<Throwable>)new Serializable(this, exception){
                        private final Exception e$1;

                        public final Exception apply() {
                            return this.e$1;
                        }
                        {
                            this.e$1 = e$1;
                        }
                    });
                    continue;
                }
                break;
            }
            return;
        }

        private boolean createOrReplaceTable(Table table) {
            if (this.target().drop(table)) {
                if (this.target().create(table)) {
                    this.org$beangle$data$conversion$impl$DataConverter$ConvertTask$$$outer().info((Function0<String>)new Serializable(this, table){
                        private final Table table$1;

                        public final String apply() {
                            return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Create table ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.table$1.name()}));
                        }
                        {
                            this.table$1 = table$1;
                        }
                    });
                    return true;
                }
                this.org$beangle$data$conversion$impl$DataConverter$ConvertTask$$$outer().error((Function0<String>)new Serializable(this, table){
                    private final Table table$1;

                    public final String apply() {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Create table ", " failure."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.table$1.name()}));
                    }
                    {
                        this.table$1 = table$1;
                    }
                });
            }
            return false;
        }

        public void convert(Tuple2<Table, Table> pair) {
            block10: {
                Table srcTable = (Table)pair._1();
                Table targetTable = (Table)pair._2();
                try {
                    if (this.createOrReplaceTable(targetTable)) {
                        IntRef count = IntRef.create((int)this.source().count(srcTable));
                        if (count.elem == 0) {
                            this.target().save(targetTable, (Seq<Seq<?>>)List$.MODULE$.empty());
                            this.org$beangle$data$conversion$impl$DataConverter$ConvertTask$$$outer().info((Function0<String>)new Serializable(this, targetTable){
                                private final Table targetTable$1;

                                public final String apply() {
                                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Insert ", "(0)"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.targetTable$1}));
                                }
                                {
                                    this.targetTable$1 = targetTable$1;
                                }
                            });
                        } else {
                            IntRef curr = IntRef.create((int)0);
                            int pageIndex = 0;
                            while (curr.elem < count.elem) {
                                PageLimit limit = new PageLimit(pageIndex + 1, 5000);
                                Seq<Seq<?>> data = this.source().supportLimit() ? this.source().get(srcTable, limit) : this.source().get(srcTable);
                                boolean breakable = false;
                                if (data.isEmpty()) {
                                    this.org$beangle$data$conversion$impl$DataConverter$ConvertTask$$$outer().error((Function0<String>)new Serializable(this, srcTable, limit){
                                        private final Table srcTable$1;
                                        private final PageLimit limit$1;

                                        public final String apply() {
                                            return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Failure in fetching ", " data ", "(", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.srcTable$1.name(), BoxesRunTime.boxToInteger((int)this.limit$1.pageIndex()), BoxesRunTime.boxToInteger((int)this.limit$1.pageSize())}));
                                        }
                                        {
                                            this.srcTable$1 = srcTable$1;
                                            this.limit$1 = limit$1;
                                        }
                                    });
                                    if (limit.pageIndex() * limit.pageSize() >= count.elem) {
                                        breakable = true;
                                    }
                                }
                                if (breakable) continue;
                                int successed = this.target().save(targetTable, data);
                                curr.elem += data.size();
                                ++pageIndex;
                                if (successed == count.elem) {
                                    this.org$beangle$data$conversion$impl$DataConverter$ConvertTask$$$outer().info((Function0<String>)new Serializable(this, targetTable, successed){
                                        private final Table targetTable$1;
                                        private final int successed$1;

                                        public final String apply() {
                                            return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Insert ", "(", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.targetTable$1, BoxesRunTime.boxToInteger((int)this.successed$1)}));
                                        }
                                        {
                                            this.targetTable$1 = targetTable$1;
                                            this.successed$1 = successed$1;
                                        }
                                    });
                                    continue;
                                }
                                if (successed == data.size()) {
                                    this.org$beangle$data$conversion$impl$DataConverter$ConvertTask$$$outer().info((Function0<String>)new Serializable(this, targetTable, count, curr){
                                        private final Table targetTable$1;
                                        private final IntRef count$1;
                                        private final IntRef curr$1;

                                        public final String apply() {
                                            return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Insert ", "(", "/", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.targetTable$1, BoxesRunTime.boxToInteger((int)this.curr$1.elem), BoxesRunTime.boxToInteger((int)this.count$1.elem)}));
                                        }
                                        {
                                            this.targetTable$1 = targetTable$1;
                                            this.count$1 = count$1;
                                            this.curr$1 = curr$1;
                                        }
                                    });
                                    continue;
                                }
                                this.org$beangle$data$conversion$impl$DataConverter$ConvertTask$$$outer().warn((Function0<String>)new Serializable(this, targetTable, data, successed){
                                    private final Table targetTable$1;
                                    private final Seq data$1;
                                    private final int successed$1;

                                    public final String apply() {
                                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Insert ", "(", "/", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.targetTable$1, BoxesRunTime.boxToInteger((int)this.successed$1), BoxesRunTime.boxToInteger((int)this.data$1.size())}));
                                    }
                                    {
                                        this.targetTable$1 = targetTable$1;
                                        this.data$1 = data$1;
                                        this.successed$1 = successed$1;
                                    }
                                });
                            }
                        }
                        break block10;
                    }
                    return;
                }
                catch (Exception exception) {
                    this.org$beangle$data$conversion$impl$DataConverter$ConvertTask$$$outer().error((Function0<String>)new Serializable(this, srcTable){
                        private final Table srcTable$1;

                        public final String apply() {
                            return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Insert error ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.srcTable$1.identifier()}));
                        }
                        {
                            this.srcTable$1 = srcTable$1;
                        }
                    }, (Function0<Throwable>)new Serializable(this, exception){
                        private final Exception e$2;

                        public final Exception apply() {
                            return this.e$2;
                        }
                        {
                            this.e$2 = e$2;
                        }
                    });
                }
            }
        }

        public /* synthetic */ DataConverter org$beangle$data$conversion$impl$DataConverter$ConvertTask$$$outer() {
            return this.$outer;
        }

        public ConvertTask(DataConverter $outer, DataWrapper source, DataWrapper target, LinkedBlockingQueue<Tuple2<Table, Table>> buffer) {
            this.source = source;
            this.target = target;
            this.buffer = buffer;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
        }
    }
}

