/*
 * Decompiled with CFR 0.152.
 */
package org.beangle.data.conversion.db;

import org.beangle.commons.lang.time.Stopwatch;
import org.beangle.commons.logging.Logging;
import org.beangle.data.conversion.Converter;
import org.beangle.data.conversion.db.DatabaseWrapper;
import org.beangle.data.jdbc.dialect.Dialect;
import org.beangle.data.jdbc.meta.Sequence;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.generic.TraversableForwarder;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ListBuffer;
import scala.math.Ordering$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u00054A!\u0001\u0002\u0001\u001b\t\t2+Z9vK:\u001cWmQ8om\u0016\u0014H/\u001a:\u000b\u0005\r!\u0011A\u00013c\u0015\t)a!\u0001\u0006d_:4XM]:j_:T!a\u0002\u0005\u0002\t\u0011\fG/\u0019\u0006\u0003\u0013)\tqAY3b]\u001edWMC\u0001\f\u0003\ry'oZ\u0002\u0001'\u0011\u0001a\u0002\u0006\r\u0011\u0005=\u0011R\"\u0001\t\u000b\u0003E\tQa]2bY\u0006L!a\u0005\t\u0003\r\u0005s\u0017PU3g!\t)b#D\u0001\u0005\u0013\t9BAA\u0005D_:4XM\u001d;feB\u0011\u0011DH\u0007\u00025)\u00111\u0004H\u0001\bY><w-\u001b8h\u0015\ti\u0002\"A\u0004d_6lwN\\:\n\u0005}Q\"a\u0002'pO\u001eLgn\u001a\u0005\tC\u0001\u0011)\u0019!C\u0001E\u000511o\\;sG\u0016,\u0012a\t\t\u0003I\u0015j\u0011AA\u0005\u0003M\t\u0011q\u0002R1uC\n\f7/Z,sCB\u0004XM\u001d\u0005\tQ\u0001\u0011\t\u0011)A\u0005G\u000591o\\;sG\u0016\u0004\u0003\u0002\u0003\u0016\u0001\u0005\u000b\u0007I\u0011\u0001\u0012\u0002\rQ\f'oZ3u\u0011!a\u0003A!A!\u0002\u0013\u0019\u0013a\u0002;be\u001e,G\u000f\t\u0005\u0006]\u0001!\taL\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0007A\n$\u0007\u0005\u0002%\u0001!)\u0011%\fa\u0001G!)!&\fa\u0001G!9A\u0007\u0001b\u0001\n\u0003)\u0014!C:fcV,gnY3t+\u00051\u0004cA\u001c=}5\t\u0001H\u0003\u0002:u\u00059Q.\u001e;bE2,'BA\u001e\u0011\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0003{a\u0012!\u0002T5ti\n+hMZ3s!\tyD)D\u0001A\u0015\t\t%)\u0001\u0003nKR\f'BA\"\u0007\u0003\u0011QGMY2\n\u0005\u0015\u0003%\u0001C*fcV,gnY3\t\r\u001d\u0003\u0001\u0015!\u00037\u0003)\u0019X-];f]\u000e,7\u000f\t\u0005\u0006\u0013\u0002!\tAS\u0001\u0006e\u0016\u001cX\r\u001e\u000b\u0002\u0017B\u0011q\u0002T\u0005\u0003\u001bB\u0011A!\u00168ji\")q\n\u0001C\u0005!\u0006A!/Z\"sK\u0006$X\r\u0006\u0002R)B\u0011qBU\u0005\u0003'B\u0011qAQ8pY\u0016\fg\u000eC\u0003V\u001d\u0002\u0007a(\u0001\u0005tKF,XM\\2f\u0011\u00159\u0006\u0001\"\u0001K\u0003\u0015\u0019H/\u0019:u\u0011\u0015I\u0006\u0001\"\u0001[\u0003\u0019\tG\rZ!mYR\u00111j\u0017\u0005\u00069b\u0003\r!X\u0001\r]\u0016<8+Z9vK:\u001cWm\u001d\t\u0004=~sT\"\u0001\u001e\n\u0005\u0001T$\u0001C%uKJ\f'\r\\3")
public class SequenceConverter
implements Converter,
Logging {
    private final DatabaseWrapper source;
    private final DatabaseWrapper target;
    private final ListBuffer<Sequence> sequences;
    private final Logger org$beangle$commons$logging$Logging$$logger;

    public Logger org$beangle$commons$logging$Logging$$logger() {
        return this.org$beangle$commons$logging$Logging$$logger;
    }

    public void org$beangle$commons$logging$Logging$_setter_$org$beangle$commons$logging$Logging$$logger_$eq(Logger x$1) {
        this.org$beangle$commons$logging$Logging$$logger = x$1;
    }

    public final boolean debugEnabled() {
        return Logging.class.debugEnabled((Logging)this);
    }

    public final void trace(Function0<String> msg) {
        Logging.class.trace((Logging)this, msg);
    }

    public final void trace(Function0<String> msg, Function0<Throwable> t) {
        Logging.class.trace((Logging)this, msg, t);
    }

    public final void debug(Function0<String> msg) {
        Logging.class.debug((Logging)this, msg);
    }

    public final void debug(Function0<String> msg, Function0<Throwable> t) {
        Logging.class.debug((Logging)this, msg, t);
    }

    public final void info(Function0<String> msg) {
        Logging.class.info((Logging)this, msg);
    }

    public final void info(Function0<String> msg, Function0<Throwable> t) {
        Logging.class.info((Logging)this, msg, t);
    }

    public final void warn(Function0<String> msg) {
        Logging.class.warn((Logging)this, msg);
    }

    public final void warn(Function0<String> msg, Function0<Throwable> t) {
        Logging.class.warn((Logging)this, msg, t);
    }

    public final void error(Function0<String> msg) {
        Logging.class.error((Logging)this, msg);
    }

    public final void error(Function0<String> msg, Function0<Throwable> t) {
        Logging.class.error((Logging)this, msg, t);
    }

    @Override
    public DatabaseWrapper source() {
        return this.source;
    }

    @Override
    public DatabaseWrapper target() {
        return this.target;
    }

    public ListBuffer<Sequence> sequences() {
        return this.sequences;
    }

    @Override
    public void reset() {
    }

    public boolean org$beangle$data$conversion$db$SequenceConverter$$reCreate(Sequence sequence) {
        if (this.target().drop(sequence)) {
            if (this.target().create(sequence)) {
                this.info((Function0<String>)new Serializable(this, sequence){
                    private final Sequence sequence$1;

                    public final String apply() {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Recreate sequence ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.sequence$1.name()}));
                    }
                    {
                        this.sequence$1 = sequence$1;
                    }
                });
                return true;
            }
            this.error((Function0<String>)new Serializable(this){

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Recreate sequence {sequence.name} failure."})).s((Seq)Nil$.MODULE$);
                }
            });
        }
        return false;
    }

    @Override
    public void start() {
        Dialect targetDialect = this.target().database().dialect();
        if (targetDialect.sequenceGrammar() == null) {
            this.info((Function0<String>)new Serializable(this, targetDialect){
                private final Dialect targetDialect$1;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Target database ", " dosen't support sequence,replication ommited."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.targetDialect$1.getClass().getSimpleName()}));
                }
                {
                    this.targetDialect$1 = targetDialect$1;
                }
            });
            return;
        }
        Stopwatch watch = new Stopwatch(true);
        this.info((Function0<String>)new Serializable(this){

            public final String apply() {
                return "Start sequence replication...";
            }
        });
        ((TraversableForwarder)this.sequences().sorted(Ordering$.MODULE$.ordered((Function1)Predef$.MODULE$.$conforms()))).foreach((Function1)new Serializable(this){
            private final /* synthetic */ SequenceConverter $outer;

            public final boolean apply(Sequence sequence) {
                return this.$outer.org$beangle$data$conversion$db$SequenceConverter$$reCreate(sequence);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.info((Function0<String>)new Serializable(this, watch){
            private final /* synthetic */ SequenceConverter $outer;
            private final Stopwatch watch$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"End ", " sequence replication,using ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.$outer.sequences().length()), this.watch$1}));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.watch$1 = watch$1;
            }
        });
    }

    public void addAll(Iterable<Sequence> newSequences) {
        this.sequences().$plus$plus$eq(newSequences);
    }

    public SequenceConverter(DatabaseWrapper source, DatabaseWrapper target) {
        this.source = source;
        this.target = target;
        Logging.class.$init$((Logging)this);
        this.sequences = new ListBuffer();
    }
}

