/*
 * Decompiled with CFR 0.152.
 */
package org.beangle.data.csv;

import java.io.BufferedReader;
import java.io.Reader;
import java.io.Serializable;
import org.beangle.data.csv.CsvFormat;
import org.beangle.data.csv.internal.CsvParser;
import scala.Function1;
import scala.Predef$;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;

public class CsvReader {
    private boolean hasNext = true;
    private boolean linesSkiped;
    private int skipLines = 0;
    private BufferedReader br;
    private CsvParser parser;

    public CsvReader(Reader reader, CsvFormat format) {
        this.br = new BufferedReader(reader);
        this.parser = new CsvParser(format);
    }

    public CsvReader(Reader reader) {
        this(reader, new CsvFormat.Builder().build());
    }

    private String getNextLine() {
        String nextLine;
        if (!this.linesSkiped) {
            RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), this.skipLines).foreach((Function1 & Serializable)i -> this.getNextLine$$anonfun$1(BoxesRunTime.unboxToInt((Object)i)));
            this.linesSkiped = true;
        }
        if ((nextLine = this.br.readLine()) == null) {
            this.hasNext = false;
        }
        if (this.hasNext) {
            return nextLine;
        }
        return null;
    }

    public String[] readNext() {
        String[] result = null;
        do {
            String nextLine = this.getNextLine();
            if (!this.hasNext) {
                return result;
            }
            String[] r = this.parser.parseLineMulti(nextLine);
            if (r.length <= 0) continue;
            if (result == null) {
                result = r;
                continue;
            }
            String[] t = new String[result.length + r.length];
            System.arraycopy(result, 0, t, 0, result.length);
            System.arraycopy(r, 0, t, result.length, r.length);
            result = t;
        } while (this.parser.isPending());
        return result;
    }

    private final /* synthetic */ String getNextLine$$anonfun$1(int i) {
        return this.br.readLine();
    }
}

