/*
 * Decompiled with CFR 0.152.
 */
package org.beangle.data.excel;

import org.beangle.commons.lang.Objects$;
import org.beangle.data.excel.AreaRef$;
import org.beangle.data.excel.CellRef;
import org.beangle.data.excel.Size;
import org.beangle.data.excel.Size$;

public class AreaRef {
    private final CellRef firstCellRef;
    private final CellRef lastCellRef;
    private final int startRow;
    private final int startCol;
    private final int endRow;
    private final int endCol;

    public static AreaRef apply(CellRef cellRef, Size size) {
        return AreaRef$.MODULE$.apply(cellRef, size);
    }

    public static AreaRef apply(String string) {
        return AreaRef$.MODULE$.apply(string);
    }

    public static void ensureSameSheet(CellRef cellRef, CellRef cellRef2) {
        AreaRef$.MODULE$.ensureSameSheet(cellRef, cellRef2);
    }

    public AreaRef(CellRef firstCellRef, CellRef lastCellRef) {
        this.firstCellRef = firstCellRef;
        this.lastCellRef = lastCellRef;
        this.startRow = firstCellRef.row();
        this.startCol = firstCellRef.col();
        this.endRow = lastCellRef.row();
        this.endCol = lastCellRef.col();
    }

    public CellRef firstCellRef() {
        return this.firstCellRef;
    }

    public CellRef lastCellRef() {
        return this.lastCellRef;
    }

    public String sheetName() {
        return this.firstCellRef().sheetName();
    }

    public Size size() {
        if (this.firstCellRef() == null || this.lastCellRef() == null) {
            return Size$.MODULE$.Zero();
        }
        return new Size(this.endCol - this.startCol + 1, this.endRow - this.startRow + 1);
    }

    public boolean contains(CellRef cellRef) {
        String sn = this.sheetName();
        String otherSheetName = cellRef.sheetName();
        if (sn == null && otherSheetName == null || sn != null && sn.equalsIgnoreCase(otherSheetName)) {
            return cellRef.row() >= this.startRow && cellRef.col() >= this.startCol && cellRef.row() <= this.endRow && cellRef.col() <= this.endCol;
        }
        return false;
    }

    public boolean contains(int row, int col) {
        return row >= this.startRow && row <= this.endRow && col >= this.startCol && col <= this.endCol;
    }

    public boolean contains(AreaRef areaRef) {
        if (areaRef == null) {
            return true;
        }
        if (this.sheetName() == null && areaRef.sheetName() == null || this.sheetName() != null && this.sheetName().equalsIgnoreCase(areaRef.sheetName())) {
            return this.contains(areaRef.firstCellRef()) && this.contains(areaRef.lastCellRef());
        }
        return false;
    }

    public String toString() {
        return this.firstCellRef().toString() + ":" + this.lastCellRef().getCellName(true);
    }

    public boolean equals(Object o) {
        Object object = o;
        if (object == null) {
            return false;
        }
        if (object instanceof AreaRef) {
            AreaRef areaRef = (AreaRef)object;
            if (this == areaRef) {
                return true;
            }
            return Objects$.MODULE$.equals((Object)this.firstCellRef(), (Object)areaRef.firstCellRef()) && Objects$.MODULE$.equals((Object)this.lastCellRef(), (Object)areaRef.lastCellRef());
        }
        return false;
    }

    public int hashCode() {
        int result = this.firstCellRef() != null ? this.firstCellRef().hashCode() : 0;
        result = 31 * result + (this.lastCellRef() != null ? this.lastCellRef().hashCode() : 0);
        return result;
    }
}

