/*
 * Decompiled with CFR 0.152.
 */
package org.beangle.data.excel;

import java.io.Serializable;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.NumberFormat;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.MonthDay;
import java.time.Year;
import java.time.YearMonth;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.temporal.Temporal;
import java.util.Calendar;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.ClientAnchor;
import org.apache.poi.ss.usermodel.Comment;
import org.apache.poi.ss.usermodel.CreationHelper;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.ss.usermodel.Drawing;
import org.apache.poi.ss.usermodel.RichTextString;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFRichTextString;
import org.beangle.commons.conversion.string.BooleanConverter$;
import org.beangle.commons.conversion.string.TemporalConverter;
import org.beangle.commons.io.DataType;
import org.beangle.commons.io.DataType$;
import org.beangle.commons.lang.Numbers$;
import org.beangle.commons.lang.Strings$;
import org.beangle.data.excel.CellOps;
import org.beangle.data.excel.ExcelStyleRegistry;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTCell;
import scala.Float$;
import scala.Int$;
import scala.MatchError;
import scala.None$;
import scala.Predef$;
import scala.Some;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;

public final class CellOps$
implements Serializable {
    private static final NumberFormat NumFormat;
    public static final CellOps$ MODULE$;

    private CellOps$() {
    }

    static {
        MODULE$ = new CellOps$();
        NumFormat = NumberFormat.getNumberInstance();
        NumFormat.setMinimumFractionDigits(0);
        NumFormat.setGroupingUsed(false);
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(CellOps$.class);
    }

    public Cell toCell(Cell x) {
        return x;
    }

    public final int hashCode$extension(Cell $this) {
        return $this.hashCode();
    }

    public final boolean equals$extension(Cell $this, Object x$0) {
        Object object = x$0;
        if (object instanceof CellOps) {
            Cell cell = object == null ? null : ((CellOps)object).org$beangle$data$excel$CellOps$$cell();
            Cell cell2 = $this;
            Cell cell3 = cell;
            return !(cell2 != null ? !cell2.equals(cell3) : cell3 != null);
        }
        return false;
    }

    public final void clearValue$extension(Cell $this) {
        Cell cell = $this;
        if (cell instanceof XSSFCell) {
            XSSFCell xc = (XSSFCell)cell;
            CTCell cell2 = xc.getCTCell();
            if (cell2.isSetV()) {
                cell2.unsetV();
                return;
            }
            return;
        }
    }

    public final void setComment$extension(Cell $this, String commentText, String commentAuthor, ClientAnchor a) {
        ClientAnchor clientAnchor;
        Sheet sheet = $this.getSheet();
        Workbook wb = sheet.getWorkbook();
        Drawing drawing = sheet.createDrawingPatriarch();
        CreationHelper factory = wb.getCreationHelper();
        if (a == null) {
            ClientAnchor ca = factory.createClientAnchor();
            ca.setCol1($this.getColumnIndex() + 1);
            ca.setCol2($this.getColumnIndex() + 3);
            ca.setRow1($this.getRowIndex());
            ca.setRow2($this.getRowIndex() + 2);
            clientAnchor = ca;
        } else {
            clientAnchor = a;
        }
        ClientAnchor anchor = clientAnchor;
        Comment comment = drawing.createCellComment(anchor);
        comment.setString(factory.createRichTextString(commentText));
        comment.setAuthor(commentAuthor != null ? commentAuthor : "");
        $this.setCellComment(comment);
    }

    public final void fillin$extension(Cell $this, Object value, ExcelStyleRegistry registry) {
        Object s;
        Object object = value;
        Object v = object instanceof Some ? (s = ((Some)object).value()) : (None$.MODULE$.equals(object) ? null : value);
        Object object2 = v;
        if (object2 == null) {
            this.org$beangle$data$excel$CellOps$$$fillBlank$extension($this);
            return;
        }
        if (object2 instanceof java.util.Date) {
            java.util.Date d = (java.util.Date)object2;
            java.util.Date date = d;
            if (date instanceof Date) {
                Date sd = (Date)date;
                this.org$beangle$data$excel$CellOps$$$fill$extension($this, sd, registry);
                return;
            }
            if (date instanceof Timestamp) {
                Timestamp st = (Timestamp)date;
                this.org$beangle$data$excel$CellOps$$$fill$extension($this, st, registry);
                return;
            }
            if (date instanceof Time) {
                Time stt = (Time)date;
                this.org$beangle$data$excel$CellOps$$$fill$extension($this, stt, registry);
                return;
            }
            this.org$beangle$data$excel$CellOps$$$fill$extension($this, d, registry);
            return;
        }
        if (object2 instanceof Calendar) {
            Calendar uc = (Calendar)object2;
            this.org$beangle$data$excel$CellOps$$$fill$extension($this, uc.getTime(), registry);
            return;
        }
        if (object2 instanceof Temporal) {
            Temporal t = (Temporal)object2;
            Temporal temporal = t;
            if (temporal instanceof LocalDate) {
                LocalDate ld = (LocalDate)temporal;
                this.org$beangle$data$excel$CellOps$$$fill$extension($this, Date.valueOf(ld), registry);
                return;
            }
            if (temporal instanceof Instant) {
                Instant i = (Instant)temporal;
                this.org$beangle$data$excel$CellOps$$$fill$extension($this, java.util.Date.from(i), registry);
                return;
            }
            if (temporal instanceof LocalDateTime) {
                LocalDateTime ldt = (LocalDateTime)temporal;
                this.org$beangle$data$excel$CellOps$$$fill$extension($this, java.util.Date.from(ldt.atZone(ZoneId.systemDefault()).toInstant()), registry);
                return;
            }
            if (temporal instanceof ZonedDateTime) {
                ZonedDateTime zdt = (ZonedDateTime)temporal;
                this.org$beangle$data$excel$CellOps$$$fill$extension($this, java.util.Date.from(zdt.toInstant()), registry);
                return;
            }
            if (temporal instanceof LocalTime) {
                LocalTime lt = (LocalTime)temporal;
                this.org$beangle$data$excel$CellOps$$$fill$extension($this, Time.valueOf(lt), registry);
                return;
            }
            if (temporal instanceof Year) {
                Year y = (Year)temporal;
                this.org$beangle$data$excel$CellOps$$$fill$extension($this, y, registry);
                return;
            }
            if (temporal instanceof YearMonth) {
                YearMonth yt = (YearMonth)temporal;
                this.org$beangle$data$excel$CellOps$$$fill$extension($this, yt, registry);
                return;
            }
            throw new MatchError((Object)temporal);
        }
        if (object2 instanceof MonthDay) {
            MonthDay md = (MonthDay)object2;
            this.org$beangle$data$excel$CellOps$$$fill$extension($this, md, registry);
            return;
        }
        if (object2 instanceof Number) {
            Number n = (Number)object2;
            Number number = n;
            if (number instanceof Integer) {
                Integer i = (Integer)number;
                this.org$beangle$data$excel$CellOps$$$fill$extension($this, i, registry);
                return;
            }
            if (number instanceof Float) {
                Float f = (Float)number;
                this.org$beangle$data$excel$CellOps$$$fill$extension($this, f.floatValue(), registry);
                return;
            }
            if (number instanceof Double) {
                Double d = (Double)number;
                this.org$beangle$data$excel$CellOps$$$fill$extension($this, d, registry);
                return;
            }
            this.org$beangle$data$excel$CellOps$$$fill$extension($this, n.intValue(), registry);
            return;
        }
        if (object2 instanceof Boolean) {
            Boolean b = (Boolean)object2;
            this.org$beangle$data$excel$CellOps$$$fill$extension($this, b, registry);
            return;
        }
        this.org$beangle$data$excel$CellOps$$$fill$extension($this, v.toString(), registry);
    }

    public final Object getValue$extension(Cell $this) {
        CellType cellType = $this.getCellType();
        CellType cellType2 = CellType.BLANK;
        CellType cellType3 = cellType;
        if (!(cellType2 != null ? !cellType2.equals(cellType3) : cellType3 != null)) {
            return null;
        }
        CellType cellType4 = CellType.STRING;
        CellType cellType5 = cellType;
        if (!(cellType4 != null ? !cellType4.equals(cellType5) : cellType5 != null)) {
            return Strings$.MODULE$.trim($this.getRichStringCellValue().getString());
        }
        CellType cellType6 = CellType.NUMERIC;
        CellType cellType7 = cellType;
        if (!(cellType6 != null ? !cellType6.equals(cellType7) : cellType7 != null)) {
            if (DateUtil.isCellDateFormatted((Cell)$this)) {
                return $this.getDateCellValue();
            }
            return NumFormat.format($this.getNumericCellValue());
        }
        CellType cellType8 = CellType.BOOLEAN;
        CellType cellType9 = cellType;
        if (!(cellType8 != null ? !cellType8.equals(cellType9) : cellType9 != null)) {
            if ($this.getBooleanCellValue()) {
                return BoxesRunTime.boxToBoolean((boolean)true);
            }
            return BoxesRunTime.boxToBoolean((boolean)false);
        }
        CellType cellType10 = CellType.FORMULA;
        CellType cellType11 = cellType;
        if (!(cellType10 != null ? !cellType10.equals(cellType11) : cellType11 != null)) {
            CellType cellType12 = $this.getCachedFormulaResultType();
            CellType cellType13 = CellType.STRING;
            CellType cellType14 = cellType12;
            if (!(cellType13 != null ? !cellType13.equals(cellType14) : cellType14 != null)) {
                return Strings$.MODULE$.trim($this.getRichStringCellValue().getString());
            }
            CellType cellType15 = CellType.NUMERIC;
            CellType cellType16 = cellType12;
            if (!(cellType15 != null ? !cellType15.equals(cellType16) : cellType16 != null)) {
                return BoxesRunTime.boxToDouble((double)$this.getNumericCellValue());
            }
            return null;
        }
        return null;
    }

    public final Object getValue$extension(Cell $this, DataType dataType) {
        Object object = this.getValue$extension($this);
        if (object == null) {
            return null;
        }
        if (object instanceof String) {
            String s = (String)object;
            return this.org$beangle$data$excel$CellOps$$$convert$extension($this, s, dataType);
        }
        if (object instanceof Double) {
            Double d = (Double)object;
            return this.org$beangle$data$excel$CellOps$$$convert$extension($this, Predef$.MODULE$.Double2double(d), dataType);
        }
        if (object instanceof java.util.Date) {
            java.util.Date d = (java.util.Date)object;
            return this.org$beangle$data$excel$CellOps$$$convert$extension($this, d, dataType);
        }
        if (object instanceof Object) {
            Object d = object;
            return d;
        }
        throw new MatchError(object);
    }

    public final Object org$beangle$data$excel$CellOps$$$convert$extension(Cell $this, String str, DataType dataType) {
        DataType dataType2 = dataType;
        DataType dataType3 = DataType$.String;
        DataType dataType4 = dataType2;
        if (!(dataType3 != null ? !dataType3.equals(dataType4) : dataType4 != null)) {
            return str;
        }
        DataType dataType5 = DataType$.Boolean;
        DataType dataType6 = dataType2;
        if (!(dataType5 != null ? !dataType5.equals(dataType6) : dataType6 != null)) {
            return BooleanConverter$.MODULE$.apply(str);
        }
        DataType dataType7 = DataType$.Short;
        DataType dataType8 = dataType2;
        if (!(dataType7 != null ? !dataType7.equals(dataType8) : dataType8 != null)) {
            return Numbers$.MODULE$.convert2Short(str, Numbers$.MODULE$.convert2Short$default$2());
        }
        DataType dataType9 = DataType$.Integer;
        DataType dataType10 = dataType2;
        if (!(dataType9 != null ? !dataType9.equals(dataType10) : dataType10 != null)) {
            return Numbers$.MODULE$.convert2Int(str, Numbers$.MODULE$.convert2Int$default$2());
        }
        DataType dataType11 = DataType$.Long;
        DataType dataType12 = dataType2;
        if (!(dataType11 != null ? !dataType11.equals(dataType12) : dataType12 != null)) {
            return Numbers$.MODULE$.convert2Long(str, Numbers$.MODULE$.convert2Long$default$2());
        }
        DataType dataType13 = DataType$.Float;
        DataType dataType14 = dataType2;
        if (!(dataType13 != null ? !dataType13.equals(dataType14) : dataType14 != null)) {
            return Numbers$.MODULE$.convert2Float(str, Numbers$.MODULE$.convert2Float$default$2());
        }
        DataType dataType15 = DataType$.Double;
        DataType dataType16 = dataType2;
        if (!(dataType15 != null ? !dataType15.equals(dataType16) : dataType16 != null)) {
            return Numbers$.MODULE$.convert2Double(str, Numbers$.MODULE$.convert2Double$default$2());
        }
        DataType dataType17 = DataType$.Date;
        DataType dataType18 = dataType2;
        if (!(dataType17 != null ? !dataType17.equals(dataType18) : dataType18 != null)) {
            return TemporalConverter.ToLocalDate$.MODULE$.apply(str);
        }
        DataType dataType19 = DataType$.DateTime;
        DataType dataType20 = dataType2;
        if (!(dataType19 != null ? !dataType19.equals(dataType20) : dataType20 != null)) {
            return TemporalConverter.ToLocalDateTime$.MODULE$.apply(str);
        }
        DataType dataType21 = DataType$.OffsetDateTime;
        DataType dataType22 = dataType2;
        if (!(dataType21 != null ? !dataType21.equals(dataType22) : dataType22 != null)) {
            return TemporalConverter.ToOffsetDateTime$.MODULE$.apply(str);
        }
        DataType dataType23 = DataType$.Instant;
        DataType dataType24 = dataType2;
        if (!(dataType23 != null ? !dataType23.equals(dataType24) : dataType24 != null)) {
            return TemporalConverter.ToInstant$.MODULE$.apply(str);
        }
        DataType dataType25 = DataType$.Time;
        DataType dataType26 = dataType2;
        if (!(dataType25 != null ? !dataType25.equals(dataType26) : dataType26 != null)) {
            return TemporalConverter.ToLocalTime$.MODULE$.apply(str);
        }
        DataType dataType27 = DataType$.YearMonth;
        DataType dataType28 = dataType2;
        if (!(dataType27 != null ? !dataType27.equals(dataType28) : dataType28 != null)) {
            return TemporalConverter.ToYearMonth$.MODULE$.apply(str);
        }
        DataType dataType29 = DataType$.MonthDay;
        DataType dataType30 = dataType2;
        if (!(dataType29 != null ? !dataType29.equals(dataType30) : dataType30 != null)) {
            return TemporalConverter.ToMonthDay$.MODULE$.apply(str);
        }
        return str;
    }

    public final Object org$beangle$data$excel$CellOps$$$convert$extension(Cell $this, double d, DataType dataType) {
        DataType dataType2 = dataType;
        DataType dataType3 = DataType$.String;
        DataType dataType4 = dataType2;
        if (!(dataType3 != null ? !dataType3.equals(dataType4) : dataType4 != null)) {
            return NumFormat.format(d);
        }
        DataType dataType5 = DataType$.Short;
        DataType dataType6 = dataType2;
        if (!(dataType5 != null ? !dataType5.equals(dataType6) : dataType6 != null)) {
            return BoxesRunTime.boxToShort((short)Predef$.MODULE$.double2Double(d).shortValue());
        }
        DataType dataType7 = DataType$.Integer;
        DataType dataType8 = dataType2;
        if (!(dataType7 != null ? !dataType7.equals(dataType8) : dataType8 != null)) {
            return BoxesRunTime.boxToInteger((int)Predef$.MODULE$.double2Double(d).intValue());
        }
        DataType dataType9 = DataType$.Long;
        DataType dataType10 = dataType2;
        if (!(dataType9 != null ? !dataType9.equals(dataType10) : dataType10 != null)) {
            return BoxesRunTime.boxToLong((long)Predef$.MODULE$.double2Double(d).longValue());
        }
        DataType dataType11 = DataType$.Float;
        DataType dataType12 = dataType2;
        if (!(dataType11 != null ? !dataType11.equals(dataType12) : dataType12 != null)) {
            return BoxesRunTime.boxToFloat((float)Predef$.MODULE$.double2Double(d).floatValue());
        }
        DataType dataType13 = DataType$.Double;
        DataType dataType14 = dataType2;
        if (!(dataType13 != null ? !dataType13.equals(dataType14) : dataType14 != null)) {
            return BoxesRunTime.boxToDouble((double)d);
        }
        throw new RuntimeException("Cannot convert double to  " + dataType);
    }

    public final Object org$beangle$data$excel$CellOps$$$convert$extension(Cell $this, java.util.Date d, DataType dataType) {
        DataType dataType2 = dataType;
        DataType dataType3 = DataType$.String;
        DataType dataType4 = dataType2;
        if (!(dataType3 != null ? !dataType3.equals(dataType4) : dataType4 != null)) {
            return new Date(d.getTime()).toLocalDate().toString();
        }
        DataType dataType5 = DataType$.Date;
        DataType dataType6 = dataType2;
        if (!(dataType5 != null ? !dataType5.equals(dataType6) : dataType6 != null)) {
            return new Date(d.getTime()).toLocalDate();
        }
        DataType dataType7 = DataType$.DateTime;
        DataType dataType8 = dataType2;
        if (!(dataType7 != null ? !dataType7.equals(dataType8) : dataType8 != null)) {
            return d.toInstant().atZone(ZoneId.systemDefault()).toLocalDateTime();
        }
        DataType dataType9 = DataType$.Time;
        DataType dataType10 = dataType2;
        if (!(dataType9 != null ? !dataType9.equals(dataType10) : dataType10 != null)) {
            return d.toInstant().atZone(ZoneId.systemDefault()).toLocalTime();
        }
        DataType dataType11 = DataType$.YearMonth;
        DataType dataType12 = dataType2;
        if (!(dataType11 != null ? !dataType11.equals(dataType12) : dataType12 != null)) {
            return YearMonth.from(new Date(d.getTime()).toLocalDate());
        }
        DataType dataType13 = DataType$.MonthDay;
        DataType dataType14 = dataType2;
        if (!(dataType13 != null ? !dataType13.equals(dataType14) : dataType14 != null)) {
            return MonthDay.from(new Date(d.getTime()).toLocalDate());
        }
        DataType dataType15 = DataType$.Instant;
        DataType dataType16 = dataType2;
        if (!(dataType15 != null ? !dataType15.equals(dataType16) : dataType16 != null)) {
            return d.toInstant();
        }
        DataType dataType17 = DataType$.OffsetDateTime;
        DataType dataType18 = dataType2;
        if (!(dataType17 != null ? !dataType17.equals(dataType18) : dataType18 != null)) {
            return d.toInstant().atOffset(ZoneOffset.UTC);
        }
        throw new RuntimeException("Cannot convert date to  " + dataType);
    }

    public final void org$beangle$data$excel$CellOps$$$fill$extension(Cell $this, Date d, ExcelStyleRegistry registry) {
        $this.setCellValue((java.util.Date)d);
        $this.setCellStyle(registry.get(DataType$.Date));
    }

    public final void org$beangle$data$excel$CellOps$$$fill$extension(Cell $this, java.util.Date d, ExcelStyleRegistry registry) {
        $this.setCellValue(d);
        $this.setCellStyle(registry.get(DataType$.DateTime));
    }

    public final void org$beangle$data$excel$CellOps$$$fill$extension(Cell $this, YearMonth d, ExcelStyleRegistry registry) {
        $this.setCellValue((java.util.Date)Date.valueOf(d.atDay(1)));
        $this.setCellStyle(registry.get(DataType$.YearMonth));
    }

    public final void org$beangle$data$excel$CellOps$$$fill$extension(Cell $this, Year d, ExcelStyleRegistry registry) {
        $this.setCellValue(Int$.MODULE$.int2double(d.getValue()));
        $this.setCellStyle(registry.get(DataType$.YearMonth));
    }

    public final void org$beangle$data$excel$CellOps$$$fill$extension(Cell $this, MonthDay d, ExcelStyleRegistry registry) {
        $this.setCellValue((java.util.Date)Date.valueOf(d.atYear(2000)));
        $this.setCellStyle(registry.get(DataType$.MonthDay));
    }

    public final void org$beangle$data$excel$CellOps$$$fill$extension(Cell $this, Time d, ExcelStyleRegistry registry) {
        $this.setCellValue((java.util.Date)d);
        $this.setCellStyle(registry.get(DataType$.Time));
    }

    public final void org$beangle$data$excel$CellOps$$$fill$extension(Cell $this, float d, ExcelStyleRegistry registry) {
        $this.setCellValue(Float$.MODULE$.float2double(d));
        $this.setCellStyle(registry.get(DataType$.Float));
    }

    public final void org$beangle$data$excel$CellOps$$$fill$extension(Cell $this, double d, ExcelStyleRegistry registry) {
        $this.setCellValue(d);
        $this.setCellStyle(registry.get(DataType$.Double));
    }

    public final void org$beangle$data$excel$CellOps$$$fill$extension(Cell $this, int d, ExcelStyleRegistry registry) {
        $this.setCellValue(Int$.MODULE$.int2double(d));
        $this.setCellStyle(registry.get(DataType$.Integer));
    }

    public final void org$beangle$data$excel$CellOps$$$fill$extension(Cell $this, String s, ExcelStyleRegistry registry) {
        $this.setCellValue((RichTextString)new XSSFRichTextString(s));
    }

    public final void org$beangle$data$excel$CellOps$$$fill$extension(Cell $this, boolean b, ExcelStyleRegistry registry) {
        $this.setCellValue(b ? "Y" : "N");
    }

    public final void org$beangle$data$excel$CellOps$$$fillBlank$extension(Cell $this) {
        $this.setBlank();
    }
}

