/*
 * Decompiled with CFR 0.152.
 */
package org.beangle.data.excel;

import org.apache.poi.ss.util.CellReference;
import org.beangle.commons.lang.Strings$;
import org.beangle.data.excel.CellRef$;

public class CellRef
implements Comparable<CellRef> {
    private String sheetName;
    private int row;
    private int col;
    private boolean isColAbs;
    private boolean isRowAbs;

    public static char ABSOLUTE_REFERENCE_MARKER() {
        return CellRef$.MODULE$.ABSOLUTE_REFERENCE_MARKER();
    }

    public static CellRef NONE() {
        return CellRef$.MODULE$.NONE();
    }

    public static char SHEET_NAME_DELIMITER() {
        return CellRef$.MODULE$.SHEET_NAME_DELIMITER();
    }

    public static CellRef apply(CellReference cellReference) {
        return CellRef$.MODULE$.apply(cellReference);
    }

    public static CellRef apply(int n, int n2) {
        return CellRef$.MODULE$.apply(n, n2);
    }

    public static CellRef apply(String string) {
        return CellRef$.MODULE$.apply(string);
    }

    public static boolean isPlainColumn(String string) {
        return CellRef$.MODULE$.isPlainColumn(string);
    }

    public CellRef(String sheetName, int row, int col) {
        this.sheetName = sheetName;
        this.row = row;
        this.col = col;
        this.isColAbs = false;
        this.isRowAbs = false;
    }

    public String sheetName() {
        return this.sheetName;
    }

    public void sheetName_$eq(String x$1) {
        this.sheetName = x$1;
    }

    public int row() {
        return this.row;
    }

    public void row_$eq(int x$1) {
        this.row = x$1;
    }

    public int col() {
        return this.col;
    }

    public void col_$eq(int x$1) {
        this.col = x$1;
    }

    public boolean isColAbs() {
        return this.isColAbs;
    }

    public void isColAbs_$eq(boolean x$1) {
        this.isColAbs = x$1;
    }

    public boolean isRowAbs() {
        return this.isRowAbs;
    }

    public void isRowAbs_$eq(boolean x$1) {
        this.isRowAbs = x$1;
    }

    public String getCellName(boolean ignoreSheetName) {
        StringBuilder sb = new StringBuilder(32);
        if (!ignoreSheetName && Strings$.MODULE$.isNotBlank((CharSequence)this.sheetName())) {
            sb.append(this.sheetName());
            sb.append(CellRef$.MODULE$.SHEET_NAME_DELIMITER());
        }
        if (this.isColAbs()) {
            sb.append(CellRef$.MODULE$.ABSOLUTE_REFERENCE_MARKER());
        }
        sb.append(CellReference.convertNumToColString((int)this.col()));
        if (this.isRowAbs()) {
            sb.append(CellRef$.MODULE$.ABSOLUTE_REFERENCE_MARKER());
        }
        sb.append(this.row() + 1);
        return sb.toString();
    }

    public boolean getCellName$default$1() {
        return false;
    }

    public CellRef move(int rowplus, int colPlus) {
        return new CellRef(this.sheetName(), rowplus + this.row(), colPlus + this.col());
    }

    public String getFormattedSheetName() {
        return this.sheetName();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object o) {
        Object object = o;
        if (object == null) {
            return false;
        }
        if (!(object instanceof CellRef)) return false;
        CellRef cellRef = (CellRef)object;
        if (this.col() != cellRef.col()) return false;
        if (this.row() != cellRef.row()) return false;
        String string = this.sheetName();
        String string2 = cellRef.sheetName();
        if (string != null) {
            if (!string.equals(string2)) return false;
            return true;
        }
        if (string2 == null) return true;
        return false;
    }

    public int hashCode() {
        int result = this.col();
        result = 31 * result + this.row();
        result = 31 * result + this.sheetName().hashCode();
        return result;
    }

    public boolean isValid() {
        return this.col() >= 0 && this.row() >= 0;
    }

    public String toString() {
        return this.getCellName(false);
    }

    @Override
    public int compareTo(CellRef that) {
        if (this == that) {
            return 0;
        }
        if (this.col() < that.col()) {
            return -1;
        }
        if (this.col() > that.col()) {
            return 1;
        }
        if (this.row() < that.row()) {
            return -1;
        }
        if (this.row() > that.row()) {
            return 1;
        }
        return 0;
    }
}

