/*
 * Decompiled with CFR 0.152.
 */
package org.beangle.data.excel;

import java.io.Serializable;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.ClientAnchor;
import org.apache.poi.ss.usermodel.CreationHelper;
import org.apache.poi.ss.usermodel.Drawing;
import org.apache.poi.ss.usermodel.Picture;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.CellAddress;
import org.apache.poi.ss.util.CellRangeAddress;
import org.beangle.data.excel.AreaRef;
import org.beangle.data.excel.CellRef;
import org.beangle.data.excel.ImageType;
import org.beangle.data.excel.ImageType$;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;

public final class Workbooks$
implements Serializable {
    public static final Workbooks$ MODULE$ = new Workbooks$();

    private Workbooks$() {
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(Workbooks$.class);
    }

    public void cleanCell(Workbook workbook, CellRef cellRef) {
        if (cellRef == null || cellRef.sheetName() == null) {
            return;
        }
        Sheet sheet = workbook.getSheet(cellRef.sheetName());
        if (sheet != null) {
            Row row = sheet.getRow(cellRef.row());
            if (row != null) {
                Cell cell = row.getCell(cellRef.col());
                if (cell == null) {
                    CellAddress cellAddress = new CellAddress(cellRef.row(), cellRef.col());
                    if (sheet.getCellComment(cellAddress) != null) {
                        cell = row.createCell(cellRef.col());
                        cell.removeCellComment();
                        return;
                    }
                    return;
                }
                cell.setBlank();
                cell.setCellStyle(workbook.getCellStyleAt(0));
                cell.removeCellComment();
                return;
            }
            return;
        }
    }

    public Cell getOrCreateCell(Workbook workbook, CellRef cellRef) {
        Cell cell;
        Row row;
        Predef$.MODULE$.require(cellRef != null && cellRef.sheetName() != null);
        Sheet sheet = workbook.getSheet(cellRef.sheetName());
        if (sheet == null) {
            sheet = workbook.createSheet(cellRef.sheetName());
        }
        if ((row = sheet.getRow(cellRef.row())) == null) {
            row = sheet.createRow(cellRef.row());
        }
        if ((cell = row.getCell(cellRef.col())) == null) {
            cell = row.createCell(cellRef.col());
        }
        return cell;
    }

    public void mergeCells(Workbook workbook, CellRef cellRef, int rows, int cols, CellStyle cellStyle) {
        Sheet sheet = workbook.getSheet(cellRef.sheetName());
        CellRangeAddress region = new CellRangeAddress(cellRef.row(), cellRef.row() + rows - 1, cellRef.col(), cellRef.col() + cols - 1);
        sheet.addMergedRegion(region);
        if (cellStyle != null) {
            this.getOrCreateCell(workbook, cellRef).setCellStyle(cellStyle);
            return;
        }
    }

    public CellStyle mergeCells$default$5() {
        return null;
    }

    public void addImage(Workbook workbook, AreaRef areaRef, byte[] imageBytes, ImageType imageType, Option<Object> scaleX, Option<Object> scaleY) {
        int pictureIdx = workbook.addPicture(imageBytes, this.findPoiPictureTypeByImageType(imageType));
        this.addImage(workbook, areaRef, pictureIdx, scaleX, scaleY);
    }

    public void addImage(Workbook workbook, AreaRef areaRef, byte[] imageBytes, ImageType imageType) {
        int pictureIdx = workbook.addPicture(imageBytes, this.findPoiPictureTypeByImageType(imageType));
        this.addImage(workbook, areaRef, pictureIdx, null, null);
    }

    private int findPoiPictureTypeByImageType(ImageType imageType) {
        ImageType imageType2 = imageType;
        ImageType imageType3 = ImageType$.PNG;
        ImageType imageType4 = imageType2;
        if (!(imageType3 != null ? !imageType3.equals(imageType4) : imageType4 != null)) {
            return 6;
        }
        ImageType imageType5 = ImageType$.JPEG;
        ImageType imageType6 = imageType2;
        if (!(imageType5 != null ? !imageType5.equals(imageType6) : imageType6 != null)) {
            return 5;
        }
        throw new MatchError((Object)imageType2);
    }

    private void addImage(Workbook workbook, AreaRef areaRef, int imageIdx, Option<Object> scaleX, Option<Object> scaleY) {
        boolean pictureResizeFlag = scaleX.nonEmpty() && scaleY.nonEmpty();
        CreationHelper helper = workbook.getCreationHelper();
        Sheet sheet = workbook.getSheet(areaRef.sheetName());
        if (sheet == null) {
            sheet = workbook.createSheet(areaRef.sheetName());
        }
        Drawing drawing = sheet.createDrawingPatriarch();
        ClientAnchor anchor = helper.createClientAnchor();
        anchor.setCol1(areaRef.firstCellRef().col());
        anchor.setRow1(areaRef.firstCellRef().row());
        if (pictureResizeFlag) {
            anchor.setAnchorType(ClientAnchor.AnchorType.MOVE_DONT_RESIZE);
            anchor.setCol2(-1);
            anchor.setRow2(-1);
        } else {
            anchor.setCol2(areaRef.lastCellRef().col());
            anchor.setRow2(areaRef.lastCellRef().row());
        }
        Picture picture = drawing.createPicture(anchor, imageIdx);
        if (pictureResizeFlag) {
            picture.resize(BoxesRunTime.unboxToDouble((Object)scaleX.get()), BoxesRunTime.unboxToDouble((Object)scaleY.get()));
            return;
        }
    }
}

