/*
 * Decompiled with CFR 0.152.
 */
package org.beangle.data.excel.schema;

import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import org.apache.poi.ss.usermodel.DataValidation;
import org.apache.poi.ss.usermodel.DataValidationConstraint;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.ss.util.CellRangeAddressList;
import org.apache.poi.xssf.usermodel.XSSFDataValidationHelper;
import org.beangle.data.excel.schema.ExcelColumn;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;

public final class Constraints$
implements Serializable {
    public static final Constraints$ MODULE$ = new Constraints$();

    private Constraints$() {
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(Constraints$.class);
    }

    public DataValidation asBoolean(XSSFDataValidationHelper helper, ExcelColumn col, int startRowIdx, int columnIdx) {
        DataValidationConstraint constraint = helper.createExplicitListConstraint(new String[]{"Y", "N"});
        DataValidation v = this.createValidation(helper, col, startRowIdx, columnIdx, constraint, "\u8bf7\u9009\u62e9Y/N");
        v.setSuppressDropDownArrow(true);
        return v;
    }

    public DataValidation asFormular(XSSFDataValidationHelper helper, String formular, ExcelColumn col, int startRowIdx, int columnIdx, String prompt) {
        DataValidationConstraint constraint = helper.createFormulaListConstraint(formular);
        DataValidation validation = this.createValidation(helper, col, startRowIdx, columnIdx, constraint, "\u8bf7\u9009\u62e9\u5408\u9002\u7684" + col.name());
        validation.setSuppressDropDownArrow(true);
        return validation;
    }

    public DataValidation asDate(XSSFDataValidationHelper helper, ExcelColumn col, int startRowIdx, int columnIdx) {
        String prompt = null;
        DataValidationConstraint constraint = null;
        String format = (String)col.format().get();
        SimpleDateFormat sdf = new SimpleDateFormat(format);
        String formual1Value = BoxesRunTime.boxToDouble((double)DateUtil.getExcelDate((Date)sdf.parse(col.formular1()))).toString();
        String lf = format.toLowerCase();
        String cellContent = lf.contains("yyyy") ? (lf.contains("hh") ? "\u65e5\u671f\u65f6\u95f4" : "\u65e5\u671f") : "\u65f6\u95f4";
        Option<String> option = col.formular2();
        if (None$.MODULE$.equals(option)) {
            constraint = helper.createDateConstraint(6, formual1Value, null, format);
            prompt = this.composeError(cellContent, col.formular1(), (Option<String>)None$.MODULE$, this.composeError$default$4());
        } else if (option instanceof Some) {
            String f2 = (String)((Some)option).value();
            String formual2Value = BoxesRunTime.boxToDouble((double)DateUtil.getExcelDate((Date)sdf.parse(f2))).toString();
            constraint = helper.createDateConstraint(0, formual1Value, formual2Value, format);
            prompt = this.composeError(cellContent, col.formular1(), col.formular2(), this.composeError$default$4());
        } else {
            throw new MatchError(option);
        }
        return this.createValidation(helper, col, startRowIdx, columnIdx, constraint, prompt);
    }

    public DataValidation asTime(XSSFDataValidationHelper helper, ExcelColumn col, int startRowIdx, int columnIdx) {
        String prompt = null;
        DataValidationConstraint constraint = null;
        String format = (String)col.format().get();
        String cellContent = "\u65f6\u95f4";
        Option<String> option = col.formular2();
        if (None$.MODULE$.equals(option)) {
            constraint = helper.createTimeConstraint(6, this.toTimeFormula(col.formular1(), format), null);
            prompt = this.composeError(cellContent, col.formular1(), (Option<String>)None$.MODULE$, this.composeError$default$4());
        } else if (option instanceof Some) {
            String f2 = (String)((Some)option).value();
            constraint = helper.createTimeConstraint(0, this.toTimeFormula(col.formular1(), format), this.toTimeFormula(f2, format));
            prompt = this.composeError(cellContent, col.formular1(), col.formular2(), this.composeError$default$4());
        } else {
            throw new MatchError(option);
        }
        return this.createValidation(helper, col, startRowIdx, columnIdx, constraint, prompt);
    }

    public DataValidation asNumeric(XSSFDataValidationHelper helper, ExcelColumn col, int validationType, int startRowIdx, int columnIdx) {
        String prompt = null;
        DataValidationConstraint constraint = null;
        String unit = "\u503c";
        int n = validationType;
        String dataType = switch (n) {
            case 1 -> "\u6574\u6570";
            case 2 -> "\u5c0f\u6570";
            case 6 -> {
                unit = "\u957f\u5ea6";
                yield "\u6587\u672c";
            }
            default -> "";
        };
        Option<String> option = col.formular2();
        if (None$.MODULE$.equals(option)) {
            constraint = helper.createNumericConstraint(validationType, 6, col.formular1(), null);
            prompt = this.composeError(dataType, col.formular1(), (Option<String>)None$.MODULE$, this.composeError$default$4());
        } else if (option instanceof Some) {
            String f2 = (String)((Some)option).value();
            constraint = helper.createNumericConstraint(validationType, 0, col.formular1(), f2);
            prompt = this.composeError(dataType, col.formular1(), col.formular2(), unit);
        } else {
            throw new MatchError(option);
        }
        return this.createValidation(helper, col, startRowIdx, columnIdx, constraint, prompt);
    }

    public DataValidation asUnique(XSSFDataValidationHelper helper, ExcelColumn col, int startRowIdx, int columnIdx) {
        char cn = (char)(65 + columnIdx);
        int rn = startRowIdx + 1;
        String formular = "COUNTIF($" + cn + "$" + rn + ":" + cn + rn + "," + cn + rn + ")=1";
        Object error = "\u8be5\u5217\u4e0d\u5141\u8bb8\u6709\u91cd\u590d";
        if (col.length().nonEmpty()) {
            String cname = BoxesRunTime.boxToCharacter((char)cn).toString() + BoxesRunTime.boxToInteger((int)rn).toString();
            formular = "AND(AND(LEN(" + cname + ") >= " + col.formular1() + ",LEN(" + cname + ") <= " + col.length().get() + ")," + formular + ")";
            error = (String)error + (",\u5e76\u4e14" + this.composeError("\u6587\u672c", col.formular1(), col.formular2(), "\u957f\u5ea6"));
        }
        DataValidationConstraint constraint = helper.createCustomConstraint("=" + formular);
        CellRangeAddressList addressList = new CellRangeAddressList(startRowIdx, 1048575, columnIdx, columnIdx);
        DataValidation validation = helper.createValidation(constraint, addressList);
        validation.createErrorBox(col.name() + "\u8f93\u5165\u9519\u8bef", (String)error);
        validation.setShowErrorBox(true);
        validation.setShowPromptBox(true);
        validation.setSuppressDropDownArrow(true);
        return validation;
    }

    private String toTimeFormula(String formula, String format) {
        LocalTime t = LocalTime.parse(formula, DateTimeFormatter.ofPattern(format));
        return "=TIME(" + t.getHour() + "," + t.getMinute() + "," + t.getSecond() + ")";
    }

    private DataValidation createValidation(XSSFDataValidationHelper helper, ExcelColumn col, int startRowIdx, int columnIdx, DataValidationConstraint constraint, String prompt) {
        CellRangeAddressList addressList = new CellRangeAddressList(startRowIdx, 1048575, columnIdx, columnIdx);
        DataValidation validation = helper.createValidation(constraint, addressList);
        validation.createErrorBox(col.name() + "\u8f93\u5165\u6709\u8bef", prompt);
        validation.setShowErrorBox(true);
        validation.setSuppressDropDownArrow(false);
        validation.setEmptyCellAllowed(!col.required());
        return validation;
    }

    private String composeError(String what, String min, Option<String> max, String quantifier) {
        Option<String> option = max;
        if (None$.MODULE$.equals(option)) {
            return "\u8bf7\u8f93\u5165" + quantifier + "\u5927\u4e8e\u7b49\u4e8e" + min + "\u7684" + what;
        }
        if (option instanceof Some) {
            String m;
            String string = m = (String)((Some)option).value();
            String string2 = min;
            if (!(string != null ? !string.equals(string2) : string2 != null)) {
                return "\u8bf7\u8f93\u5165" + quantifier + "\u4e3a" + min + "\u7684" + what;
            }
            return "\u8bf7\u8f93\u5165" + quantifier + "\u5728" + min + "~" + m + "\u4e4b\u95f4\u7684" + what;
        }
        throw new MatchError(option);
    }

    private String composeError$default$4() {
        return "";
    }
}

