/*
 * Decompiled with CFR 0.152.
 */
package org.beangle.data.excel.schema;

import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import org.beangle.commons.io.DataType;
import org.beangle.commons.io.DataType$;
import org.beangle.commons.lang.Numbers$;
import org.beangle.data.excel.ExcelStyleRegistry$;
import scala.None$;
import scala.Option;
import scala.Some$;
import scala.collection.Seq;
import scala.runtime.BoxesRunTime;
import scala.runtime.Scala3RunTime$;

public class ExcelColumn {
    private String name;
    private Option comment;
    private Option remark;
    private DataType dataType;
    private boolean isDate;
    private boolean isTime;
    private boolean isInt;
    private boolean isDecimal;
    private boolean isBool;
    private Seq refs;
    private Seq datas;
    private String formular1;
    private Option formular2;
    private Option length;
    private boolean required;
    private boolean unique;
    private Option format;

    public ExcelColumn(String name) {
        this.name = name;
        this.comment = None$.MODULE$;
        this.remark = None$.MODULE$;
        this.dataType = DataType$.String;
        this.formular2 = None$.MODULE$;
        this.length = None$.MODULE$;
        this.format = None$.MODULE$;
    }

    public String name() {
        return this.name;
    }

    public void name_$eq(String x$1) {
        this.name = x$1;
    }

    public Option<String> comment() {
        return this.comment;
    }

    public void comment_$eq(Option<String> x$1) {
        this.comment = x$1;
    }

    public Option<String> remark() {
        return this.remark;
    }

    public void remark_$eq(Option<String> x$1) {
        this.remark = x$1;
    }

    public DataType dataType() {
        return this.dataType;
    }

    public void dataType_$eq(DataType x$1) {
        this.dataType = x$1;
    }

    public boolean isDate() {
        return this.isDate;
    }

    public void isDate_$eq(boolean x$1) {
        this.isDate = x$1;
    }

    public boolean isTime() {
        return this.isTime;
    }

    public void isTime_$eq(boolean x$1) {
        this.isTime = x$1;
    }

    public boolean isInt() {
        return this.isInt;
    }

    public void isInt_$eq(boolean x$1) {
        this.isInt = x$1;
    }

    public boolean isDecimal() {
        return this.isDecimal;
    }

    public void isDecimal_$eq(boolean x$1) {
        this.isDecimal = x$1;
    }

    public boolean isBool() {
        return this.isBool;
    }

    public void isBool_$eq(boolean x$1) {
        this.isBool = x$1;
    }

    public Seq<String> refs() {
        return this.refs;
    }

    public void refs_$eq(Seq<String> x$1) {
        this.refs = x$1;
    }

    public Seq<String> datas() {
        return this.datas;
    }

    public void datas_$eq(Seq<String> x$1) {
        this.datas = x$1;
    }

    public String formular1() {
        return this.formular1;
    }

    public void formular1_$eq(String x$1) {
        this.formular1 = x$1;
    }

    public Option<String> formular2() {
        return this.formular2;
    }

    public void formular2_$eq(Option<String> x$1) {
        this.formular2 = x$1;
    }

    public Option<Object> length() {
        return this.length;
    }

    public void length_$eq(Option<Object> x$1) {
        this.length = x$1;
    }

    public boolean required() {
        return this.required;
    }

    public void required_$eq(boolean x$1) {
        this.required = x$1;
    }

    public boolean unique() {
        return this.unique;
    }

    public void unique_$eq(boolean x$1) {
        this.unique = x$1;
    }

    public Option<String> format() {
        return this.format;
    }

    public void format_$eq(Option<String> x$1) {
        this.format = x$1;
    }

    public ExcelColumn format(String f) {
        this.format_$eq((Option<String>)Some$.MODULE$.apply((Object)f));
        return this;
    }

    public ExcelColumn remark(String r) {
        this.remark_$eq((Option<String>)Some$.MODULE$.apply((Object)r));
        return this;
    }

    public ExcelColumn unique(boolean nv) {
        this.unique_$eq(nv);
        return this;
    }

    public boolean unique$default$1() {
        return true;
    }

    public ExcelColumn required(boolean r) {
        this.required_$eq(r);
        return this;
    }

    public boolean required$default$1() {
        return true;
    }

    public ExcelColumn date(String f) {
        this.isDate_$eq(true);
        this.dataType_$eq(DataType$.Date);
        this.format_$eq((Option<String>)Some$.MODULE$.apply((Object)f));
        this.formular1_$eq("1900-01-01");
        return this;
    }

    public String date$default$1() {
        return "YYYY-MM-DD";
    }

    public ExcelColumn yearMonth() {
        this.isDate_$eq(true);
        this.dataType_$eq(DataType$.YearMonth);
        this.format_$eq((Option<String>)Some$.MODULE$.apply((Object)"yyyy-MM"));
        this.formular1_$eq("1900-01");
        return this;
    }

    public ExcelColumn datatime() {
        this.isDate_$eq(true);
        this.dataType_$eq(DataType$.DateTime);
        this.format_$eq((Option<String>)Some$.MODULE$.apply((Object)"yyyy-MM-dd HH:mm:ss"));
        this.formular1_$eq("1900-01-01 00:00:01");
        return this;
    }

    public ExcelColumn time() {
        this.isTime_$eq(true);
        this.dataType_$eq(DataType$.Time);
        this.format_$eq((Option<String>)Some$.MODULE$.apply((Object)"HH:mm:ss"));
        this.formular1_$eq("00:00:01");
        return this;
    }

    public ExcelColumn min(Object formular) {
        this.formular1_$eq(formular.toString());
        return this;
    }

    public ExcelColumn max(Object formular) {
        this.length_$eq((Option<Object>)Some$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)Numbers$.MODULE$.toInt(formular.toString(), Numbers$.MODULE$.toInt$default$2()))));
        if (this.formular1() == null) {
            this.formular1_$eq("0");
        }
        this.formular2_$eq((Option<String>)Some$.MODULE$.apply((Object)formular.toString()));
        return this;
    }

    public ExcelColumn length(int max) {
        this.length_$eq((Option<Object>)Some$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)max)));
        this.format_$eq((Option<String>)Some$.MODULE$.apply((Object)"@"));
        if (this.formular1() == null) {
            this.formular1_$eq("0");
        }
        this.formular2_$eq((Option<String>)Some$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)max).toString()));
        return this;
    }

    public ExcelColumn decimal(String f) {
        this.isDecimal_$eq(true);
        this.dataType_$eq(DataType$.Double);
        this.format_$eq((Option<String>)Some$.MODULE$.apply((Object)f));
        this.formular1_$eq("0");
        return this;
    }

    public String decimal$default$1() {
        return "0.##";
    }

    public ExcelColumn decimal(float min, float max) {
        this.isDecimal_$eq(true);
        this.dataType_$eq(DataType$.Double);
        this.format_$eq((Option<String>)Some$.MODULE$.apply((Object)"0.##"));
        if (!(max >= min)) {
            throw Scala3RunTime$.MODULE$.assertFailed();
        }
        this.formular1_$eq(BoxesRunTime.boxToFloat((float)min).toString());
        this.formular2_$eq((Option<String>)Some$.MODULE$.apply((Object)BoxesRunTime.boxToFloat((float)max).toString()));
        return this;
    }

    public ExcelColumn bool() {
        this.isBool_$eq(true);
        this.dataType_$eq(DataType$.Boolean);
        return this;
    }

    public ExcelColumn integer(String f) {
        this.isInt_$eq(true);
        this.dataType_$eq(DataType$.Integer);
        this.format_$eq((Option<String>)Some$.MODULE$.apply((Object)f));
        this.formular1_$eq("0");
        return this;
    }

    public String integer$default$1() {
        return "0";
    }

    public ExcelColumn integer(int min, int max) {
        this.isInt_$eq(true);
        this.dataType_$eq(DataType$.Integer);
        this.format_$eq((Option<String>)Some$.MODULE$.apply((Object)"0"));
        if (max < min) {
            throw Scala3RunTime$.MODULE$.assertFailed();
        }
        this.formular1_$eq(BoxesRunTime.boxToInteger((int)min).toString());
        this.formular2_$eq((Option<String>)Some$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)max).toString()));
        return this;
    }

    public ExcelColumn ref(Seq<String> data) {
        this.refs_$eq(data);
        return this;
    }

    public ExcelColumn data(Seq<String> data) {
        this.datas_$eq(data);
        return this;
    }

    public ExcelColumn asType(Class<?> clazz) {
        return this.asType(DataType$.MODULE$.toType(clazz));
    }

    public ExcelColumn asType(DataType dt) {
        block1: {
            block15: {
                DataType dataType;
                DataType dataType2;
                block27: {
                    DataType dataType3;
                    block26: {
                        DataType dataType4;
                        DataType dataType5;
                        block25: {
                            block24: {
                                DataType dataType6;
                                DataType dataType7;
                                block23: {
                                    block22: {
                                        DataType dataType8;
                                        DataType dataType9;
                                        block21: {
                                            block20: {
                                                DataType dataType10;
                                                DataType dataType11;
                                                block19: {
                                                    block18: {
                                                        DataType dataType12;
                                                        DataType dataType13;
                                                        block17: {
                                                            block16: {
                                                                DataType dataType14;
                                                                DataType dataType15;
                                                                block14: {
                                                                    block13: {
                                                                        block10: {
                                                                            DataType dataType16;
                                                                            DataType dataType17;
                                                                            block12: {
                                                                                block11: {
                                                                                    DataType dataType18;
                                                                                    DataType dataType19;
                                                                                    block9: {
                                                                                        block8: {
                                                                                            block3: {
                                                                                                DataType dataType20;
                                                                                                DataType dataType21;
                                                                                                block7: {
                                                                                                    block6: {
                                                                                                        DataType dataType22;
                                                                                                        DataType dataType23;
                                                                                                        block5: {
                                                                                                            block4: {
                                                                                                                DataType dataType24;
                                                                                                                DataType dataType25;
                                                                                                                block2: {
                                                                                                                    block0: {
                                                                                                                        this.dataType_$eq(dt);
                                                                                                                        this.format_$eq((Option<String>)Some$.MODULE$.apply((Object)ExcelStyleRegistry$.MODULE$.defaultFormat(this.dataType())));
                                                                                                                        dataType3 = dt;
                                                                                                                        DataType dataType26 = DataType$.Boolean;
                                                                                                                        DataType dataType27 = dataType3;
                                                                                                                        if (dataType26 != null ? !dataType26.equals(dataType27) : dataType27 != null) break block0;
                                                                                                                        this.isBool_$eq(true);
                                                                                                                        break block1;
                                                                                                                    }
                                                                                                                    dataType25 = DataType$.Short;
                                                                                                                    dataType24 = dataType3;
                                                                                                                    if (dataType25 != null) break block2;
                                                                                                                    if (dataType24 == null) break block3;
                                                                                                                    break block4;
                                                                                                                }
                                                                                                                if (dataType25.equals(dataType24)) break block3;
                                                                                                            }
                                                                                                            dataType23 = DataType$.Integer;
                                                                                                            dataType22 = dataType3;
                                                                                                            if (dataType23 != null) break block5;
                                                                                                            if (dataType22 == null) break block3;
                                                                                                            break block6;
                                                                                                        }
                                                                                                        if (dataType23.equals(dataType22)) break block3;
                                                                                                    }
                                                                                                    dataType21 = DataType$.Long;
                                                                                                    dataType20 = dataType3;
                                                                                                    if (dataType21 != null) break block7;
                                                                                                    if (dataType20 == null) break block3;
                                                                                                    break block8;
                                                                                                }
                                                                                                if (!dataType21.equals(dataType20)) break block8;
                                                                                            }
                                                                                            this.isInt_$eq(true);
                                                                                            this.formular1_$eq("0");
                                                                                            break block1;
                                                                                        }
                                                                                        dataType19 = DataType$.Float;
                                                                                        dataType18 = dataType3;
                                                                                        if (dataType19 != null) break block9;
                                                                                        if (dataType18 == null) break block10;
                                                                                        break block11;
                                                                                    }
                                                                                    if (dataType19.equals(dataType18)) break block10;
                                                                                }
                                                                                dataType17 = DataType$.Double;
                                                                                dataType16 = dataType3;
                                                                                if (dataType17 != null) break block12;
                                                                                if (dataType16 == null) break block10;
                                                                                break block13;
                                                                            }
                                                                            if (!dataType17.equals(dataType16)) break block13;
                                                                        }
                                                                        this.isDecimal_$eq(true);
                                                                        this.formular1_$eq("0");
                                                                        break block1;
                                                                    }
                                                                    dataType15 = DataType$.Date;
                                                                    dataType14 = dataType3;
                                                                    if (dataType15 != null) break block14;
                                                                    if (dataType14 == null) break block15;
                                                                    break block16;
                                                                }
                                                                if (dataType15.equals(dataType14)) break block15;
                                                            }
                                                            dataType13 = DataType$.Time;
                                                            dataType12 = dataType3;
                                                            if (dataType13 != null) break block17;
                                                            if (dataType12 == null) break block15;
                                                            break block18;
                                                        }
                                                        if (dataType13.equals(dataType12)) break block15;
                                                    }
                                                    dataType11 = DataType$.DateTime;
                                                    dataType10 = dataType3;
                                                    if (dataType11 != null) break block19;
                                                    if (dataType10 == null) break block15;
                                                    break block20;
                                                }
                                                if (dataType11.equals(dataType10)) break block15;
                                            }
                                            dataType9 = DataType$.OffsetDateTime;
                                            dataType8 = dataType3;
                                            if (dataType9 != null) break block21;
                                            if (dataType8 == null) break block15;
                                            break block22;
                                        }
                                        if (dataType9.equals(dataType8)) break block15;
                                    }
                                    dataType7 = DataType$.Instant;
                                    dataType6 = dataType3;
                                    if (dataType7 != null) break block23;
                                    if (dataType6 == null) break block15;
                                    break block24;
                                }
                                if (dataType7.equals(dataType6)) break block15;
                            }
                            dataType5 = DataType$.YearMonth;
                            dataType4 = dataType3;
                            if (dataType5 != null) break block25;
                            if (dataType4 == null) break block15;
                            break block26;
                        }
                        if (dataType5.equals(dataType4)) break block15;
                    }
                    dataType2 = DataType$.MonthDay;
                    dataType = dataType3;
                    if (dataType2 != null) break block27;
                    if (dataType == null) break block15;
                    break block1;
                }
                if (!dataType2.equals(dataType)) break block1;
            }
            this.isDate_$eq(true);
            LocalDate start = LocalDate.of(1900, 1, 1);
            this.formular1_$eq(start.format(DateTimeFormatter.ofPattern((String)this.format().get())));
        }
        return this;
    }
}

