/*
 * Decompiled with CFR 0.152.
 */
package org.beangle.data.excel.template;

import java.io.Serializable;
import org.beangle.data.excel.CellRef;
import org.beangle.data.excel.Size;
import org.beangle.data.excel.template.CellData;
import org.beangle.data.excel.template.RowData;
import org.beangle.data.excel.template.SheetData;
import org.beangle.data.excel.template.Transformer;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.Set;
import scala.collection.immutable.Map;
import scala.collection.mutable.HashSet;
import scala.runtime.RichInt$;
import scala.runtime.function.JProcedure1;
import scala.runtime.java8.JFunction1;

public abstract class AbstractTransformer
implements Transformer {
    private boolean ignoreColumnProps = false;
    private boolean ignoreRowProps = false;
    private Map sheetMap;
    private boolean evaluateFormulas = false;
    private boolean fullFormulaRecalculationOnOpening = false;

    public boolean ignoreColumnProps() {
        return this.ignoreColumnProps;
    }

    public void ignoreColumnProps_$eq(boolean x$1) {
        this.ignoreColumnProps = x$1;
    }

    public boolean ignoreRowProps() {
        return this.ignoreRowProps;
    }

    public void ignoreRowProps_$eq(boolean x$1) {
        this.ignoreRowProps = x$1;
    }

    public Map<String, SheetData> sheetMap() {
        return this.sheetMap;
    }

    public void sheetMap_$eq(Map<String, SheetData> x$1) {
        this.sheetMap = x$1;
    }

    public boolean evaluateFormulas() {
        return this.evaluateFormulas;
    }

    public void evaluateFormulas_$eq(boolean x$1) {
        this.evaluateFormulas = x$1;
    }

    public boolean fullFormulaRecalculationOnOpening() {
        return this.fullFormulaRecalculationOnOpening;
    }

    public void fullFormulaRecalculationOnOpening_$eq(boolean x$1) {
        this.fullFormulaRecalculationOnOpening = x$1;
    }

    @Override
    public void resetTargetCellRefs() {
        this.sheetMap().values().foreach((Function1)(JProcedure1 & Serializable)sheetData -> RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), sheetData.getNumberOfRows()).foreach((Function1)(JFunction1.mcVI.sp & Serializable)i -> sheetData.getRowData(i).foreach((Function1)(JProcedure1 & Serializable)rowData -> RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), rowData.getNumberOfCells()).foreach((Function1)(JFunction1.mcVI.sp & Serializable)j -> rowData.getCellData(j).foreach((Function1)(JProcedure1 & Serializable)cd -> cd.resetTargetPos())))));
    }

    @Override
    public Option<CellData> getCellData(CellRef cellRef) {
        if (cellRef == null || cellRef.sheetName() == null) {
            return None$.MODULE$;
        }
        Option option = this.sheetMap().get((Object)cellRef.sheetName());
        if (option instanceof Some) {
            SheetData sheetData = (SheetData)((Some)option).value();
            Option<RowData> option2 = sheetData.getRowData(cellRef.row());
            if (option2 instanceof Some) {
                RowData rd = (RowData)((Some)option2).value();
                return rd.getCellData(cellRef.col());
            }
            if (None$.MODULE$.equals(option2)) {
                return None$.MODULE$;
            }
            throw new MatchError(option2);
        }
        if (None$.MODULE$.equals(option)) {
            return None$.MODULE$;
        }
        throw new MatchError((Object)option);
    }

    @Override
    public Set<CellData> getFormulaCells() {
        HashSet formulaCells = new HashSet();
        this.sheetMap().values().foreach((Function1)(JProcedure1 & Serializable)sheetData -> RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), sheetData.getNumberOfRows()).foreach((Function1)(JFunction1.mcVI.sp & Serializable)i -> sheetData.getRowData(i).foreach((Function1)(JProcedure1 & Serializable)rowData -> RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), rowData.getNumberOfCells()).foreach((Function1)(JFunction1.mcVI.sp & Serializable)j -> rowData.getCellData(j).foreach((Function1)(JProcedure1 & Serializable)cellData -> {
            if (cellData.isFormulaCell()) {
                formulaCells.add(cellData);
                return;
            }
        })))));
        return formulaCells;
    }

    @Override
    public void adjustTableSize(CellRef ref, Size size) {
    }

    @Override
    public boolean isForwardOnly() {
        return false;
    }
}

