/*
 * Decompiled with CFR 0.152.
 */
package org.beangle.data.excel.template;

import java.io.Serializable;
import org.beangle.data.excel.AreaRef;
import org.beangle.data.excel.AreaRef$;
import org.beangle.data.excel.CellRef;
import org.beangle.data.excel.CellRef$;
import org.beangle.data.excel.Size;
import org.beangle.data.excel.Size$;
import org.beangle.data.excel.template.Area$;
import org.beangle.data.excel.template.CellRange;
import org.beangle.data.excel.template.CellShiftStrategy;
import org.beangle.data.excel.template.CellShiftStrategy$Adjacent$;
import org.beangle.data.excel.template.CellShiftStrategy$Inner$;
import org.beangle.data.excel.template.Context;
import org.beangle.data.excel.template.DefaultFormulaProcessor;
import org.beangle.data.excel.template.DirectiveData;
import org.beangle.data.excel.template.DirectiveData$;
import org.beangle.data.excel.template.FormulaProcessor;
import org.beangle.data.excel.template.Transformer;
import org.beangle.data.excel.template.directive.Directive;
import org.beangle.data.excel.template.directive.Directive$;
import org.slf4j.Logger;
import scala.Function1;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.mutable.LinkedHashSet;
import scala.collection.mutable.Set;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.function.JProcedure1;
import scala.runtime.java8.JFunction1;

public class Area {
    private final CellRef startCellRef;
    private final Size size;
    private Transformer transformer;
    private List directiveDatas;
    private Directive parentDirective;
    private CellRange cellRange;
    private boolean cellsCleared;
    private FormulaProcessor formulaProcessor;

    public static Area Empty() {
        return Area$.MODULE$.Empty();
    }

    public static Area apply(AreaRef areaRef, Transformer transformer) {
        return Area$.MODULE$.apply(areaRef, transformer);
    }

    public static Area apply(CellRef cellRef, CellRef cellRef2, Transformer transformer) {
        return Area$.MODULE$.apply(cellRef, cellRef2, transformer);
    }

    public static Area apply(String string, Transformer transformer) {
        return Area$.MODULE$.apply(string, transformer);
    }

    public static Logger logger() {
        return Area$.MODULE$.logger();
    }

    public Area(CellRef startCellRef, Size size, Transformer transformer) {
        this.startCellRef = startCellRef;
        this.size = size;
        this.transformer = transformer;
        this.directiveDatas = package$.MODULE$.List().empty();
        this.parentDirective = null;
        this.cellRange = null;
        this.cellsCleared = false;
        this.formulaProcessor = new DefaultFormulaProcessor();
        CellShiftStrategy$Inner$ cellShiftStrategy = CellShiftStrategy$Inner$.MODULE$;
    }

    public CellRef startCellRef() {
        return this.startCellRef;
    }

    public Size size() {
        return this.size;
    }

    public Transformer transformer() {
        return this.transformer;
    }

    public void transformer_$eq(Transformer x$1) {
        this.transformer = x$1;
    }

    public List<DirectiveData> directiveDatas() {
        return this.directiveDatas;
    }

    public void directiveDatas_$eq(List<DirectiveData> x$1) {
        this.directiveDatas = x$1;
    }

    public Directive parentDirective() {
        return this.parentDirective;
    }

    public void parentDirective_$eq(Directive x$1) {
        this.parentDirective = x$1;
    }

    public boolean cellsCleared() {
        return this.cellsCleared;
    }

    public void cellsCleared_$eq(boolean x$1) {
        this.cellsCleared = x$1;
    }

    public FormulaProcessor formulaProcessor() {
        return this.formulaProcessor;
    }

    public void formulaProcessor_$eq(FormulaProcessor x$1) {
        this.formulaProcessor = x$1;
    }

    public Area(CellRef startCellRef, Size size, List<DirectiveData> datas, Transformer transformer) {
        this(startCellRef, size, transformer);
        this.directiveDatas_$eq(datas != null ? datas : package$.MODULE$.List().empty());
    }

    public void addDirective(AreaRef areaRef, Directive directive) {
        AreaRef thisAreaRef = AreaRef$.MODULE$.apply(this.startCellRef(), this.size());
        if (!thisAreaRef.contains(areaRef)) {
            throw new IllegalArgumentException("Cannot add directive '" + directive.name() + "' to area " + thisAreaRef + " at " + areaRef);
        }
        this.directiveDatas_$eq((List<DirectiveData>)((List)this.directiveDatas().$colon$plus((Object)DirectiveData$.MODULE$.apply(areaRef, directive))));
    }

    public void addDirective(String areaRef, Directive directive) {
        this.directiveDatas_$eq((List<DirectiveData>)((List)this.directiveDatas().$colon$plus((Object)DirectiveData$.MODULE$.apply(areaRef, directive))));
    }

    private void excludeCells(CellRef startCellRef, Size size) {
        this.cellRange.excludeCells(startCellRef.col() - this.startCellRef().col(), startCellRef.col() - this.startCellRef().col() + size.width() - 1, startCellRef.row() - this.startCellRef().row(), startCellRef.row() - this.startCellRef().row() + size.height() - 1);
    }

    private void createCellRange() {
        this.cellRange = new CellRange(this.startCellRef(), this.size().width(), this.size().height());
        this.directiveDatas().foreach((Function1)(JProcedure1 & Serializable)data -> {
            CellRef startCellRef = data.initStartCellRef();
            Size size = data.size();
            if (data.directive().lockRange()) {
                this.excludeCells(startCellRef, size);
                return;
            }
        });
    }

    public Size applyAt(CellRef cellRef, Context context) {
        Area area = this;
        Area area2 = Area$.MODULE$.Empty();
        if (!(area != null ? !area.equals(area2) : area2 != null)) {
            return Size$.MODULE$.Zero();
        }
        Area$.MODULE$.logger().debug("Applying Area at {}", (Object)cellRef);
        this.createCellRange();
        AreaRef topArea = this.transformTopStaticArea(cellRef, context);
        ObjectRef tail = ObjectRef.create(this.directiveDatas());
        this.directiveDatas().foreach((Function1)(JProcedure1 & Serializable)dd -> {
            this.cellRange.resetChangeMatrix();
            List list = (List)((List)tail$1.elem).tail();
            tail$1.elem = list;
            list = null;
            String shiftMode = dd.directive().shiftMode();
            this.cellRange.cellShiftStrategy_$eq(this.detectCellShiftStrategy(shiftMode));
            CellRef cmdStartCellRef = dd.startCellRef();
            Size cmdInitialSize = dd.size();
            int startCol = cmdStartCellRef.col() - this.startCellRef().col();
            int startRow = cmdStartCellRef.row() - this.startCellRef().row();
            Size cmdNewSize = dd.directive().applyAt(cellRef.move(startRow, startCol), context);
            int widthChange = cmdNewSize.width() - cmdInitialSize.width();
            int heightChange = cmdNewSize.height() - cmdInitialSize.height();
            int endCol = startCol + cmdInitialSize.width() - 1;
            int endRow = startRow + cmdInitialSize.height() - 1;
            if (heightChange != 0) {
                this.cellRange.shiftCellsWithColBlock(startCol, endCol, endRow, heightChange, true);
                Set<DirectiveData> cmdsToShift = this.findDirectivesForVerticalShift((List<DirectiveData>)((List)tail$1.elem), startCol, endCol, endRow, heightChange);
                cmdsToShift.foreach((Function1)(JProcedure1 & Serializable)cmdDataToShift -> {
                    CellRef cmdDataStartCellRef = cmdDataToShift.startCellRef();
                    int relativeRow = cmdDataStartCellRef.row() - this.startCellRef().row();
                    int relativeStartCol = cmdDataStartCellRef.col() - this.startCellRef().col();
                    int relativeEndCol = relativeStartCol + cmdDataToShift.size().width() - 1;
                    this.cellRange.shiftCellsWithColBlock(relativeStartCol, relativeEndCol, relativeRow + cmdDataToShift.size().height() - 1, heightChange, false);
                    cmdDataToShift.startCellRef_$eq(new CellRef(cmdStartCellRef.sheetName(), cmdDataStartCellRef.row() + heightChange, cmdDataStartCellRef.col()));
                    if (heightChange < 0) {
                        CellRef initialStartCellRef = cmdDataToShift.initStartCellRef();
                        Size initialSize = cmdDataToShift.size();
                        int initialStartRow = initialStartCellRef.row() - this.startCellRef().row();
                        int initialEndRow = initialStartRow + initialSize.height() - 1;
                        int initialStartCol = initialStartCellRef.col() - this.startCellRef().col();
                        int initialEndCol = initialStartCol + initialSize.width() - 1;
                        this.cellRange.clearCells(initialStartCol, initialEndCol, initialStartRow, initialEndRow);
                        return;
                    }
                });
            }
            if (widthChange != 0) {
                this.cellRange.shiftCellsWithRowBlock(startRow, endRow, endCol, widthChange, true);
                Set<DirectiveData> cmdsToShift = this.findDirectivesForHorizontalShift((List<DirectiveData>)((List)tail$1.elem), startRow, endRow, endCol, widthChange);
                cmdsToShift.foreach((Function1)(JProcedure1 & Serializable)cmdDataToShift -> {
                    CellRef cmdDataStartCellRef = cmdDataToShift.startCellRef();
                    int relativeCol = cmdDataStartCellRef.col() - this.startCellRef().col();
                    int relativeStartRow = cmdDataStartCellRef.row() - this.startCellRef().row();
                    int relativeEndRow = relativeStartRow + cmdDataToShift.size().height() - 1;
                    this.cellRange.shiftCellsWithRowBlock(relativeStartRow, relativeEndRow, relativeCol + cmdDataToShift.size().width() - 1, widthChange, false);
                    cmdDataToShift.startCellRef_$eq(new CellRef(cmdStartCellRef.sheetName(), cmdDataStartCellRef.row(), cmdDataStartCellRef.col() + widthChange));
                    if (widthChange < 0) {
                        CellRef initialStartCellRef = cmdDataToShift.initStartCellRef();
                        Size initialSize = cmdDataToShift.size();
                        int initialStartRow = initialStartCellRef.row() - this.startCellRef().row();
                        int initialEndRow = initialStartRow + initialSize.height() - 1;
                        int initialStartCol = initialStartCellRef.col() - this.startCellRef().col();
                        int initialEndCol = initialStartCellRef.col() + initialSize.width() - 1;
                        this.cellRange.clearCells(initialStartCol, initialEndCol, initialStartRow, initialEndRow);
                        return;
                    }
                });
                return;
            }
        });
        this.transformStaticCells(cellRef, context, topArea);
        Size finalSize = new Size(this.cellRange.calculateWidth(), this.cellRange.calculateHeight());
        this.updateCellDataFinalAreaForFormulaCells(AreaRef$.MODULE$.apply(cellRef, finalSize));
        this.directiveDatas().foreach((Function1)(JProcedure1 & Serializable)_$1 -> _$1.resetStartCellAndSize());
        return finalSize;
    }

    private void transformStaticCells(CellRef cellRef, Context context, AreaRef area) {
        int relativeStartRow = area.firstCellRef().row();
        int relativeStartCol = area.firstCellRef().col() + 1;
        if (this.transformer().isForwardOnly()) {
            relativeStartRow = area.lastCellRef().row() + 1;
            relativeStartCol = 0;
        }
        this.transformStaticCells(cellRef, context, relativeStartRow, relativeStartCol);
    }

    private Set<DirectiveData> findDirectivesForHorizontalShift(List<DirectiveData> directiveDatas, int startRow, int endRow, int shiftingCol, int widthChange) {
        LinkedHashSet result = new LinkedHashSet();
        ObjectRef tail = ObjectRef.create(directiveDatas);
        directiveDatas.withFilter((Function1 & Serializable)dd -> !result.contains(dd)).foreach((Function1)(JProcedure1 & Serializable)dd -> {
            List list = (List)((List)tail$2.elem).tail();
            tail$2.elem = list;
            list = null;
            CellRef ddStartCellRef = dd.startCellRef();
            int relativeCol = ddStartCellRef.col() - this.startCellRef().col();
            int relativeStartRow = ddStartCellRef.row() - this.startCellRef().row();
            int relativeEndRow = relativeStartRow + dd.size().height() - 1;
            if (relativeCol > shiftingCol) {
                boolean isShiftingNeeded = false;
                if (widthChange > 0) {
                    if (relativeStartRow >= startRow && relativeStartRow <= endRow || relativeEndRow >= startRow && relativeEndRow <= endRow || startRow >= relativeStartRow && startRow <= relativeEndRow) {
                        isShiftingNeeded = true;
                    } else if (relativeStartRow >= startRow && relativeEndRow <= endRow && this.isNoHighDirectivesInArea(directiveDatas, shiftingCol + 1, relativeCol - 1, startRow, endRow)) {
                        isShiftingNeeded = true;
                    }
                }
                if (isShiftingNeeded) {
                    result.add(dd);
                    Set<DirectiveData> dependents = this.findDirectivesForHorizontalShift((List<DirectiveData>)((List)tail$2.elem), relativeStartRow, relativeEndRow, relativeCol + dd.size().width() - 1, widthChange);
                    result.addAll(dependents);
                    return;
                }
                return;
            }
        });
        return result;
    }

    private Set<DirectiveData> findDirectivesForVerticalShift(List<DirectiveData> directiveDatas, int startCol, int endCol, int shiftingRow, int heightChange) {
        LinkedHashSet result = new LinkedHashSet();
        ObjectRef tail = ObjectRef.create(directiveDatas);
        directiveDatas.withFilter((Function1 & Serializable)dd -> !result.contains(dd)).foreach((Function1)(JProcedure1 & Serializable)dd -> {
            List list = (List)((List)tail$3.elem).tail();
            tail$3.elem = list;
            list = null;
            CellRef ddStartCellRef = dd.startCellRef();
            int relativeRow = ddStartCellRef.row() - this.startCellRef().row();
            int relativeStartCol = ddStartCellRef.col() - this.startCellRef().col();
            int relativeEndCol = relativeStartCol + dd.size().width() - 1;
            if (relativeRow > shiftingRow) {
                boolean isShiftingNeeded = false;
                if (heightChange > 0) {
                    if (relativeStartCol >= startCol && relativeStartCol <= endCol || relativeEndCol >= startCol && relativeEndCol <= endCol || startCol >= relativeStartCol && startCol <= relativeEndCol) {
                        isShiftingNeeded = true;
                    } else if (relativeStartCol >= startCol && relativeEndCol <= endCol && this.isNoWideDirectivesInArea((Seq<DirectiveData>)directiveDatas, startCol, endCol, shiftingRow + 1, relativeRow - 1)) {
                        isShiftingNeeded = true;
                    }
                }
                if (isShiftingNeeded) {
                    result.add(dd);
                    Set<DirectiveData> dependents = this.findDirectivesForVerticalShift((List<DirectiveData>)((List)tail$3.elem), relativeStartCol, relativeEndCol, relativeRow + dd.size().height() - 1, heightChange);
                    result.addAll(dependents);
                    return;
                }
                return;
            }
        });
        return result;
    }

    private boolean isNoHighDirectivesInArea(List<DirectiveData> directiveDatas, int startCol, int endCol, int startRow, int endRow) {
        return !directiveDatas.exists((Function1 & Serializable)dd -> {
            CellRef ddStartCellRef = dd.startCellRef();
            int relativeCol = ddStartCellRef.col() - this.startCellRef().col();
            int relativeEndCol = relativeCol + dd.size().width() - 1;
            int relativeStartRow = ddStartCellRef.row() - this.startCellRef().row();
            int relativeEndRow = relativeStartRow + dd.size().height() - 1;
            return relativeCol >= startCol && relativeEndCol <= endCol && (relativeStartRow < startRow && relativeEndRow >= startRow || relativeEndRow > endRow && relativeStartRow <= endRow);
        });
    }

    private boolean isNoWideDirectivesInArea(Seq<DirectiveData> directiveDatas, int startCol, int endCol, int startRow, int endRow) {
        return !directiveDatas.exists((Function1 & Serializable)dd -> {
            CellRef ddStartCellRef = dd.startCellRef();
            int relativeRow = ddStartCellRef.row() - this.startCellRef().row();
            int relativeEndRow = relativeRow + dd.size().height() - 1;
            int relativeStartCol = ddStartCellRef.col() - this.startCellRef().col();
            int relativeEndCol = relativeStartCol + dd.size().width() - 1;
            return relativeRow >= startRow && relativeEndRow <= endRow && (relativeStartCol < startCol && relativeEndCol >= startCol || relativeEndCol > endCol && relativeStartCol <= endCol);
        });
    }

    private CellShiftStrategy detectCellShiftStrategy(String shiftMode) {
        if (shiftMode != null && Directive$.MODULE$.ADJACENT_SHIFT_MODE().equalsIgnoreCase(shiftMode)) {
            return CellShiftStrategy$Adjacent$.MODULE$;
        }
        return CellShiftStrategy$Inner$.MODULE$;
    }

    private void updateCellDataFinalAreaForFormulaCells(AreaRef newAreaRef) {
        String sheetName = this.startCellRef().sheetName();
        int offsetRow = this.startCellRef().row();
        int startCol = this.startCellRef().col();
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), this.size().width()).foreach((Function1)(JFunction1.mcVI.sp & Serializable)col -> RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), this.size().height()).foreach((Function1)(JFunction1.mcVI.sp & Serializable)row -> {
            if (!this.cellRange.isExcluded(row, col)) {
                CellRef srcCell = new CellRef(sheetName, offsetRow + row, startCol + col);
                this.transformer().getCellData(srcCell).foreach((Function1)(JProcedure1 & Serializable)cellData -> {
                    if (cellData.isFormulaCell()) {
                        cellData.addTargetParentAreaRef(newAreaRef);
                        return;
                    }
                });
                return;
            }
        }));
    }

    private AreaRef transformTopStaticArea(CellRef cellRef, Context context) {
        CellRef topLeftCmdCell = this.findRelativeTopCmdCellRef();
        CellRef bottomRightCmdCell = this.findRelativeBottomCmdCellRef();
        int topStaticAreaLastRow = topLeftCmdCell.row() - 1;
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), this.size().width()).foreach((Function1)(JFunction1.mcVI.sp & Serializable)col -> RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), topStaticAreaLastRow).foreach((Function1)(JFunction1.mcVI.sp & Serializable)row -> this.transformStaticCell(cellRef, context, row, col)));
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), topLeftCmdCell.col()).foreach((Function1)(JFunction1.mcVI.sp & Serializable)col -> {
            if (this.cellRange.contains(topLeftCmdCell.row(), col)) {
                this.transformStaticCell(cellRef, context, topLeftCmdCell.row(), col);
                return;
            }
        });
        if (this.parentDirective() == null) {
            this.updateRowHeights(cellRef, 0, topStaticAreaLastRow);
        }
        return new AreaRef(topLeftCmdCell, bottomRightCmdCell);
    }

    private void transformStaticCell(CellRef cellRef, Context context, int row, int col) {
        if (!this.cellRange.isExcluded(row, col)) {
            CellRef relativeCell = this.cellRange.getCell(row, col);
            CellRef srcCell = this.startCellRef().move(row, col);
            CellRef targetCell = cellRef.move(relativeCell.row(), relativeCell.col());
            try {
                this.updateCellDataArea(srcCell, targetCell, context);
                this.transformer().transform(srcCell, targetCell, context, this.parentDirective() != null);
            }
            catch (Exception e) {
                Area$.MODULE$.logger().error("Failed to transform " + srcCell + " into " + targetCell, (Throwable)e);
            }
            return;
        }
    }

    private void updateRowHeights(CellRef areaStartCellRef, int relativeStartRow, int relativeEndRow) {
        if (this.transformer() != null) {
            RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(relativeStartRow), relativeEndRow).foreach((Function1)(JFunction1.mcVI.sp & Serializable)relativeSrcRow -> {
                if (!this.cellRange.containsDirectivesInRow(relativeSrcRow)) {
                    int relativeTarrow = this.cellRange.findTarrow(relativeSrcRow);
                    int tarrow = areaStartCellRef.row() + relativeTarrow;
                    int srcRow = areaStartCellRef.row() + relativeSrcRow;
                    try {
                        this.transformer().updateRowHeight(this.startCellRef().sheetName(), srcRow, areaStartCellRef.sheetName(), tarrow);
                    }
                    catch (Exception e) {
                        Area$.MODULE$.logger().error("Failed to update row height for src row={} and target row={}", new Object[]{BoxesRunTime.boxToInteger((int)relativeSrcRow), BoxesRunTime.boxToInteger((int)tarrow), e});
                    }
                    return;
                }
            });
            return;
        }
    }

    private CellRef findRelativeTopCmdCellRef() {
        IntRef topCmdRow = IntRef.create((int)(this.startCellRef().row() + this.size().height()));
        IntRef topCmdCol = IntRef.create((int)(this.startCellRef().col() + this.size().width()));
        this.directiveDatas().foreach((Function1)(JProcedure1 & Serializable)data -> {
            if (data.startCellRef().row() <= topCmdRow$1.elem && data.startCellRef().col() <= topCmdCol$1.elem) {
                int n;
                int n2;
                topCmdRow$1.elem = n2 = data.startCellRef().row();
                topCmdCol$1.elem = n = data.startCellRef().col();
                return;
            }
        });
        return CellRef$.MODULE$.apply(topCmdRow.elem - this.startCellRef().row(), topCmdCol.elem - this.startCellRef().col());
    }

    private CellRef findRelativeBottomCmdCellRef() {
        IntRef bottomCmdRow = IntRef.create((int)this.startCellRef().row());
        IntRef bottomCmdCol = IntRef.create((int)this.startCellRef().col());
        this.directiveDatas().foreach((Function1)(JProcedure1 & Serializable)data -> {
            if (data.startCellRef().row() + data.size().height() >= bottomCmdRow$1.elem) {
                int n;
                int n2;
                bottomCmdRow$1.elem = n2 = data.startCellRef().row() + data.size().height() - 1;
                bottomCmdCol$1.elem = n = data.startCellRef().col() + data.size().width() - 1;
                return;
            }
        });
        return CellRef$.MODULE$.apply(bottomCmdRow.elem - this.startCellRef().row(), bottomCmdCol.elem - this.startCellRef().col());
    }

    public void clearCells() {
        if (this.cellsCleared()) {
            return;
        }
        String sheetName = this.startCellRef().sheetName();
        int startRow = this.startCellRef().row();
        int startCol = this.startCellRef().col();
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), this.size().height()).foreach((Function1)(JFunction1.mcVI.sp & Serializable)row -> RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), this.size().width()).foreach((Function1)(JFunction1.mcVI.sp & Serializable)col -> {
            CellRef cellRef = new CellRef(sheetName, startRow + row, startCol + col);
            this.transformer().clearCell(cellRef);
        }));
        this.transformer().resetArea(this.getAreaRef());
        this.cellsCleared_$eq(true);
    }

    private void transformStaticCells(CellRef cellRef, Context context, int relativeStartRow, int relativeStartCol) {
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), this.size().width()).foreach((Function1)(JFunction1.mcVI.sp & Serializable)col -> RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(relativeStartRow), this.size().height()).withFilter((Function1)(JFunction1.mcZI.sp & Serializable)row -> row != relativeStartRow || col >= relativeStartCol).foreach((Function1)(JFunction1.mcVI.sp & Serializable)row -> {
            if (!this.cellRange.isExcluded(row, col)) {
                CellRef relativeCell = this.cellRange.getCell(row, col);
                CellRef srcCell = this.startCellRef().move(row, col);
                CellRef targetCell = cellRef.move(relativeCell.row(), relativeCell.col());
                try {
                    this.updateCellDataArea(srcCell, targetCell, context);
                    this.transformer().transform(srcCell, targetCell, context, this.parentDirective() != null);
                }
                catch (Exception e) {
                    Area$.MODULE$.logger().error("Failed to transform " + srcCell + " into " + targetCell, (Throwable)e);
                }
                return;
            }
        }));
        if (this.parentDirective() == null) {
            this.updateRowHeights(cellRef, relativeStartRow, this.size().height() - 1);
            return;
        }
    }

    private void updateCellDataArea(CellRef srcCell, CellRef targetCell, Context context) {
        this.transformer().getCellData(srcCell).foreach((Function1)(JProcedure1 & Serializable)cellData -> {
            cellData.area_$eq(this);
            cellData.addTargetPos(targetCell);
        });
    }

    public AreaRef getAreaRef() {
        return AreaRef$.MODULE$.apply(this.startCellRef(), this.size());
    }

    public void processFormulas() {
        this.formulaProcessor().processAreaFormulas(this.transformer(), this);
    }

    public Seq<Directive> findDirectiveByName(String name) {
        return this.directiveDatas().filter((Function1 & Serializable)x -> {
            if (name == null) return false;
            String string = name;
            String string2 = x.directive().name();
            if (string != null) {
                if (!string.equals(string2)) return false;
                return true;
            }
            if (string2 == null) return true;
            return false;
        }).map((Function1 & Serializable)_$2 -> _$2.directive());
    }

    public void reset() {
        this.directiveDatas().foreach((Function1)(JProcedure1 & Serializable)_$3 -> _$3.reset());
        this.transformer().resetTargetCellRefs();
    }
}

