/*
 * Decompiled with CFR 0.152.
 */
package org.beangle.data.excel.template;

import java.io.Serializable;
import java.sql.Date;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.regex.Matcher;
import org.apache.poi.ss.formula.FormulaParseException;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.Comment;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.ss.usermodel.Hyperlink;
import org.apache.poi.ss.usermodel.RichTextString;
import org.beangle.commons.io.DataType;
import org.beangle.commons.io.DataType$;
import org.beangle.commons.lang.Objects$;
import org.beangle.commons.script.ExpressionEvaluator;
import org.beangle.data.excel.AreaRef;
import org.beangle.data.excel.CellOps$;
import org.beangle.data.excel.CellRef;
import org.beangle.data.excel.template.Area;
import org.beangle.data.excel.template.CellData$;
import org.beangle.data.excel.template.CellData$FormulaStrategy$;
import org.beangle.data.excel.template.Context;
import org.beangle.data.excel.template.DefaultTransformer;
import org.beangle.data.excel.template.FormulaProcessor$;
import org.beangle.data.excel.template.Notation$;
import org.beangle.data.excel.template.RowData;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Product;
import scala.collection.ArrayOps$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.Map;
import scala.reflect.Enum;
import scala.runtime.BoxesRunTime;
import scala.runtime.function.JProcedure1;

public class CellData {
    private final CellRef cellRef;
    private Cell cell;
    private Map attrMap;
    private Object cellValue;
    private DataType cellType;
    private String cellComment;
    private String formula;
    private Object evaluationResult;
    private DataType targetCellType;
    private FormulaStrategy formulaStrategy;
    private String defaultValue;
    private Area area;
    private RowData rowData;
    private RichTextString richTextString;
    private CellStyle cellStyle;
    private Hyperlink hyperlink;
    private Comment comment;
    private String commentAuthor;
    private final ArrayBuffer targetPos;
    private final ArrayBuffer targetParentAreaRef;
    private ArrayBuffer evaluatedFormulas;

    public static CellData createCellData(RowData rowData, CellRef cellRef, Cell cell) {
        return CellData$.MODULE$.createCellData(rowData, cellRef, cell);
    }

    public static Map<String, String> parseDirectiveAttributes(String string) {
        return CellData$.MODULE$.parseDirectiveAttributes(string);
    }

    public CellData(CellRef cellRef, Cell cell) {
        this.cellRef = cellRef;
        this.cell = cell;
        this.formulaStrategy = CellData$FormulaStrategy$.DEFAULT;
        this.targetPos = new ArrayBuffer();
        this.targetParentAreaRef = new ArrayBuffer();
        this.evaluatedFormulas = new ArrayBuffer();
    }

    public CellRef cellRef() {
        return this.cellRef;
    }

    public Cell cell() {
        return this.cell;
    }

    public void cell_$eq(Cell x$1) {
        this.cell = x$1;
    }

    public Map<String, String> attrMap() {
        return this.attrMap;
    }

    public void attrMap_$eq(Map<String, String> x$1) {
        this.attrMap = x$1;
    }

    public Object cellValue() {
        return this.cellValue;
    }

    public void cellValue_$eq(Object x$1) {
        this.cellValue = x$1;
    }

    public DataType cellType() {
        return this.cellType;
    }

    public void cellType_$eq(DataType x$1) {
        this.cellType = x$1;
    }

    public String cellComment() {
        return this.cellComment;
    }

    public void cellComment_$eq(String x$1) {
        this.cellComment = x$1;
    }

    public String formula() {
        return this.formula;
    }

    public void formula_$eq(String x$1) {
        this.formula = x$1;
    }

    public Object evaluationResult() {
        return this.evaluationResult;
    }

    public void evaluationResult_$eq(Object x$1) {
        this.evaluationResult = x$1;
    }

    public DataType targetCellType() {
        return this.targetCellType;
    }

    public void targetCellType_$eq(DataType x$1) {
        this.targetCellType = x$1;
    }

    public FormulaStrategy formulaStrategy() {
        return this.formulaStrategy;
    }

    public void formulaStrategy_$eq(FormulaStrategy x$1) {
        this.formulaStrategy = x$1;
    }

    public String defaultValue() {
        return this.defaultValue;
    }

    public void defaultValue_$eq(String x$1) {
        this.defaultValue = x$1;
    }

    public Area area() {
        return this.area;
    }

    public void area_$eq(Area x$1) {
        this.area = x$1;
    }

    private RowData rowData() {
        return this.rowData;
    }

    public void org$beangle$data$excel$template$CellData$$rowData_$eq(RowData x$0) {
        this.rowData = x$0;
    }

    public CellStyle cellStyle() {
        return this.cellStyle;
    }

    public void cellStyle_$eq(CellStyle x$1) {
        this.cellStyle = x$1;
    }

    public ArrayBuffer<CellRef> targetPos() {
        return this.targetPos;
    }

    public ArrayBuffer<AreaRef> targetParentAreaRef() {
        return this.targetParentAreaRef;
    }

    public ArrayBuffer<String> evaluatedFormulas() {
        return this.evaluatedFormulas;
    }

    public void evaluatedFormulas_$eq(ArrayBuffer<String> x$1) {
        this.evaluatedFormulas = x$1;
    }

    public CellData(String sheetName, int row, int col, DataType cellType, Object cellValue) {
        this(new CellRef(sheetName, row, col), null);
        this.cellType_$eq(cellType);
        this.cellValue_$eq(cellValue);
        this.updateFormulaValue();
    }

    public CellData(CellRef cellRef, DataType cellType, Object cellValue) {
        this(cellRef, null);
        this.cellType_$eq(cellType);
        this.cellValue_$eq(cellValue);
        this.updateFormulaValue();
    }

    public CellData(String sheetName, int row, int col) {
        this(sheetName, row, col, DataType$.Blank, null);
    }

    public String sheetName() {
        return this.cellRef().sheetName();
    }

    public int row() {
        return this.cellRef().row();
    }

    public int col() {
        return this.cellRef().col();
    }

    public boolean isFormulaCell() {
        return this.formula() != null;
    }

    public boolean isParameterizedFormulaCell() {
        return this.isFormulaCell() && CellData$.MODULE$.org$beangle$data$excel$template$CellData$$$isUserFormula(this.cellValue().toString());
    }

    public boolean isJointedFormulaCell() {
        return this.isParameterizedFormulaCell() && FormulaProcessor$.MODULE$.formulaContainsJointedCellRef(this.cellValue().toString());
    }

    public void addTargetPos(CellRef cellRef) {
        this.targetPos().addOne((Object)cellRef);
    }

    public void addTargetParentAreaRef(AreaRef areaRef) {
        this.targetParentAreaRef().addOne((Object)areaRef);
    }

    public void resetTargetPos() {
        this.targetPos().clear();
        this.targetParentAreaRef().clear();
    }

    public Object evaluate(Context context) {
        this.targetCellType_$eq(this.cellType());
        DataType dataType = this.cellType();
        DataType dataType2 = DataType$.String;
        if (!(dataType != null ? !dataType.equals(dataType2) : dataType2 != null) && this.cellValue() != null) {
            String strValue = this.cellValue().toString();
            if (CellData$.MODULE$.org$beangle$data$excel$template$CellData$$$isUserFormula(strValue)) {
                String formulaStr = strValue.substring(Notation$.MODULE$.USER_FORMULA_PREFIX().length(), strValue.length() - Notation$.MODULE$.USER_FORMULA_SUFFIX().length());
                this.evaluate(formulaStr, context);
                if (this.evaluationResult() != null) {
                    this.targetCellType_$eq(DataType$.Formula);
                    this.formula_$eq(this.evaluationResult().toString());
                    this.evaluatedFormulas().addOne((Object)this.formula());
                }
            } else {
                this.evaluate(strValue, context);
            }
            if (this.evaluationResult() == null) {
                this.targetCellType_$eq(DataType$.Blank);
            }
        }
        return this.evaluationResult();
    }

    private void evaluate(String strValue, Context context) {
        boolean isAppendTail;
        StringBuilder sb = new StringBuilder();
        int beginExpressionLength = Notation$.MODULE$.ExpressionBegin().length();
        int endExpressionLength = Notation$.MODULE$.ExpressionEnd().length();
        Matcher exprMatcher = Notation$.MODULE$.ExpressionPattern().matcher(strValue);
        ExpressionEvaluator evaluator = context.evaluator();
        String matchedString = null;
        String expression = null;
        Object lastMatchEvalResult = null;
        int matchCount = 0;
        int endOffset = 0;
        while (exprMatcher.find()) {
            endOffset = exprMatcher.end();
            ++matchCount;
            matchedString = exprMatcher.group();
            expression = matchedString.substring(beginExpressionLength, matchedString.length() - endExpressionLength);
            lastMatchEvalResult = evaluator.eval(expression, context.toMap());
            exprMatcher.appendReplacement(sb, Matcher.quoteReplacement(lastMatchEvalResult != null ? lastMatchEvalResult.toString() : ""));
        }
        String lastStringResult = lastMatchEvalResult != null ? lastMatchEvalResult.toString() : "";
        boolean bl = isAppendTail = matchCount == 1 && endOffset < strValue.length();
        if (matchCount > 1 || isAppendTail) {
            exprMatcher.appendTail(sb);
            this.evaluationResult_$eq(sb.toString());
            return;
        }
        if (matchCount == 1) {
            if (sb.length() > lastStringResult.length()) {
                this.evaluationResult_$eq(sb.toString());
                return;
            }
            this.evaluationResult_$eq(lastMatchEvalResult);
            this.setTargetCellType();
            return;
        }
        if (matchCount == 0) {
            this.evaluationResult_$eq(strValue);
            return;
        }
    }

    public void updateFormulaValue() {
        DataType dataType = this.cellType();
        DataType dataType2 = DataType$.Formula;
        if (!(dataType != null ? !dataType.equals(dataType2) : dataType2 != null)) {
            this.formula_$eq(this.cellValue() != null ? this.cellValue().toString() : "");
            return;
        }
        DataType dataType3 = this.cellType();
        DataType dataType4 = DataType$.String;
        if (!(dataType3 != null ? !dataType3.equals(dataType4) : dataType4 != null)) {
            if (this.cellValue() != null && CellData$.MODULE$.org$beangle$data$excel$template$CellData$$$isUserFormula(this.cellValue().toString())) {
                this.formula_$eq(this.cellValue().toString().substring(2, this.cellValue().toString().length() - 1));
                return;
            }
        }
    }

    public boolean isParamsComment(String cellComment) {
        return cellComment.trim().startsWith(Notation$.MODULE$.JX_PARAMS_PREFIX());
    }

    private void setTargetCellType() {
        this.targetCellType_$eq(this.evaluationResult() == null ? DataType$.String : DataType$.MODULE$.toType(this.evaluationResult().getClass()));
    }

    public void processParams(String cellComment) {
        int nameEndIndex = cellComment.indexOf(Notation$.MODULE$.ATTR_PREFIX(), Notation$.MODULE$.JX_PARAMS_PREFIX().length());
        if (nameEndIndex < 0) {
            String errMsg = "Failed to parse params [" + cellComment + "] at " + (Function1 & Serializable)ignoreSheetName -> this.$anonfun$1(BoxesRunTime.unboxToBoolean((Object)ignoreSheetName)) + ". Expected '" + Notation$.MODULE$.ATTR_PREFIX() + "' symbol.";
            CellData$.org$beangle$data$excel$template$CellData$$$logger.error(errMsg);
            throw new IllegalStateException(errMsg);
        }
        this.attrMap_$eq(this.buildAttrMap(cellComment, nameEndIndex));
        if (this.attrMap().contains((Object)CellData$.org$beangle$data$excel$template$CellData$$$FORMULA_STRATEGY_PARAM)) {
            this.initFormulaStrategy((String)this.attrMap().apply((Object)CellData$.org$beangle$data$excel$template$CellData$$$FORMULA_STRATEGY_PARAM));
        }
        if (this.attrMap().contains((Object)CellData$.org$beangle$data$excel$template$CellData$$$DEFAULT_VALUE)) {
            this.defaultValue_$eq((String)this.attrMap().apply((Object)CellData$.org$beangle$data$excel$template$CellData$$$DEFAULT_VALUE));
            return;
        }
    }

    private Map<String, String> buildAttrMap(String paramsLine, int nameEndIndex) {
        int paramsEndIndex = paramsLine.lastIndexOf(Notation$.MODULE$.ATTR_SUFFIX());
        if (paramsEndIndex < 0) {
            String errMsg = "Failed to parse params line [" + paramsLine + "] at " + (Function1 & Serializable)ignoreSheetName -> this.$anonfun$2(BoxesRunTime.unboxToBoolean((Object)ignoreSheetName)) + ". Expected '" + Notation$.MODULE$.ATTR_SUFFIX() + "' symbol.";
            CellData$.org$beangle$data$excel$template$CellData$$$logger.error(errMsg);
            throw new IllegalArgumentException(errMsg);
        }
        String attrString = paramsLine.substring(nameEndIndex + 1, paramsEndIndex).trim();
        return CellData$.MODULE$.parseDirectiveAttributes(attrString);
    }

    private void initFormulaStrategy(String formulaStrategyValue) {
        try {
            this.formulaStrategy_$eq(CellData$FormulaStrategy$.MODULE$.valueOf(formulaStrategyValue));
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException("Cannot parse formula strategy value at " + (Function1 & Serializable)ignoreSheetName -> this.initFormulaStrategy$$anonfun$1(BoxesRunTime.unboxToBoolean((Object)ignoreSheetName)), e);
        }
    }

    public void readCell(Cell cell) {
        this.readCellGeneralInfo(cell);
        this.readCellContents(cell);
        this.readCellStyle(cell);
    }

    private void readCellGeneralInfo(Cell cell) {
        this.hyperlink = cell.getHyperlink();
        this.comment = cell.getCellComment();
        if (this.comment != null) {
            this.commentAuthor = this.comment.getAuthor();
        }
        if (this.comment != null && this.comment.getString() != null && this.comment.getString().getString() != null) {
            String commentString = this.comment.getString().getString();
            Object[] commentLines = commentString.split("\\n");
            Object object = Predef$.MODULE$.refArrayOps(commentLines);
            ArrayOps$.MODULE$.withFilter$extension(object, (Function1 & Serializable)commentLine -> this.comment != null).foreach((Function1)(JProcedure1 & Serializable)commentLine -> {
                if (this.isParamsComment((String)commentLine)) {
                    this.processParams((String)commentLine);
                    this.comment = null;
                    return;
                }
            });
            this.cellComment_$eq(commentString);
            return;
        }
    }

    private void readCellContents(Cell cell) {
        block6: {
            CellType cellType;
            block12: {
                CellType cellType2;
                CellType cellType3;
                block11: {
                    block10: {
                        block9: {
                            block8: {
                                block7: {
                                    block5: {
                                        cellType = cell.getCellType();
                                        CellType cellType4 = CellType.STRING;
                                        CellType cellType5 = cellType;
                                        if (cellType4 != null ? !cellType4.equals(cellType5) : cellType5 != null) break block5;
                                        this.richTextString = cell.getRichStringCellValue();
                                        this.cellValue_$eq(this.richTextString.getString());
                                        this.cellType_$eq(DataType$.String);
                                        break block6;
                                    }
                                    CellType cellType6 = CellType.BOOLEAN;
                                    CellType cellType7 = cellType;
                                    if (cellType6 != null ? !cellType6.equals(cellType7) : cellType7 != null) break block7;
                                    this.cellValue_$eq(BoxesRunTime.boxToBoolean((boolean)cell.getBooleanCellValue()));
                                    this.cellType_$eq(DataType$.Boolean);
                                    break block6;
                                }
                                CellType cellType8 = CellType.NUMERIC;
                                CellType cellType9 = cellType;
                                if (cellType8 != null ? !cellType8.equals(cellType9) : cellType9 != null) break block8;
                                this.readNumericCellContents(cell);
                                break block6;
                            }
                            CellType cellType10 = CellType.FORMULA;
                            CellType cellType11 = cellType;
                            if (cellType10 != null ? !cellType10.equals(cellType11) : cellType11 != null) break block9;
                            this.formula_$eq(cell.getCellFormula());
                            this.cellValue_$eq(this.formula());
                            this.cellType_$eq(DataType$.Formula);
                            break block6;
                        }
                        CellType cellType12 = CellType.ERROR;
                        CellType cellType13 = cellType;
                        if (cellType12 != null ? !cellType12.equals(cellType13) : cellType13 != null) break block10;
                        this.cellValue_$eq(BoxesRunTime.boxToByte((byte)cell.getErrorCellValue()));
                        this.cellType_$eq(DataType$.Error);
                        break block6;
                    }
                    cellType3 = CellType.BLANK;
                    cellType2 = cellType;
                    if (cellType3 != null) break block11;
                    if (cellType2 == null) break block6;
                    break block12;
                }
                if (cellType3.equals(cellType2)) break block6;
            }
            CellType cellType14 = CellType._NONE;
            CellType cellType15 = cellType;
            if (!(cellType14 != null ? !cellType14.equals(cellType15) : cellType15 != null)) {
                this.cellValue_$eq(null);
                this.cellType_$eq(DataType$.Blank);
            } else {
                throw new MatchError((Object)cellType);
            }
        }
        this.evaluationResult_$eq(this.cellValue());
    }

    private void readNumericCellContents(Cell cell) {
        if (DateUtil.isCellDateFormatted((Cell)cell)) {
            this.cellValue_$eq(cell.getDateCellValue());
            this.cellType_$eq(DataType$.Date);
            return;
        }
        this.cellValue_$eq(BoxesRunTime.boxToDouble((double)cell.getNumericCellValue()));
        this.cellType_$eq(DataType$.Double);
    }

    private void readCellStyle(Cell cell) {
        this.cellStyle_$eq(cell.getCellStyle());
    }

    public void writeToCell(Cell cell, Context context, DefaultTransformer transformer) {
        this.evaluate(context);
        this.updateCellGeneralInfo(cell);
        this.updateCellContents(cell);
        this.updateCellStyle(cell, this.cellStyle());
        this.rowData().sheetData().updateConditionalFormatting(this, cell);
    }

    private void updateCellGeneralInfo(Cell cell) {
        if (this.hyperlink != null) {
            cell.setHyperlink(this.hyperlink);
        }
        if (this.comment != null && !Notation$.MODULE$.isJxComment(this.cellComment())) {
            CellOps$.MODULE$.setComment$extension(CellOps$.MODULE$.toCell(cell), this.cellComment(), this.commentAuthor, null);
            return;
        }
    }

    private void updateCellContents(Cell cell) {
        DataType dataType;
        block27: {
            block22: {
                DataType dataType2;
                DataType dataType3;
                block26: {
                    block25: {
                        DataType dataType4;
                        DataType dataType5;
                        block24: {
                            block23: {
                                DataType dataType6;
                                DataType dataType7;
                                block21: {
                                    if (this.evaluationResult() == null) {
                                        cell.setBlank();
                                        return;
                                    }
                                    dataType = this.targetCellType();
                                    DataType dataType8 = DataType$.String;
                                    DataType dataType9 = dataType;
                                    if (!(dataType8 != null ? !dataType8.equals(dataType9) : dataType9 != null)) {
                                        this.updateStringCellContents(cell);
                                        return;
                                    }
                                    DataType dataType10 = DataType$.Boolean;
                                    DataType dataType11 = dataType;
                                    if (!(dataType10 != null ? !dataType10.equals(dataType11) : dataType11 != null)) {
                                        cell.setCellValue(BoxesRunTime.unboxToBoolean((Object)this.evaluationResult()));
                                        return;
                                    }
                                    DataType dataType12 = DataType$.Date;
                                    DataType dataType13 = dataType;
                                    if (!(dataType12 != null ? !dataType12.equals(dataType13) : dataType13 != null)) {
                                        Object object = this.evaluationResult();
                                        if (object instanceof Date) {
                                            Date s = (Date)object;
                                            cell.setCellValue((java.util.Date)s);
                                            return;
                                        }
                                        if (object instanceof LocalDate) {
                                            LocalDate ld = (LocalDate)object;
                                            cell.setCellValue(ld);
                                            return;
                                        }
                                        throw new MatchError(object);
                                    }
                                    DataType dataType14 = DataType$.Time;
                                    DataType dataType15 = dataType;
                                    if (!(dataType14 != null ? !dataType14.equals(dataType15) : dataType15 != null)) {
                                        cell.setCellValue(((LocalTime)this.evaluationResult()).atDate(LocalDate.now()));
                                        return;
                                    }
                                    DataType dataType16 = DataType$.DateTime;
                                    DataType dataType17 = dataType;
                                    if (!(dataType16 != null ? !dataType16.equals(dataType17) : dataType17 != null)) {
                                        Object object = this.evaluationResult();
                                        if (object instanceof Timestamp) {
                                            Timestamp ts = (Timestamp)object;
                                            cell.setCellValue((java.util.Date)ts);
                                            return;
                                        }
                                        if (object instanceof LocalDateTime) {
                                            LocalDateTime ldt = (LocalDateTime)object;
                                            cell.setCellValue(ldt);
                                            return;
                                        }
                                        if (object instanceof java.util.Date) {
                                            java.util.Date jud = (java.util.Date)object;
                                            cell.setCellValue(jud);
                                            return;
                                        }
                                        throw new MatchError(object);
                                    }
                                    DataType dataType18 = DataType$.OffsetDateTime;
                                    DataType dataType19 = dataType;
                                    if (!(dataType18 != null ? !dataType18.equals(dataType19) : dataType19 != null)) {
                                        Object object = this.evaluationResult();
                                        if (object instanceof ZonedDateTime) {
                                            ZonedDateTime z = (ZonedDateTime)object;
                                            cell.setCellValue(z.toLocalDateTime());
                                            return;
                                        }
                                        if (object instanceof OffsetDateTime) {
                                            OffsetDateTime o = (OffsetDateTime)object;
                                            cell.setCellValue(o.toLocalDateTime());
                                            return;
                                        }
                                        throw new MatchError(object);
                                    }
                                    DataType dataType20 = DataType$.Instant;
                                    DataType dataType21 = dataType;
                                    if (!(dataType20 != null ? !dataType20.equals(dataType21) : dataType21 != null)) {
                                        cell.setCellValue(((Instant)this.evaluationResult()).atZone(ZoneId.systemDefault()).toLocalDateTime());
                                        return;
                                    }
                                    dataType7 = DataType$.Integer;
                                    dataType6 = dataType;
                                    if (dataType7 != null) break block21;
                                    if (dataType6 == null) break block22;
                                    break block23;
                                }
                                if (dataType7.equals(dataType6)) break block22;
                            }
                            dataType5 = DataType$.Float;
                            dataType4 = dataType;
                            if (dataType5 != null) break block24;
                            if (dataType4 == null) break block22;
                            break block25;
                        }
                        if (dataType5.equals(dataType4)) break block22;
                    }
                    dataType3 = DataType$.Double;
                    dataType2 = dataType;
                    if (dataType3 != null) break block26;
                    if (dataType2 == null) break block22;
                    break block27;
                }
                if (!dataType3.equals(dataType2)) break block27;
            }
            cell.setCellValue(((Number)this.evaluationResult()).doubleValue());
            return;
        }
        DataType dataType22 = DataType$.Formula;
        DataType dataType23 = dataType;
        if (!(dataType22 != null ? !dataType22.equals(dataType23) : dataType23 != null)) {
            this.updateFormulaCellContents(cell);
            return;
        }
        DataType dataType24 = DataType$.Error;
        DataType dataType25 = dataType;
        if (!(dataType24 != null ? !dataType24.equals(dataType25) : dataType25 != null)) {
            cell.setCellErrorValue(BoxesRunTime.unboxToByte((Object)this.evaluationResult()));
            return;
        }
        DataType dataType26 = DataType$.Blank;
        DataType dataType27 = dataType;
        if (!(dataType26 != null ? !dataType26.equals(dataType27) : dataType27 != null)) {
            cell.setBlank();
            return;
        }
        cell.setCellValue(this.evaluationResult().toString());
    }

    private void updateStringCellContents(Cell cell) {
        String result;
        if (this.evaluationResult() instanceof byte[]) {
            return;
        }
        String string = result = this.evaluationResult() != null ? this.evaluationResult().toString() : "";
        if (this.cellValue() != null) {
            Object object = this.cellValue();
            String string2 = result;
            if (!(object != null ? !object.equals(string2) : string2 != null)) {
                cell.setCellValue(this.richTextString);
                return;
            }
        }
        cell.setCellValue(result);
    }

    private void updateFormulaCellContents(Cell cell) {
        block5: {
            String evaluateResultStr = this.evaluationResult().toString();
            try {
                if (FormulaProcessor$.MODULE$.formulaContainsJointedCellRef(evaluateResultStr)) {
                    cell.setCellValue(evaluateResultStr);
                    break block5;
                }
                cell.setCellFormula(evaluateResultStr);
                CellOps$.MODULE$.clearValue$extension(CellOps$.MODULE$.toCell(cell));
            }
            catch (FormulaParseException e) {
                try {
                    CellData$.org$beangle$data$excel$template$CellData$$$logger.error("Failed to set cell formula " + evaluateResultStr + " for cell " + this.toString(), (Throwable)e);
                    cell.setCellValue(evaluateResultStr);
                }
                catch (Exception exception) {
                    CellData$.org$beangle$data$excel$template$CellData$$$logger.warn("Failed to convert formula to string for cell " + this.toString());
                }
            }
        }
    }

    private void updateCellStyle(Cell cell, CellStyle cellStyle) {
        cell.setCellStyle(cellStyle);
    }

    public String toString() {
        return "CellData{" + this.cellRef() + ", cellType=" + this.cellType() + ", cellValue=" + this.cellValue() + '}';
    }

    public boolean equals(Object o) {
        Object object = o;
        if (object == null) {
            return false;
        }
        if (object instanceof CellData) {
            CellData cd = (CellData)object;
            if (this == cd) {
                return true;
            }
            return Objects$.MODULE$.equals((Object)this.cellType(), (Object)cd.cellType()) && Objects$.MODULE$.equals(this.cellValue(), cd.cellValue()) && Objects$.MODULE$.equals((Object)this.cellRef(), (Object)cd.cellRef());
        }
        return false;
    }

    public int hashCode() {
        int result = this.cellRef() != null ? this.cellRef().hashCode() : 0;
        result = 31 * result + (this.cellValue() != null ? this.cellValue().hashCode() : 0);
        result = 31 * result + (this.cellType() != null ? this.cellType().hashCode() : 0);
        return result;
    }

    private final /* synthetic */ String $anonfun$1(boolean ignoreSheetName) {
        return this.cellRef().getCellName(ignoreSheetName);
    }

    private final /* synthetic */ String $anonfun$2(boolean ignoreSheetName) {
        return this.cellRef().getCellName(ignoreSheetName);
    }

    private final /* synthetic */ String initFormulaStrategy$$anonfun$1(boolean ignoreSheetName) {
        return this.cellRef().getCellName(ignoreSheetName);
    }

    public static abstract class FormulaStrategy
    implements Product,
    Enum {
        public static FormulaStrategy fromOrdinal(int n) {
            return CellData$FormulaStrategy$.MODULE$.fromOrdinal(n);
        }

        public static FormulaStrategy valueOf(String string) {
            return CellData$FormulaStrategy$.MODULE$.valueOf(string);
        }

        public static FormulaStrategy[] values() {
            return CellData$FormulaStrategy$.MODULE$.values();
        }
    }
}

