/*
 * Decompiled with CFR 0.152.
 */
package org.beangle.data.excel.template;

import java.io.Serializable;
import org.beangle.data.excel.CellRef;
import org.beangle.data.excel.CellRef$;
import org.beangle.data.excel.template.CellShiftStrategy;
import org.beangle.data.excel.template.CellShiftStrategy$Inner$;
import scala.Function1;
import scala.Predef$;
import scala.runtime.IntRef;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

public class CellRange {
    private CellRef startCellRef;
    private int width;
    private int height;
    private final String sheetName;
    private CellRef[][] cells;
    private boolean[][] changeMatrix;
    private int[] colHeights;
    private int[] rowWidths;
    private CellShiftStrategy cellShiftStrategy;

    public CellRange(CellRef startCellRef, int width, int height) {
        this.startCellRef = startCellRef;
        this.width = width;
        this.height = height;
        this.sheetName = this.startCellRef().sheetName();
        this.cells = new CellRef[this.height()][];
        this.changeMatrix = new boolean[this.height()][];
        this.colHeights = new int[this.width()];
        this.rowWidths = new int[this.height()];
        this.cellShiftStrategy = CellShiftStrategy$Inner$.MODULE$;
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), this.height()).foreach((Function1)(JFunction1.mcVI.sp & Serializable)row -> {
            this.rowWidths[row] = this.width();
            this.cells[row] = new CellRef[this.width()];
            this.changeMatrix[row] = new boolean[this.width()];
            RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), this.width()).foreach((Function1)(JFunction1.mcVI.sp & Serializable)col -> {
                this.cells[row$1][col] = new CellRef(this.sheetName(), row, col);
            });
        });
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), this.width()).foreach((Function1)(JFunction1.mcVI.sp & Serializable)col -> {
            this.colHeights[col] = this.height();
        });
    }

    public CellRef startCellRef() {
        return this.startCellRef;
    }

    public void startCellRef_$eq(CellRef x$1) {
        this.startCellRef = x$1;
    }

    public int width() {
        return this.width;
    }

    public void width_$eq(int x$1) {
        this.width = x$1;
    }

    public int height() {
        return this.height;
    }

    public void height_$eq(int x$1) {
        this.height = x$1;
    }

    public String sheetName() {
        return this.sheetName;
    }

    public CellShiftStrategy cellShiftStrategy() {
        return this.cellShiftStrategy;
    }

    public void cellShiftStrategy_$eq(CellShiftStrategy x$1) {
        this.cellShiftStrategy = x$1;
    }

    public CellRef getCell(int row, int col) {
        return this.cells[row][col];
    }

    private void setCell(int row, int col, CellRef cellRef) {
        this.cells[row][col] = cellRef;
    }

    public void shiftCellsWithRowBlock(int startRow, int endRow, int col, int colShift, boolean updateRowWidths) {
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), this.height()).foreach((Function1)(JFunction1.mcVI.sp & Serializable)i -> RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), this.width()).foreach((Function1)(JFunction1.mcVI.sp & Serializable)j -> {
            boolean requiresShifting = this.cellShiftStrategy().requiresColShifting(this.cells[i][j], startRow, endRow, col);
            if (requiresShifting && this.isHorizontalShiftAllowed(col, colShift, i, j)) {
                this.cells[i][j].col_$eq(this.cells[i][j].col() + colShift);
                this.changeMatrix[i$1][j] = true;
                return;
            }
        }));
        if (updateRowWidths) {
            int maxRow = Math.min(endRow, this.rowWidths.length - 1);
            RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(startRow), maxRow).foreach((Function1)(JFunction1.mcVI.sp & Serializable)row -> {
                int[] nArray = this.rowWidths;
                nArray[row] = nArray[row] + colShift;
            });
            return;
        }
    }

    private boolean isHorizontalShiftAllowed(int col, int widthChange, int cellRow, int cellCol) {
        if (this.changeMatrix[cellRow][cellCol]) {
            return false;
        }
        if (widthChange >= 0) {
            return true;
        }
        return !RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(cellCol - 1), col).by(-1).exists((Function1)(JFunction1.mcZI.sp & Serializable)i -> this.isEmpty(cellRow, i));
    }

    public boolean requiresColShifting(CellRef cell, int startRow, int endRow, int startColShift) {
        return this.cellShiftStrategy().requiresColShifting(cell, startRow, endRow, startColShift);
    }

    public void shiftCellsWithColBlock(int startCol, int endCol, int row, int rowShift, boolean updateColHeights) {
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), this.height()).foreach((Function1)(JFunction1.mcVI.sp & Serializable)i -> RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), this.width()).foreach((Function1)(JFunction1.mcVI.sp & Serializable)j -> {
            boolean requiresShifting = this.cellShiftStrategy().requiresRowShifting(this.cells[i][j], startCol, endCol, row);
            if (requiresShifting && this.isVerticalShiftAllowed(row, rowShift, i, j)) {
                this.cells[i][j].row_$eq(this.cells[i][j].row() + rowShift);
                this.changeMatrix[i$2][j] = true;
                return;
            }
        }));
        if (updateColHeights) {
            int maxCol = Math.min(endCol, this.colHeights.length - 1);
            RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(startCol), maxCol).foreach((Function1)(JFunction1.mcVI.sp & Serializable)col -> {
                int[] nArray = this.colHeights;
                nArray[col] = nArray[col] + rowShift;
            });
            return;
        }
    }

    private boolean isVerticalShiftAllowed(int row, int heightChange, int cellRow, int cellCol) {
        if (this.changeMatrix[cellRow][cellCol]) {
            return false;
        }
        if (heightChange >= 0) {
            return true;
        }
        boolean nonEmpty = true;
        for (int i = cellRow - 1; i > row && nonEmpty; --i) {
            nonEmpty = !this.isEmpty(i, cellCol);
        }
        return nonEmpty;
    }

    public void excludeCells(int startCol, int endCol, int startRow, int endRow) {
        RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(startRow), endRow).foreach((Function1)(JFunction1.mcVI.sp & Serializable)row -> RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(startCol), endCol).foreach((Function1)(JFunction1.mcVI.sp & Serializable)col -> {
            this.cells[row$4][col] = null;
        }));
    }

    public void clearCells(int startCol, int endCol, int startRow, int endRow) {
        RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(startRow), endRow).foreach((Function1)(JFunction1.mcVI.sp & Serializable)row -> RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(startCol), endCol).foreach((Function1)(JFunction1.mcVI.sp & Serializable)col -> {
            this.cells[row$5][col] = CellRef$.MODULE$.NONE();
        }));
    }

    public int calculateHeight() {
        IntRef maxHeight = IntRef.create((int)0);
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), this.width()).foreach((Function1)(JFunction1.mcVI.sp & Serializable)col -> {
            int n;
            maxHeight$1.elem = n = Math.max(maxHeight$1.elem, this.colHeights[col]);
        });
        return maxHeight.elem;
    }

    public int calculateWidth() {
        IntRef maxWidth = IntRef.create((int)0);
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), this.height()).foreach((Function1)(JFunction1.mcVI.sp & Serializable)row -> {
            int n;
            maxWidth$1.elem = n = Math.max(maxWidth$1.elem, this.rowWidths[row]);
        });
        return maxWidth.elem;
    }

    public boolean isExcluded(int row, int col) {
        return this.cells[row][col] == null || CellRef$.MODULE$.NONE().equals(this.cells[row][col]);
    }

    public boolean contains(int row, int col) {
        return row >= 0 && row < this.cells.length && col >= 0 && this.cells[0].length > col;
    }

    public boolean containsDirectivesInRow(int row) {
        return RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), this.width()).exists((Function1)(JFunction1.mcZI.sp & Serializable)col -> this.cells[row][col] == null || this.cells[row][col] == CellRef$.MODULE$.NONE());
    }

    public boolean isEmpty(int row, int col) {
        return this.cells[row][col] == null;
    }

    public boolean hasChanged(int row, int col) {
        return this.changeMatrix[row][col];
    }

    public void resetChangeMatrix() {
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), this.height()).foreach((Function1)(JFunction1.mcVI.sp & Serializable)i -> RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), this.width()).foreach((Function1)(JFunction1.mcVI.sp & Serializable)j -> {
            this.changeMatrix[i$3][j] = false;
        }));
    }

    public int findTarrow(int srcRow) {
        IntRef maxRow = IntRef.create((int)-1);
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), this.width()).foreach((Function1)(JFunction1.mcVI.sp & Serializable)col -> {
            int n;
            CellRef cellRef = this.cells[srcRow][col];
            maxRow$1.elem = n = Math.max(maxRow$1.elem, cellRef.row());
        });
        if (maxRow.elem < 0) {
            int n;
            maxRow.elem = n = srcRow;
        }
        return maxRow.elem;
    }
}

