/*
 * Decompiled with CFR 0.152.
 */
package org.beangle.data.excel.template;

import java.io.Serializable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.beangle.data.excel.AreaRef;
import org.beangle.data.excel.CellRef;
import org.beangle.data.excel.CellRef$;
import org.beangle.data.excel.template.Area;
import org.beangle.data.excel.template.CellData;
import org.beangle.data.excel.template.CellData$FormulaStrategy$;
import org.beangle.data.excel.template.FormulaProcessor;
import org.beangle.data.excel.template.FormulaProcessor$;
import org.beangle.data.excel.template.Transformer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.Iterable;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.StringOps$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.HashSet;
import scala.math.Ordering$;
import scala.runtime.BooleanRef;
import scala.runtime.ObjectRef;
import scala.runtime.function.JProcedure1;
import scala.runtime.java8.JFunction1;

public class DefaultFormulaProcessor
implements FormulaProcessor {
    private final Logger logger = LoggerFactory.getLogger(DefaultFormulaProcessor.class);

    @Override
    public void processAreaFormulas(Transformer transformer, Area area) {
        Set<CellData> formulaCells = transformer.getFormulaCells();
        formulaCells.withFilter((Function1 & Serializable)fcd -> fcd.area() != null && area.getAreaRef().sheetName().equals(fcd.sheetName())).foreach((Function1)(JProcedure1 & Serializable)fcd -> {
            this.logger.debug("Processing formula cell {}", fcd);
            ArrayBuffer<CellRef> targetFormulaCells = fcd.targetPos();
            Map targetCellRefMap = this.buildTargetCellRefMap(transformer, area, (CellData)fcd);
            Map jointedCellRefMap = this.buildJointedCellRefMap(transformer, (CellData)fcd);
            HashSet usedCellRefs = new HashSet();
            targetFormulaCells.indices().foreach((Function1)(JFunction1.mcVI.sp & Serializable)i -> {
                CellRef targetFormulaCellRef = (CellRef)targetFormulaCells.apply(i);
                ObjectRef targetFormulaString = ObjectRef.create((Object)fcd.formula());
                if (fcd.isParameterizedFormulaCell() && i < fcd.evaluatedFormulas().size()) {
                    String string = (String)fcd.evaluatedFormulas().apply(i);
                    targetFormulaString.elem = string;
                    string = null;
                }
                AreaRef formulaSourceAreaRef = fcd.area().getAreaRef();
                AreaRef formulaTargetAreaRef = (AreaRef)fcd.targetParentAreaRef().apply(i);
                BooleanRef isFormulaCellRefsEmpty = BooleanRef.create((boolean)true);
                targetCellRefMap.foreach((Function1)(JProcedure1 & Serializable)cellRefEntry -> {
                    Seq targetCells = (Seq)cellRefEntry._2();
                    if (targetCells.nonEmpty()) {
                        boolean bl;
                        isFormulaCellRefsEmpty$1.elem = bl = false;
                        Seq<CellRef> replacementCells = this.findFormulaCellRefReplacements(transformer, targetFormulaCellRef, formulaSourceAreaRef, formulaTargetAreaRef, (Tuple2<CellRef, Seq<CellRef>>)cellRefEntry);
                        CellData.FormulaStrategy formulaStrategy = fcd.formulaStrategy();
                        CellData.FormulaStrategy formulaStrategy2 = CellData$FormulaStrategy$.BY_COLUMN;
                        if (!(formulaStrategy != null ? !formulaStrategy.equals(formulaStrategy2) : formulaStrategy2 != null)) {
                            replacementCells = FormulaProcessor$.MODULE$.createTargetCellRefListByColumn(targetFormulaCellRef, (Iterable<CellRef>)replacementCells, (Set<CellRef>)usedCellRefs);
                            usedCellRefs.addAll(replacementCells);
                        }
                        String replacementString = this.createTargetCellRef((Seq)replacementCells);
                        String from = FormulaProcessor$.MODULE$.regexJointedLookBehind() + FormulaProcessor$.MODULE$.regexExcludePrefixSymbols() + Pattern.quote(((CellRef)cellRefEntry._1()).getCellName(true));
                        String to = Matcher.quoteReplacement(replacementString);
                        String string = ((String)targetFormulaString$1.elem).replaceAll(from, to);
                        targetFormulaString$1.elem = string;
                        string = null;
                        return;
                    }
                });
                BooleanRef isFormulaJointedCellRefsEmpty = BooleanRef.create((boolean)true);
                jointedCellRefMap.foreach((Function1)(JProcedure1 & Serializable)jointedCellRefEntry -> {
                    Seq targetCellRefList = (Seq)jointedCellRefEntry._2();
                    if (targetCellRefList.nonEmpty()) {
                        boolean bl;
                        isFormulaJointedCellRefsEmpty$1.elem = bl = false;
                        Tuple2 cellRefMapEntryParam = Tuple2$.MODULE$.apply(null, targetCellRefList.sorted(Ordering$.MODULE$.ordered(Predef$.MODULE$.$conforms())));
                        Seq<CellRef> replacementCells = this.findFormulaCellRefReplacements(transformer, targetFormulaCellRef, formulaSourceAreaRef, formulaTargetAreaRef, (Tuple2<CellRef, Seq<CellRef>>)cellRefMapEntryParam);
                        String replacementString = this.createTargetCellRef((Seq)replacementCells);
                        String string = ((String)targetFormulaString$2.elem).replaceAll(Pattern.quote((String)jointedCellRefEntry._1()), replacementString);
                        targetFormulaString$2.elem = string;
                        string = null;
                        return;
                    }
                });
                String sheetNameReplacementRegex = Pattern.quote(targetFormulaCellRef.getFormattedSheetName() + CellRef$.MODULE$.SHEET_NAME_DELIMITER());
                String string = ((String)targetFormulaString.elem).replaceAll(sheetNameReplacementRegex, "");
                targetFormulaString.elem = string;
                string = null;
                if (isFormulaCellRefsEmpty.elem && isFormulaJointedCellRefsEmpty.elem && (!fcd.isParameterizedFormulaCell() || fcd.isJointedFormulaCell())) {
                    String string2 = fcd.defaultValue() != null ? fcd.defaultValue() : "0";
                    targetFormulaString.elem = string2;
                    string2 = null;
                }
                if (StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString((String)targetFormulaString.elem))) {
                    transformer.setFormula(new CellRef(targetFormulaCellRef.sheetName(), targetFormulaCellRef.row(), targetFormulaCellRef.col()), (String)targetFormulaString.elem);
                    return;
                }
            });
        });
    }

    private Seq<CellRef> findFormulaCellRefReplacements(Transformer transformer, CellRef targetFormulaCellRef, AreaRef formulaSourceAreaRef, AreaRef formulaTargetAreaRef, Tuple2<CellRef, Seq<CellRef>> entry) {
        CellRef cellReference = (CellRef)entry._1();
        Seq targets = (Seq)entry._2();
        if (cellReference != null && !formulaSourceAreaRef.contains(cellReference)) {
            CellData cd = (CellData)transformer.getCellData(cellReference).orNull((.less.colon.less)$less$colon$less$.MODULE$.refl());
            if (cd != null && cd.targetParentAreaRef().nonEmpty()) {
                ArrayBuffer targetReferences = new ArrayBuffer();
                Option option = cd.targetParentAreaRef().find((Function1 & Serializable)_$1 -> _$1.contains(targetFormulaCellRef));
                if (option instanceof Some) {
                    AreaRef ar = (AreaRef)((Some)option).value();
                    targets.foreach((Function1)(JProcedure1 & Serializable)x -> {
                        if (ar.contains((CellRef)x)) {
                            targetReferences.addOne(x);
                            return;
                        }
                    });
                    return targetReferences;
                }
                if (!None$.MODULE$.equals(option)) {
                    throw new MatchError((Object)option);
                }
            }
            return targets;
        }
        return (Seq)targets.filter((Function1 & Serializable)cellRef -> formulaTargetAreaRef.contains((CellRef)cellRef));
    }
}

