/*
 * Decompiled with CFR 0.152.
 */
package org.beangle.data.excel.template;

import org.apache.poi.ss.util.WorkbookUtil;
import org.beangle.data.excel.template.SheetNameBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.collection.mutable.HashSet;

public class DefaultSheetNameBuilder
implements SheetNameBuilder {
    private final Logger logger = LoggerFactory.getLogger(DefaultSheetNameBuilder.class);
    private final HashSet<String> usedSheetNames = new HashSet();

    @Override
    public String createSheetName(String givenSheetName, int index) {
        String sheetName = WorkbookUtil.createSafeSheetName((String)givenSheetName);
        int serialNumber = 1;
        String newName = sheetName;
        while (this.usedSheetNames.contains((Object)newName)) {
            String string;
            String string2;
            int len = sheetName.length();
            String nameWithNumber = null;
            do {
                nameWithNumber = this.addSerialNumber(sheetName.substring(0, --len + 1), serialNumber);
                string2 = newName = WorkbookUtil.createSafeSheetName((String)nameWithNumber);
                string = nameWithNumber;
            } while (string2 != null ? !string2.equals(string) : string != null);
            ++serialNumber;
        }
        String string = givenSheetName;
        String string3 = newName;
        if (string == null ? string3 != null : !string.equals(string3)) {
            this.logger.info("Change invalid sheet name {} to {}", (Object)givenSheetName, (Object)sheetName);
        }
        this.usedSheetNames.addOne((Object)newName);
        return newName;
    }

    public String addSerialNumber(String text, int serialNumber) {
        return text + "(" + serialNumber + ")";
    }
}

