/*
 * Decompiled with CFR 0.152.
 */
package org.beangle.data.excel.template;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Comment;
import org.apache.poi.ss.usermodel.ConditionalFormatting;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.SheetConditionalFormatting;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.CellAddress;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.beangle.commons.lang.Strings$;
import org.beangle.data.excel.AreaRef;
import org.beangle.data.excel.AreaRef$;
import org.beangle.data.excel.CellOps$;
import org.beangle.data.excel.CellRef;
import org.beangle.data.excel.Sheets$;
import org.beangle.data.excel.Size;
import org.beangle.data.excel.Workbooks$;
import org.beangle.data.excel.template.AbstractTransformer;
import org.beangle.data.excel.template.CellData;
import org.beangle.data.excel.template.Context;
import org.beangle.data.excel.template.DefaultTransformer$;
import org.beangle.data.excel.template.RowData;
import org.beangle.data.excel.template.SheetData;
import org.beangle.data.excel.template.SheetData$;
import org.slf4j.Logger;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.ArrayOps$;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.LinkedHashMap;
import scala.jdk.javaapi.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.runtime.BooleanRef;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.function.JProcedure1;
import scala.runtime.java8.JFunction1;

public class DefaultTransformer
extends AbstractTransformer {
    private final Workbook workbook;
    private int lastCommentedColumn;

    public static Context createInitialContext() {
        return DefaultTransformer$.MODULE$.createInitialContext();
    }

    public static DefaultTransformer createTransformer(InputStream inputStream) {
        return DefaultTransformer$.MODULE$.createTransformer(inputStream);
    }

    public static DefaultTransformer createTransformer(Workbook workbook, boolean bl) {
        return DefaultTransformer$.MODULE$.createTransformer(workbook, bl);
    }

    public static Logger logger() {
        return DefaultTransformer$.MODULE$.logger();
    }

    public static boolean createTransformer$default$2() {
        return DefaultTransformer$.MODULE$.createTransformer$default$2();
    }

    public DefaultTransformer(Workbook workbook) {
        this.workbook = workbook;
        this.lastCommentedColumn = 50;
        this.sheetMap_$eq(this.readSheetData());
    }

    @Override
    public Workbook workbook() {
        return this.workbook;
    }

    public int lastCommentedColumn() {
        return this.lastCommentedColumn;
    }

    public void lastCommentedColumn_$eq(int x$1) {
        this.lastCommentedColumn = x$1;
    }

    @Override
    public boolean isForwardOnly() {
        return this.workbook() instanceof SXSSFWorkbook;
    }

    public void removeAllRowBreaks() {
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), this.workbook().getNumberOfSheets()).foreach((Function1)(JFunction1.mcVI.sp & Serializable)i -> {
            Sheet sheet = this.workbook().getSheetAt(i);
            int[] breaks = sheet.getRowBreaks();
            if (breaks != null && breaks.length > 0) {
                Object object = Predef$.MODULE$.intArrayOps(breaks);
                ArrayOps$.MODULE$.foreach$extension(object, (Function1)(JFunction1.mcVI.sp & Serializable)b -> sheet.removeRowBreak(b));
                return;
            }
        });
    }

    private Map<String, SheetData> readSheetData() {
        int numberOfSheets = this.workbook().getNumberOfSheets();
        LinkedHashMap sheets = new LinkedHashMap();
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), numberOfSheets).foreach((Function1 & Serializable)i -> this.readSheetData$$anonfun$1(sheets, BoxesRunTime.unboxToInt((Object)i)));
        return sheets.toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    @Override
    public void transform(CellRef srcCellRef, CellRef targetCellRef, Context context, boolean updateRowHeightFlag) {
        Row destRow;
        CellData cellData = this.isTransformable(srcCellRef, targetCellRef);
        if (cellData == null) {
            return;
        }
        Sheet destSheet = this.workbook().getSheet(targetCellRef.sheetName());
        if (destSheet == null) {
            destSheet = this.workbook().createSheet(targetCellRef.sheetName());
            Sheets$.MODULE$.copyProperties(this.workbook().getSheet(srcCellRef.sheetName()), destSheet);
        }
        if ((destRow = destSheet.getRow(targetCellRef.row())) == null) {
            destRow = destSheet.createRow(targetCellRef.row());
        }
        this.transformCell(srcCellRef, targetCellRef, context, updateRowHeightFlag, cellData, destSheet, destRow);
    }

    public CellData isTransformable(CellRef srcCellRef, CellRef targetCellRef) {
        Option<CellData> option = this.getCellData(srcCellRef);
        if (option instanceof Some) {
            CellData cd = (CellData)((Some)option).value();
            if (targetCellRef == null || Strings$.MODULE$.isBlank((CharSequence)targetCellRef.sheetName())) {
                return null;
            }
            return cd;
        }
        if (None$.MODULE$.equals(option)) {
            return null;
        }
        throw new MatchError(option);
    }

    public void transformCell(CellRef srcCell, CellRef targetCell, Context context, boolean updateRowHeightFlag, CellData cellData, Sheet destSheet, Row destRow) {
        Cell destCell;
        SheetData sheetData = (SheetData)this.sheetMap().apply((Object)srcCell.sheetName());
        if (!this.ignoreColumnProps()) {
            destSheet.setColumnWidth(targetCell.col(), sheetData.getColumnWidth(srcCell.col()));
        }
        if (updateRowHeightFlag && !this.ignoreRowProps()) {
            destRow.setHeight((short)((RowData)sheetData.getRowData(srcCell.row()).orNull((.less.colon.less)$less$colon$less$.MODULE$.refl())).height());
        }
        if ((destCell = destRow.getCell(targetCell.col())) == null) {
            destCell = destRow.createCell(targetCell.col());
        }
        try {
            destCell.setBlank();
            cellData.writeToCell(destCell, context, this);
            this.copyMergedRegions(sheetData, cellData, targetCell);
        }
        catch (Exception e) {
            DefaultTransformer$.MODULE$.logger().error("Failed to write a cell with {} and context keys {}", new Object[]{cellData, context.toMap().keySet(), e});
        }
    }

    @Override
    public void resetArea(AreaRef areaRef) {
        this.removeMergedRegions(areaRef);
        this.removeConditionalFormatting(areaRef);
    }

    private void removeMergedRegions(AreaRef areaRef) {
        Sheet destSheet = this.workbook().getSheet(areaRef.sheetName());
        int numMergedRegions = destSheet.getNumMergedRegions();
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(numMergedRegions), 0).by(-1).foreach((Function1)(JFunction1.mcVI.sp & Serializable)i -> destSheet.removeMergedRegion(i - 1));
    }

    private void removeConditionalFormatting(AreaRef areaRef) {
        Sheet destSheet = this.workbook().getSheet(areaRef.sheetName());
        CellRangeAddress areaRange = CellRangeAddress.valueOf((String)areaRef.toString());
        SheetConditionalFormatting sheetConditionalFormatting = destSheet.getSheetConditionalFormatting();
        int numConditionalFormattings = sheetConditionalFormatting.getNumConditionalFormattings();
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), numConditionalFormattings).foreach((Function1)(JFunction1.mcVI.sp & Serializable)index -> {
            ConditionalFormatting conditionalFormatting = sheetConditionalFormatting.getConditionalFormattingAt(index);
            Object[] ranges = conditionalFormatting.getFormattingRanges();
            ArrayBuffer newRanges = new ArrayBuffer();
            Object object = Predef$.MODULE$.refArrayOps(ranges);
            ArrayOps$.MODULE$.foreach$extension(object, (Function1)(JProcedure1 & Serializable)range -> {
                if (!areaRange.isInRange(range.getFirstRow(), range.getFirstColumn()) || !areaRange.isInRange(range.getLastRow(), range.getLastColumn())) {
                    newRanges.addOne(range);
                    return;
                }
            });
            conditionalFormatting.setFormattingRanges((CellRangeAddress[])newRanges.toArray(ClassTag$.MODULE$.apply(CellRangeAddress.class)));
        });
    }

    public final void copyMergedRegions(SheetData sheetData, CellData srcCellData, CellRef destCell) {
        sheetData.mergedRegions().find((Function1 & Serializable)x -> x.getFirstRow() == srcCellData.row() && x.getFirstColumn() == srcCellData.col()).foreach((Function1 & Serializable)r -> {
            this.findAndRemoveExistingCellRegion(destCell);
            Sheet destSheet = this.workbook().getSheet(destCell.sheetName());
            return destSheet.addMergedRegion(new CellRangeAddress(destCell.row(), destCell.row() + r.getLastRow() - r.getFirstRow(), destCell.col(), destCell.col() + r.getLastColumn() - r.getFirstColumn()));
        });
    }

    public final void findAndRemoveExistingCellRegion(CellRef cellRef) {
        Sheet destSheet = this.workbook().getSheet(cellRef.sheetName());
        int numMergedRegions = destSheet.getNumMergedRegions();
        BooleanRef breaked = BooleanRef.create((boolean)false);
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), numMergedRegions).withFilter((Function1)(JFunction1.mcZI.sp & Serializable)i -> !breaked$1.elem).foreach((Function1)(JFunction1.mcVI.sp & Serializable)i -> {
            CellRangeAddress mergedRegion = destSheet.getMergedRegion(i);
            if (mergedRegion.getFirstRow() <= cellRef.row() && mergedRegion.getLastRow() >= cellRef.row() && mergedRegion.getFirstColumn() <= cellRef.col() && mergedRegion.getLastColumn() >= cellRef.col()) {
                boolean bl;
                destSheet.removeMergedRegion(i);
                breaked$2.elem = bl = true;
                return;
            }
        });
    }

    @Override
    public void setFormula(CellRef cellRef, String formulaString) {
        if (cellRef == null || cellRef.sheetName() == null) {
            return;
        }
        Cell cell = Workbooks$.MODULE$.getOrCreateCell(this.workbook(), cellRef);
        cell.setCellFormula(formulaString);
        CellOps$.MODULE$.clearValue$extension(CellOps$.MODULE$.toCell(cell));
    }

    @Override
    public void clearCell(CellRef cellRef) {
        if (cellRef != null && cellRef.sheetName() != null) {
            Workbooks$.MODULE$.cleanCell(this.workbook(), cellRef);
            this.findAndRemoveExistingCellRegion(cellRef);
            return;
        }
    }

    @Override
    public Seq<CellData> getCommentedCells() {
        ArrayBuffer commentedCells = new ArrayBuffer();
        this.sheetMap().values().foreach((Function1)(JProcedure1 & Serializable)sheetData -> sheetData.withFilter((Function1 & Serializable)rowData -> rowData != null).foreach((Function1 & Serializable)rowData -> {
            int row = rowData.row().getRowNum();
            Seq<CellData> cellDataList = this.readCommentsFromSheet(sheetData.sheet(), row);
            return commentedCells.addAll(cellDataList);
        }));
        return commentedCells;
    }

    @Override
    public void write(OutputStream os) throws IOException {
        this.workbook().write(os);
        os.close();
        this.dispose();
    }

    @Override
    public void writeTo(OutputStream os) throws IOException {
        this.workbook().write(os);
        this.dispose();
    }

    private void dispose() {
        Workbook workbook = this.workbook();
        if (workbook instanceof SXSSFWorkbook) {
            SXSSFWorkbook x = (SXSSFWorkbook)workbook;
            x.dispose();
            return;
        }
    }

    private Seq<CellData> readCommentsFromSheet(Sheet sheet, int rowNum) {
        ArrayBuffer commentDataCells = new ArrayBuffer();
        RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), this.lastCommentedColumn()).foreach((Function1)(JFunction1.mcVI.sp & Serializable)i -> {
            CellAddress cellAddress = new CellAddress(rowNum, i);
            Comment comment = sheet.getCellComment(cellAddress);
            if (comment != null && comment.getString() != null) {
                String cc = comment.getString().getString();
                if (Strings$.MODULE$.isNotBlank((CharSequence)cc)) {
                    CellData cellData = new CellData(new CellRef(sheet.getSheetName(), rowNum, i), null);
                    cellData.cellComment_$eq(comment.getString().getString());
                    commentDataCells.addOne((Object)cellData);
                    return;
                }
                return;
            }
        });
        return commentDataCells;
    }

    @Override
    public void updateRowHeight(String srcSheetName, int srcRowNum, String targetSheetName, int targetRowNum) {
        Row targetRow;
        if (this.isForwardOnly()) {
            return;
        }
        SheetData sheetData = (SheetData)this.sheetMap().apply((Object)srcSheetName);
        RowData rowData = (RowData)sheetData.getRowData(srcRowNum).orNull((.less.colon.less)$less$colon$less$.MODULE$.refl());
        Sheet sheet = this.workbook().getSheet(targetSheetName);
        if (sheet == null) {
            sheet = this.workbook().createSheet(targetSheetName);
        }
        if ((targetRow = sheet.getRow(targetRowNum)) == null) {
            targetRow = sheet.createRow(targetRowNum);
        }
        short srcHeight = rowData != null ? (short)rowData.height() : sheet.getDefaultRowHeight();
        targetRow.setHeight(srcHeight);
    }

    private XSSFWorkbook getXSSFWorkbook() {
        Workbook workbook = this.workbook();
        if (workbook instanceof SXSSFWorkbook) {
            SXSSFWorkbook sb = (SXSSFWorkbook)workbook;
            return sb.getXSSFWorkbook();
        }
        if (workbook instanceof XSSFWorkbook) {
            XSSFWorkbook xb = (XSSFWorkbook)workbook;
            return xb;
        }
        return null;
    }

    @Override
    public void adjustTableSize(CellRef ref, Size size) {
        XSSFWorkbook xwb = this.getXSSFWorkbook();
        if (size.height() > 0 && xwb != null) {
            XSSFSheet sheet = xwb.getSheet(ref.sheetName());
            if (sheet == null) {
                DefaultTransformer$.MODULE$.logger().error("Can not access sheet '{}'", (Object)ref.sheetName());
                return;
            }
            CollectionConverters$.MODULE$.asScala(sheet.getTables()).foreach((Function1)(JProcedure1 & Serializable)table -> {
                AreaRef areaRef = AreaRef$.MODULE$.apply(table.getSheetName() + "!" + table.getCTTable().getRef());
                if (areaRef.contains(ref)) {
                    areaRef.lastCellRef().row_$eq(ref.row() + size.height() - 1);
                    table.getCTTable().setRef(areaRef.firstCellRef().getCellName(true) + ":" + areaRef.lastCellRef().getCellName(true));
                    return;
                }
            });
            return;
        }
    }

    public CellStyle getCellStyle(CellRef cellRef) {
        SheetData sheetData = (SheetData)this.sheetMap().apply((Object)cellRef.sheetName());
        return (CellStyle)sheetData.getCellData(cellRef).map((Function1 & Serializable)_$1 -> _$1.cellStyle()).orNull((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    @Override
    public void mergeCells(CellRef cellRef, int rows, int cols) {
        Workbooks$.MODULE$.mergeCells(this.workbook(), cellRef, rows, cols, this.getCellStyle(cellRef));
    }

    private final /* synthetic */ Option readSheetData$$anonfun$1(LinkedHashMap sheets$1, int i) {
        Sheet sheet = this.workbook().getSheetAt(i);
        SheetData sheetData = SheetData$.MODULE$.createSheetData(sheet, this);
        return sheets$1.put((Object)sheetData.sheetName(), (Object)sheetData);
    }
}

