/*
 * Decompiled with CFR 0.152.
 */
package org.beangle.data.excel.template;

import java.io.Serializable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.beangle.data.excel.CellRef;
import scala.Function1;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.immutable.List;
import scala.collection.mutable.ArrayBuffer;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.function.JProcedure1;

public final class FormulaProcessor$
implements Serializable {
    private static final String regexJointedLookBehind;
    private static final String regexSimpleCellRef;
    private static final String regexCellRef;
    private static final String regexAreaRef;
    private static final Pattern regexAreaRefPattern;
    private static final Pattern regexCellRefExcludingJointedPattern;
    private static final Pattern regexCellRefPattern;
    private static final Pattern regexJointedCellRefPattern;
    private static final String regexExcludePrefixSymbols;
    public static final FormulaProcessor$ MODULE$;

    private FormulaProcessor$() {
    }

    static {
        MODULE$ = new FormulaProcessor$();
        regexJointedLookBehind = "(?<!U_\\([^)]{0,100})";
        regexSimpleCellRef = "[a-zA-Z]+[0-9]+";
        regexCellRef = "([a-zA-Z_]+[a-zA-Z0-9_]*![a-zA-Z]+[0-9]+|(?<!\\d)[a-zA-Z]+[0-9]+|'[^?\\\\/:'*]+'![a-zA-Z]+[0-9]+)";
        regexAreaRef = MODULE$.regexCellRef() + ":" + MODULE$.regexSimpleCellRef();
        regexAreaRefPattern = Pattern.compile(MODULE$.regexAreaRef());
        regexCellRefExcludingJointedPattern = Pattern.compile(MODULE$.regexJointedLookBehind() + MODULE$.regexCellRef());
        regexCellRefPattern = Pattern.compile(MODULE$.regexCellRef());
        regexJointedCellRefPattern = Pattern.compile("U_\\([^\\)]+\\)");
        regexExcludePrefixSymbols = "(?<!\\w)";
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(FormulaProcessor$.class);
    }

    public String regexJointedLookBehind() {
        return regexJointedLookBehind;
    }

    public String regexSimpleCellRef() {
        return regexSimpleCellRef;
    }

    public String regexCellRef() {
        return regexCellRef;
    }

    public String regexAreaRef() {
        return regexAreaRef;
    }

    public Pattern regexAreaRefPattern() {
        return regexAreaRefPattern;
    }

    public Pattern regexCellRefExcludingJointedPattern() {
        return regexCellRefExcludingJointedPattern;
    }

    public Pattern regexCellRefPattern() {
        return regexCellRefPattern;
    }

    public Pattern regexJointedCellRefPattern() {
        return regexJointedCellRefPattern;
    }

    public String regexExcludePrefixSymbols() {
        return regexExcludePrefixSymbols;
    }

    public List<String> getFormulaCellRefs(String formula) {
        return this.getStringPartsByPattern(formula, this.regexCellRefExcludingJointedPattern());
    }

    public List<String> getJointedCellRefs(String formula) {
        return this.getStringPartsByPattern(formula, this.regexJointedCellRefPattern());
    }

    public List<String> getCellRefsFromJointedCellRef(String jointedCellRef) {
        return this.getStringPartsByPattern(jointedCellRef, this.regexCellRefPattern());
    }

    public List<String> getStringPartsByPattern(String str, Pattern pattern) {
        ArrayBuffer cellRefs = new ArrayBuffer();
        if (str != null) {
            Matcher cellRefMatcher = pattern.matcher(str);
            while (cellRefMatcher.find()) {
                cellRefs.addOne((Object)cellRefMatcher.group());
            }
        }
        return cellRefs.toList();
    }

    public boolean formulaContainsJointedCellRef(String formula) {
        return this.regexJointedCellRefPattern().matcher(formula).find();
    }

    public Seq<CellRef> createTargetCellRefListByColumn(CellRef targetFormulaCellRef, Iterable<CellRef> targetCells, Set<CellRef> cellRefsToExclude) {
        ArrayBuffer resultCellList = new ArrayBuffer();
        int col = targetFormulaCellRef.col();
        targetCells.foreach((Function1)(JProcedure1 & Serializable)targetCell -> {
            if (targetCell.col() == col && targetCell.row() < targetFormulaCellRef.row() && !cellRefsToExclude.contains(targetCell)) {
                resultCellList.addOne(targetCell);
                return;
            }
        });
        return resultCellList;
    }
}

