/*
 * Decompiled with CFR 0.152.
 */
package org.beangle.data.excel.template;

import java.io.Serializable;
import java.util.regex.Pattern;
import org.beangle.data.excel.CellRef;
import org.beangle.data.excel.CellRef$;
import org.beangle.data.excel.template.Area;
import org.beangle.data.excel.template.CellData;
import org.beangle.data.excel.template.FormulaProcessor$;
import org.beangle.data.excel.template.Transformer;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.Predef$;
import scala.collection.Iterable;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.immutable.List;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.LinkedHashMap;
import scala.runtime.IntRef;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.function.JProcedure1;
import scala.runtime.java8.JFunction1;

public interface FormulaProcessor {
    public static Seq<CellRef> createTargetCellRefListByColumn(CellRef cellRef, Iterable<CellRef> iterable, Set<CellRef> set) {
        return FormulaProcessor$.MODULE$.createTargetCellRefListByColumn(cellRef, iterable, set);
    }

    public static boolean formulaContainsJointedCellRef(String string) {
        return FormulaProcessor$.MODULE$.formulaContainsJointedCellRef(string);
    }

    public static List<String> getCellRefsFromJointedCellRef(String string) {
        return FormulaProcessor$.MODULE$.getCellRefsFromJointedCellRef(string);
    }

    public static List<String> getFormulaCellRefs(String string) {
        return FormulaProcessor$.MODULE$.getFormulaCellRefs(string);
    }

    public static List<String> getJointedCellRefs(String string) {
        return FormulaProcessor$.MODULE$.getJointedCellRefs(string);
    }

    public static List<String> getStringPartsByPattern(String string, Pattern pattern) {
        return FormulaProcessor$.MODULE$.getStringPartsByPattern(string, pattern);
    }

    public static String regexAreaRef() {
        return FormulaProcessor$.MODULE$.regexAreaRef();
    }

    public static Pattern regexAreaRefPattern() {
        return FormulaProcessor$.MODULE$.regexAreaRefPattern();
    }

    public static String regexCellRef() {
        return FormulaProcessor$.MODULE$.regexCellRef();
    }

    public static Pattern regexCellRefExcludingJointedPattern() {
        return FormulaProcessor$.MODULE$.regexCellRefExcludingJointedPattern();
    }

    public static Pattern regexCellRefPattern() {
        return FormulaProcessor$.MODULE$.regexCellRefPattern();
    }

    public static String regexExcludePrefixSymbols() {
        return FormulaProcessor$.MODULE$.regexExcludePrefixSymbols();
    }

    public static Pattern regexJointedCellRefPattern() {
        return FormulaProcessor$.MODULE$.regexJointedCellRefPattern();
    }

    public static String regexJointedLookBehind() {
        return FormulaProcessor$.MODULE$.regexJointedLookBehind();
    }

    public static String regexSimpleCellRef() {
        return FormulaProcessor$.MODULE$.regexSimpleCellRef();
    }

    public void processAreaFormulas(Transformer var1, Area var2);

    public static Map buildTargetCellRefMap$(FormulaProcessor $this, Transformer transformer, Area area, CellData formulaCellData) {
        return $this.buildTargetCellRefMap(transformer, area, formulaCellData);
    }

    default public Map<CellRef, Seq<CellRef>> buildTargetCellRefMap(Transformer transformer, Area area, CellData formulaCellData) {
        LinkedHashMap targetCellRefMap = new LinkedHashMap();
        List<String> formulaCellRefs = FormulaProcessor$.MODULE$.getFormulaCellRefs(formulaCellData.formula());
        formulaCellRefs.foreach((Function1)(JProcedure1 & Serializable)cellRef -> {
            CellRef pos = CellRef$.MODULE$.apply((String)cellRef);
            if (pos.isValid()) {
                ArrayBuffer<CellRef> targetCellDataList;
                if (pos.sheetName() == null) {
                    pos.sheetName_$eq(formulaCellData.sheetName());
                }
                if ((targetCellDataList = ((CellData)transformer.getCellData(pos).orNull((.less.colon.less)$less$colon$less$.MODULE$.refl())).targetPos()).isEmpty() && area != null && !area.getAreaRef().contains(pos)) {
                    targetCellDataList.addOne((Object)pos);
                }
                targetCellRefMap.put((Object)pos, targetCellDataList);
                return;
            }
        });
        return targetCellRefMap;
    }

    public static Map buildJointedCellRefMap$(FormulaProcessor $this, Transformer transformer, CellData formulaCellData) {
        return $this.buildJointedCellRefMap(transformer, formulaCellData);
    }

    default public Map<String, Seq<CellRef>> buildJointedCellRefMap(Transformer transformer, CellData formulaCellData) {
        LinkedHashMap jointedCellRefMap = new LinkedHashMap();
        List<String> jointedCellRefs = FormulaProcessor$.MODULE$.getJointedCellRefs(formulaCellData.formula());
        jointedCellRefs.foreach((Function1 & Serializable)jointedCellRef -> {
            List<String> nestedCellRefs = FormulaProcessor$.MODULE$.getCellRefsFromJointedCellRef((String)jointedCellRef);
            ArrayBuffer jointedCellRefList = new ArrayBuffer();
            nestedCellRefs.foreach((Function1 & Serializable)cellRef -> {
                CellRef pos = CellRef$.MODULE$.apply((String)cellRef);
                if (pos.sheetName() == null) {
                    pos.sheetName_$eq(formulaCellData.sheetName());
                }
                ArrayBuffer<CellRef> targetCellDataList = ((CellData)transformer.getCellData(pos).orNull((.less.colon.less)$less$colon$less$.MODULE$.refl())).targetPos();
                return jointedCellRefList.addAll(targetCellDataList);
            });
            return jointedCellRefMap.put(jointedCellRef, (Object)jointedCellRefList);
        });
        return jointedCellRefMap;
    }

    public static String createTargetCellRef$(FormulaProcessor $this, Seq targetCellDataList) {
        return $this.createTargetCellRef((Seq<CellRef>)targetCellDataList);
    }

    default public String createTargetCellRef(Seq<CellRef> targetCellDataList) {
        Object object;
        Object object2 = new Object();
        try {
            if (targetCellDataList == null) {
                return "";
            }
            int size = targetCellDataList.size();
            if (size == 0) {
                return "";
            }
            if (size == 1) {
                CellRef cellRef = (CellRef)targetCellDataList.apply(0);
                return cellRef.getCellName(cellRef.getCellName$default$1());
            }
            RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), size - 1).foreach((Function1)(JFunction1.mcVI.sp & Serializable)i -> {
                if (!((CellRef)targetCellDataList.apply(i)).sheetName().equals(((CellRef)targetCellDataList.apply(i + 1)).sheetName())) {
                    throw new NonLocalReturnControl(object2, (Object)this.buildCellRefsString(targetCellDataList));
                }
            });
            CellRef upperLeft = (CellRef)targetCellDataList.apply(0);
            CellRef lowerRight = (CellRef)targetCellDataList.apply(size - 1);
            int rowCount = lowerRight.row() - upperLeft.row() + 1;
            int colCount = lowerRight.col() - upperLeft.col() + 1;
            if (size != colCount * rowCount) {
                return this.buildCellRefsString(targetCellDataList);
            }
            if (rowCount == 1 || colCount == 1) {
                return upperLeft.getCellName(upperLeft.getCellName$default$1()) + ":" + lowerRight.getCellName(lowerRight.getCellName$default$1());
            }
            IntRef minRow = IntRef.create((int)upperLeft.row());
            IntRef minCol = IntRef.create((int)upperLeft.col());
            IntRef maxRow = IntRef.create((int)minRow.elem);
            IntRef maxCol = IntRef.create((int)minCol.elem);
            targetCellDataList.foreach((Function1)(JProcedure1 & Serializable)cell -> {
                if (cell.col() < minCol$1.elem) {
                    int n;
                    minCol$1.elem = n = cell.col();
                }
                if (cell.col() > maxCol$1.elem) {
                    int n;
                    maxCol$1.elem = n = cell.col();
                }
                if (cell.row() < minRow$1.elem) {
                    int n;
                    minRow$1.elem = n = cell.row();
                }
                if (cell.row() > maxRow$1.elem) {
                    int n;
                    maxRow$1.elem = n = cell.row();
                    return;
                }
            });
            if (maxRow.elem != lowerRight.row() || minRow.elem != upperLeft.row() || maxCol.elem != lowerRight.col() || minCol.elem != upperLeft.col()) {
                return this.buildCellRefsString(targetCellDataList);
            }
            object = upperLeft.getCellName(upperLeft.getCellName$default$1()) + ":" + lowerRight.getCellName(lowerRight.getCellName$default$1());
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object2) {
                object = (String)ex.value();
            }
            throw ex;
        }
        return object;
    }

    private String buildCellRefsString(Seq<CellRef> cellRefs) {
        ObjectRef reply = ObjectRef.create((Object)"");
        cellRefs.foreach((Function1)(JProcedure1 & Serializable)cellRef -> {
            Object object;
            reply$1.elem = object = (String)reply$1.elem + ("," + cellRef.getCellName(cellRef.getCellName$default$1()));
            object = null;
        });
        return ((String)reply.elem).substring(1);
    }
}

