/*
 * Decompiled with CFR 0.152.
 */
package org.beangle.data.excel.template;

import org.beangle.data.excel.CellRef;
import org.beangle.data.excel.template.CellRefGenerator;
import org.beangle.data.excel.template.Context;
import org.beangle.data.excel.template.SheetNameBuilder;
import scala.collection.Seq;

public class MultiSheetCellRefGenerator
implements CellRefGenerator {
    private final Seq sheetNames;
    private final CellRef startCellRef;

    public MultiSheetCellRefGenerator(Seq<String> sheetNames, CellRef startCellRef) {
        this.sheetNames = sheetNames;
        this.startCellRef = startCellRef;
    }

    public Seq<String> sheetNames() {
        return this.sheetNames;
    }

    public CellRef startCellRef() {
        return this.startCellRef;
    }

    @Override
    public CellRef generateCellRef(int index, Context context) {
        String sheetName = index >= 0 && index < this.sheetNames().size() ? (String)this.sheetNames().apply(index) : null;
        Object object = context.getVar("sheetNameBuilder");
        if (object instanceof SheetNameBuilder) {
            SheetNameBuilder builder = (SheetNameBuilder)object;
            sheetName = builder.createSheetName(sheetName, index);
        }
        if (sheetName == null) {
            return null;
        }
        return new CellRef(sheetName, this.startCellRef().row(), this.startCellRef().col());
    }
}

