/*
 * Decompiled with CFR 0.152.
 */
package org.beangle.data.excel.template;

import java.io.Serializable;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.SheetConditionalFormatting;
import org.apache.poi.ss.util.CellRangeAddress;
import org.beangle.data.excel.CellRef;
import org.beangle.data.excel.template.CellData;
import org.beangle.data.excel.template.PoiConditionalFormatting;
import org.beangle.data.excel.template.RowData;
import org.beangle.data.excel.template.SheetData$;
import org.beangle.data.excel.template.Transformer;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.collection.Iterable;
import scala.collection.IterableFactoryDefaults;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Iterator;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArraySeq;
import scala.math.Ordering;
import scala.runtime.function.JProcedure1;

public class SheetData
implements Iterable<RowData> {
    private final Sheet sheet;
    private int[] columnWidth;
    private final ArrayBuffer<RowData> rowDatas;
    private Transformer transformer;
    private final ArrayBuffer mergedRegions;
    private final ArrayBuffer poiConditionalFormattings;

    public static SheetData createSheetData(Sheet sheet, Transformer transformer) {
        return SheetData$.MODULE$.createSheetData(sheet, transformer);
    }

    public SheetData(Sheet sheet) {
        this.sheet = sheet;
        IterableOnce.$init$((IterableOnce)this);
        IterableOnceOps.$init$((IterableOnceOps)this);
        IterableOps.$init$((IterableOps)this);
        IterableFactoryDefaults.$init$((IterableFactoryDefaults)this);
        Iterable.$init$((Iterable)this);
        this.columnWidth = null;
        this.rowDatas = new ArrayBuffer();
        this.transformer = null;
        this.mergedRegions = new ArrayBuffer();
        this.poiConditionalFormattings = new ArrayBuffer();
    }

    public Sheet sheet() {
        return this.sheet;
    }

    public int[] columnWidth() {
        return this.columnWidth;
    }

    public void columnWidth_$eq(int[] x$1) {
        this.columnWidth = x$1;
    }

    public Transformer transformer() {
        return this.transformer;
    }

    public void transformer_$eq(Transformer x$1) {
        this.transformer = x$1;
    }

    public int getNumberOfRows() {
        return this.rowDatas.size();
    }

    public String sheetName() {
        return this.sheet().getSheetName();
    }

    public int getColumnWidth(int col) {
        return this.columnWidth()[col];
    }

    public Option<RowData> getRowData(int row) {
        if (row < this.rowDatas.size()) {
            return Option$.MODULE$.apply(this.rowDatas.apply(row));
        }
        return None$.MODULE$;
    }

    public Option<CellData> getCellData(CellRef cellRef) {
        if (cellRef.row() < this.rowDatas.size()) {
            return ((RowData)this.rowDatas.apply(cellRef.row())).getCellData(cellRef.col());
        }
        return None$.MODULE$;
    }

    public void addRowData(RowData rowData) {
        this.rowDatas.addOne((Object)rowData);
    }

    public Iterator<RowData> iterator() {
        return this.rowDatas.iterator();
    }

    public ArrayBuffer<CellRangeAddress> mergedRegions() {
        return this.mergedRegions;
    }

    public ArrayBuffer<PoiConditionalFormatting> org$beangle$data$excel$template$SheetData$$poiConditionalFormattings() {
        return this.poiConditionalFormattings;
    }

    public void updateConditionalFormatting(CellData srcCellData, Cell targetCell) {
        this.org$beangle$data$excel$template$SheetData$$poiConditionalFormattings().foreach((Function1)(JProcedure1 & Serializable)conditionalFormatting -> {
            ArraySeq<CellRangeAddress> ranges = conditionalFormatting.ranges();
            ranges.foreach((Function1)(JProcedure1 & Serializable)range -> {
                if (range.isInRange(srcCellData.row(), srcCellData.col())) {
                    CellRangeAddress newRange = new CellRangeAddress(targetCell.getRowIndex(), targetCell.getRowIndex(), targetCell.getColumnIndex(), targetCell.getColumnIndex());
                    Sheet targetSheet = targetCell.getSheet();
                    SheetConditionalFormatting targetSheetConditionalFormatting = targetSheet.getSheetConditionalFormatting();
                    ArrayBuffer sortedRules = (ArrayBuffer)conditionalFormatting.rules().sortBy((Function1 & Serializable)_$1 -> _$1.getPriority(), (Ordering)Ordering.Int$.MODULE$);
                    sortedRules.foreach((Function1 & Serializable)rule -> targetSheetConditionalFormatting.addConditionalFormatting(new CellRangeAddress[]{newRange}, rule));
                    return;
                }
            });
        });
    }
}

