/*
 * Decompiled with CFR 0.152.
 */
package org.beangle.data.excel.template;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import org.beangle.commons.lang.Strings$;
import org.beangle.data.excel.CellRef$;
import org.beangle.data.excel.Sheets$;
import org.beangle.data.excel.template.Area;
import org.beangle.data.excel.template.Context;
import org.beangle.data.excel.template.DefaultFormulaProcessor;
import org.beangle.data.excel.template.DefaultTransformer;
import org.beangle.data.excel.template.DefaultTransformer$;
import org.beangle.data.excel.template.XlsCommentAreaBuilder;
import org.beangle.data.excel.template.XlsCommentAreaBuilder$;
import org.beangle.data.excel.template.directive.EachDirective;
import scala.Function1;
import scala.collection.Iterable;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.mutable.ArrayBuffer;
import scala.runtime.BooleanRef;
import scala.runtime.function.JProcedure1;

public class TransformHelper {
    private final InputStream templateStream;
    private boolean deleteTemplateSheet;
    private boolean processFormulas;

    public TransformHelper(InputStream templateStream) {
        this.templateStream = templateStream;
        this.deleteTemplateSheet = true;
        this.processFormulas = true;
    }

    public boolean deleteTemplateSheet() {
        return this.deleteTemplateSheet;
    }

    public void deleteTemplateSheet_$eq(boolean x$1) {
        this.deleteTemplateSheet = x$1;
    }

    public boolean processFormulas() {
        return this.processFormulas;
    }

    public void processFormulas_$eq(boolean x$1) {
        this.processFormulas = x$1;
    }

    public void transform(OutputStream os, Map<String, Object> datas) throws IOException {
        DefaultTransformer transformer = DefaultTransformer$.MODULE$.createTransformer(this.templateStream);
        XlsCommentAreaBuilder areaBuilder = new XlsCommentAreaBuilder(transformer, XlsCommentAreaBuilder$.MODULE$.$lessinit$greater$default$2());
        Context context = new Context(datas);
        Seq<Area> areas = areaBuilder.build();
        transformer.removeAllRowBreaks();
        areas.foreach((Function1 & Serializable)area -> area.applyAt(CellRef$.MODULE$.apply(area.startCellRef().getCellName(false)), context));
        if (this.processFormulas()) {
            areas.foreach((Function1)(JProcedure1 & Serializable)area -> {
                area.formulaProcessor_$eq(new DefaultFormulaProcessor());
                area.processFormulas();
            });
        }
        if (this.deleteTemplateSheet()) {
            this.getSheetsNameOfMultiSheetTemplate((Iterable<Area>)areas).foreach((Function1 & Serializable)_$1 -> Sheets$.MODULE$.remove(transformer.workbook(), (String)_$1));
        }
        transformer.workbook().setForceFormulaRecalculation(true);
        transformer.write(os);
    }

    private Iterable<String> getSheetsNameOfMultiSheetTemplate(Iterable<Area> areas) {
        ArrayBuffer names = new ArrayBuffer();
        areas.foreach((Function1)(JProcedure1 & Serializable)xlsArea -> {
            BooleanRef found = BooleanRef.create((boolean)false);
            xlsArea.findDirectiveByName("each").withFilter((Function1 & Serializable)directive -> !found$1.elem).foreach((Function1)(JProcedure1 & Serializable)directive -> {
                if (Strings$.MODULE$.isNotBlank((CharSequence)((EachDirective)directive).multisheet())) {
                    boolean bl;
                    names.addOne((Object)xlsArea.getAreaRef().sheetName());
                    found$2.elem = bl = true;
                    return;
                }
            });
        });
        return names;
    }
}

