/*
 * Decompiled with CFR 0.152.
 */
package org.beangle.data.excel.template;

import java.io.Serializable;
import java.util.regex.Matcher;
import org.beangle.commons.lang.Strings$;
import org.beangle.data.excel.AreaRef;
import org.beangle.data.excel.AreaRef$;
import org.beangle.data.excel.CellRef;
import org.beangle.data.excel.CellRef$;
import org.beangle.data.excel.template.Area;
import org.beangle.data.excel.template.Area$;
import org.beangle.data.excel.template.CellData;
import org.beangle.data.excel.template.CellData$;
import org.beangle.data.excel.template.DirectiveData;
import org.beangle.data.excel.template.DirectiveData$;
import org.beangle.data.excel.template.FormulaProcessor$;
import org.beangle.data.excel.template.Notation$;
import org.beangle.data.excel.template.Transformer;
import org.beangle.data.excel.template.XlsCommentAreaBuilder$;
import org.beangle.data.excel.template.directive.AreaDirective;
import org.beangle.data.excel.template.directive.Directive;
import org.beangle.data.excel.template.directive.DirectiveFactory$;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.Predef$;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArraySeq;
import scala.collection.mutable.ArraySeq$;
import scala.package$;
import scala.runtime.BooleanRef;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;
import scala.runtime.java8.JFunction1;

public class XlsCommentAreaBuilder {
    private final Transformer transformer;
    private final boolean clearTemplateCells;
    private final Logger logger;

    public static boolean $lessinit$greater$default$2() {
        return XlsCommentAreaBuilder$.MODULE$.$lessinit$greater$default$2();
    }

    public XlsCommentAreaBuilder(Transformer transformer, boolean clearTemplateCells) {
        this.transformer = transformer;
        this.clearTemplateCells = clearTemplateCells;
        this.logger = LoggerFactory.getLogger(XlsCommentAreaBuilder.class);
    }

    public Transformer transformer() {
        return this.transformer;
    }

    public boolean clearTemplateCells() {
        return this.clearTemplateCells;
    }

    public Seq<Area> build() {
        ArrayBuffer userAreas = new ArrayBuffer();
        Seq<CellData> commentedCells = this.transformer().getCommentedCells();
        ArrayBuffer allDirectives = new ArrayBuffer();
        ArrayBuffer allAreas = new ArrayBuffer();
        commentedCells.foreach((Function1)(JProcedure1 & Serializable)cellData -> {
            String comment = cellData.cellComment();
            Iterable<DirectiveData> directiveDatas = this.buildDirectiveDatas((CellData)cellData, comment);
            directiveDatas.foreach((Function1 & Serializable)data -> {
                Directive directive = data.directive();
                if (directive instanceof AreaDirective) {
                    Area userArea = Area$.MODULE$.apply(data.areaRef(), this.transformer());
                    allAreas.addOne((Object)userArea);
                    return userAreas.addOne((Object)userArea);
                }
                allAreas.addAll(data.directive().areas());
                return allDirectives.addOne(data);
            });
        });
        allDirectives.indices().foreach((Function1)(JFunction1.mcVI.sp & Serializable)i -> {
            DirectiveData data = (DirectiveData)allDirectives.apply(i);
            AreaRef cmdAreaRef = data.areaRef();
            List<Area> cmdAreas = data.directive().areas();
            ObjectRef minArea = ObjectRef.create(null);
            ArrayBuffer minAreas = new ArrayBuffer();
            allAreas.foreach((Function1)(JProcedure1 & Serializable)area -> {
                if (!cmdAreas.contains(area) && area.getAreaRef().contains(cmdAreaRef)) {
                    BooleanRef belongsToNextCmd = BooleanRef.create((boolean)false);
                    RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(i + 1), allDirectives.size()).withFilter((Function1)(JFunction1.mcZI.sp & Serializable)j -> !belongsToNextCmd$1.elem).foreach((Function1)(JFunction1.mcVI.sp & Serializable)j -> {
                        DirectiveData nextCmd = (DirectiveData)allDirectives.apply(j);
                        if (nextCmd.directive().areas().contains(area)) {
                            boolean bl;
                            belongsToNextCmd$2.elem = bl = true;
                            return;
                        }
                    });
                    if (!belongsToNextCmd.elem && ((Area)minArea$1.elem == null || ((Area)minArea$1.elem).getAreaRef().contains(area.getAreaRef()))) {
                        if ((Area)minArea$1.elem != null) {
                            Area area2 = (Area)minArea$1.elem;
                            Area area3 = area;
                            if (!(area2 != null ? !area2.equals(area3) : area3 != null)) {
                                minAreas.addOne(area);
                                return;
                            }
                        }
                        Area area4 = area;
                        minArea$1.elem = area4;
                        area4 = null;
                        minAreas.clear();
                        minAreas.addOne((Object)((Area)minArea$1.elem));
                        return;
                    }
                    return;
                }
            });
            minAreas.foreach((Function1)(JProcedure1 & Serializable)_$1 -> _$1.addDirective(data.areaRef(), data.directive()));
        });
        if (this.clearTemplateCells()) {
            userAreas.foreach((Function1)(JProcedure1 & Serializable)_$2 -> _$2.clearCells());
        }
        return userAreas;
    }

    private Iterable<DirectiveData> buildDirectiveDatas(CellData cellData, String text) {
        ArrayBuffer directiveDatas = new ArrayBuffer();
        ArraySeq commentLines = ArraySeq$.MODULE$.make((Object)text.split("\\n"));
        commentLines.foreach((Function1)(JProcedure1 & Serializable)commentLine -> {
            String line = commentLine.trim();
            if (Notation$.MODULE$.isDirectiveString(line)) {
                int nameEndIndex = line.indexOf(Notation$.MODULE$.ATTR_PREFIX(), Notation$.MODULE$.DirectivePrefox().length());
                if (nameEndIndex < 0) {
                    String errMsg = "Failed to parse directive line [" + line + "]. Expected '" + Notation$.MODULE$.ATTR_PREFIX() + "' symbol.";
                    throw new IllegalStateException(errMsg);
                }
                String directiveName = line.substring(Notation$.MODULE$.DirectivePrefox().length(), nameEndIndex).trim();
                Map<String, String> attrMap = this.buildAttrMap(line, nameEndIndex);
                String lastCellRef = (String)attrMap.get((Object)Notation$.MODULE$.LAST_CELL_ATTR_NAME()).orNull((.less.colon.less)$less$colon$less$.MODULE$.refl());
                if (lastCellRef == null) {
                    this.logger.warn("Failed to find last cell ref attribute '" + Notation$.MODULE$.LAST_CELL_ATTR_NAME() + "' for directive '" + directiveName + "' in cell " + cellData.cellRef());
                    return;
                }
                CellRef lastCell = CellRef$.MODULE$.apply(lastCellRef);
                if (Strings$.MODULE$.isBlank((CharSequence)lastCell.sheetName())) {
                    lastCell.sheetName_$eq(cellData.sheetName());
                }
                Iterable cmdAreas = this.buildAreas(cellData, line);
                AreaRef locationAreaRef = new AreaRef(cellData.cellRef(), lastCell);
                if (cmdAreas.isEmpty()) {
                    cmdAreas = (Iterable)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Area[]{Area$.MODULE$.apply(locationAreaRef, this.transformer())}));
                }
                DirectiveFactory$.MODULE$.newDirective(directiveName, attrMap, cmdAreas).foreach((Function1 & Serializable)d -> directiveDatas.addOne((Object)DirectiveData$.MODULE$.apply(locationAreaRef, (Directive)d)));
                return;
            }
        });
        return directiveDatas;
    }

    private Iterable<Area> buildAreas(CellData cellData, String cmdLine) {
        ArrayBuffer areas = new ArrayBuffer();
        Matcher areasAttrMatcher = Notation$.MODULE$.AREAS_ATTR_REGEX_PATTERN().matcher(cmdLine);
        if (areasAttrMatcher.find()) {
            String areasAttr = areasAttrMatcher.group();
            Iterable<AreaRef> areaRefs = this.extractAreaRefs(cellData, areasAttr);
            areas.$plus$plus$eq((IterableOnce)areaRefs.map((Function1 & Serializable)_$3 -> Area$.MODULE$.apply((AreaRef)_$3, this.transformer())));
        }
        return areas;
    }

    private Iterable<AreaRef> extractAreaRefs(CellData cellData, String areasAttr) {
        ArrayBuffer areaRefs = new ArrayBuffer();
        Matcher areaRefMatcher = FormulaProcessor$.MODULE$.regexAreaRefPattern().matcher(areasAttr);
        while (areaRefMatcher.find()) {
            String areaRefName = areaRefMatcher.group();
            AreaRef areaRef = AreaRef$.MODULE$.apply(areaRefName);
            if (Strings$.MODULE$.isBlank((CharSequence)areaRef.sheetName())) {
                areaRef.firstCellRef().sheetName_$eq(cellData.sheetName());
            }
            areaRefs.addOne((Object)areaRef);
        }
        return areaRefs;
    }

    private Map<String, String> buildAttrMap(String cmdLine, int nameEndIndex) {
        int paramsEndIndex = cmdLine.lastIndexOf(Notation$.MODULE$.ATTR_SUFFIX());
        if (paramsEndIndex < 0) {
            String errMsg = "Failed to parse directive line [" + cmdLine + "]. Expected '" + Notation$.MODULE$.ATTR_SUFFIX() + "' symbol.";
            this.logger.error(errMsg);
            throw new IllegalArgumentException(errMsg);
        }
        String attrString = cmdLine.substring(nameEndIndex + 1, paramsEndIndex).trim();
        return CellData$.MODULE$.parseDirectiveAttributes(attrString);
    }
}

