/*
 * Decompiled with CFR 0.152.
 */
package org.beangle.data.excel.template.directive;

import java.io.Serializable;
import java.util.Collection;
import org.apache.poi.ss.usermodel.Sheet;
import org.beangle.commons.bean.Properties$;
import org.beangle.commons.bean.orderings.MultiPropertyOrdering;
import org.beangle.commons.bean.orderings.PropertyOrdering;
import org.beangle.commons.script.ExpressionEvaluator;
import org.beangle.data.excel.CellRef;
import org.beangle.data.excel.Size;
import org.beangle.data.excel.template.Area;
import org.beangle.data.excel.template.CellRefGenerator;
import org.beangle.data.excel.template.Context;
import org.beangle.data.excel.template.MultiSheetCellRefGenerator;
import org.beangle.data.excel.template.directive.AbstractDirective;
import org.beangle.data.excel.template.directive.EachDirective$;
import org.beangle.data.excel.template.directive.EachDirective$Direction$;
import org.beangle.data.excel.template.directive.EachDirective$GroupData$;
import org.slf4j.Logger;
import scala.Function1;
import scala.Predef$;
import scala.Product;
import scala.collection.Iterable;
import scala.collection.IterableOnceOps;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.mutable.ArraySeq$;
import scala.jdk.javaapi.CollectionConverters$;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.Enum;
import scala.runtime.BooleanRef;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;

public class EachDirective
extends AbstractDirective {
    private String var;
    private String items;
    private Area area;
    private Direction direction;
    private final String GROUP_DATA_KEY;
    private String select;
    private String groupBy;
    private String groupOrder;
    private String orderBy;
    private String multisheet;
    private boolean pageable;

    public static Logger logger() {
        return EachDirective$.MODULE$.logger();
    }

    public static Direction $lessinit$greater$default$4() {
        return EachDirective$.MODULE$.$lessinit$greater$default$4();
    }

    public EachDirective(String var, String items, Area area, Direction direction) {
        this.var = var;
        this.items = items;
        this.area = area;
        this.direction = direction;
        this.GROUP_DATA_KEY = "_group";
        this.select = null;
        this.groupBy = null;
        this.groupOrder = null;
        this.orderBy = null;
        this.multisheet = null;
        this.pageable = false;
        this.addArea(this.area());
    }

    public String var() {
        return this.var;
    }

    public void var_$eq(String x$1) {
        this.var = x$1;
    }

    public String items() {
        return this.items;
    }

    public void items_$eq(String x$1) {
        this.items = x$1;
    }

    public Area area() {
        return this.area;
    }

    public void area_$eq(Area x$1) {
        this.area = x$1;
    }

    public Direction direction() {
        return this.direction;
    }

    public void direction_$eq(Direction x$1) {
        this.direction = x$1;
    }

    public String select() {
        return this.select;
    }

    public void select_$eq(String x$1) {
        this.select = x$1;
    }

    public String groupBy() {
        return this.groupBy;
    }

    public void groupBy_$eq(String x$1) {
        this.groupBy = x$1;
    }

    public String groupOrder() {
        return this.groupOrder;
    }

    public void groupOrder_$eq(String x$1) {
        this.groupOrder = x$1;
    }

    public String orderBy() {
        return this.orderBy;
    }

    public void orderBy_$eq(String x$1) {
        this.orderBy = x$1;
    }

    public String multisheet() {
        return this.multisheet;
    }

    public void multisheet_$eq(String x$1) {
        this.multisheet = x$1;
    }

    public boolean pageable() {
        return this.pageable;
    }

    public void pageable_$eq(boolean x$1) {
        this.pageable = x$1;
    }

    @Override
    public Size applyAt(CellRef cellRef, Context context) {
        List itemsCollection = null;
        try {
            itemsCollection = this.transformToIterableObject(context.evaluator(), this.items(), context);
            itemsCollection = this.orderCollection((Iterable<?>)itemsCollection);
        }
        catch (Exception e) {
            EachDirective$.MODULE$.logger().warn("Failed to evaluate collection expression {}", (Object)this.items(), (Object)e);
            itemsCollection = package$.MODULE$.List().empty();
        }
        Size size = null;
        if (this.groupBy() == null || this.groupBy().length() == 0) {
            size = this.processCollection(context, (Iterable<?>)itemsCollection, cellRef, this.var());
        } else {
            Iterable<GroupData> groupedData = this.group((Iterable<Object>)itemsCollection, this.groupBy(), this.groupOrder());
            String groupVar = this.var() != null ? this.var() : this.GROUP_DATA_KEY;
            size = this.processCollection(context, groupedData, cellRef, groupVar);
        }
        Direction direction = this.direction();
        Direction direction2 = EachDirective$Direction$.Down;
        if (!(direction != null ? !direction.equals(direction2) : direction2 != null)) {
            this.area().transformer().adjustTableSize(cellRef, size);
        }
        return size;
    }

    private Iterable<?> orderCollection(Iterable<?> itemsCollection) {
        if (this.orderBy() != null && !this.orderBy().trim().isEmpty()) {
            MultiPropertyOrdering comp = this.orderBy().contains(",") ? new MultiPropertyOrdering(this.orderBy()) : new PropertyOrdering(this.orderBy());
            return (Iterable)itemsCollection.toBuffer().sorted((Ordering)comp);
        }
        return itemsCollection;
    }

    private Iterable<GroupData> group(Iterable<Object> cl, String groupProperty, String groupOrder) {
        if (cl == null) {
            return (Iterable)package$.MODULE$.Seq().empty();
        }
        Map grouped = cl.groupBy((Function1 & Serializable)x -> Properties$.MODULE$.get(x, groupProperty));
        return (Iterable)grouped.map((Function1 & Serializable)g -> EachDirective$GroupData$.MODULE$.apply(g._1(), (Iterable)((IterableOnceOps)g._2()).toBuffer().sorted((Ordering)new PropertyOrdering(groupOrder))));
    }

    private Iterable<?> transformToIterableObject(ExpressionEvaluator evaluator, String collectionName, Context context) {
        Object collectionObject = evaluator.eval(collectionName, context.toMap());
        Object object = collectionObject;
        if (object == null) {
            return package$.MODULE$.List().empty();
        }
        if (object instanceof Object[]) {
            Object[] a = (Object[])object;
            return (Iterable)ArraySeq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Object[][]{a}), (Object)ClassTag$.MODULE$.Any().wrap());
        }
        if (object instanceof Collection) {
            Collection c = (Collection)object;
            return CollectionConverters$.MODULE$.asScala(c);
        }
        if (object instanceof Iterable) {
            Iterable i = (Iterable)object;
            return i;
        }
        throw new RuntimeException(collectionName + " expression is not a collection or an array");
    }

    private Size processCollection(Context context, Iterable<?> itemsCollection, CellRef cellRef, String varName) {
        IntRef newWidth = IntRef.create((int)0);
        IntRef newHeight = IntRef.create((int)0);
        ObjectRef cellRefGenerator = ObjectRef.create(null);
        if (this.multisheet() != null) {
            Seq<String> sheetNameList = this.extractSheetNameList(context);
            MultiSheetCellRefGenerator multiSheetCellRefGenerator = new MultiSheetCellRefGenerator(sheetNameList, cellRef);
            cellRefGenerator.elem = multiSheetCellRefGenerator;
            multiSheetCellRefGenerator = null;
        }
        ObjectRef currentCell = ObjectRef.create((Object)cellRef);
        String varIndex = varName + "_idx";
        Object currentVarObject = context.getVar(varName);
        Object currentVarIndexObject = context.getVar(varIndex);
        IntRef currentIndex = IntRef.create((int)0);
        BooleanRef breaked = BooleanRef.create((boolean)false);
        IntRef index = IntRef.create((int)0);
        itemsCollection.withFilter((Function1 & Serializable)obj -> !breaked$1.elem).foreach((Function1)(JProcedure1 & Serializable)obj -> {
            int n;
            context.putVar(varName, obj);
            context.putVar(varIndex, BoxesRunTime.boxToInteger((int)currentIndex$1.elem));
            if (this.select() != null && !context.isTrue(this.select())) {
                context.removeVar(varName);
                return;
            }
            if ((CellRefGenerator)cellRefGenerator$1.elem != null) {
                int n2;
                index$1.elem = n2 = index$1.elem + 1;
                CellRef cellRef = ((CellRefGenerator)cellRefGenerator$1.elem).generateCellRef(index$1.elem - 1, context);
                currentCell$1.elem = cellRef;
                cellRef = null;
            }
            if ((CellRef)currentCell$1.elem == null) {
                boolean bl;
                breaked$2.elem = bl = true;
                return;
            }
            Size size = null;
            try {
                size = this.area().applyAt((CellRef)currentCell$1.elem, context);
            }
            catch (NegativeArraySizeException e) {
                throw new RuntimeException("Check jx:each/lastCell parameter in template! Illegal area: " + this.area().getAreaRef(), e);
            }
            if ((CellRefGenerator)cellRefGenerator$1.elem == null) {
                Direction direction = this.direction();
                Direction direction2 = EachDirective$Direction$.Down;
                if (!(direction != null ? !direction.equals(direction2) : direction2 != null)) {
                    int n3;
                    int n4;
                    CellRef cellRef = new CellRef(((CellRef)currentCell$1.elem).sheetName(), ((CellRef)currentCell$1.elem).row() + size.height(), ((CellRef)currentCell$1.elem).col());
                    currentCell$1.elem = cellRef;
                    cellRef = null;
                    newWidth$1.elem = n4 = Math.max(newWidth$1.elem, size.width());
                    newHeight$1.elem = n3 = newHeight$1.elem + size.height();
                } else {
                    int n5;
                    int n6;
                    CellRef cellRef = new CellRef(((CellRef)currentCell$1.elem).sheetName(), ((CellRef)currentCell$1.elem).row(), ((CellRef)currentCell$1.elem).col() + size.width());
                    currentCell$1.elem = cellRef;
                    cellRef = null;
                    newWidth$1.elem = n6 = newWidth$1.elem + size.width();
                    newHeight$1.elem = n5 = Math.max(newHeight$1.elem, size.height());
                }
            } else {
                int n7;
                int n8;
                newWidth$1.elem = n8 = Math.max(newWidth$1.elem, size.width());
                newHeight$1.elem = n7 = Math.max(newHeight$1.elem, size.height());
            }
            currentIndex$1.elem = n = currentIndex$1.elem + 1;
            if (this.pageable() && currentIndex$1.elem < itemsCollection.size()) {
                Sheet sheet = this.area().transformer().workbook().getSheet(((CellRef)currentCell$1.elem).sheetName());
                sheet.setRowBreak(newHeight$1.elem - 1);
                return;
            }
        });
        this.restoreVarObject(context, varIndex, currentVarIndexObject);
        this.restoreVarObject(context, varName, currentVarObject);
        return new Size(newWidth.elem, newHeight.elem);
    }

    private void restoreVarObject(Context context, String varName, Object varObject) {
        if (varName != null) {
            if (varObject == null) {
                context.removeVar(varName);
                return;
            }
            context.putVar(varName, varObject);
            return;
        }
    }

    private Seq<String> extractSheetNameList(Context context) {
        Seq sheetnames = (Seq)context.getVar(this.multisheet());
        Predef$.MODULE$.require(sheetnames != null && sheetnames.nonEmpty(), this::extractSheetNameList$$anonfun$1);
        return sheetnames;
    }

    private final Object extractSheetNameList$$anonfun$1() {
        return "cannot find nonempty " + this.multisheet();
    }

    public static abstract class Direction
    implements Product,
    Enum {
        public static Direction fromOrdinal(int n) {
            return EachDirective$Direction$.MODULE$.fromOrdinal(n);
        }

        public static Direction valueOf(String string) {
            return EachDirective$Direction$.MODULE$.valueOf(string);
        }

        public static Direction[] values() {
            return EachDirective$Direction$.MODULE$.values();
        }
    }

    public static class GroupData
    implements Product,
    Serializable {
        private final Object item;
        private final Iterable items;

        public static GroupData apply(Object object, Iterable<?> iterable) {
            return EachDirective$GroupData$.MODULE$.apply(object, iterable);
        }

        public static GroupData fromProduct(Product product) {
            return EachDirective$GroupData$.MODULE$.fromProduct(product);
        }

        public static GroupData unapply(GroupData groupData) {
            return EachDirective$GroupData$.MODULE$.unapply(groupData);
        }

        public GroupData(Object item, Iterable<?> items) {
            this.item = item;
            this.items = items;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof GroupData)) return false;
            GroupData groupData = (GroupData)object;
            if (!BoxesRunTime.equals((Object)this.item(), (Object)groupData.item())) return false;
            Iterable<?> iterable = this.items();
            Iterable<?> iterable2 = groupData.items();
            if (iterable == null) {
                if (iterable2 != null) {
                    return false;
                }
            } else if (!iterable.equals(iterable2)) return false;
            if (!groupData.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof GroupData;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "GroupData";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            if (1 == n2) {
                return this._2();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "item";
            }
            if (1 == n2) {
                return "items";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public Object item() {
            return this.item;
        }

        public Iterable<?> items() {
            return this.items;
        }

        public GroupData copy(Object item, Iterable<?> items) {
            return new GroupData(item, items);
        }

        public Object copy$default$1() {
            return this.item();
        }

        public Iterable<?> copy$default$2() {
            return this.items();
        }

        public Object _1() {
            return this.item();
        }

        public Iterable<?> _2() {
            return this.items();
        }
    }
}

