/*
 * Decompiled with CFR 0.152.
 */
package org.beangle.data.excel.template.directive;

import java.io.InputStream;
import org.apache.poi.ss.usermodel.Workbook;
import org.beangle.commons.io.IOs$;
import org.beangle.data.excel.AreaRef;
import org.beangle.data.excel.AreaRef$;
import org.beangle.data.excel.CellRef;
import org.beangle.data.excel.ImageType$;
import org.beangle.data.excel.Size;
import org.beangle.data.excel.Workbooks$;
import org.beangle.data.excel.template.Area;
import org.beangle.data.excel.template.Context;
import org.beangle.data.excel.template.directive.AbstractDirective;
import scala.None$;
import scala.Option;

public class ImageDirective
extends AbstractDirective {
    private final String src;
    private final String imageTypeStr;
    private Option scaleX;
    private Option scaleY;

    public ImageDirective(String src, String imageTypeStr, Area area) {
        this.src = src;
        this.imageTypeStr = imageTypeStr;
        this.scaleX = None$.MODULE$;
        this.scaleY = None$.MODULE$;
        super.addArea(area);
    }

    public Option<Object> scaleX() {
        return this.scaleX;
    }

    public void scaleX_$eq(Option<Object> x$1) {
        this.scaleX = x$1;
    }

    public Option<Object> scaleY() {
        return this.scaleY;
    }

    public void scaleY_$eq(Option<Object> x$1) {
        this.scaleY = x$1;
    }

    private boolean needResizePicture() {
        return this.scaleX().nonEmpty() && this.scaleY().nonEmpty();
    }

    public boolean getLockRange() {
        if (this.needResizePicture()) {
            return false;
        }
        return this.lockRange();
    }

    @Override
    public Size applyAt(CellRef cellRef, Context context) {
        byte[] byArray;
        Area area = (Area)this.areas().head();
        Size imageAnchorAreaSize = new Size(area.size().width() + 1, area.size().height() + 1);
        AreaRef imageAnchorArea = AreaRef$.MODULE$.apply(cellRef, imageAnchorAreaSize);
        Object imgObj = context.evaluator().eval(this.src, context.toMap());
        if (imgObj == null) {
            return area.size();
        }
        Object object = imgObj;
        if (object instanceof byte[]) {
            byte[] ba;
            byArray = ba = (byte[])object;
        } else if (object instanceof InputStream) {
            InputStream is = (InputStream)object;
            byArray = IOs$.MODULE$.readBytes(is);
        } else {
            throw new IllegalArgumentException("src value must contain image bytes (byte[])");
        }
        byte[] imgBytes = byArray;
        Workbook wb = area.transformer().workbook();
        Workbooks$.MODULE$.addImage(wb, imageAnchorArea, imgBytes, ImageType$.MODULE$.valueOf(this.imageTypeStr), this.scaleX(), this.scaleY());
        return area.size();
    }
}

