/*
 * Decompiled with CFR 0.152.
 */
package org.beangle.data.excel.template.directive;

import java.io.Serializable;
import org.beangle.data.excel.CellRef;
import org.beangle.data.excel.Size;
import org.beangle.data.excel.template.Area;
import org.beangle.data.excel.template.CellData;
import org.beangle.data.excel.template.Context;
import org.beangle.data.excel.template.directive.AbstractDirective;
import org.beangle.data.excel.template.directive.UpdateCellDirective$;
import org.slf4j.Logger;
import scala.Function1;
import scala.runtime.function.JProcedure1;

public class UpdateCellDirective
extends AbstractDirective {
    private String updater = null;
    private CellDataUpdater cellDataUpdater = null;

    public static Logger logger() {
        return UpdateCellDirective$.MODULE$.logger();
    }

    public UpdateCellDirective(Area area) {
        super.addArea(area);
        if (area.size().height() != 1 && area.size().width() != 1) {
            throw new IllegalArgumentException("You can only add a single cell area to updateCell");
        }
    }

    public String updater() {
        return this.updater;
    }

    public void updater_$eq(String x$1) {
        this.updater = x$1;
    }

    public CellDataUpdater cellDataUpdater() {
        return this.cellDataUpdater;
    }

    public void cellDataUpdater_$eq(CellDataUpdater x$1) {
        this.cellDataUpdater = x$1;
    }

    @Override
    public Size applyAt(CellRef cellRef, Context context) {
        CellDataUpdater cellDataUpdater = this.createCellDataUpdater(context);
        Area area = (Area)this.areas().head();
        if (cellDataUpdater != null) {
            CellRef srcCell = area.startCellRef();
            area.transformer().getCellData(srcCell).foreach((Function1)(JProcedure1 & Serializable)cd -> cellDataUpdater.updateCellData((CellData)cd, cellRef, context));
        }
        return area.applyAt(cellRef, context);
    }

    private CellDataUpdater createCellDataUpdater(Context context) {
        if (this.updater() == null) {
            UpdateCellDirective$.MODULE$.logger().warn("Attribute 'updater' is not set!");
            return null;
        }
        Object updaterInstance = context.getVar(this.updater());
        if (updaterInstance instanceof CellDataUpdater) {
            return (CellDataUpdater)updaterInstance;
        }
        UpdateCellDirective$.MODULE$.logger().warn("CellDataUpdater is null or does not implement CellDataUpdater! Attribute 'updater': {}", (Object)this.updater());
        return null;
    }

    public static interface CellDataUpdater {
        public void updateCellData(CellData var1, CellRef var2, Context var3);
    }
}

