/*
 * Decompiled with CFR 0.152.
 */
package org.beangle.data.jdbc.dialect;

import java.io.Serializable;
import java.util.Map;
import org.beangle.commons.lang.Strings$;
import org.beangle.data.jdbc.dialect.AbstractDialect;
import org.beangle.data.jdbc.dialect.DB2Dialect;
import org.beangle.data.jdbc.dialect.DerbyDialect;
import org.beangle.data.jdbc.dialect.Dialect;
import org.beangle.data.jdbc.dialect.H2Dialect;
import org.beangle.data.jdbc.dialect.HSQL2Dialect;
import org.beangle.data.jdbc.dialect.MySQLDialect;
import org.beangle.data.jdbc.dialect.OracleDialect;
import org.beangle.data.jdbc.dialect.PostgreSQLDialect;
import org.beangle.data.jdbc.dialect.SQLServer2005Dialect;
import org.beangle.data.jdbc.dialect.SQLServer2008Dialect;
import org.beangle.data.jdbc.dialect.SQLServerDialect;
import org.beangle.data.jdbc.vendor.VendorInfo;
import org.beangle.data.jdbc.vendor.Vendors$;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.HashMap;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

public final class Dialects$ {
    public static final Dialects$ MODULE$;
    private final HashMap<VendorInfo, List<Dialect>> registeredDialects;
    private static /* synthetic */ Map $deserializeLambdaCache$;

    static {
        new Dialects$();
    }

    public HashMap<VendorInfo, List<Dialect>> registeredDialects() {
        return this.registeredDialects;
    }

    public Option<Dialect> getDialect(VendorInfo vendor, String version) {
        Option option;
        Object object = new Object();
        try {
            this.registeredDialects().get((Object)vendor).foreach((Function1)(JFunction1 & Serializable & scala.Serializable)dialects -> {
                throw new NonLocalReturnControl(object, (Object)dialects.find((Function1)(JFunction1 & Serializable & scala.Serializable)d -> BoxesRunTime.boxToBoolean((boolean)d.support(version))));
            });
            option = None$.MODULE$;
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                option = (Option)ex.value();
            }
            throw ex;
        }
        return option;
    }

    public void register(VendorInfo product, Seq<Dialect> dialects) {
        this.registeredDialects().put((Object)product, (Object)dialects.toList());
    }

    private void printPad(String name) {
        Predef$.MODULE$.print((Object)Strings$.MODULE$.rightPad(name, 17, ' '));
    }

    public void printTypeMatrix() {
        int[] types = new int[]{16, -7, 1, 4, 5, -6, -5, 6, 8, 3, 2, 91, 92, 93, 12, -1, -2, -3, -4, 2004, 2005};
        String[] typeNames = (String[])((Object[])new String[]{"BOOLEAN", "BIT", "CHAR", "INTEGER", "SMALLINT", "TINYINT", "BIGINT", "FLOAT", "DOUBLE", "DECIMAL", "NUMERIC", "DATE", "TIME", "TIMESTAMP", "VARCHAR", "LONGVARCHAR", "BINARY", "VARBINARY", "LONGVARBINARY", "BLOB", "CLOB"});
        AbstractDialect[] dialects = (AbstractDialect[])((Object[])new AbstractDialect[]{new OracleDialect(), new H2Dialect(), new MySQLDialect(), new PostgreSQLDialect(), new SQLServer2005Dialect(), new DB2Dialect()});
        this.printPad("Type/Dialect");
        new ArrayOps.ofRef(Predef$.MODULE$._refArrayOps((Object[])dialects)).foreach((Function1)(JFunction1 & Serializable & scala.Serializable)dialect -> {
            this.org$beangle$data$jdbc$dialect$Dialects$$$anonfun$3((AbstractDialect)dialect);
            return BoxedUnit.UNIT;
        });
        Predef$.MODULE$.println();
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), types.length).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
            this.printPad(typeNames[i]);
            new ArrayOps.ofRef(Predef$.MODULE$._refArrayOps((Object[])dialects)).foreach((Function1)(JFunction1 & Serializable & scala.Serializable)dialect -> {
                this.org$beangle$data$jdbc$dialect$Dialects$$$anonfun$5(types, i, (AbstractDialect)dialect);
                return BoxedUnit.UNIT;
            });
            Predef$.MODULE$.println((Object)"");
        });
    }

    public final /* synthetic */ void org$beangle$data$jdbc$dialect$Dialects$$$anonfun$3(AbstractDialect dialect) {
        this.printPad(Strings$.MODULE$.replace(dialect.getClass().getSimpleName(), "Dialect", ""));
    }

    public final /* synthetic */ void org$beangle$data$jdbc$dialect$Dialects$$$anonfun$5(int[] types$1, int i$1, AbstractDialect dialect) {
        String string;
        try {
            string = dialect.typeNames().get(types$1[i$1]);
        }
        catch (Exception e) {
            string = "error";
        }
        String typeName = string;
        this.printPad(typeName);
    }

    private Dialects$() {
        MODULE$ = this;
        this.registeredDialects = new HashMap();
        this.register(Vendors$.MODULE$.oracle(), (Seq<Dialect>)Predef$.MODULE$.wrapRefArray((Object[])new Dialect[]{new OracleDialect()}));
        this.register(Vendors$.MODULE$.db2(), (Seq<Dialect>)Predef$.MODULE$.wrapRefArray((Object[])new Dialect[]{new DB2Dialect()}));
        this.register(Vendors$.MODULE$.derby(), (Seq<Dialect>)Predef$.MODULE$.wrapRefArray((Object[])new Dialect[]{new DerbyDialect()}));
        this.register(Vendors$.MODULE$.h2(), (Seq<Dialect>)Predef$.MODULE$.wrapRefArray((Object[])new Dialect[]{new H2Dialect()}));
        this.register(Vendors$.MODULE$.hsql(), (Seq<Dialect>)Predef$.MODULE$.wrapRefArray((Object[])new Dialect[]{new HSQL2Dialect()}));
        this.register(Vendors$.MODULE$.mysql(), (Seq<Dialect>)Predef$.MODULE$.wrapRefArray((Object[])new Dialect[]{new MySQLDialect()}));
        this.register(Vendors$.MODULE$.postgresql(), (Seq<Dialect>)Predef$.MODULE$.wrapRefArray((Object[])new Dialect[]{new PostgreSQLDialect()}));
        this.register(Vendors$.MODULE$.sqlserver(), (Seq<Dialect>)Predef$.MODULE$.wrapRefArray((Object[])new Dialect[]{new SQLServer2008Dialect(), new SQLServer2005Dialect(), new SQLServerDialect()}));
    }
}

