/*
 * Decompiled with CFR 0.152.
 */
package org.beangle.data.jdbc.script;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URL;
import javax.sql.DataSource;
import org.beangle.commons.io.Files$;
import org.beangle.commons.lang.Consoles$;
import org.beangle.commons.lang.Numbers$;
import org.beangle.commons.lang.Strings$;
import org.beangle.commons.lang.SystemInfo$;
import org.beangle.commons.logging.Logger;
import org.beangle.commons.logging.Logging;
import org.beangle.data.jdbc.ds.DataSourceUtils$;
import org.beangle.data.jdbc.ds.DatasourceConfig;
import org.beangle.data.jdbc.ds.DatasourceConfig$;
import org.beangle.data.jdbc.script.OracleParser$;
import org.beangle.data.jdbc.script.Runner;
import org.beangle.data.jdbc.vendor.UrlFormat;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.StringContext;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.StringBuilder;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.xml.Node;
import scala.xml.XML$;

public final class Sql$
implements Logging {
    public static final Sql$ MODULE$;
    private DatasourceConfig datasource;
    private ListBuffer<DatasourceConfig> datasources;
    private String workdir;
    private String sqlDir;
    private final Logger logger;
    private static /* synthetic */ java.util.Map $deserializeLambdaCache$;

    static {
        new Sql$();
    }

    public Logger logger() {
        return this.logger;
    }

    public void org$beangle$commons$logging$Logging$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    public DatasourceConfig datasource() {
        return this.datasource;
    }

    public void datasource_$eq(DatasourceConfig x$1) {
        this.datasource = x$1;
    }

    public ListBuffer<DatasourceConfig> datasources() {
        return this.datasources;
    }

    public void datasources_$eq(ListBuffer<DatasourceConfig> x$1) {
        this.datasources = x$1;
    }

    public String workdir() {
        return this.workdir;
    }

    public void workdir_$eq(String x$1) {
        this.workdir = x$1;
    }

    public String sqlDir() {
        return this.sqlDir;
    }

    public void sqlDir_$eq(String x$1) {
        this.sqlDir = x$1;
    }

    public void main(String[] args) {
        this.workdir_$eq(args.length == 0 ? SystemInfo$.MODULE$.user().dir() : args[0]);
        this.read();
        this.sqlDir_$eq(new StringBuilder().append((Object)this.workdir()).append((Object)Files$.MODULE$.$div()).append((Object)"sql").append((Object)Files$.MODULE$.$div()).toString());
        if (new ArrayOps.ofRef(Predef$.MODULE$._refArrayOps((Object[])this.sqlFiles())).isEmpty()) {
            Predef$.MODULE$.println((Object)new StringBuilder().append((Object)"Cannot find sql files in ").append((Object)this.sqlDir()).toString());
            return;
        }
        if (this.datasources().isEmpty()) {
            this.logger().info((Function0)(JFunction0 & Serializable & scala.Serializable)() -> "Cannot find datasource");
            return;
        }
        if (this.datasources().size() == 1) {
            this.datasource_$eq((DatasourceConfig)this.datasources().head());
        }
        Predef$.MODULE$.println((Object)"Sql executor:help ls exec exit(quit/q)");
        Consoles$.MODULE$.shell((Function0)(JFunction0 & Serializable & scala.Serializable)() -> {
            String prefix = this.datasource() != null ? this.datasource().name() : "sql";
            return new StringBuilder().append((Object)prefix).append((Object)" >").toString();
        }, (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"exit", "quit", "q"})), (Function1)(JFunction1 & Serializable & scala.Serializable)command -> {
            this.org$beangle$data$jdbc$script$Sql$$$anonfun$3((String)command);
            return BoxedUnit.UNIT;
        });
    }

    public String[] sqlFiles() {
        String[] stringArray;
        File file = new File(this.sqlDir());
        if (file.exists()) {
            String[] files = (String[])new ArrayOps.ofRef(Predef$.MODULE$._refArrayOps((Object[])file.list())).withFilter((Function1)(JFunction1 & Serializable & scala.Serializable)f -> BoxesRunTime.boxToBoolean((boolean)f.endsWith(".sql"))).map((Function1)(JFunction1 & Serializable & scala.Serializable)f -> f, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)));
            stringArray = (String[])new ArrayOps.ofRef(Predef$.MODULE$._refArrayOps((Object[])files)).sorted((Ordering)Ordering.String$.MODULE$);
        } else {
            stringArray = (String[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(String.class));
        }
        return stringArray;
    }

    public void exec(String file) {
        if (Strings$.MODULE$.isBlank((CharSequence)file)) {
            Predef$.MODULE$.println((Object)"Usage exec all or exec file1 file2");
        } else {
            String fileName = file;
            String string = file;
            String string2 = "all";
            if (!(string == null ? string2 != null : !string.equals(string2))) {
                fileName = new ArrayOps.ofRef(Predef$.MODULE$._refArrayOps((Object[])this.sqlFiles())).mkString(" ");
            }
            ListBuffer urls = new ListBuffer();
            new ArrayOps.ofRef(Predef$.MODULE$._refArrayOps((Object[])Strings$.MODULE$.split(fileName, " "))).foreach((Function1)(JFunction1 & Serializable & scala.Serializable)name -> {
                ListBuffer listBuffer;
                File f = new File(new StringBuilder().append((Object)this.sqlDir()).append((Object)(name.endsWith(".sql") ? name : new StringBuilder().append(name).append((Object)".sql").toString())).toString());
                if (f.exists()) {
                    listBuffer = urls.$plus$eq((Object)f.toURI().toURL());
                } else {
                    Predef$.MODULE$.println((Object)new StringBuilder().append((Object)"file ").append((Object)f.getAbsolutePath()).append((Object)" doesn't exists").toString());
                    listBuffer = BoxedUnit.UNIT;
                }
                return listBuffer;
            });
            Runner runner = new Runner(OracleParser$.MODULE$, (Seq<URL>)urls);
            if (this.datasource() == null) {
                this.use(-1);
            }
            if (this.datasource() == null || urls.isEmpty()) {
                Predef$.MODULE$.println((Object)"Execute sql aborted.");
            } else {
                this.config(this.datasource());
                if (this.datasource().password() == null) {
                    this.datasource().password_$eq(Consoles$.MODULE$.readPassword("enter datasource [%1$s] %2$s password:", (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.datasource().name(), this.datasource().user()})));
                }
                DataSource ds = DataSourceUtils$.MODULE$.build(this.datasource().driver(), this.datasource().user(), this.datasource().password(), (Map<String, String>)this.datasource().props());
                runner.execute(ds, true);
            }
        }
    }

    public String exec$default$1() {
        return null;
    }

    public void printHelp() {
        Predef$.MODULE$.println((Object)"Avaliable command:\n  ls                        print datasource and sql file\n  exec [sqlfile1,sqlfile2]  execute simple file\n  exec all                  execute all sql file\n  help              print this help conent");
    }

    public void use(int index) {
        if (this.datasources().isEmpty()) {
            Predef$.MODULE$.println((Object)"datasource is empty");
        } else if (index > -1) {
            this.datasource_$eq((DatasourceConfig)this.datasources().apply(index));
        } else {
            String selectName = Consoles$.MODULE$.prompt("choose datasource index?", null, (Function1)(JFunction1 & Serializable & scala.Serializable)name -> BoxesRunTime.boxToBoolean((boolean)this.org$beangle$data$jdbc$script$Sql$$$anonfun$7((String)name)));
            this.datasource_$eq((DatasourceConfig)this.datasources().apply(Numbers$.MODULE$.toInt(selectName, Numbers$.MODULE$.toInt$default$2())));
        }
    }

    public int use$default$1() {
        return 0;
    }

    public void info() {
        ListBuffer infos = new ListBuffer();
        IntRef index = IntRef.create((int)0);
        this.datasources().foreach((Function1)(JFunction1 & Serializable & scala.Serializable)ds -> {
            this.org$beangle$data$jdbc$script$Sql$$$anonfun$8(infos, index, (DatasourceConfig)ds);
            return BoxedUnit.UNIT;
        });
        Predef$.MODULE$.println((Object)new StringBuilder().append((Object)"Data sources:\n").append((Object)new StringOps(Predef$.MODULE$.augmentString("-")).$times(50)).toString());
        Predef$.MODULE$.println((Object)infos.mkString("\n"));
        Predef$.MODULE$.println();
        Predef$.MODULE$.println((Object)new StringBuilder().append((Object)"Sql files:\n").append((Object)new StringOps(Predef$.MODULE$.augmentString("-")).$times(50)).toString());
        Predef$.MODULE$.println((Object)new ArrayOps.ofRef(Predef$.MODULE$._refArrayOps((Object[])this.sqlFiles())).mkString(" "));
    }

    private void config(DatasourceConfig resource) {
        block2: {
            String url;
            block3: {
                BoxedUnit boxedUnit;
                url = (String)resource.props().get((Object)"url").orNull(Predef$.MODULE$.$conforms());
                if (url != null) break block2;
                UrlFormat format = new UrlFormat(url);
                if (!format.params().isEmpty()) {
                    List<String> params = format.params();
                    HashMap values = new HashMap();
                    params.foreach((Function1)(JFunction1 & Serializable & scala.Serializable)param -> values.put(param, (Object)Consoles$.MODULE$.prompt(new StringBuilder().append((Object)"enter ").append(param).append((Object)":").toString(), Consoles$.MODULE$.prompt$default$2())));
                    url = format.fill((scala.collection.immutable.Map<String, String>)values.toMap(Predef$.MODULE$.$conforms()));
                    boxedUnit = resource.props().put((Object)"url", (Object)url);
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                if (resource.user() == null) break block3;
                String string = resource.user();
                String string2 = "<username>";
                if (string == null ? string2 != null : !string.equals(string2)) break block2;
            }
            resource.user_$eq(Consoles$.MODULE$.prompt(new StringBuilder().append((Object)"enter datasource ").append((Object)url).append((Object)" username:").toString(), Consoles$.MODULE$.prompt$default$2()));
        }
    }

    private void read() {
        block0: {
            Predef$.MODULE$.assert(this.workdir() != null);
            File target = new File(new StringBuilder().append((Object)this.workdir()).append((Object)Files$.MODULE$.$div()).append((Object)"datasources.xml").toString());
            if (!target.exists()) break block0;
            this.logger().info((Function0)(JFunction0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Read config file ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{target.getName()})));
            XML$.MODULE$.load((InputStream)new FileInputStream(target)).$bslash$bslash("datasource").foreach((Function1)(JFunction1 & Serializable & scala.Serializable)elem -> this.datasources().$plus$eq((Object)DatasourceConfig$.MODULE$.build((Node)elem)));
        }
    }

    public final /* synthetic */ void org$beangle$data$jdbc$script$Sql$$$anonfun$3(String command) {
        String string = command;
        if ("ls".equals(string)) {
            this.info();
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if ("help".equals(string)) {
            this.printHelp();
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            BoxedUnit boxedUnit;
            if (string.startsWith("use")) {
                this.use(Numbers$.MODULE$.toInt(Strings$.MODULE$.trim(Strings$.MODULE$.substringAfter(string, "use")), 0));
                boxedUnit = BoxedUnit.UNIT;
            } else if (string.startsWith("exec")) {
                this.exec(Strings$.MODULE$.trim(Strings$.MODULE$.substringAfter(string, "exec")));
                boxedUnit = BoxedUnit.UNIT;
            } else if (Strings$.MODULE$.isNotEmpty((CharSequence)string)) {
                Predef$.MODULE$.println((Object)new StringBuilder().append((Object)string).append((Object)": command not found...").toString());
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit2 = boxedUnit;
        }
    }

    public final /* synthetic */ boolean org$beangle$data$jdbc$script$Sql$$$anonfun$7(String name) {
        Integer result = Numbers$.MODULE$.convert2Int(name, null);
        return result != null && Predef$.MODULE$.Integer2int(result) > -1 && Predef$.MODULE$.Integer2int(result) < this.datasources().size();
    }

    public final /* synthetic */ void org$beangle$data$jdbc$script$Sql$$$anonfun$8(ListBuffer infos$1, IntRef index$1, DatasourceConfig ds) {
        DatasourceConfig datasourceConfig = ds;
        DatasourceConfig datasourceConfig2 = this.datasource();
        String prefix = !(datasourceConfig == null ? datasourceConfig2 != null : !datasourceConfig.equals(datasourceConfig2)) ? "[*] " : new StringBuilder().append((Object)"[").append((Object)BoxesRunTime.boxToInteger((int)index$1.elem)).append((Object)"] ").toString();
        infos$1.$plus$eq((Object)new StringBuilder().append((Object)prefix).append((Object)ds.name()).toString());
        ++index$1.elem;
    }

    private Sql$() {
        MODULE$ = this;
        Logging.class.$init$((Logging)this);
        this.datasources = new ListBuffer();
    }
}

