/*
 * Decompiled with CFR 0.152.
 */
package org.beangle.data.jdbc.ds;

import org.beangle.commons.lang.ClassLoaders$;
import org.beangle.commons.lang.Strings$;
import org.beangle.data.jdbc.dialect.Dialect;
import org.beangle.data.jdbc.ds.DatasourceConfig;
import org.beangle.data.jdbc.vendor.DriverInfo;
import org.beangle.data.jdbc.vendor.Vendors$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.collection.Seq;
import scala.collection.immutable.Set;
import scala.runtime.BoxedUnit;
import scala.xml.Node;

public final class DatasourceConfig$ {
    public static final DatasourceConfig$ MODULE$;

    static {
        new DatasourceConfig$();
    }

    public DatasourceConfig build(Node xml) {
        DriverInfo d;
        Option option;
        DriverInfo driver = null;
        String url = xml.$bslash$bslash("url").text().trim();
        String driverName = xml.$bslash$bslash("driver").text().trim();
        if (Strings$.MODULE$.isEmpty((CharSequence)driverName) && Strings$.MODULE$.isNotEmpty((CharSequence)url)) {
            driverName = Strings$.MODULE$.substringBetween(url, "jdbc:", ":");
        }
        if (!((option = Vendors$.MODULE$.drivers().get((Object)driverName)) instanceof Some)) {
            if (None$.MODULE$.equals(option)) {
                throw new RuntimeException("Not Supported:[" + driverName + "] supports:" + Vendors$.MODULE$.driverPrefixes());
            }
            throw new MatchError((Object)option);
        }
        Some some = (Some)option;
        driver = d = (DriverInfo)some.x();
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
        Dialect dialect = xml.$bslash("@dialect").isEmpty() ? driver.vendor().dialect() : (Dialect)ClassLoaders$.MODULE$.load(xml.$bslash$bslash("dialect").text().trim(), ClassLoaders$.MODULE$.load$default$2()).newInstance();
        DatasourceConfig dbconf = new DatasourceConfig(driverName, dialect);
        Object object = Strings$.MODULE$.isNotEmpty((CharSequence)url) ? dbconf.props().put((Object)"url", (Object)url) : BoxedUnit.UNIT;
        if (!xml.$bslash("@name").isEmpty()) {
            dbconf.name_$eq(xml.$bslash("@name").text().trim());
        }
        dbconf.user_$eq(xml.$bslash$bslash("user").text().trim());
        dbconf.password_$eq(xml.$bslash$bslash("password").text().trim());
        dbconf.catalog_$eq(dialect.parse(xml.$bslash$bslash("catalog").text().trim()));
        String schemaName = xml.$bslash$bslash("schema").text().trim();
        if (Strings$.MODULE$.isEmpty((CharSequence)schemaName)) {
            String string = schemaName = dialect.defaultSchema();
            String string2 = "$user";
            if (!(string != null ? !string.equals(string2) : string2 != null)) {
                schemaName = dbconf.user();
            }
        }
        dbconf.schema_$eq(dialect.parse(schemaName));
        xml.$bslash$bslash("props").$bslash$bslash("prop").foreach((Function1 & java.io.Serializable & Serializable)ele -> dbconf.props().put((Object)ele.$bslash("@name").text(), (Object)ele.$bslash("@value").text()));
        Set processed = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"url", "driver", "props", "user", "password", "catalog", "schema"}));
        xml.$bslash$bslash("datasource").$bslash("_").foreach((Function1 & java.io.Serializable & Serializable)n -> {
            String label = n.label();
            return !processed.contains((Object)label) && Strings$.MODULE$.isNotEmpty((CharSequence)n.text()) ? dbconf.props().put((Object)label, (Object)n.text()) : BoxedUnit.UNIT;
        });
        return dbconf;
    }

    private void addProperty(DatasourceConfig dbconf, Node xml, Seq<String> attrs) {
        attrs.foreach((Function1 & java.io.Serializable & Serializable)attr -> !xml.$bslash$bslash(attr).isEmpty() ? dbconf.props().put(attr, (Object)xml.$bslash$bslash(attr).text().trim()) : BoxedUnit.UNIT);
    }

    private DatasourceConfig$() {
        MODULE$ = this;
    }
}

