/*
 * Decompiled with CFR 0.152.
 */
package org.beangle.data.jdbc.query;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.io.StringReader;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.sql.BatchUpdateException;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import javax.sql.DataSource;
import org.beangle.commons.io.IOs$;
import org.beangle.commons.lang.Strings$;
import org.beangle.commons.logging.Logger;
import org.beangle.commons.logging.Logging;
import org.beangle.data.jdbc.query.JdbcExecutor$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.ListBuffer;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\u0005ex!B\u0001\u0003\u0011\u0003i\u0011\u0001\u0004&eE\u000e,\u00050Z2vi>\u0014(BA\u0002\u0005\u0003\u0015\tX/\u001a:z\u0015\t)a!\u0001\u0003kI\n\u001c'BA\u0004\t\u0003\u0011!\u0017\r^1\u000b\u0005%Q\u0011a\u00022fC:<G.\u001a\u0006\u0002\u0017\u0005\u0019qN]4\u0004\u0001A\u0011abD\u0007\u0002\u0005\u0019)\u0001C\u0001E\u0001#\ta!\n\u001a2d\u000bb,7-\u001e;peN\u0011qB\u0005\t\u0003'Yi\u0011\u0001\u0006\u0006\u0002+\u0005)1oY1mC&\u0011q\u0003\u0006\u0002\u0007\u0003:L(+\u001a4\t\u000beyA\u0011\u0001\u000e\u0002\rqJg.\u001b;?)\u0005i\u0001\"\u0003\u000f\u0010\u0001\u0004\u0005\r\u0011\"\u0001\u001e\u0003Uy'/Y2mKRKW.Z:uC6\u0004X*\u001a;i_\u0012,\u0012A\b\t\u0003?\u0019j\u0011\u0001\t\u0006\u0003C\t\nqA]3gY\u0016\u001cGO\u0003\u0002$I\u0005!A.\u00198h\u0015\u0005)\u0013\u0001\u00026bm\u0006L!a\n\u0011\u0003\r5+G\u000f[8e\u0011%Is\u00021AA\u0002\u0013\u0005!&A\rpe\u0006\u001cG.\u001a+j[\u0016\u001cH/Y7q\u001b\u0016$\bn\u001c3`I\u0015\fHCA\u0016/!\t\u0019B&\u0003\u0002.)\t!QK\\5u\u0011\u001dy\u0003&!AA\u0002y\t1\u0001\u001f\u00132\u0011\u0019\tt\u0002)Q\u0005=\u00051rN]1dY\u0016$\u0016.\\3ti\u0006l\u0007/T3uQ>$\u0007\u0005C\u00044\u001f\t\u0007I\u0011\u0001\u001b\u0002-=\u0014'.Z2u)f\u0004X\rV8Tc2$\u0016\u0010]3NCB,\u0012!\u000e\t\u0005mu\u0002eK\u0004\u00028wA\u0011\u0001\bF\u0007\u0002s)\u0011!\bD\u0001\u0007yI|w\u000e\u001e \n\u0005q\"\u0012A\u0002)sK\u0012,g-\u0003\u0002?\u007f\t\u0019Q*\u00199\u000b\u0005q\"\u0002GA!G!\r1$\tR\u0005\u0003\u0007~\u0012Qa\u00117bgN\u0004\"!\u0012$\r\u0001\u0011Iq\tSA\u0001\u0002\u0003\u0015\ta\u0014\u0002\u0004?\u0012\n\u0004BB%\u0010A\u0003%!*A\fpE*,7\r\u001e+za\u0016$vnU9m)f\u0004X-T1qAA!a'P&Wa\tae\nE\u00027\u00056\u0003\"!\u0012(\u0005\u0013\u001dC\u0015\u0011!A\u0001\u0006\u0003y\u0015C\u0001)T!\t\u0019\u0012+\u0003\u0002S)\t9aj\u001c;iS:<\u0007CA\nU\u0013\t)FCA\u0002B]f\u0004\"aE,\n\u0005a#\"aA%oi\")!l\u0004C\u00017\u0006a\u0011n]*ue&tw\rV=qKR\u0011Al\u0018\t\u0003'uK!A\u0018\u000b\u0003\u000f\t{w\u000e\\3b]\")\u0001-\u0017a\u0001C\u0006)1\r\\1{uB\u0012!\r\u001a\t\u0004m\t\u001b\u0007CA#e\t%)w,!A\u0001\u0002\u000b\u0005qJA\u0002`IIBQaZ\b\u0005\u0002!\f!\"[:ECR,G+\u001f9f)\ta\u0016\u000eC\u0003aM\u0002\u0007!\u000e\r\u0002l[B\u0019aG\u00117\u0011\u0005\u0015kG!\u00038j\u0003\u0003\u0005\tQ!\u0001P\u0005\ryFe\r\u0005\u0006a>!\t!]\u0001\ni>\u001c\u0016\u000f\u001c+za\u0016$\"A\u0016:\t\u000b\u0001|\u0007\u0019A:1\u0005Q4\bc\u0001\u001cCkB\u0011QI\u001e\u0003\noJ\f\t\u0011!A\u0003\u0002=\u00131a\u0018\u00135\r\u0011\u0001\"\u0001A=\u0014\u0007a\u0014\"\u0010E\u0002|\u0003\u0003i\u0011\u0001 \u0006\u0003{z\fq\u0001\\8hO&twM\u0003\u0002\u0000\u0011\u000591m\\7n_:\u001c\u0018bAA\u0002y\n9Aj\\4hS:<\u0007BCA\u0004q\n\u0005\t\u0015!\u0003\u0002\n\u0005QA-\u0019;b'>,(oY3\u0011\t\u0005-\u0011QC\u0007\u0003\u0003\u001bQA!a\u0004\u0002\u0012\u0005\u00191/\u001d7\u000b\u0005\u0005M\u0011!\u00026bm\u0006D\u0018\u0002BA\f\u0003\u001b\u0011!\u0002R1uCN{WO]2f\u0011\u0019I\u0002\u0010\"\u0001\u0002\u001cQ!\u0011QDA\u0010!\tq\u0001\u0010\u0003\u0005\u0002\b\u0005e\u0001\u0019AA\u0005\u0011%\t\u0019\u0003\u001fa\u0001\n\u0003\t)#\u0001\bq[\u0012\\en\\<o\u0005J|7.\u001a8\u0016\u0003qC\u0011\"!\u000by\u0001\u0004%\t!a\u000b\u0002%AlGm\u00138po:\u0014%o\\6f]~#S-\u001d\u000b\u0004W\u00055\u0002\u0002C\u0018\u0002(\u0005\u0005\t\u0019\u0001/\t\u000f\u0005E\u0002\u0010)Q\u00059\u0006y\u0001/\u001c3L]><hN\u0011:pW\u0016t\u0007\u0005C\u0005\u00026a\u0004\r\u0011\"\u0001\u0002&\u000591\u000f[8x'Fd\u0007\"CA\u001dq\u0002\u0007I\u0011AA\u001e\u0003-\u0019\bn\\<Tc2|F%Z9\u0015\u0007-\ni\u0004\u0003\u00050\u0003o\t\t\u00111\u0001]\u0011\u001d\t\t\u0005\u001fQ!\nq\u000b\u0001b\u001d5poN\u000bH\u000e\t\u0005\b\u0003\u000bBH\u0011AA$\u0003-\tX/\u001a:z\r>\u0014\u0018J\u001c;\u0015\u0007Y\u000bI\u0005\u0003\u0005\u0002\u0010\u0005\r\u0003\u0019AA&!\r1\u0014QJ\u0005\u0004\u0003\u001fz$AB*ue&tw\rC\u0004\u0002Ta$\t!!\u0016\u0002\u0019E,XM]=G_JduN\\4\u0015\t\u0005]\u0013Q\f\t\u0004'\u0005e\u0013bAA.)\t!Aj\u001c8h\u0011!\ty!!\u0015A\u0002\u0005-\u0003bBA1q\u0012\u0005\u00111M\u0001\u000eO\u0016$8i\u001c8oK\u000e$\u0018n\u001c8\u0015\u0005\u0005\u0015\u0004\u0003BA4\u0003Wj!!!\u001b\u000b\u0007\u0005=A%\u0003\u0003\u0002n\u0005%$AC\"p]:,7\r^5p]\"11\u0001\u001fC\u0001\u0003c\"b!a\u001d\u0002\f\u00065\u0005CBA;\u0003\u007f\n)I\u0004\u0003\u0002x\u0005mdb\u0001\u001d\u0002z%\tQ#C\u0002\u0002~Q\tq\u0001]1dW\u0006<W-\u0003\u0003\u0002\u0002\u0006\r%aA*fc*\u0019\u0011Q\u0010\u000b\u0011\tM\t9iU\u0005\u0004\u0003\u0013#\"!B!se\u0006L\b\u0002CA\b\u0003_\u0002\r!a\u0013\t\u0011\u0005=\u0015q\u000ea\u0001\u0003#\u000ba\u0001]1sC6\u001c\b\u0003B\n\u0002\u0014NK1!!&\u0015\u0005)a$/\u001a9fCR,GM\u0010\u0005\b\u00033CH\u0011AAN\u0003\u0019)\b\u000fZ1uKR)a+!(\u0002 \"A\u0011qBAL\u0001\u0004\tY\u0005\u0003\u0005\u0002\u0010\u0006]\u0005\u0019AAI\u0011\u001d\t\u0019\u000b\u001fC\u0001\u0003K\u000bQAY1uG\"$\u0002\"a*\u0002*\u0006-\u00161\u0018\t\u0006\u0003k\nyH\u0016\u0005\t\u0003\u001f\t\t\u000b1\u0001\u0002L!A\u0011QVAQ\u0001\u0004\ty+A\u0003eCR\f7\u000f\u0005\u0004\u0002v\u0005}\u0014\u0011\u0017\u0019\u0005\u0003g\u000b9\fE\u0003\u0014\u0003\u000f\u000b)\fE\u0002F\u0003o#1\"!/\u0002,\u0006\u0005\t\u0011!B\u0001\u001f\n\u0019q\fJ\u001b\t\u0011\u0005u\u0016\u0011\u0015a\u0001\u0003O\u000bQ\u0001^=qKNDq!!1y\t\u0003\t\u0019-A\u0005tKR\u0004\u0016M]1ngR91&!2\u0002P\u0006M\u0007\u0002CAd\u0003\u007f\u0003\r!!3\u0002\tM$X\u000e\u001e\t\u0005\u0003O\nY-\u0003\u0003\u0002N\u0006%$!\u0005)sKB\f'/\u001a3Ti\u0006$X-\\3oi\"A\u0011qRA`\u0001\u0004\t\t\u000eE\u0003\u0002v\u0005}4\u000b\u0003\u0005\u0002>\u0006}\u0006\u0019AAT\u0011\u001d\t9\u000e\u001fC\t\u00033\fqA]3uQJ|w\u000fF\u0004,\u00037\f)/a:\t\u0011\u0005u\u0017Q\u001ba\u0001\u0003?\fQaY1vg\u0016\u0004B!a\u001a\u0002b&!\u00111]A5\u00051\u0019\u0016\u000bT#yG\u0016\u0004H/[8o\u0011!\ty!!6A\u0002\u0005-\u0003\u0002CAH\u0003+\u0004\r!!%\t\u000f\u0005-\b\u0010\"\u0003\u0002n\u0006a1m\u001c8wKJ$Hk\\*fcR!\u00111OAx\u0011!\t\t0!;A\u0002\u0005M\u0018A\u0001:t!\u0011\t9'!>\n\t\u0005]\u0018\u0011\u000e\u0002\n%\u0016\u001cX\u000f\u001c;TKR\u0004")
public class JdbcExecutor
implements Logging {
    private final DataSource dataSource;
    private boolean pmdKnownBroken;
    private boolean showSql;
    private final Logger logger;

    public static int toSqlType(Class<?> clazz) {
        return JdbcExecutor$.MODULE$.toSqlType(clazz);
    }

    public static boolean isDateType(Class<?> clazz) {
        return JdbcExecutor$.MODULE$.isDateType(clazz);
    }

    public static boolean isStringType(Class<?> clazz) {
        return JdbcExecutor$.MODULE$.isStringType(clazz);
    }

    public static Map<Class<?>, Object> objectTypeToSqlTypeMap() {
        return JdbcExecutor$.MODULE$.objectTypeToSqlTypeMap();
    }

    public static void oracleTimestampMethod_$eq(Method method) {
        JdbcExecutor$.MODULE$.oracleTimestampMethod_$eq(method);
    }

    public static Method oracleTimestampMethod() {
        return JdbcExecutor$.MODULE$.oracleTimestampMethod();
    }

    public Logger logger() {
        return this.logger;
    }

    public void org$beangle$commons$logging$Logging$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    public boolean pmdKnownBroken() {
        return this.pmdKnownBroken;
    }

    public void pmdKnownBroken_$eq(boolean x$1) {
        this.pmdKnownBroken = x$1;
    }

    public boolean showSql() {
        return this.showSql;
    }

    public void showSql_$eq(boolean x$1) {
        this.showSql = x$1;
    }

    public int queryForInt(String sql) {
        return ((Number)Predef$.MODULE$.genericArrayOps(this.query(sql, (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[0])).head()).head()).intValue();
    }

    public long queryForLong(String sql) {
        return ((Number)Predef$.MODULE$.genericArrayOps(this.query(sql, (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[0])).head()).head()).longValue();
    }

    public Connection getConnection() {
        return this.dataSource.getConnection();
    }

    public Seq<Object[]> query(String sql, Seq<Object> params) {
        List list;
        if (this.showSql()) {
            Predef$.MODULE$.println((Object)("JdbcExecutor:" + sql));
        }
        Connection conn = this.getConnection();
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            try {
                stmt = conn.prepareStatement(sql);
                this.setParams(stmt, params, null);
                rs = stmt.executeQuery();
                list = this.convertToSeq(rs);
            }
            catch (SQLException e) {
                this.rethrow(e, sql, (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{params}));
                list = List$.MODULE$.empty();
            }
        }
        finally {
            if (rs != null) {
                rs.close();
            }
            if (stmt != null) {
                stmt.close();
            }
            conn.close();
        }
        return list;
    }

    public int update(String sql, Seq<Object> params) {
        if (this.showSql()) {
            Predef$.MODULE$.println((Object)("JdbcExecutor:" + sql));
        }
        PreparedStatement stmt = null;
        Connection conn = this.getConnection();
        if (conn.getAutoCommit()) {
            conn.setAutoCommit(false);
        }
        int rows = 0;
        try {
            try {
                stmt = conn.prepareStatement(sql);
                this.setParams(stmt, params, null);
                rows = stmt.executeUpdate();
                stmt.close();
                stmt = null;
                conn.commit();
            }
            catch (SQLException e) {
                conn.rollback();
                this.rethrow(e, sql, (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{params}));
            }
        }
        finally {
            if (stmt != null) {
                stmt.close();
            }
            conn.close();
        }
        return rows;
    }

    public Seq<Object> batch(String sql, Seq<Object> datas, Seq<Object> types) {
        if (this.showSql()) {
            Predef$.MODULE$.println((Object)("JdbcExecutor:" + sql));
        }
        ObjectRef stmt = ObjectRef.create(null);
        Connection conn = this.getConnection();
        if (conn.getAutoCommit()) {
            conn.setAutoCommit(false);
        }
        ListBuffer rows = new ListBuffer();
        ObjectRef curParam = ObjectRef.create(null);
        try {
            try {
                stmt.elem = conn.prepareStatement(sql);
                datas.foreach((Function1 & Serializable & scala.Serializable)param -> {
                    this.org$beangle$data$jdbc$query$JdbcExecutor$$$anonfun$1(types, stmt, curParam, param);
                    return BoxedUnit.UNIT;
                });
                rows.$plus$plus$eq((TraversableOnce)new ArrayOps.ofInt(Predef$.MODULE$._intArrayOps(((PreparedStatement)stmt.elem).executeBatch())));
                conn.commit();
            }
            catch (BatchUpdateException be) {
                conn.rollback();
                this.rethrow(be.getNextException(), sql, (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{(Seq)curParam.elem}));
            }
            catch (SQLException e) {
                conn.rollback();
                this.rethrow(e, sql, (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{(Seq)curParam.elem}));
            }
        }
        finally {
            ((PreparedStatement)stmt.elem).close();
            conn.close();
        }
        return rows.toList();
    }

    public void setParams(PreparedStatement stmt, Seq<Object> params, Seq<Object> types) {
        int paramsCount = params == null ? 0 : params.length();
        int stmtParamCount = 0;
        ObjectRef sqltypes = ObjectRef.create(null);
        if (types != null && !types.isEmpty()) {
            stmtParamCount = types.length();
            sqltypes.elem = (int[])types.toArray(ClassTag$.MODULE$.Int());
        } else {
            stmtParamCount = !this.pmdKnownBroken() ? stmt.getParameterMetaData().getParameterCount() : params.length();
            sqltypes.elem = new int[stmtParamCount];
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), stmtParamCount).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                ((int[])sqltypes$1.elem)[i] = 0;
            });
            if (!this.pmdKnownBroken()) {
                ObjectRef pmd = ObjectRef.create((Object)stmt.getParameterMetaData());
                try {
                    RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), stmtParamCount).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                        ((int[])sqltypes$1.elem)[i] = ((ParameterMetaData)pmd$1.elem).getParameterType(i + 1);
                    });
                }
                catch (SQLException e) {
                    this.pmdKnownBroken_$eq(true);
                    RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), stmtParamCount).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                        ((int[])sqltypes$1.elem)[i] = params.apply(i) == null ? 12 : JdbcExecutor$.MODULE$.toSqlType(params.apply(i).getClass());
                    });
                }
            } else {
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), stmtParamCount).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    ((int[])sqltypes$1.elem)[i] = params.apply(i) == null ? 12 : JdbcExecutor$.MODULE$.toSqlType(params.apply(i).getClass());
                });
            }
        }
        if (stmtParamCount > paramsCount) {
            throw new SQLException("Wrong number of parameters: expected " + stmtParamCount + ", was given " + paramsCount);
        }
        for (int i2 = 0; i2 < stmtParamCount; ++i2) {
            int index = i2 + 1;
            if (params.apply(i2) == null) {
                stmt.setNull(index, ((int[])sqltypes.elem)[i2] == 0 ? 12 : ((int[])sqltypes.elem)[i2]);
                continue;
            }
            Object value = params.apply(i2);
            try {
                int sqltype;
                int n = sqltype = ((int[])sqltypes.elem)[i2];
                switch (n) {
                    case 1: 
                    case 12: {
                        stmt.setString(index, (String)value);
                        break;
                    }
                    case -1: {
                        stmt.setCharacterStream(index, new StringReader((String)value));
                        break;
                    }
                    case -7: 
                    case 16: {
                        BoxedUnit boxedUnit;
                        Object object = value;
                        if (object instanceof Boolean) {
                            boolean bl = BoxesRunTime.unboxToBoolean((Object)object);
                            stmt.setBoolean(index, bl);
                            boxedUnit = BoxedUnit.UNIT;
                            break;
                        }
                        if (object instanceof Number) {
                            Number number = (Number)object;
                            stmt.setBoolean(index, number.intValue() > 0);
                            boxedUnit = BoxedUnit.UNIT;
                            break;
                        }
                        throw new MatchError(object);
                    }
                    case -6: 
                    case 4: 
                    case 5: {
                        stmt.setInt(index, ((Number)value).intValue());
                        break;
                    }
                    case -5: {
                        stmt.setLong(index, ((Number)value).longValue());
                        break;
                    }
                    case 6: 
                    case 8: {
                        if (value instanceof BigDecimal) {
                            stmt.setBigDecimal(index, (BigDecimal)value);
                            break;
                        }
                        stmt.setDouble(index, BoxesRunTime.unboxToDouble((Object)value));
                        break;
                    }
                    case 2: 
                    case 3: {
                        if (value instanceof BigDecimal) {
                            stmt.setBigDecimal(index, (BigDecimal)value);
                            break;
                        }
                        stmt.setObject(index, value, sqltype);
                        break;
                    }
                    case 91: {
                        if (value instanceof java.util.Date) {
                            if (value instanceof Date) {
                                stmt.setDate(index, (Date)value);
                                break;
                            }
                            stmt.setDate(index, new Date(((java.util.Date)value).getTime()));
                            break;
                        }
                        if (value instanceof Calendar) {
                            Calendar cal = (Calendar)value;
                            stmt.setDate(index, new Date(cal.getTime().getTime()), cal);
                            break;
                        }
                        stmt.setObject(index, value, 91);
                        break;
                    }
                    case 92: {
                        if (value instanceof java.util.Date) {
                            if (value instanceof Time) {
                                stmt.setTime(index, (Time)value);
                                break;
                            }
                            stmt.setTime(index, new Time(((java.util.Date)value).getTime()));
                            break;
                        }
                        if (value instanceof Calendar) {
                            Calendar cal = (Calendar)value;
                            stmt.setTime(index, new Time(cal.getTime().getTime()), cal);
                            break;
                        }
                        stmt.setObject(index, value, 92);
                        break;
                    }
                    case 93: {
                        if (value instanceof java.util.Date) {
                            if (value instanceof Timestamp) {
                                stmt.setTimestamp(index, (Timestamp)value);
                                break;
                            }
                            stmt.setTimestamp(index, new Timestamp(((java.util.Date)value).getTime()));
                            break;
                        }
                        if (value instanceof Calendar) {
                            Calendar cal = (Calendar)value;
                            stmt.setTimestamp(index, new Timestamp(cal.getTime().getTime()), cal);
                            break;
                        }
                        stmt.setObject(index, value, 93);
                        break;
                    }
                    case -4: 
                    case -3: 
                    case -2: {
                        if (value instanceof byte[]) {
                            byte[] bytes = (byte[])value;
                            stmt.setBinaryStream(index, (InputStream)new ByteArrayInputStream(bytes), bytes.length);
                            break;
                        }
                        InputStream in = (InputStream)value;
                        ByteArrayOutputStream out = new ByteArrayOutputStream();
                        IOs$.MODULE$.copy(in, (OutputStream)out);
                        stmt.setBinaryStream(index, in, out.size());
                        break;
                    }
                    case 2005: {
                        if (JdbcExecutor$.MODULE$.isStringType(value.getClass())) {
                            stmt.setString(index, value.toString());
                            break;
                        }
                        Clob clb = (Clob)value;
                        ByteArrayOutputStream out = new ByteArrayOutputStream();
                        IOs$.MODULE$.copy(clb.getAsciiStream(), (OutputStream)out);
                        stmt.setAsciiStream(index, clb.getAsciiStream(), out.size());
                        break;
                    }
                    case 2004: {
                        InputStream in = ((Blob)value).getBinaryStream();
                        ByteArrayOutputStream out = new ByteArrayOutputStream();
                        IOs$.MODULE$.copy(in, (OutputStream)out);
                        stmt.setBinaryStream(index, in, out.size());
                        break;
                    }
                    default: {
                        if (0 == sqltype) {
                            stmt.setObject(index, value);
                            break;
                        }
                        stmt.setObject(index, value, sqltype);
                        break;
                    }
                }
                continue;
            }
            catch (Exception e) {
                this.logger().error((Function0 & Serializable & scala.Serializable)() -> "set value error", (Function0 & Serializable & scala.Serializable)() -> e);
            }
        }
    }

    public void rethrow(SQLException cause, String sql, Seq<Object> params) {
        String causeMessage = cause.getMessage();
        if (causeMessage == null) {
            causeMessage = "";
        }
        StringBuffer msg = new StringBuffer(causeMessage);
        msg.append(" Query: ").append(sql).append(" Parameters: ");
        StringBuffer stringBuffer = params == null ? msg.append("[]") : msg.append(Strings$.MODULE$.join(params, ","));
        SQLException e = new SQLException(msg.toString(), cause.getSQLState(), cause.getErrorCode());
        e.setNextException(cause);
        throw e;
    }

    private Seq<Object[]> convertToSeq(ResultSet rs) {
        ResultSetMetaData meta = rs.getMetaData();
        int cols = meta.getColumnCount();
        ListBuffer rows = new ListBuffer();
        String string = meta.getColumnName(1);
        String string2 = "_row_nr_";
        int start = !(string != null ? !string.equals(string2) : string2 != null) ? 1 : 0;
        int rowlength = cols - start;
        while (rs.next()) {
            Object[] row = new Object[rowlength];
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(start), cols).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                Object v = rs.getObject(i + 1);
                if (v != null && meta.getColumnType(i + 1) == 93 && !(v instanceof Timestamp)) {
                    if (JdbcExecutor$.MODULE$.oracleTimestampMethod() != null) {
                        v = JdbcExecutor$.MODULE$.oracleTimestampMethod().invoke(v, new Object[0]);
                    } else {
                        throw new Exception("Cannot translate " + v.getClass() + "timestamp to java.sql.Timestamp");
                    }
                }
                row$1[i - start$1] = v;
            });
            rows.$plus$eq((Object)row);
        }
        rs.close();
        return rows;
    }

    public final /* synthetic */ void org$beangle$data$jdbc$query$JdbcExecutor$$$anonfun$1(Seq types$1, ObjectRef stmt$1, ObjectRef curParam$1, Object param) {
        curParam$1.elem = Predef$.MODULE$.genericWrapArray(param);
        this.setParams((PreparedStatement)stmt$1.elem, (Seq<Object>)Predef$.MODULE$.genericWrapArray(param), (Seq<Object>)types$1);
        ((PreparedStatement)stmt$1.elem).addBatch();
    }

    public JdbcExecutor(DataSource dataSource) {
        this.dataSource = dataSource;
        this.pmdKnownBroken = false;
        this.showSql = false;
    }
}

