/*
 * Decompiled with CFR 0.152.
 */
package org.beangle.data.jdbc.meta;

import java.io.Serializable;
import java.sql.DatabaseMetaData;
import org.beangle.commons.lang.Strings$;
import org.beangle.data.jdbc.dialect.Dialect;
import org.beangle.data.jdbc.dialect.Name;
import org.beangle.data.jdbc.meta.MetadataLoader;
import org.beangle.data.jdbc.meta.NameFilter;
import org.beangle.data.jdbc.meta.Sequence;
import org.beangle.data.jdbc.meta.Table;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.HashSet;
import scala.collection.mutable.HashSet$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001\u0005\u001db\u0001B\u0001\u0003\u00015\u0011aaU2iK6\f'BA\u0002\u0005\u0003\u0011iW\r^1\u000b\u0005\u00151\u0011\u0001\u00026eE\u000eT!a\u0002\u0005\u0002\t\u0011\fG/\u0019\u0006\u0003\u0013)\tqAY3b]\u001edWMC\u0001\f\u0003\ry'oZ\u0002\u0001'\t\u0001a\u0002\u0005\u0002\u0010%5\t\u0001CC\u0001\u0012\u0003\u0015\u00198-\u00197b\u0013\t\u0019\u0002C\u0001\u0004B]f\u0014VM\u001a\u0005\t+\u0001\u0011)\u0019!C\u0001-\u00059A-[1mK\u000e$X#A\f\u0011\u0005aQR\"A\r\u000b\u0005U!\u0011BA\u000e\u001a\u0005\u001d!\u0015.\u00197fGRD\u0001\"\b\u0001\u0003\u0002\u0003\u0006IaF\u0001\tI&\fG.Z2uA!Aq\u0004\u0001BC\u0002\u0013\u0005\u0001%A\u0004dCR\fGn\\4\u0016\u0003\u0005\u0002\"\u0001\u0007\u0012\n\u0005\rJ\"\u0001\u0002(b[\u0016D\u0001\"\n\u0001\u0003\u0002\u0003\u0006I!I\u0001\tG\u0006$\u0018\r\\8hA!Aq\u0005\u0001BC\u0002\u0013\u0005\u0001%\u0001\u0003oC6,\u0007\u0002C\u0015\u0001\u0005\u0003\u0005\u000b\u0011B\u0011\u0002\u000b9\fW.\u001a\u0011\t\u000b-\u0002A\u0011\u0001\u0017\u0002\rqJg.\u001b;?)\u0011is\u0006M\u0019\u0011\u00059\u0002Q\"\u0001\u0002\t\u000bUQ\u0003\u0019A\f\t\u000b}Q\u0003\u0019A\u0011\t\u000b\u001dR\u0003\u0019A\u0011\t\u000fM\u0002!\u0019!C\u0001i\u00051A/\u00192mKN,\u0012!\u000e\t\u0005mmj\u0004*D\u00018\u0015\tA\u0014(A\u0004nkR\f'\r\\3\u000b\u0005i\u0002\u0012AC2pY2,7\r^5p]&\u0011Ah\u000e\u0002\b\u0011\u0006\u001c\b.T1q!\tqTI\u0004\u0002@\u0007B\u0011\u0001\tE\u0007\u0002\u0003*\u0011!\tD\u0001\u0007yI|w\u000e\u001e \n\u0005\u0011\u0003\u0012A\u0002)sK\u0012,g-\u0003\u0002G\u000f\n11\u000b\u001e:j]\u001eT!\u0001\u0012\t\u0011\u00059J\u0015B\u0001&\u0003\u0005\u0015!\u0016M\u00197f\u0011\u0019a\u0005\u0001)A\u0005k\u00059A/\u00192mKN\u0004\u0003b\u0002(\u0001\u0005\u0004%\taT\u0001\ng\u0016\fX/\u001a8dKN,\u0012\u0001\u0015\t\u0004mE\u001b\u0016B\u0001*8\u0005\u001dA\u0015m\u001d5TKR\u0004\"A\f+\n\u0005U\u0013!\u0001C*fcV,gnY3\t\r]\u0003\u0001\u0015!\u0003Q\u0003)\u0019X-];f]\u000e,7\u000f\t\u0005\u00063\u0002!\tAW\u0001\u000bY>\fG\rV1cY\u0016\u001cHcA\u001b\\I\")1\u0001\u0017a\u00019B\u0011QLY\u0007\u0002=*\u0011q\fY\u0001\u0004gFd'\"A1\u0002\t)\fg/Y\u0005\u0003Gz\u0013\u0001\u0003R1uC\n\f7/Z'fi\u0006$\u0015\r^1\t\u000b\u0015D\u0006\u0019\u00014\u0002\r\u0015DHO]1t!\tyq-\u0003\u0002i!\t9!i\\8mK\u0006t\u0007\"\u00026\u0001\t\u0003Y\u0017!\u00047pC\u0012\u001cV-];f]\u000e,7\u000f\u0006\u0002QY\")1!\u001ba\u00019\")a\u000e\u0001C\u0001_\u0006Aq-\u001a;UC\ndW\r\u0006\u0002qgB\u0019q\"\u001d%\n\u0005I\u0004\"AB(qi&|g\u000eC\u0003([\u0002\u0007Q\bC\u0003v\u0001\u0011\u0005c/\u0001\u0005u_N#(/\u001b8h)\u00059\bC\u0001=|\u001b\u0005I(B\u0001>a\u0003\u0011a\u0017M\\4\n\u0005\u0019K\b\"B?\u0001\t\u0003q\u0018\u0001\u00044jYR,'\u000fV1cY\u0016\u001cH#B@\u0002\u0012\u0005]\u0001#BA\u0001\u0003\u0017Ae\u0002BA\u0002\u0003\u000fq1\u0001QA\u0003\u0013\u0005\t\u0012bAA\u0005!\u00059\u0001/Y2lC\u001e,\u0017\u0002BA\u0007\u0003\u001f\u00111aU3r\u0015\r\tI\u0001\u0005\u0005\b\u0003'a\b\u0019AA\u000b\u0003!Ign\u00197vI\u0016\u001c\b#BA\u0001\u0003\u0017i\u0004bBA\ry\u0002\u0007\u0011QC\u0001\tKb\u001cG.\u001e3fg\"9\u0011Q\u0004\u0001\u0005\u0002\u0005}\u0011a\u00044jYR,'oU3rk\u0016t7-Z:\u0015\r\u0005\u0005\u00121EA\u0013!\u0015\t\t!a\u0003T\u0011!\t\u0019\"a\u0007A\u0002\u0005U\u0001\u0002CA\r\u00037\u0001\r!!\u0006")
public class Schema {
    private final Dialect dialect;
    private final Name catalog;
    private final Name name;
    private final HashMap<String, Table> tables;
    private final HashSet<Sequence> sequences;

    public Dialect dialect() {
        return this.dialect;
    }

    public Name catalog() {
        return this.catalog;
    }

    public Name name() {
        return this.name;
    }

    public HashMap<String, Table> tables() {
        return this.tables;
    }

    public HashSet<Sequence> sequences() {
        return this.sequences;
    }

    public HashMap<String, Table> loadTables(DatabaseMetaData meta, boolean extras) {
        MetadataLoader loader = new MetadataLoader(this.dialect(), meta);
        Set<Table> loadTables = loader.loadTables(this.catalog(), this.name(), extras);
        loadTables.foreach((Function1 & Serializable & scala.Serializable)table -> {
            table.dialect_$eq(this.dialect());
            return this.tables().put((Object)table.name().value(), table);
        });
        return this.tables();
    }

    public HashSet<Sequence> loadSequences(DatabaseMetaData meta) {
        this.sequences().$plus$plus$eq(new MetadataLoader(this.dialect(), meta).loadSequences(this.name()));
        return this.sequences();
    }

    public Option<Table> getTable(String name) {
        Object object;
        String nschema = this.name().qualified(this.dialect());
        if (name.contains(".")) {
            String string = nschema;
            String string2 = this.dialect().parse(Strings$.MODULE$.substringBefore(name, ".")).value();
            object = (string == null ? string2 != null : !string.equals(string2)) ? None$.MODULE$ : this.tables().get((Object)this.dialect().parse(Strings$.MODULE$.substringAfter(name, ".")).value());
        } else {
            object = this.tables().get((Object)this.dialect().parse(name).value());
        }
        return object;
    }

    public String toString() {
        return "Database" + this.tables().keySet().toString() + this.sequences().toString();
    }

    public Seq<Table> filterTables(Seq<String> includes, Seq<String> excludes) {
        NameFilter filter;
        block1: {
            filter = new NameFilter();
            if (includes != null) {
                includes.foreach((Function1 & Serializable & scala.Serializable)include -> {
                    filter.include(this.dialect().parse(include).value());
                    return BoxedUnit.UNIT;
                });
            }
            if (excludes == null) break block1;
            excludes.foreach((Function1 & Serializable & scala.Serializable)exclude -> {
                filter.exclude(this.dialect().parse(exclude).value());
                return BoxedUnit.UNIT;
            });
        }
        return (Seq)filter.filter((Iterable<String>)this.tables().keySet()).map((Function1 & Serializable & scala.Serializable)t -> (Table)this.tables().apply(t), List$.MODULE$.canBuildFrom());
    }

    public Seq<Sequence> filterSequences(Seq<String> includes, Seq<String> excludes) {
        NameFilter filter = new NameFilter();
        if (includes != null) {
            includes.foreach((Function1 & Serializable & scala.Serializable)include -> {
                filter.include(this.dialect().parse(include).value());
                return BoxedUnit.UNIT;
            });
        }
        if (excludes != null) {
            excludes.foreach((Function1 & Serializable & scala.Serializable)exclude -> {
                filter.exclude(this.dialect().parse(exclude).value());
                return BoxedUnit.UNIT;
            });
        }
        Map seqMap = ((TraversableOnce)this.sequences().map((Function1 & Serializable & scala.Serializable)f -> new Tuple2((Object)f.qualifiedName(), f), HashSet$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        return (Seq)filter.filter((Iterable<String>)seqMap.keys()).map((Function1 & Serializable & scala.Serializable)s -> (Sequence)seqMap.apply(s), List$.MODULE$.canBuildFrom());
    }

    public Schema(Dialect dialect, Name catalog, Name name) {
        this.dialect = dialect;
        this.catalog = catalog;
        this.name = name;
        this.tables = new HashMap();
        this.sequences = new HashSet();
        Predef$.MODULE$.assert(name != null);
    }
}

