/*
 * Decompiled with CFR 0.152.
 */
package org.beangle.data.jdbc.query;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.io.StringReader;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.sql.BatchUpdateException;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import javax.sql.DataSource;
import org.beangle.commons.io.IOs$;
import org.beangle.commons.lang.Strings$;
import org.beangle.commons.logging.Logger;
import org.beangle.commons.logging.Logging;
import org.beangle.data.jdbc.query.JdbcExecutor$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.ListBuffer;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\t-q!B\u0001\u0003\u0011\u0003i\u0011\u0001\u0004&eE\u000e,\u00050Z2vi>\u0014(BA\u0002\u0005\u0003\u0015\tX/\u001a:z\u0015\t)a!\u0001\u0003kI\n\u001c'BA\u0004\t\u0003\u0011!\u0017\r^1\u000b\u0005%Q\u0011a\u00022fC:<G.\u001a\u0006\u0002\u0017\u0005\u0019qN]4\u0004\u0001A\u0011abD\u0007\u0002\u0005\u0019)\u0001C\u0001E\u0001#\ta!\n\u001a2d\u000bb,7-\u001e;peN\u0011qB\u0005\t\u0003'Yi\u0011\u0001\u0006\u0006\u0002+\u0005)1oY1mC&\u0011q\u0003\u0006\u0002\u0007\u0003:L(+\u001a4\t\u000beyA\u0011\u0001\u000e\u0002\rqJg.\u001b;?)\u0005i\u0001\"\u0003\u000f\u0010\u0001\u0004\u0005\r\u0011\"\u0001\u001e\u0003Uy'/Y2mKRKW.Z:uC6\u0004X*\u001a;i_\u0012,\u0012A\b\t\u0003?\u0019j\u0011\u0001\t\u0006\u0003C\t\nqA]3gY\u0016\u001cGO\u0003\u0002$I\u0005!A.\u00198h\u0015\u0005)\u0013\u0001\u00026bm\u0006L!a\n\u0011\u0003\r5+G\u000f[8e\u0011%Is\u00021AA\u0002\u0013\u0005!&A\rpe\u0006\u001cG.\u001a+j[\u0016\u001cH/Y7q\u001b\u0016$\bn\u001c3`I\u0015\fHCA\u0016/!\t\u0019B&\u0003\u0002.)\t!QK\\5u\u0011\u001dy\u0003&!AA\u0002y\t1\u0001\u001f\u00132\u0011\u0019\tt\u0002)Q\u0005=\u00051rN]1dY\u0016$\u0016.\\3ti\u0006l\u0007/T3uQ>$\u0007\u0005C\u00044\u001f\t\u0007I\u0011\u0001\u001b\u0002-=\u0014'.Z2u)f\u0004X\rV8Tc2$\u0016\u0010]3NCB,\u0012!\u000e\t\u0005mu\u0002\u0015K\u0004\u00028wA\u0011\u0001\bF\u0007\u0002s)\u0011!\bD\u0001\u0007yI|w\u000e\u001e \n\u0005q\"\u0012A\u0002)sK\u0012,g-\u0003\u0002?\u007f\t\u0019Q*\u00199\u000b\u0005q\"\u0002GA!G!\r1$\tR\u0005\u0003\u0007~\u0012Qa\u00117bgN\u0004\"!\u0012$\r\u0001\u0011Iq\tSA\u0001\u0002\u0003\u0015\tA\u0013\u0002\u0004?\u0012\n\u0004BB%\u0010A\u0003%Q'A\fpE*,7\r\u001e+za\u0016$vnU9m)f\u0004X-T1qAE\u00111J\u0014\t\u0003'1K!!\u0014\u000b\u0003\u000f9{G\u000f[5oOB\u00111cT\u0005\u0003!R\u00111!\u00118z!\t\u0019\"+\u0003\u0002T)\t\u0019\u0011J\u001c;\t\u000bU{A\u0011\u0001,\u0002\u0019%\u001c8\u000b\u001e:j]\u001e$\u0016\u0010]3\u0015\u0005]S\u0006CA\nY\u0013\tIFCA\u0004C_>dW-\u00198\t\u000bm#\u0006\u0019\u0001/\u0002\u000b\rd\u0017M\u001f>1\u0005u{\u0006c\u0001\u001cC=B\u0011Qi\u0018\u0003\nAj\u000b\t\u0011!A\u0003\u0002)\u00131a\u0018\u00133\u0011\u0015\u0011w\u0002\"\u0001d\u0003)I7\u000fR1uKRK\b/\u001a\u000b\u0003/\u0012DQaW1A\u0002\u0015\u0004$A\u001a5\u0011\u0007Y\u0012u\r\u0005\u0002FQ\u0012I\u0011\u000eZA\u0001\u0002\u0003\u0015\tA\u0013\u0002\u0004?\u0012\u001a\u0004\"B6\u0010\t\u0003a\u0017!\u0003;p'FdG+\u001f9f)\t\tV\u000eC\u0003\\U\u0002\u0007a\u000e\r\u0002pcB\u0019aG\u00119\u0011\u0005\u0015\u000bH!\u0003:n\u0003\u0003\u0005\tQ!\u0001K\u0005\ryF\u0005\u000e\u0004\u0005!\t\u0001AoE\u0002t%U\u0004\"A^>\u000e\u0003]T!\u0001_=\u0002\u000f1|wmZ5oO*\u0011!\u0010C\u0001\bG>lWn\u001c8t\u0013\taxOA\u0004M_\u001e<\u0017N\\4\t\u0011y\u001c(\u0011!Q\u0001\n}\f!\u0002Z1uCN{WO]2f!\u0011\t\t!a\u0003\u000e\u0005\u0005\r!\u0002BA\u0003\u0003\u000f\t1a]9m\u0015\t\tI!A\u0003kCZ\f\u00070\u0003\u0003\u0002\u000e\u0005\r!A\u0003#bi\u0006\u001cv.\u001e:dK\"1\u0011d\u001dC\u0001\u0003#!B!a\u0005\u0002\u0016A\u0011ab\u001d\u0005\u0007}\u0006=\u0001\u0019A@\t\u0013\u0005e1\u000f1A\u0005\u0002\u0005m\u0011A\u00049nI.swn\u001e8Ce>\\WM\\\u000b\u0002/\"I\u0011qD:A\u0002\u0013\u0005\u0011\u0011E\u0001\u0013a6$7J\\8x]\n\u0013xn[3o?\u0012*\u0017\u000fF\u0002,\u0003GA\u0001bLA\u000f\u0003\u0003\u0005\ra\u0016\u0005\b\u0003O\u0019\b\u0015)\u0003X\u0003=\u0001X\u000eZ&o_^t'I]8lK:\u0004\u0003\"CA\u0016g\u0002\u0007I\u0011AA\u000e\u0003\u001d\u0019\bn\\<Tc2D\u0011\"a\ft\u0001\u0004%\t!!\r\u0002\u0017MDwn^*rY~#S-\u001d\u000b\u0004W\u0005M\u0002\u0002C\u0018\u0002.\u0005\u0005\t\u0019A,\t\u000f\u0005]2\u000f)Q\u0005/\u0006A1\u000f[8x'Fd\u0007\u0005C\u0004\u0002<M$\t!!\u0010\u0002\rUt\u0017.];f+\u0011\ty$!\u0013\u0015\r\u0005\u0005\u0013QJA+!\u0015\u0019\u00121IA$\u0013\r\t)\u0005\u0006\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u0007\u0015\u000bI\u0005B\u0004\u0002L\u0005e\"\u0019\u0001&\u0003\u0003QC\u0001\"!\u0002\u0002:\u0001\u0007\u0011q\n\t\u0004m\u0005E\u0013bAA*\u007f\t11\u000b\u001e:j]\u001eD\u0001\"a\u0016\u0002:\u0001\u0007\u0011\u0011L\u0001\u0007a\u0006\u0014\u0018-\\:\u0011\tM\tYFT\u0005\u0004\u0003;\"\"A\u0003\u001fsKB,\u0017\r^3e}!9\u0011\u0011M:\u0005\u0002\u0005\r\u0014aC9vKJLhi\u001c:J]R$B!!\u001a\u0002hA!1#a\u0011R\u0011!\t)!a\u0018A\u0002\u0005=\u0003bBA6g\u0012\u0005\u0011QN\u0001\rcV,'/\u001f$pe2{gn\u001a\u000b\u0005\u0003_\n9\bE\u0003\u0014\u0003\u0007\n\t\bE\u0002\u0014\u0003gJ1!!\u001e\u0015\u0005\u0011auN\\4\t\u0011\u0005\u0015\u0011\u0011\u000ea\u0001\u0003\u001fBq!a\u001ft\t\u0003\ti(A\u0007hKR\u001cuN\u001c8fGRLwN\u001c\u000b\u0003\u0003\u007f\u0002B!!!\u0002\u00066\u0011\u00111\u0011\u0006\u0004\u0003\u000b!\u0013\u0002BAD\u0003\u0007\u0013!bQ8o]\u0016\u001cG/[8o\u0011\u0019\u00191\u000f\"\u0001\u0002\fR1\u0011QRAS\u0003O\u0003b!a$\u0002\u001a\u0006}e\u0002BAI\u0003+s1\u0001OAJ\u0013\u0005)\u0012bAAL)\u00059\u0001/Y2lC\u001e,\u0017\u0002BAN\u0003;\u00131aU3r\u0015\r\t9\n\u0006\t\u0005'\u0005\u0005f*C\u0002\u0002$R\u0011Q!\u0011:sCfD\u0001\"!\u0002\u0002\n\u0002\u0007\u0011q\n\u0005\t\u0003/\nI\t1\u0001\u0002Z!9\u00111V:\u0005\u0002\u00055\u0016AB;qI\u0006$X\rF\u0003R\u0003_\u000b\t\f\u0003\u0005\u0002\u0006\u0005%\u0006\u0019AA(\u0011!\t9&!+A\u0002\u0005e\u0003bBA[g\u0012\u0005\u0011qW\u0001\u0006E\u0006$8\r\u001b\u000b\t\u0003s\u000bY,!0\u0002NB)\u0011qRAM#\"A\u0011QAAZ\u0001\u0004\ty\u0005\u0003\u0005\u0002@\u0006M\u0006\u0019AAa\u0003\u0015!\u0017\r^1t!\u0019\ty)!'\u0002DB\"\u0011QYAe!\u0015\u0019\u0012\u0011UAd!\r)\u0015\u0011\u001a\u0003\f\u0003\u0017\fi,!A\u0001\u0002\u000b\u0005!JA\u0002`IUB\u0001\"a4\u00024\u0002\u0007\u0011\u0011X\u0001\u0006if\u0004Xm\u001d\u0005\b\u0003'\u001cH\u0011AAk\u0003%\u0019X\r\u001e)be\u0006l7\u000fF\u0004,\u0003/\f\t/!:\t\u0011\u0005e\u0017\u0011\u001ba\u0001\u00037\fAa\u001d;niB!\u0011\u0011QAo\u0013\u0011\ty.a!\u0003#A\u0013X\r]1sK\u0012\u001cF/\u0019;f[\u0016tG\u000f\u0003\u0005\u0002X\u0005E\u0007\u0019AAr!\u0015\ty)!'O\u0011!\ty-!5A\u0002\u0005e\u0006bBAug\u0012E\u00111^\u0001\be\u0016$\bN]8x)\u001dY\u0013Q^A|\u0003sD\u0001\"a<\u0002h\u0002\u0007\u0011\u0011_\u0001\u0006G\u0006,8/\u001a\t\u0005\u0003\u0003\u000b\u00190\u0003\u0003\u0002v\u0006\r%\u0001D*R\u0019\u0016C8-\u001a9uS>t\u0007\u0002CA\u0003\u0003O\u0004\r!a\u0014\t\u0011\u0005]\u0013q\u001da\u0001\u00033Bq!!@t\t\u0013\ty0\u0001\u0007d_:4XM\u001d;U_N+\u0017\u000f\u0006\u0003\u0002\u000e\n\u0005\u0001\u0002\u0003B\u0002\u0003w\u0004\rA!\u0002\u0002\u0005I\u001c\b\u0003BAA\u0005\u000fIAA!\u0003\u0002\u0004\nI!+Z:vYR\u001cV\r\u001e")
public class JdbcExecutor
implements Logging {
    private final DataSource dataSource;
    private boolean pmdKnownBroken;
    private boolean showSql;
    private final Logger logger;

    public static int toSqlType(Class<?> clazz) {
        return JdbcExecutor$.MODULE$.toSqlType(clazz);
    }

    public static boolean isDateType(Class<?> clazz) {
        return JdbcExecutor$.MODULE$.isDateType(clazz);
    }

    public static boolean isStringType(Class<?> clazz) {
        return JdbcExecutor$.MODULE$.isStringType(clazz);
    }

    public static Map<Class<?>, Object> objectTypeToSqlTypeMap() {
        return JdbcExecutor$.MODULE$.objectTypeToSqlTypeMap();
    }

    public static void oracleTimestampMethod_$eq(Method method) {
        JdbcExecutor$.MODULE$.oracleTimestampMethod_$eq(method);
    }

    public static Method oracleTimestampMethod() {
        return JdbcExecutor$.MODULE$.oracleTimestampMethod();
    }

    public Logger logger() {
        return this.logger;
    }

    public void org$beangle$commons$logging$Logging$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    public boolean pmdKnownBroken() {
        return this.pmdKnownBroken;
    }

    public void pmdKnownBroken_$eq(boolean x$1) {
        this.pmdKnownBroken = x$1;
    }

    public boolean showSql() {
        return this.showSql;
    }

    public void showSql_$eq(boolean x$1) {
        this.showSql = x$1;
    }

    public <T> Option<T> unique(String sql, Seq<Object> params) {
        Seq<Object[]> rs = this.query(sql, (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[0]));
        return rs.isEmpty() ? None$.MODULE$ : new Some(Predef$.MODULE$.genericArrayOps(rs.head()).head());
    }

    public Option<Object> queryForInt(String sql) {
        None$ none$;
        Option num = this.unique(sql, (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[0]));
        Option option = num;
        if (option instanceof Some) {
            Some some = (Some)option;
            Number n = (Number)some.value();
            none$ = new Some((Object)BoxesRunTime.boxToInteger((int)n.intValue()));
        } else if (None$.MODULE$.equals(option)) {
            none$ = None$.MODULE$;
        } else {
            throw new MatchError(option);
        }
        return none$;
    }

    public Option<Object> queryForLong(String sql) {
        None$ none$;
        Option num = this.unique(sql, (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[0]));
        Option option = num;
        if (option instanceof Some) {
            Some some = (Some)option;
            Number n = (Number)some.value();
            none$ = new Some((Object)BoxesRunTime.boxToLong((long)n.longValue()));
        } else if (None$.MODULE$.equals(option)) {
            none$ = None$.MODULE$;
        } else {
            throw new MatchError(option);
        }
        return none$;
    }

    public Connection getConnection() {
        return this.dataSource.getConnection();
    }

    public Seq<Object[]> query(String sql, Seq<Object> params) {
        List list;
        if (this.showSql()) {
            Predef$.MODULE$.println((Object)("JdbcExecutor:" + sql));
        }
        Connection conn = this.getConnection();
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            try {
                stmt = conn.prepareStatement(sql);
                this.setParams(stmt, params, null);
                rs = stmt.executeQuery();
                list = this.convertToSeq(rs);
            }
            catch (SQLException e) {
                this.rethrow(e, sql, (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{params}));
                list = List$.MODULE$.empty();
            }
        }
        finally {
            if (rs != null) {
                rs.close();
            }
            if (stmt != null) {
                stmt.close();
            }
            conn.close();
        }
        return list;
    }

    public int update(String sql, Seq<Object> params) {
        if (this.showSql()) {
            Predef$.MODULE$.println((Object)("JdbcExecutor:" + sql));
        }
        PreparedStatement stmt = null;
        Connection conn = this.getConnection();
        if (conn.getAutoCommit()) {
            conn.setAutoCommit(false);
        }
        int rows = 0;
        try {
            try {
                stmt = conn.prepareStatement(sql);
                this.setParams(stmt, params, null);
                rows = stmt.executeUpdate();
                stmt.close();
                stmt = null;
                conn.commit();
            }
            catch (SQLException e) {
                conn.rollback();
                this.rethrow(e, sql, (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{params}));
            }
        }
        finally {
            if (stmt != null) {
                stmt.close();
            }
            conn.close();
        }
        return rows;
    }

    public Seq<Object> batch(String sql, Seq<Object> datas, Seq<Object> types) {
        if (this.showSql()) {
            Predef$.MODULE$.println((Object)("JdbcExecutor:" + sql));
        }
        ObjectRef stmt = ObjectRef.create(null);
        Connection conn = this.getConnection();
        if (conn.getAutoCommit()) {
            conn.setAutoCommit(false);
        }
        ListBuffer rows = new ListBuffer();
        ObjectRef curParam = ObjectRef.create(null);
        try {
            try {
                stmt.elem = conn.prepareStatement(sql);
                datas.foreach((Function1 & Serializable & scala.Serializable)param -> {
                    JdbcExecutor.$anonfun$batch$1(this, types, stmt, curParam, param);
                    return BoxedUnit.UNIT;
                });
                rows.$plus$plus$eq((TraversableOnce)new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(((PreparedStatement)stmt.elem).executeBatch())));
                conn.commit();
            }
            catch (BatchUpdateException be) {
                conn.rollback();
                this.rethrow(be.getNextException(), sql, (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{(Seq)curParam.elem}));
            }
            catch (SQLException e) {
                conn.rollback();
                this.rethrow(e, sql, (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{(Seq)curParam.elem}));
            }
        }
        finally {
            ((PreparedStatement)stmt.elem).close();
            conn.close();
        }
        return rows.toList();
    }

    public void setParams(PreparedStatement stmt, Seq<Object> params, Seq<Object> types) {
        int paramsCount = params == null ? 0 : params.length();
        int stmtParamCount = 0;
        ObjectRef sqltypes = ObjectRef.create(null);
        if (types != null && !types.isEmpty()) {
            stmtParamCount = types.length();
            sqltypes.elem = (int[])types.toArray(ClassTag$.MODULE$.Int());
        } else {
            stmtParamCount = !this.pmdKnownBroken() ? stmt.getParameterMetaData().getParameterCount() : params.length();
            sqltypes.elem = new int[stmtParamCount];
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), stmtParamCount).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                ((int[])sqltypes$1.elem)[i] = 0;
            });
            if (!this.pmdKnownBroken()) {
                ObjectRef pmd = ObjectRef.create((Object)stmt.getParameterMetaData());
                try {
                    RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), stmtParamCount).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                        ((int[])sqltypes$1.elem)[i] = ((ParameterMetaData)pmd$1.elem).getParameterType(i + 1);
                    });
                }
                catch (SQLException e) {
                    this.pmdKnownBroken_$eq(true);
                    RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), stmtParamCount).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                        ((int[])sqltypes$1.elem)[i] = params.apply(i) == null ? 12 : JdbcExecutor$.MODULE$.toSqlType(params.apply(i).getClass());
                    });
                }
            } else {
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), stmtParamCount).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    ((int[])sqltypes$1.elem)[i] = params.apply(i) == null ? 12 : JdbcExecutor$.MODULE$.toSqlType(params.apply(i).getClass());
                });
            }
        }
        if (stmtParamCount > paramsCount) {
            throw new SQLException("Wrong number of parameters: expected " + stmtParamCount + ", was given " + paramsCount);
        }
        for (int i2 = 0; i2 < stmtParamCount; ++i2) {
            int index = i2 + 1;
            if (params.apply(i2) == null) {
                stmt.setNull(index, ((int[])sqltypes.elem)[i2] == 0 ? 12 : ((int[])sqltypes.elem)[i2]);
                continue;
            }
            Object value = params.apply(i2);
            try {
                int sqltype;
                int n = sqltype = ((int[])sqltypes.elem)[i2];
                switch (n) {
                    case 1: 
                    case 12: {
                        stmt.setString(index, (String)value);
                        break;
                    }
                    case -1: {
                        stmt.setCharacterStream(index, new StringReader((String)value));
                        break;
                    }
                    case -7: 
                    case 16: {
                        BoxedUnit boxedUnit;
                        Object object = value;
                        if (object instanceof Boolean) {
                            boolean bl = BoxesRunTime.unboxToBoolean((Object)object);
                            stmt.setBoolean(index, bl);
                            boxedUnit = BoxedUnit.UNIT;
                            break;
                        }
                        if (object instanceof Number) {
                            Number number = (Number)object;
                            stmt.setBoolean(index, number.intValue() > 0);
                            boxedUnit = BoxedUnit.UNIT;
                            break;
                        }
                        throw new MatchError(object);
                    }
                    case -6: 
                    case 4: 
                    case 5: {
                        stmt.setInt(index, ((Number)value).intValue());
                        break;
                    }
                    case -5: {
                        stmt.setLong(index, ((Number)value).longValue());
                        break;
                    }
                    case 6: 
                    case 8: {
                        if (value instanceof BigDecimal) {
                            stmt.setBigDecimal(index, (BigDecimal)value);
                            break;
                        }
                        stmt.setDouble(index, BoxesRunTime.unboxToDouble((Object)value));
                        break;
                    }
                    case 2: 
                    case 3: {
                        if (value instanceof BigDecimal) {
                            stmt.setBigDecimal(index, (BigDecimal)value);
                            break;
                        }
                        stmt.setObject(index, value, sqltype);
                        break;
                    }
                    case 91: {
                        if (value instanceof java.util.Date) {
                            if (value instanceof Date) {
                                stmt.setDate(index, (Date)value);
                                break;
                            }
                            stmt.setDate(index, new Date(((java.util.Date)value).getTime()));
                            break;
                        }
                        if (value instanceof Calendar) {
                            Calendar cal = (Calendar)value;
                            stmt.setDate(index, new Date(cal.getTime().getTime()), cal);
                            break;
                        }
                        stmt.setObject(index, value, 91);
                        break;
                    }
                    case 92: {
                        if (value instanceof java.util.Date) {
                            if (value instanceof Time) {
                                stmt.setTime(index, (Time)value);
                                break;
                            }
                            stmt.setTime(index, new Time(((java.util.Date)value).getTime()));
                            break;
                        }
                        if (value instanceof Calendar) {
                            Calendar cal = (Calendar)value;
                            stmt.setTime(index, new Time(cal.getTime().getTime()), cal);
                            break;
                        }
                        stmt.setObject(index, value, 92);
                        break;
                    }
                    case 93: {
                        if (value instanceof java.util.Date) {
                            if (value instanceof Timestamp) {
                                stmt.setTimestamp(index, (Timestamp)value);
                                break;
                            }
                            stmt.setTimestamp(index, new Timestamp(((java.util.Date)value).getTime()));
                            break;
                        }
                        if (value instanceof Calendar) {
                            Calendar cal = (Calendar)value;
                            stmt.setTimestamp(index, new Timestamp(cal.getTime().getTime()), cal);
                            break;
                        }
                        stmt.setObject(index, value, 93);
                        break;
                    }
                    case -4: 
                    case -3: 
                    case -2: {
                        if (value instanceof byte[]) {
                            byte[] bytes = (byte[])value;
                            stmt.setBinaryStream(index, (InputStream)new ByteArrayInputStream(bytes), bytes.length);
                            break;
                        }
                        InputStream in = (InputStream)value;
                        ByteArrayOutputStream out = new ByteArrayOutputStream();
                        IOs$.MODULE$.copy(in, (OutputStream)out);
                        stmt.setBinaryStream(index, in, out.size());
                        break;
                    }
                    case 2005: {
                        if (JdbcExecutor$.MODULE$.isStringType(value.getClass())) {
                            stmt.setString(index, value.toString());
                            break;
                        }
                        Clob clb = (Clob)value;
                        ByteArrayOutputStream out = new ByteArrayOutputStream();
                        IOs$.MODULE$.copy(clb.getAsciiStream(), (OutputStream)out);
                        stmt.setAsciiStream(index, clb.getAsciiStream(), out.size());
                        break;
                    }
                    case 2004: {
                        InputStream in = ((Blob)value).getBinaryStream();
                        ByteArrayOutputStream out = new ByteArrayOutputStream();
                        IOs$.MODULE$.copy(in, (OutputStream)out);
                        stmt.setBinaryStream(index, in, out.size());
                        break;
                    }
                    default: {
                        if (0 == sqltype) {
                            stmt.setObject(index, value);
                            break;
                        }
                        stmt.setObject(index, value, sqltype);
                        break;
                    }
                }
                continue;
            }
            catch (Exception e) {
                this.logger().error((Function0 & Serializable & scala.Serializable)() -> "set value error", (Function0 & Serializable & scala.Serializable)() -> e);
            }
        }
    }

    public void rethrow(SQLException cause, String sql, Seq<Object> params) {
        String causeMessage = cause.getMessage();
        if (causeMessage == null) {
            causeMessage = "";
        }
        StringBuffer msg = new StringBuffer(causeMessage);
        msg.append(" Query: ").append(sql).append(" Parameters: ");
        StringBuffer stringBuffer = params == null ? msg.append("[]") : msg.append(Strings$.MODULE$.join(params, ","));
        SQLException e = new SQLException(msg.toString(), cause.getSQLState(), cause.getErrorCode());
        e.setNextException(cause);
        throw e;
    }

    private Seq<Object[]> convertToSeq(ResultSet rs) {
        ResultSetMetaData meta = rs.getMetaData();
        int cols = meta.getColumnCount();
        ListBuffer rows = new ListBuffer();
        String string = meta.getColumnName(1);
        String string2 = "_row_nr_";
        int start = !(string != null ? !string.equals(string2) : string2 != null) ? 1 : 0;
        int rowlength = cols - start;
        while (rs.next()) {
            Object[] row = new Object[rowlength];
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(start), cols).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                Object v = rs.getObject(i + 1);
                if (v != null && meta.getColumnType(i + 1) == 93 && !(v instanceof Timestamp)) {
                    if (JdbcExecutor$.MODULE$.oracleTimestampMethod() != null) {
                        v = JdbcExecutor$.MODULE$.oracleTimestampMethod().invoke(v, new Object[0]);
                    } else {
                        throw new Exception("Cannot translate " + v.getClass() + "timestamp to java.sql.Timestamp");
                    }
                }
                row$1[i - start$1] = v;
            });
            rows.$plus$eq((Object)row);
        }
        rs.close();
        return rows;
    }

    public static final /* synthetic */ void $anonfun$batch$1(JdbcExecutor $this, Seq types$1, ObjectRef stmt$1, ObjectRef curParam$1, Object param) {
        curParam$1.elem = Predef$.MODULE$.genericWrapArray(param);
        $this.setParams((PreparedStatement)stmt$1.elem, (Seq<Object>)Predef$.MODULE$.genericWrapArray(param), (Seq<Object>)types$1);
        ((PreparedStatement)stmt$1.elem).addBatch();
    }

    public JdbcExecutor(DataSource dataSource) {
        this.dataSource = dataSource;
        Logging.$init$((Logging)this);
        this.pmdKnownBroken = false;
        this.showSql = false;
    }
}

