/*
 * Decompiled with CFR 0.152.
 */
package org.beangle.data.jdbc.query;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.sql.BatchUpdateException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Timestamp;
import javax.sql.DataSource;
import org.beangle.commons.lang.Strings$;
import org.beangle.commons.logging.Logger;
import org.beangle.commons.logging.Logging;
import org.beangle.data.jdbc.DefaultSqlTypeMapping;
import org.beangle.data.jdbc.meta.Engine;
import org.beangle.data.jdbc.meta.Engines$;
import org.beangle.data.jdbc.query.JdbcExecutor$;
import org.beangle.data.jdbc.query.ParamSetter$;
import org.beangle.data.jdbc.query.Statement;
import org.beangle.data.jdbc.query.TypeParamSetter$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List$;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.ListBuffer;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\u0005\rx!B\u0001\u0003\u0011\u0003i\u0011\u0001\u0004&eE\u000e,\u00050Z2vi>\u0014(BA\u0002\u0005\u0003\u0015\tX/\u001a:z\u0015\t)a!\u0001\u0003kI\n\u001c'BA\u0004\t\u0003\u0011!\u0017\r^1\u000b\u0005%Q\u0011a\u00022fC:<G.\u001a\u0006\u0002\u0017\u0005\u0019qN]4\u0004\u0001A\u0011abD\u0007\u0002\u0005\u0019)\u0001C\u0001E\u0001#\ta!\n\u001a2d\u000bb,7-\u001e;peN\u0011qB\u0005\t\u0003'Yi\u0011\u0001\u0006\u0006\u0002+\u0005)1oY1mC&\u0011q\u0003\u0006\u0002\u0007\u0003:L(+\u001a4\t\u000beyA\u0011\u0001\u000e\u0002\rqJg.\u001b;?)\u0005i\u0001\"\u0003\u000f\u0010\u0001\u0004\u0005\r\u0011\"\u0001\u001e\u0003Uy'/Y2mKRKW.Z:uC6\u0004X*\u001a;i_\u0012,\u0012A\b\t\u0003?\u0019j\u0011\u0001\t\u0006\u0003C\t\nqA]3gY\u0016\u001cGO\u0003\u0002$I\u0005!A.\u00198h\u0015\u0005)\u0013\u0001\u00026bm\u0006L!a\n\u0011\u0003\r5+G\u000f[8e\u0011%Is\u00021AA\u0002\u0013\u0005!&A\rpe\u0006\u001cG.\u001a+j[\u0016\u001cH/Y7q\u001b\u0016$\bn\u001c3`I\u0015\fHCA\u0016/!\t\u0019B&\u0003\u0002.)\t!QK\\5u\u0011\u001dy\u0003&!AA\u0002y\t1\u0001\u001f\u00132\u0011\u0019\tt\u0002)Q\u0005=\u00051rN]1dY\u0016$\u0016.\\3ti\u0006l\u0007/T3uQ>$\u0007E\u0002\u0003\u0011\u0005\u0001\u00194c\u0001\u001a\u0013iA\u0011QGO\u0007\u0002m)\u0011q\u0007O\u0001\bY><w-\u001b8h\u0015\tI\u0004\"A\u0004d_6lwN\\:\n\u0005m2$a\u0002'pO\u001eLgn\u001a\u0005\t{I\u0012\t\u0011)A\u0005}\u0005QA-\u0019;b'>,(oY3\u0011\u0005}\"U\"\u0001!\u000b\u0005\u0005\u0013\u0015aA:rY*\t1)A\u0003kCZ\f\u00070\u0003\u0002F\u0001\nQA)\u0019;b'>,(oY3\t\u000be\u0011D\u0011A$\u0015\u0005!K\u0005C\u0001\b3\u0011\u0015id\t1\u0001?\u0011\u001dY%G1A\u0005\u00021\u000ba!\u001a8hS:,W#A'\u0011\u00059\u000bV\"A(\u000b\u0005A#\u0011\u0001B7fi\u0006L!AU(\u0003\r\u0015sw-\u001b8f\u0011\u0019!&\u0007)A\u0005\u001b\u00069QM\\4j]\u0016\u0004\u0003b\u0002,3\u0005\u0004%\taV\u0001\u000fgFdG+\u001f9f\u001b\u0006\u0004\b/\u001b8h+\u0005A\u0006CA-[\u001b\u0005!\u0011BA.\u0005\u0005U!UMZ1vYR\u001c\u0016\u000f\u001c+za\u0016l\u0015\r\u001d9j]\u001eDa!\u0018\u001a!\u0002\u0013A\u0016aD:rYRK\b/Z'baBLgn\u001a\u0011\t\u000f}\u0013\u0004\u0019!C\u0001A\u000691\u000f[8x'FdW#A1\u0011\u0005M\u0011\u0017BA2\u0015\u0005\u001d\u0011un\u001c7fC:Dq!\u001a\u001aA\u0002\u0013\u0005a-A\u0006tQ><8+\u001d7`I\u0015\fHCA\u0016h\u0011\u001dyC-!AA\u0002\u0005Da!\u001b\u001a!B\u0013\t\u0017\u0001C:i_^\u001c\u0016\u000f\u001c\u0011\t\u000b-\u0014D\u0011\u00017\u0002\rUt\u0017.];f+\ti7\u000f\u0006\u0003oy\u0006E\u0001cA\npc&\u0011\u0001\u000f\u0006\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u0005I\u001cH\u0002\u0001\u0003\u0006i*\u0014\r!\u001e\u0002\u0002)F\u0011a/\u001f\t\u0003']L!\u0001\u001f\u000b\u0003\u000f9{G\u000f[5oOB\u00111C_\u0005\u0003wR\u00111!\u00118z\u0011\u0015\t%\u000e1\u0001~!\rq\u00181\u0002\b\u0004\u007f\u0006\u001d\u0001cAA\u0001)5\u0011\u00111\u0001\u0006\u0004\u0003\u000ba\u0011A\u0002\u001fs_>$h(C\u0002\u0002\nQ\ta\u0001\u0015:fI\u00164\u0017\u0002BA\u0007\u0003\u001f\u0011aa\u0015;sS:<'bAA\u0005)!9\u00111\u00036A\u0002\u0005U\u0011A\u00029be\u0006l7\u000f\u0005\u0003\u0014\u0003/I\u0018bAA\r)\tQAH]3qK\u0006$X\r\u001a \t\u000f\u0005u!\u0007\"\u0001\u0002 \u0005Y\u0011/^3ss\u001a{'/\u00138u)\u0011\t\t#!\u000b\u0011\tMy\u00171\u0005\t\u0004'\u0005\u0015\u0012bAA\u0014)\t\u0019\u0011J\u001c;\t\r\u0005\u000bY\u00021\u0001~\u0011\u001d\tiC\rC\u0001\u0003_\tA\"];fef4uN\u001d'p]\u001e$B!!\r\u0002:A!1c\\A\u001a!\r\u0019\u0012QG\u0005\u0004\u0003o!\"\u0001\u0002'p]\u001eDa!QA\u0016\u0001\u0004i\bbBA\u001fe\u0011\u0005\u0011qH\u0001\u000eO\u0016$8i\u001c8oK\u000e$\u0018n\u001c8\u0015\u0005\u0005\u0005\u0003\u0003BA\"\u0003\u000fj!!!\u0012\u000b\u0005\u0005#\u0013\u0002BA%\u0003\u000b\u0012!bQ8o]\u0016\u001cG/[8o\u0011\u001d\tiE\rC\u0001\u0003\u001f\n\u0011b\u001d;bi\u0016lWM\u001c;\u0015\t\u0005E\u0013q\u000b\t\u0004\u001d\u0005M\u0013bAA+\u0005\tI1\u000b^1uK6,g\u000e\u001e\u0005\u0007\u0003\u0006-\u0003\u0019A?\t\r\r\u0011D\u0011AA.)\u0019\ti&!\u001e\u0002xA1\u0011qLA5\u0003_rA!!\u0019\u0002f9!\u0011\u0011AA2\u0013\u0005)\u0012bAA4)\u00059\u0001/Y2lC\u001e,\u0017\u0002BA6\u0003[\u00121aU3r\u0015\r\t9\u0007\u0006\t\u0005'\u0005E\u00140C\u0002\u0002tQ\u0011Q!\u0011:sCfDa!QA-\u0001\u0004i\b\u0002CA\n\u00033\u0002\r!!\u0006\t\r\r\u0011D\u0011AA>)\u0019\ti&! \u0002\u0000!1\u0011)!\u001fA\u0002uD\u0001\"!!\u0002z\u0001\u0007\u00111Q\u0001\u0007g\u0016$H/\u001a:\u0011\rM\t))!#,\u0013\r\t9\t\u0006\u0002\n\rVt7\r^5p]F\u0002B!a\u0011\u0002\f&!\u0011QRA#\u0005E\u0001&/\u001a9be\u0016$7\u000b^1uK6,g\u000e\u001e\u0005\b\u0003#\u0013D\u0011AAJ\u0003\u0019)\b\u000fZ1uKR1\u00111EAK\u0003/Ca!QAH\u0001\u0004i\b\u0002CA\n\u0003\u001f\u0003\r!!\u0006\t\u000f\u0005E%\u0007\"\u0001\u0002\u001cR1\u00111EAO\u0003?Ca!QAM\u0001\u0004i\b\u0002CAA\u00033\u0003\r!a!\t\u000f\u0005\r&\u0007\"\u0001\u0002&\u0006)!-\u0019;dQRA\u0011qUAU\u0003W\u000bY\f\u0005\u0004\u0002`\u0005%\u00141\u0005\u0005\u0007\u0003\u0006\u0005\u0006\u0019A?\t\u0011\u00055\u0016\u0011\u0015a\u0001\u0003_\u000bQ\u0001Z1uCN\u0004b!a\u0018\u0002j\u0005E\u0006\u0007BAZ\u0003o\u0003RaEA9\u0003k\u00032A]A\\\t-\tI,a+\u0002\u0002\u0003\u0005)\u0011A;\u0003\u0007}#\u0013\u0007\u0003\u0005\u0002>\u0006\u0005\u0006\u0019AAT\u0003\u0015!\u0018\u0010]3t\u0011\u001d\t\tM\rC\t\u0003\u0007\fqA]3uQJ|w\u000fF\u0004,\u0003\u000b\fy-!5\t\u0011\u0005\u001d\u0017q\u0018a\u0001\u0003\u0013\fQaY1vg\u0016\u0004B!a\u0011\u0002L&!\u0011QZA#\u00051\u0019\u0016\u000bT#yG\u0016\u0004H/[8o\u0011\u0019\t\u0015q\u0018a\u0001{\"A\u00111CA`\u0001\u0004\t)\u0002C\u0004\u0002VJ\"I!a6\u0002\u0019\r|gN^3siR{7+Z9\u0015\t\u0005u\u0013\u0011\u001c\u0005\t\u00037\f\u0019\u000e1\u0001\u0002^\u0006\u0011!o\u001d\t\u0005\u0003\u0007\ny.\u0003\u0003\u0002b\u0006\u0015#!\u0003*fgVdGoU3u\u0001")
public class JdbcExecutor
implements Logging {
    private final DataSource dataSource;
    private final Engine engine;
    private final DefaultSqlTypeMapping sqlTypeMapping;
    private boolean showSql;
    private final Logger logger;

    public static void oracleTimestampMethod_$eq(Method method) {
        JdbcExecutor$.MODULE$.oracleTimestampMethod_$eq(method);
    }

    public static Method oracleTimestampMethod() {
        return JdbcExecutor$.MODULE$.oracleTimestampMethod();
    }

    public Logger logger() {
        return this.logger;
    }

    public void org$beangle$commons$logging$Logging$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    public Engine engine() {
        return this.engine;
    }

    public DefaultSqlTypeMapping sqlTypeMapping() {
        return this.sqlTypeMapping;
    }

    public boolean showSql() {
        return this.showSql;
    }

    public void showSql_$eq(boolean x$1) {
        this.showSql = x$1;
    }

    public <T> Option<T> unique(String sql, Seq<Object> params) {
        Seq<Object[]> rs = this.query(sql, (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{params}));
        return rs.isEmpty() ? None$.MODULE$ : new Some(Predef$.MODULE$.genericArrayOps(rs.head()).head());
    }

    public Option<Object> queryForInt(String sql) {
        None$ none$;
        Option num = this.unique(sql, (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[0]));
        Option option = num;
        if (option instanceof Some) {
            Some some = (Some)option;
            Number n = (Number)some.value();
            none$ = new Some((Object)BoxesRunTime.boxToInteger((int)n.intValue()));
        } else if (None$.MODULE$.equals(option)) {
            none$ = None$.MODULE$;
        } else {
            throw new MatchError(option);
        }
        return none$;
    }

    public Option<Object> queryForLong(String sql) {
        None$ none$;
        Option num = this.unique(sql, (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[0]));
        Option option = num;
        if (option instanceof Some) {
            Some some = (Some)option;
            Number n = (Number)some.value();
            none$ = new Some((Object)BoxesRunTime.boxToLong((long)n.longValue()));
        } else if (None$.MODULE$.equals(option)) {
            none$ = None$.MODULE$;
        } else {
            throw new MatchError(option);
        }
        return none$;
    }

    public Connection getConnection() {
        return this.dataSource.getConnection();
    }

    public Statement statement(String sql) {
        return new Statement(sql, this);
    }

    public Seq<Object[]> query(String sql, Seq<Object> params) {
        return this.query(sql, TypeParamSetter$.MODULE$.apply(this.sqlTypeMapping(), params));
    }

    public Seq<Object[]> query(String sql, Function1<PreparedStatement, BoxedUnit> setter) {
        Seq<Object[]> seq;
        if (this.showSql()) {
            Predef$.MODULE$.println((Object)("JdbcExecutor:" + sql));
        }
        Connection conn = this.getConnection();
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            try {
                stmt = conn.prepareStatement(sql);
                setter.apply((Object)stmt);
                rs = stmt.executeQuery();
                seq = this.convertToSeq(rs);
            }
            catch (SQLException e) {
                this.rethrow(e, sql, (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[0]));
                seq = List$.MODULE$.empty();
            }
        }
        finally {
            if (rs != null) {
                rs.close();
            }
            if (stmt != null) {
                stmt.close();
            }
            conn.close();
        }
        return seq;
    }

    public int update(String sql, Seq<Object> params) {
        return this.update(sql, TypeParamSetter$.MODULE$.apply(this.sqlTypeMapping(), params));
    }

    public int update(String sql, Function1<PreparedStatement, BoxedUnit> setter) {
        if (this.showSql()) {
            Predef$.MODULE$.println((Object)("JdbcExecutor:" + sql));
        }
        PreparedStatement stmt = null;
        Connection conn = this.getConnection();
        if (conn.getAutoCommit()) {
            conn.setAutoCommit(false);
        }
        int rows = 0;
        try {
            try {
                stmt = conn.prepareStatement(sql);
                setter.apply((Object)stmt);
                rows = stmt.executeUpdate();
                stmt.close();
                stmt = null;
                conn.commit();
            }
            catch (SQLException e) {
                conn.rollback();
                this.rethrow(e, sql, (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[0]));
            }
        }
        finally {
            if (stmt != null) {
                stmt.close();
            }
            conn.close();
        }
        return rows;
    }

    public Seq<Object> batch(String sql, Seq<Object> datas, Seq<Object> types) {
        if (this.showSql()) {
            Predef$.MODULE$.println((Object)("JdbcExecutor:" + sql));
        }
        ObjectRef stmt = ObjectRef.create(null);
        Connection conn = this.getConnection();
        if (conn.getAutoCommit()) {
            conn.setAutoCommit(false);
        }
        ListBuffer rows = new ListBuffer();
        ObjectRef curParam = ObjectRef.create(null);
        try {
            try {
                stmt.elem = conn.prepareStatement(sql);
                datas.foreach((Function1 & Serializable & scala.Serializable)param -> {
                    JdbcExecutor.$anonfun$batch$1(types, stmt, curParam, param);
                    return BoxedUnit.UNIT;
                });
                rows.$plus$plus$eq((TraversableOnce)new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(((PreparedStatement)stmt.elem).executeBatch())));
                conn.commit();
            }
            catch (BatchUpdateException be) {
                conn.rollback();
                this.rethrow(be.getNextException(), sql, (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{(Seq)curParam.elem}));
            }
            catch (SQLException e) {
                conn.rollback();
                this.rethrow(e, sql, (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{(Seq)curParam.elem}));
            }
        }
        finally {
            ((PreparedStatement)stmt.elem).close();
            conn.close();
        }
        return rows.toList();
    }

    public void rethrow(SQLException cause, String sql, Seq<Object> params) {
        String causeMessage = cause.getMessage();
        if (causeMessage == null) {
            causeMessage = "";
        }
        StringBuffer msg = new StringBuffer(causeMessage);
        msg.append(" Query: ").append(sql).append(" Parameters: ");
        StringBuffer stringBuffer = params == null ? msg.append("[]") : msg.append(Strings$.MODULE$.join(params, ","));
        SQLException e = new SQLException(msg.toString(), cause.getSQLState(), cause.getErrorCode());
        e.setNextException(cause);
        throw e;
    }

    private Seq<Object[]> convertToSeq(ResultSet rs) {
        ResultSetMetaData meta = rs.getMetaData();
        int cols = meta.getColumnCount();
        ListBuffer rows = new ListBuffer();
        String string = meta.getColumnName(1);
        String string2 = "_row_nr_";
        int start = !(string != null ? !string.equals(string2) : string2 != null) ? 1 : 0;
        int rowlength = cols - start;
        while (rs.next()) {
            Object[] row = new Object[rowlength];
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(start), cols).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                Object v = rs.getObject(i + 1);
                if (v != null && meta.getColumnType(i + 1) == 93 && !(v instanceof Timestamp)) {
                    if (JdbcExecutor$.MODULE$.oracleTimestampMethod() != null) {
                        v = JdbcExecutor$.MODULE$.oracleTimestampMethod().invoke(v, new Object[0]);
                    } else {
                        throw new Exception("Cannot translate " + v.getClass() + "timestamp to java.sql.Timestamp");
                    }
                }
                row$1[i - start$1] = v;
            });
            rows.$plus$eq((Object)row);
        }
        rs.close();
        return rows;
    }

    public static final /* synthetic */ void $anonfun$batch$1(Seq types$1, ObjectRef stmt$1, ObjectRef curParam$1, Object param) {
        curParam$1.elem = Predef$.MODULE$.genericWrapArray(param);
        ParamSetter$.MODULE$.setParams((PreparedStatement)stmt$1.elem, (Seq<Object>)Predef$.MODULE$.genericWrapArray(param), (Seq<Object>)types$1);
        ((PreparedStatement)stmt$1.elem).addBatch();
    }

    public JdbcExecutor(DataSource dataSource) {
        this.dataSource = dataSource;
        Logging.$init$((Logging)this);
        this.engine = Engines$.MODULE$.forDataSource(dataSource);
        this.sqlTypeMapping = new DefaultSqlTypeMapping(this.engine());
        this.showSql = false;
    }
}

