/*
 * Decompiled with CFR 0.152.
 */
package org.beangle.data.jdbc.dialect;

import java.io.Serializable;
import org.beangle.commons.collection.Collections$;
import org.beangle.data.jdbc.dialect.Dialect;
import org.beangle.data.jdbc.dialect.TableGrammar;
import org.beangle.data.jdbc.meta.Column;
import org.beangle.data.jdbc.meta.Engine;
import org.beangle.data.jdbc.meta.ForeignKey;
import org.beangle.data.jdbc.meta.Index;
import org.beangle.data.jdbc.meta.PrimaryKey;
import org.beangle.data.jdbc.meta.Sequence;
import org.beangle.data.jdbc.meta.Table;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.StringContext;
import scala.collection.IndexedSeq;
import scala.collection.Iterable;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxedUnit;

public final class SQL$ {
    public static SQL$ MODULE$;

    static {
        new SQL$();
    }

    public String insert(Table table) {
        StringBuilder sb = new StringBuilder("insert into ");
        sb.$plus$plus$eq(table.qualifiedName());
        sb.$plus$eq('(');
        sb.$plus$plus$eq(table.quotedColumnNames().mkString(","));
        sb.$plus$plus$eq(") values(");
        sb.$plus$plus$eq(new StringOps(Predef$.MODULE$.augmentString("?,")).$times(table.columns().size()));
        sb.setCharAt(Predef$.MODULE$.SeqCharSequence((IndexedSeq)sb).length() - 1, ')');
        return sb.mkString();
    }

    public String createTable(Table table, Dialect dialect) {
        StringBuilder buf;
        block2: {
            TableGrammar grammar = dialect.tableGrammar();
            buf = new StringBuilder(grammar.createString()).append(' ').append(table.qualifiedName()).append(" (");
            Iterator iter = table.columns().iterator();
            List l = table.columns().toList();
            while (iter.hasNext()) {
                boolean useUniqueConstraint;
                Column col = (Column)iter.next();
                buf.append(col.literalName(dialect.engine())).append(' ');
                buf.append(col.sqlType().name());
                col.defaultValue().foreach((Function1 & Serializable & scala.Serializable)dv -> buf.append(" default ").append(dv));
                StringBuilder stringBuilder = col.nullable() ? buf.append(grammar.nullColumnString()) : buf.append(" not null");
                boolean bl = useUniqueConstraint = col.unique() && (!col.nullable() || grammar.supportsNullUnique());
                Object object = useUniqueConstraint ? (grammar.supportsUnique() ? buf.append(" unique") : BoxedUnit.UNIT) : BoxedUnit.UNIT;
                Object object2 = col.hasCheck() && grammar.supportsColumnCheck() ? buf.append(" check (").append((String)col.check().get()).append(")") : BoxedUnit.UNIT;
                if (!dialect.supportsCommentOn()) {
                    col.comment().foreach((Function1 & Serializable & scala.Serializable)c -> buf.append(grammar.getColumnComment((String)c)));
                }
                Object object3 = iter.hasNext() ? buf.append(", ") : BoxedUnit.UNIT;
            }
            table.primaryKey().foreach((Function1 & Serializable & scala.Serializable)pk -> pk.enabled() ? buf.append(", ").append(MODULE$.primaryKeySql((PrimaryKey)pk, dialect)) : BoxedUnit.UNIT);
            buf.append(')');
            if (dialect.supportsCommentOn()) break block2;
            table.comment().foreach((Function1 & Serializable & scala.Serializable)c -> buf.append(grammar.getComment((String)c)));
        }
        return buf.toString();
    }

    public List<String> commentsOnTable(Table table, Dialect dialect) {
        List list;
        if (dialect.supportsCommentOn()) {
            Buffer comments = Collections$.MODULE$.newBuffer();
            String tableName = table.qualifiedName();
            table.comment().foreach((Function1 & Serializable & scala.Serializable)c -> comments.$plus$eq((Object)("comment on table " + tableName + " is '" + c + "'")));
            table.columns().foreach((Function1 & Serializable & scala.Serializable)c -> {
                SQL$.$anonfun$commentsOnTable$2(comments, tableName, c);
                return BoxedUnit.UNIT;
            });
            list = comments.toList();
        } else {
            list = List$.MODULE$.empty();
        }
        return list;
    }

    public String query(Table table) {
        StringBuilder sb = new StringBuilder();
        sb.append("select ");
        table.quotedColumnNames().foreach((Function1 & Serializable & scala.Serializable)columnName -> sb.append(columnName).append(','));
        sb.deleteCharAt(Predef$.MODULE$.SeqCharSequence((IndexedSeq)sb).length() - 1);
        sb.append(" from ").append(table.qualifiedName());
        return sb.toString();
    }

    public String createSequence(Sequence seq, Dialect dialect) {
        if (dialect.sequenceGrammar() == null) {
            return null;
        }
        String sql = dialect.sequenceGrammar().createSql();
        sql = sql.replace(":name", seq.qualifiedName());
        sql = sql.replace(":start", String.valueOf(seq.current() + 1L));
        sql = sql.replace(":increment", String.valueOf(seq.increment()));
        sql = sql.replace(":cache", String.valueOf(seq.cache()));
        sql = sql.replace(":cycle", seq.cycle() ? "cycle" : "");
        return sql;
    }

    public String dropSequence(Sequence seq, Dialect dialect) {
        if (dialect.sequenceGrammar() == null) {
            return null;
        }
        String sql = dialect.sequenceGrammar().dropSql();
        sql = sql.replace(":name", seq.qualifiedName());
        return sql;
    }

    public String createIndex(Index i) {
        StringBuilder buf = new StringBuilder("create").append(i.unique() ? " unique" : "").append(" index ").append(i.literalName()).append(" on ").append(i.table().qualifiedName()).append(" (");
        Iterator iter = i.columns().iterator();
        while (iter.hasNext()) {
            buf.append(iter.next());
            Object object = iter.hasNext() ? buf.append(", ") : BoxedUnit.UNIT;
        }
        buf.append(")");
        return buf.toString();
    }

    public String dropIndex(Index i) {
        return "drop index " + i.table().qualifiedName() + "." + i.literalName();
    }

    public String alterTableAddforeignKey(ForeignKey fk, Dialect dialect) {
        Predef$.MODULE$.require(fk.name() != null && fk.table() != null && fk.referencedTable() != null);
        Predef$.MODULE$.require(!fk.referencedColumns().isEmpty(), (Function0 & Serializable & scala.Serializable)() -> " reference columns is empty.");
        Predef$.MODULE$.require(!fk.columns().isEmpty(), (Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " column's size should greate than 0"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{fk.name()})));
        Engine engine = fk.table().engine();
        List referencedColumnNames = ((ListBuffer)fk.referencedColumns().map((Function1 & Serializable & scala.Serializable)x -> x.toLiteral(engine), ListBuffer$.MODULE$.canBuildFrom())).toList();
        String result = "alter table " + fk.table().qualifiedName() + dialect.foreignKeySql(fk.literalName(), (Iterable<String>)fk.columnNames(), fk.referencedTable().qualifiedName(), (Iterable<String>)referencedColumnNames);
        return fk.cascadeDelete() && dialect.supportsCascadeDelete() ? result + " on delete cascade" : result;
    }

    public String primaryKeySql(PrimaryKey k, Dialect dialect) {
        StringBuilder buf = new StringBuilder("primary key (");
        Engine engine = dialect.engine();
        k.columns().foreach((Function1 & Serializable & scala.Serializable)col -> buf.append(col.toLiteral(engine)).append(", "));
        Object object = !k.columns().isEmpty() ? buf.delete(buf.size() - 2, buf.size()) : BoxedUnit.UNIT;
        return buf.append(')').result();
    }

    public static final /* synthetic */ void $anonfun$commentsOnTable$2(Buffer comments$1, String tableName$1, Column c) {
        c.comment().foreach((Function1 & Serializable & scala.Serializable)cc -> comments$1.$plus$eq((Object)("comment on column " + tableName$1 + '.' + c.name() + " is '" + cc + "'")));
    }

    private SQL$() {
        MODULE$ = this;
    }
}

