/*
 * Decompiled with CFR 0.152.
 */
package org.beangle.data.jdbc.query;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.io.StringReader;
import java.io.StringWriter;
import java.math.BigDecimal;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZonedDateTime;
import java.util.Calendar;
import org.beangle.commons.io.IOs$;
import org.beangle.commons.logging.Logger;
import org.beangle.commons.logging.Logging;
import scala.Function0;
import scala.MatchError;
import scala.collection.Seq;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class ParamSetter$
implements Logging {
    public static ParamSetter$ MODULE$;
    private final Logger logger;

    static {
        new ParamSetter$();
    }

    public Logger logger() {
        return this.logger;
    }

    public void org$beangle$commons$logging$Logging$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    public void setParam(PreparedStatement stmt, int index, Object value2, int sqltype) {
        try {
            int n = sqltype;
            switch (n) {
                case 1: 
                case 12: {
                    stmt.setString(index, (String)value2);
                    break;
                }
                case -1: {
                    stmt.setCharacterStream(index, new StringReader((String)value2));
                    break;
                }
                case -7: 
                case 16: {
                    Object object = value2;
                    if (object instanceof Boolean) {
                        boolean bl = BoxesRunTime.unboxToBoolean((Object)object);
                        stmt.setBoolean(index, bl);
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        break;
                    }
                    if (object instanceof Number) {
                        Number number = (Number)object;
                        stmt.setBoolean(index, number.intValue() > 0);
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        break;
                    }
                    throw new MatchError(object);
                }
                case -6: 
                case 4: 
                case 5: {
                    stmt.setInt(index, ((Number)value2).intValue());
                    break;
                }
                case -5: {
                    stmt.setLong(index, ((Number)value2).longValue());
                    break;
                }
                case 6: 
                case 8: {
                    if (value2 instanceof BigDecimal) {
                        stmt.setBigDecimal(index, (BigDecimal)value2);
                        break;
                    }
                    stmt.setDouble(index, BoxesRunTime.unboxToDouble((Object)value2));
                    break;
                }
                case 2: 
                case 3: {
                    if (value2 instanceof BigDecimal) {
                        stmt.setBigDecimal(index, (BigDecimal)value2);
                        break;
                    }
                    stmt.setObject(index, value2, sqltype);
                    break;
                }
                case 91: {
                    Object object = value2;
                    if (object instanceof LocalDate) {
                        LocalDate localDate = (LocalDate)object;
                        stmt.setDate(index, Date.valueOf(localDate));
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        break;
                    }
                    if (object instanceof java.util.Date) {
                        BoxedUnit boxedUnit;
                        java.util.Date date = (java.util.Date)object;
                        if (date instanceof Date) {
                            stmt.setDate(index, (Date)date);
                            boxedUnit = BoxedUnit.UNIT;
                        } else {
                            stmt.setDate(index, new Date(date.getTime()));
                            boxedUnit = BoxedUnit.UNIT;
                        }
                        BoxedUnit boxedUnit2 = boxedUnit;
                        break;
                    }
                    if (object instanceof Calendar) {
                        Calendar calendar = (Calendar)object;
                        stmt.setDate(index, new Date(calendar.getTime().getTime()), calendar);
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        break;
                    }
                    stmt.setObject(index, value2, 91);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    break;
                }
                case 92: {
                    Object object = value2;
                    if (object instanceof LocalTime) {
                        LocalTime localTime = (LocalTime)object;
                        stmt.setTime(index, Time.valueOf(localTime));
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        break;
                    }
                    if (object instanceof java.util.Date) {
                        BoxedUnit boxedUnit;
                        java.util.Date date = (java.util.Date)object;
                        if (value2 instanceof Time) {
                            stmt.setTime(index, (Time)value2);
                            boxedUnit = BoxedUnit.UNIT;
                        } else {
                            stmt.setTime(index, new Time(date.getTime()));
                            boxedUnit = BoxedUnit.UNIT;
                        }
                        BoxedUnit boxedUnit3 = boxedUnit;
                        break;
                    }
                    if (object instanceof Calendar) {
                        Calendar calendar = (Calendar)object;
                        stmt.setTime(index, new Time(calendar.getTime().getTime()), calendar);
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        break;
                    }
                    stmt.setObject(index, value2, 92);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    break;
                }
                case 93: {
                    Object object = value2;
                    if (object instanceof Instant) {
                        Instant instant = (Instant)object;
                        stmt.setTimestamp(index, Timestamp.from(instant));
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        break;
                    }
                    if (object instanceof LocalDateTime) {
                        LocalDateTime localDateTime = (LocalDateTime)object;
                        stmt.setTimestamp(index, Timestamp.valueOf(localDateTime));
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        break;
                    }
                    if (object instanceof ZonedDateTime) {
                        ZonedDateTime zonedDateTime = (ZonedDateTime)object;
                        stmt.setTimestamp(index, Timestamp.valueOf(zonedDateTime.toLocalDateTime()));
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        break;
                    }
                    if (object instanceof Timestamp) {
                        Timestamp timestamp = (Timestamp)object;
                        stmt.setTimestamp(index, timestamp);
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        break;
                    }
                    if (object instanceof Calendar) {
                        Calendar calendar = (Calendar)object;
                        stmt.setTimestamp(index, new Timestamp(calendar.getTime().getTime()), calendar);
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        break;
                    }
                    if (object instanceof java.util.Date) {
                        java.util.Date date = (java.util.Date)object;
                        stmt.setTimestamp(index, new Timestamp(date.getTime()));
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        break;
                    }
                    stmt.setObject(index, value2, 93);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    break;
                }
                case -4: 
                case -3: 
                case -2: {
                    if (value2 instanceof byte[]) {
                        byte[] bytes = (byte[])value2;
                        stmt.setBinaryStream(index, (InputStream)new ByteArrayInputStream(bytes), bytes.length);
                        break;
                    }
                    InputStream in = (InputStream)value2;
                    ByteArrayOutputStream out = new ByteArrayOutputStream();
                    IOs$.MODULE$.copy(in, (OutputStream)out);
                    stmt.setBinaryStream(index, in, out.size());
                    break;
                }
                case 2005: {
                    if (this.isStringType(value2.getClass())) {
                        stmt.setString(index, value2.toString());
                        break;
                    }
                    Clob clb = (Clob)value2;
                    ByteArrayOutputStream out = new ByteArrayOutputStream();
                    IOs$.MODULE$.copy(clb.getAsciiStream(), (OutputStream)out);
                    stmt.setAsciiStream(index, clb.getAsciiStream(), out.size());
                    break;
                }
                case 2004: {
                    InputStream in = ((Blob)value2).getBinaryStream();
                    ByteArrayOutputStream out = new ByteArrayOutputStream();
                    IOs$.MODULE$.copy(in, (OutputStream)out);
                    stmt.setBinaryStream(index, in, out.size());
                    break;
                }
                default: {
                    if (0 == sqltype) {
                        stmt.setObject(index, value2);
                        break;
                    }
                    stmt.setObject(index, value2, sqltype);
                    break;
                }
            }
        }
        catch (Exception e) {
            this.logger().error((Function0 & Serializable & scala.Serializable)() -> "set value error", (Function0 & Serializable & scala.Serializable)() -> e);
        }
    }

    public void setParams(PreparedStatement stmt, Seq<Object> params, Seq<Object> types) {
        int paramsCount = params == null ? 0 : params.length();
        int stmtParamCount = types.length();
        int[] sqltypes = (int[])types.toArray(ClassTag$.MODULE$.Int());
        if (stmtParamCount > paramsCount) {
            throw new SQLException("Wrong number of parameters: expected " + stmtParamCount + ", was given " + paramsCount);
        }
        for (int i = 0; i < stmtParamCount; ++i) {
            int index = i + 1;
            if (params.apply(i) == null) {
                stmt.setNull(index, sqltypes[i] == 0 ? 12 : sqltypes[i]);
                continue;
            }
            this.setParam(stmt, index, params.apply(i), sqltypes[i]);
        }
    }

    private boolean isStringType(Class<?> clazz) {
        return CharSequence.class.isAssignableFrom(clazz) || StringWriter.class.isAssignableFrom(clazz);
    }

    private ParamSetter$() {
        MODULE$ = this;
        Logging.$init$((Logging)this);
    }
}

