/*
 * Decompiled with CFR 0.152.
 */
package org.beangle.data.jdbc.query;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.sql.BatchUpdateException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Timestamp;
import javax.sql.DataSource;
import org.beangle.commons.lang.Strings$;
import org.beangle.commons.logging.Logging;
import org.beangle.data.jdbc.DefaultSqlTypeMapping;
import org.beangle.data.jdbc.meta.Engine;
import org.beangle.data.jdbc.meta.Engines$;
import org.beangle.data.jdbc.query.JdbcExecutor$;
import org.beangle.data.jdbc.query.ParamSetter$;
import org.beangle.data.jdbc.query.Statement;
import org.beangle.data.jdbc.query.TypeParamSetter$;
import org.slf4j.Logger;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List$;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.ListBuffer;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\u0005\rx!B\u0001\u0003\u0011\u0003i\u0011\u0001\u0004&eE\u000e,\u00050Z2vi>\u0014(BA\u0002\u0005\u0003\u0015\tX/\u001a:z\u0015\t)a!\u0001\u0003kI\n\u001c'BA\u0004\t\u0003\u0011!\u0017\r^1\u000b\u0005%Q\u0011a\u00022fC:<G.\u001a\u0006\u0002\u0017\u0005\u0019qN]4\u0004\u0001A\u0011abD\u0007\u0002\u0005\u0019)\u0001C\u0001E\u0001#\ta!\n\u001a2d\u000bb,7-\u001e;peN\u0011qB\u0005\t\u0003'Yi\u0011\u0001\u0006\u0006\u0002+\u0005)1oY1mC&\u0011q\u0003\u0006\u0002\u0007\u0003:L(+\u001a4\t\u000beyA\u0011\u0001\u000e\u0002\rqJg.\u001b;?)\u0005i\u0001\"\u0003\u000f\u0010\u0001\u0004\u0005\r\u0011\"\u0001\u001e\u0003Uy'/Y2mKRKW.Z:uC6\u0004X*\u001a;i_\u0012,\u0012A\b\t\u0003?\u0019j\u0011\u0001\t\u0006\u0003C\t\nqA]3gY\u0016\u001cGO\u0003\u0002$I\u0005!A.\u00198h\u0015\u0005)\u0013\u0001\u00026bm\u0006L!a\n\u0011\u0003\r5+G\u000f[8e\u0011%Is\u00021AA\u0002\u0013\u0005!&A\rpe\u0006\u001cG.\u001a+j[\u0016\u001cH/Y7q\u001b\u0016$\bn\u001c3`I\u0015\fHCA\u0016/!\t\u0019B&\u0003\u0002.)\t!QK\\5u\u0011\u001dy\u0003&!AA\u0002y\t1\u0001\u001f\u00132\u0011%\tt\u00021A\u0001B\u0003&a$\u0001\fpe\u0006\u001cG.\u001a+j[\u0016\u001cH/Y7q\u001b\u0016$\bn\u001c3!\r\u0011\u0001\"\u0001A\u001a\u0014\u0007I\u0012B\u0007\u0005\u00026u5\taG\u0003\u00028q\u00059An\\4hS:<'BA\u001d\t\u0003\u001d\u0019w.\\7p]NL!a\u000f\u001c\u0003\u000f1{wmZ5oO\"AQH\rB\u0001B\u0003%a(\u0001\u0006eCR\f7k\\;sG\u0016\u0004\"a\u0010#\u000e\u0003\u0001S!!\u0011\"\u0002\u0007M\fHNC\u0001D\u0003\u0015Q\u0017M^1y\u0013\t)\u0005I\u0001\u0006ECR\f7k\\;sG\u0016DQ!\u0007\u001a\u0005\u0002\u001d#\"\u0001S%\u0011\u00059\u0011\u0004\"B\u001fG\u0001\u0004q\u0004bB&3\u0005\u0004%\t\u0001T\u0001\u0007K:<\u0017N\\3\u0016\u00035\u0003\"AT)\u000e\u0003=S!\u0001\u0015\u0003\u0002\t5,G/Y\u0005\u0003%>\u0013a!\u00128hS:,\u0007B\u0002+3A\u0003%Q*A\u0004f]\u001eLg.\u001a\u0011\t\u000fY\u0013$\u0019!C\u0001/\u0006q1/\u001d7UsB,W*\u00199qS:<W#\u0001-\u0011\u0005eSV\"\u0001\u0003\n\u0005m#!!\u0006#fM\u0006,H\u000e^*rYRK\b/Z'baBLgn\u001a\u0005\u0007;J\u0002\u000b\u0011\u0002-\u0002\u001fM\fH\u000eV=qK6\u000b\u0007\u000f]5oO\u0002Bqa\u0018\u001aA\u0002\u0013\u0005\u0001-A\u0004tQ><8+\u001d7\u0016\u0003\u0005\u0004\"a\u00052\n\u0005\r$\"a\u0002\"p_2,\u0017M\u001c\u0005\bKJ\u0002\r\u0011\"\u0001g\u0003-\u0019\bn\\<Tc2|F%Z9\u0015\u0005-:\u0007bB\u0018e\u0003\u0003\u0005\r!\u0019\u0005\u0007SJ\u0002\u000b\u0015B1\u0002\u0011MDwn^*rY\u0002BQa\u001b\u001a\u0005\u00021\fa!\u001e8jcV,WCA7t)\u0011qG0!\u0005\u0011\u0007My\u0017/\u0003\u0002q)\t1q\n\u001d;j_:\u0004\"A]:\r\u0001\u0011)AO\u001bb\u0001k\n\tA+\u0005\u0002wsB\u00111c^\u0005\u0003qR\u0011qAT8uQ&tw\r\u0005\u0002\u0014u&\u00111\u0010\u0006\u0002\u0004\u0003:L\b\"B!k\u0001\u0004i\bc\u0001@\u0002\f9\u0019q0a\u0002\u0011\u0007\u0005\u0005A#\u0004\u0002\u0002\u0004)\u0019\u0011Q\u0001\u0007\u0002\rq\u0012xn\u001c;?\u0013\r\tI\u0001F\u0001\u0007!J,G-\u001a4\n\t\u00055\u0011q\u0002\u0002\u0007'R\u0014\u0018N\\4\u000b\u0007\u0005%A\u0003C\u0004\u0002\u0014)\u0004\r!!\u0006\u0002\rA\f'/Y7t!\u0011\u0019\u0012qC=\n\u0007\u0005eAC\u0001\u0006=e\u0016\u0004X-\u0019;fIzBq!!\b3\t\u0003\ty\"A\u0006rk\u0016\u0014\u0018PR8s\u0013:$H\u0003BA\u0011\u0003S\u0001BaE8\u0002$A\u00191#!\n\n\u0007\u0005\u001dBCA\u0002J]RDa!QA\u000e\u0001\u0004i\bbBA\u0017e\u0011\u0005\u0011qF\u0001\rcV,'/\u001f$pe2{gn\u001a\u000b\u0005\u0003c\tI\u0004\u0005\u0003\u0014_\u0006M\u0002cA\n\u00026%\u0019\u0011q\u0007\u000b\u0003\t1{gn\u001a\u0005\u0007\u0003\u0006-\u0002\u0019A?\t\u000f\u0005u\"\u0007\"\u0001\u0002@\u0005iq-\u001a;D_:tWm\u0019;j_:$\"!!\u0011\u0011\t\u0005\r\u0013qI\u0007\u0003\u0003\u000bR!!\u0011\u0013\n\t\u0005%\u0013Q\t\u0002\u000b\u0007>tg.Z2uS>t\u0007bBA'e\u0011\u0005\u0011qJ\u0001\ngR\fG/Z7f]R$B!!\u0015\u0002XA\u0019a\"a\u0015\n\u0007\u0005U#AA\u0005Ti\u0006$X-\\3oi\"1\u0011)a\u0013A\u0002uDaa\u0001\u001a\u0005\u0002\u0005mCCBA/\u0003k\n9\b\u0005\u0004\u0002`\u0005%\u0014q\u000e\b\u0005\u0003C\n)G\u0004\u0003\u0002\u0002\u0005\r\u0014\"A\u000b\n\u0007\u0005\u001dD#A\u0004qC\u000e\\\u0017mZ3\n\t\u0005-\u0014Q\u000e\u0002\u0004'\u0016\f(bAA4)A!1#!\u001dz\u0013\r\t\u0019\b\u0006\u0002\u0006\u0003J\u0014\u0018-\u001f\u0005\u0007\u0003\u0006e\u0003\u0019A?\t\u0011\u0005M\u0011\u0011\fa\u0001\u0003+Aaa\u0001\u001a\u0005\u0002\u0005mDCBA/\u0003{\ny\b\u0003\u0004B\u0003s\u0002\r! \u0005\t\u0003\u0003\u000bI\b1\u0001\u0002\u0004\u000611/\u001a;uKJ\u0004baEAC\u0003\u0013[\u0013bAAD)\tIa)\u001e8di&|g.\r\t\u0005\u0003\u0007\nY)\u0003\u0003\u0002\u000e\u0006\u0015#!\u0005)sKB\f'/\u001a3Ti\u0006$X-\\3oi\"9\u0011\u0011\u0013\u001a\u0005\u0002\u0005M\u0015AB;qI\u0006$X\r\u0006\u0004\u0002$\u0005U\u0015q\u0013\u0005\u0007\u0003\u0006=\u0005\u0019A?\t\u0011\u0005M\u0011q\u0012a\u0001\u0003+Aq!!%3\t\u0003\tY\n\u0006\u0004\u0002$\u0005u\u0015q\u0014\u0005\u0007\u0003\u0006e\u0005\u0019A?\t\u0011\u0005\u0005\u0015\u0011\u0014a\u0001\u0003\u0007Cq!a)3\t\u0003\t)+A\u0003cCR\u001c\u0007\u000e\u0006\u0005\u0002(\u0006%\u00161VA^!\u0019\ty&!\u001b\u0002$!1\u0011)!)A\u0002uD\u0001\"!,\u0002\"\u0002\u0007\u0011qV\u0001\u0006I\u0006$\u0018m\u001d\t\u0007\u0003?\nI'!-1\t\u0005M\u0016q\u0017\t\u0006'\u0005E\u0014Q\u0017\t\u0004e\u0006]FaCA]\u0003W\u000b\t\u0011!A\u0003\u0002U\u00141a\u0018\u00132\u0011!\ti,!)A\u0002\u0005\u001d\u0016!\u0002;za\u0016\u001c\bbBAae\u0011E\u00111Y\u0001\be\u0016$\bN]8x)\u001dY\u0013QYAh\u0003#D\u0001\"a2\u0002@\u0002\u0007\u0011\u0011Z\u0001\u0006G\u0006,8/\u001a\t\u0005\u0003\u0007\nY-\u0003\u0003\u0002N\u0006\u0015#\u0001D*R\u0019\u0016C8-\u001a9uS>t\u0007BB!\u0002@\u0002\u0007Q\u0010\u0003\u0005\u0002\u0014\u0005}\u0006\u0019AA\u000b\u0011\u001d\t)N\rC\u0005\u0003/\fAbY8om\u0016\u0014H\u000fV8TKF$B!!\u0018\u0002Z\"A\u00111\\Aj\u0001\u0004\ti.\u0001\u0002sgB!\u00111IAp\u0013\u0011\t\t/!\u0012\u0003\u0013I+7/\u001e7u'\u0016$\b")
public class JdbcExecutor
implements Logging {
    private final DataSource dataSource;
    private final Engine engine;
    private final DefaultSqlTypeMapping sqlTypeMapping;
    private boolean showSql;
    private final Logger logger;

    public static void oracleTimestampMethod_$eq(Method method) {
        JdbcExecutor$.MODULE$.oracleTimestampMethod_$eq(method);
    }

    public static Method oracleTimestampMethod() {
        return JdbcExecutor$.MODULE$.oracleTimestampMethod();
    }

    public Logger logger() {
        return this.logger;
    }

    public void org$beangle$commons$logging$Logging$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    public Engine engine() {
        return this.engine;
    }

    public DefaultSqlTypeMapping sqlTypeMapping() {
        return this.sqlTypeMapping;
    }

    public boolean showSql() {
        return this.showSql;
    }

    public void showSql_$eq(boolean x$1) {
        this.showSql = x$1;
    }

    public <T> Option<T> unique(String sql, Seq<Object> params) {
        Seq<Object[]> rs = this.query(sql, (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{params}));
        return rs.isEmpty() ? None$.MODULE$ : new Some(Predef$.MODULE$.genericArrayOps(rs.head()).head());
    }

    public Option<Object> queryForInt(String sql) {
        None$ none$;
        Option num = this.unique(sql, (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[0]));
        Option option = num;
        if (option instanceof Some) {
            Some some = (Some)option;
            Number n = (Number)some.value();
            none$ = new Some((Object)BoxesRunTime.boxToInteger((int)n.intValue()));
        } else if (None$.MODULE$.equals(option)) {
            none$ = None$.MODULE$;
        } else {
            throw new MatchError(option);
        }
        return none$;
    }

    public Option<Object> queryForLong(String sql) {
        None$ none$;
        Option num = this.unique(sql, (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[0]));
        Option option = num;
        if (option instanceof Some) {
            Some some = (Some)option;
            Number n = (Number)some.value();
            none$ = new Some((Object)BoxesRunTime.boxToLong((long)n.longValue()));
        } else if (None$.MODULE$.equals(option)) {
            none$ = None$.MODULE$;
        } else {
            throw new MatchError(option);
        }
        return none$;
    }

    public Connection getConnection() {
        return this.dataSource.getConnection();
    }

    public Statement statement(String sql) {
        return new Statement(sql, this);
    }

    public Seq<Object[]> query(String sql, Seq<Object> params) {
        return this.query(sql, TypeParamSetter$.MODULE$.apply(this.sqlTypeMapping(), params));
    }

    public Seq<Object[]> query(String sql, Function1<PreparedStatement, BoxedUnit> setter) {
        Seq<Object[]> seq;
        if (this.showSql()) {
            Predef$.MODULE$.println((Object)("JdbcExecutor:" + sql));
        }
        Connection conn = this.getConnection();
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            try {
                stmt = conn.prepareStatement(sql);
                setter.apply((Object)stmt);
                rs = stmt.executeQuery();
                seq = this.convertToSeq(rs);
            }
            catch (SQLException e) {
                this.rethrow(e, sql, (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[0]));
                seq = List$.MODULE$.empty();
            }
        }
        finally {
            if (rs != null) {
                rs.close();
            }
            if (stmt != null) {
                stmt.close();
            }
            conn.close();
        }
        return seq;
    }

    public int update(String sql, Seq<Object> params) {
        return this.update(sql, TypeParamSetter$.MODULE$.apply(this.sqlTypeMapping(), params));
    }

    public int update(String sql, Function1<PreparedStatement, BoxedUnit> setter) {
        if (this.showSql()) {
            Predef$.MODULE$.println((Object)("JdbcExecutor:" + sql));
        }
        PreparedStatement stmt = null;
        Connection conn = this.getConnection();
        if (conn.getAutoCommit()) {
            conn.setAutoCommit(false);
        }
        int rows = 0;
        try {
            try {
                stmt = conn.prepareStatement(sql);
                setter.apply((Object)stmt);
                rows = stmt.executeUpdate();
                stmt.close();
                stmt = null;
                conn.commit();
            }
            catch (SQLException e) {
                conn.rollback();
                this.rethrow(e, sql, (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[0]));
            }
        }
        finally {
            if (stmt != null) {
                stmt.close();
            }
            conn.close();
        }
        return rows;
    }

    public Seq<Object> batch(String sql, Seq<Object> datas, Seq<Object> types) {
        if (this.showSql()) {
            Predef$.MODULE$.println((Object)("JdbcExecutor:" + sql));
        }
        ObjectRef stmt = ObjectRef.create(null);
        Connection conn = this.getConnection();
        if (conn.getAutoCommit()) {
            conn.setAutoCommit(false);
        }
        ListBuffer rows = new ListBuffer();
        ObjectRef curParam = ObjectRef.create(null);
        try {
            try {
                stmt.elem = conn.prepareStatement(sql);
                datas.foreach((Function1 & Serializable & scala.Serializable)param -> {
                    JdbcExecutor.$anonfun$batch$1(types, stmt, curParam, param);
                    return BoxedUnit.UNIT;
                });
                rows.$plus$plus$eq((TraversableOnce)new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(((PreparedStatement)stmt.elem).executeBatch())));
                conn.commit();
            }
            catch (BatchUpdateException be) {
                conn.rollback();
                this.rethrow(be.getNextException(), sql, (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{(Seq)curParam.elem}));
            }
            catch (SQLException e) {
                conn.rollback();
                this.rethrow(e, sql, (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{(Seq)curParam.elem}));
            }
        }
        finally {
            ((PreparedStatement)stmt.elem).close();
            conn.close();
        }
        return rows.toList();
    }

    public void rethrow(SQLException cause, String sql, Seq<Object> params) {
        String causeMessage = cause.getMessage();
        if (causeMessage == null) {
            causeMessage = "";
        }
        StringBuffer msg = new StringBuffer(causeMessage);
        msg.append(" Query: ").append(sql).append(" Parameters: ");
        StringBuffer stringBuffer = params == null ? msg.append("[]") : msg.append(Strings$.MODULE$.join(params, ","));
        SQLException e = new SQLException(msg.toString(), cause.getSQLState(), cause.getErrorCode());
        e.setNextException(cause);
        throw e;
    }

    private Seq<Object[]> convertToSeq(ResultSet rs) {
        ResultSetMetaData meta = rs.getMetaData();
        int cols = meta.getColumnCount();
        ListBuffer rows = new ListBuffer();
        String string = meta.getColumnName(1);
        String string2 = "_row_nr_";
        int start = !(string != null ? !string.equals(string2) : string2 != null) ? 1 : 0;
        int rowlength = cols - start;
        while (rs.next()) {
            Object[] row = new Object[rowlength];
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(start), cols).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                Object v = rs.getObject(i + 1);
                if (v != null && meta.getColumnType(i + 1) == 93 && !(v instanceof Timestamp)) {
                    if (JdbcExecutor$.MODULE$.oracleTimestampMethod() != null) {
                        v = JdbcExecutor$.MODULE$.oracleTimestampMethod().invoke(v, new Object[0]);
                    } else {
                        throw new Exception("Cannot translate " + v.getClass() + "timestamp to java.sql.Timestamp");
                    }
                }
                row$1[i - start$1] = v;
            });
            rows.$plus$eq((Object)row);
        }
        rs.close();
        return rows;
    }

    public static final /* synthetic */ void $anonfun$batch$1(Seq types$1, ObjectRef stmt$1, ObjectRef curParam$1, Object param) {
        curParam$1.elem = Predef$.MODULE$.genericWrapArray(param);
        ParamSetter$.MODULE$.setParams((PreparedStatement)stmt$1.elem, (Seq<Object>)Predef$.MODULE$.genericWrapArray(param), (Seq<Object>)types$1);
        ((PreparedStatement)stmt$1.elem).addBatch();
    }

    public JdbcExecutor(DataSource dataSource) {
        this.dataSource = dataSource;
        Logging.$init$((Logging)this);
        this.engine = Engines$.MODULE$.forDataSource(dataSource);
        this.sqlTypeMapping = new DefaultSqlTypeMapping(this.engine());
        this.showSql = false;
    }
}

