/*
 * Decompiled with CFR 0.152.
 */
package org.beangle.data.jdbc.meta;

import java.sql.Connection;
import javax.sql.DataSource;
import org.beangle.commons.lang.Strings$;
import org.beangle.data.jdbc.meta.AbstractEngine;
import org.beangle.data.jdbc.meta.Engine;
import org.beangle.data.jdbc.meta.Engines$DB2$;
import org.beangle.data.jdbc.meta.Engines$H2$;
import org.beangle.data.jdbc.meta.Engines$HSQL$;
import org.beangle.data.jdbc.meta.Engines$MySQL$;
import org.beangle.data.jdbc.meta.Engines$Oracle$;
import org.beangle.data.jdbc.meta.Engines$PostgreSQL$;
import org.beangle.data.jdbc.meta.Engines$SQLServer$;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.Map;

public final class Engines$ {
    public static Engines$ MODULE$;
    private final Map<String, AbstractEngine> name2Engines;

    static {
        new Engines$();
    }

    private Map<String, AbstractEngine> name2Engines() {
        return this.name2Engines;
    }

    public Engine forDataSource(DataSource ds) {
        Connection connection = ds.getConnection();
        String name = connection.getMetaData().getDatabaseProductName();
        connection.close();
        return this.forName(name);
    }

    public Engine forName(String databaseName) {
        AbstractEngine abstractEngine;
        String name = Strings$.MODULE$.capitalize(databaseName);
        name = name.replace("sql", "SQL");
        Option option = this.name2Engines().get((Object)name);
        if (option instanceof Some) {
            AbstractEngine engine;
            Some some = (Some)option;
            abstractEngine = engine = (AbstractEngine)some.value();
        } else if (None$.MODULE$.equals(option)) {
            AbstractEngine abstractEngine2;
            if (databaseName.startsWith("DB2/")) {
                abstractEngine2 = Engines$DB2$.MODULE$;
            } else if (databaseName.startsWith("Microsoft SQL Server")) {
                abstractEngine2 = Engines$SQLServer$.MODULE$;
            } else {
                throw new RuntimeException(new StringBuilder(32).append("Cannot find engine for database ").append(databaseName).toString());
            }
            abstractEngine = abstractEngine2;
        } else {
            throw new MatchError((Object)option);
        }
        return abstractEngine;
    }

    private Engines$() {
        MODULE$ = this;
        this.name2Engines = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"PostgreSQL"), (Object)Engines$PostgreSQL$.MODULE$), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"MySQL"), (Object)Engines$MySQL$.MODULE$), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"H2"), (Object)Engines$H2$.MODULE$), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"HSQL Database Engine"), (Object)Engines$HSQL$.MODULE$), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"Oracle"), (Object)Engines$Oracle$.MODULE$)}));
    }
}

