/*
 * Decompiled with CFR 0.152.
 */
package org.beangle.data.jdbc.query;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.sql.BatchUpdateException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Timestamp;
import javax.sql.DataSource;
import org.beangle.commons.lang.Strings$;
import org.beangle.commons.logging.Logging;
import org.beangle.data.jdbc.DefaultSqlTypeMapping;
import org.beangle.data.jdbc.meta.Engine;
import org.beangle.data.jdbc.meta.Engines$;
import org.beangle.data.jdbc.query.JdbcExecutor$;
import org.beangle.data.jdbc.query.ParamSetter$;
import org.beangle.data.jdbc.query.Statement;
import org.beangle.data.jdbc.query.TypeParamSetter$;
import org.slf4j.Logger;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List$;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.ListBuffer;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\u0005\rx!\u0002\u000f\u001e\u0011\u0003Ac!\u0002\u0016\u001e\u0011\u0003Y\u0003\"\u0002\u001a\u0002\t\u0003\u0019\u0004\"\u0003\u001b\u0002\u0001\u0004\u0005\r\u0011\"\u00016\u0011%\u0001\u0015\u00011AA\u0002\u0013\u0005\u0011\tC\u0005H\u0003\u0001\u0007\t\u0011)Q\u0005m\u0019!!&\b\u0001I\u0011!\tfA!A!\u0002\u0013\u0011\u0006\"\u0002\u001a\u0007\t\u0003Q\u0006bB/\u0007\u0005\u0004%\tA\u0018\u0005\u0007K\u001a\u0001\u000b\u0011B0\t\u000f\u00194!\u0019!C\u0001O\"1AN\u0002Q\u0001\n!Dq!\u001c\u0004A\u0002\u0013\u0005a\u000eC\u0004s\r\u0001\u0007I\u0011A:\t\rU4\u0001\u0015)\u0003p\u0011\u00151h\u0001\"\u0001x\u0011\u001d\t\tD\u0002C\u0001\u0003gAq!a\u0010\u0007\t\u0003\t\t\u0005C\u0004\u0002N\u0019!\t!a\u0014\t\u000f\u0005mc\u0001\"\u0001\u0002^!1aD\u0002C\u0001\u0003OBaA\b\u0004\u0005\u0002\u0005\u0015\u0005bBAM\r\u0011\u0005\u00111\u0014\u0005\b\u000333A\u0011AAQ\u0011\u001d\t9K\u0002C\u0001\u0003SCq!a1\u0007\t#\t)\rC\u0004\u0002V\u001a!I!a6\u0002\u0019)#'mY#yK\u000e,Ho\u001c:\u000b\u0005yy\u0012!B9vKJL(B\u0001\u0011\"\u0003\u0011QGMY2\u000b\u0005\t\u001a\u0013\u0001\u00023bi\u0006T!\u0001J\u0013\u0002\u000f\t,\u0017M\\4mK*\ta%A\u0002pe\u001e\u001c\u0001\u0001\u0005\u0002*\u00035\tQD\u0001\u0007KI\n\u001cW\t_3dkR|'o\u0005\u0002\u0002YA\u0011Q\u0006M\u0007\u0002])\tq&A\u0003tG\u0006d\u0017-\u0003\u00022]\t1\u0011I\\=SK\u001a\fa\u0001P5oSRtD#\u0001\u0015\u0002+=\u0014\u0018m\u00197f)&lWm\u001d;b[BlU\r\u001e5pIV\ta\u0007\u0005\u00028}5\t\u0001H\u0003\u0002:u\u00059!/\u001a4mK\u000e$(BA\u001e=\u0003\u0011a\u0017M\\4\u000b\u0003u\nAA[1wC&\u0011q\b\u000f\u0002\u0007\u001b\u0016$\bn\u001c3\u00023=\u0014\u0018m\u00197f)&lWm\u001d;b[BlU\r\u001e5pI~#S-\u001d\u000b\u0003\u0005\u0016\u0003\"!L\"\n\u0005\u0011s#\u0001B+oSRDqA\u0012\u0003\u0002\u0002\u0003\u0007a'A\u0002yIE\nac\u001c:bG2,G+[7fgR\fW\u000e]'fi\"|G\rI\n\u0004\r1J\u0005C\u0001&P\u001b\u0005Y%B\u0001'N\u0003\u001dawnZ4j]\u001eT!AT\u0012\u0002\u000f\r|W.\\8og&\u0011\u0001k\u0013\u0002\b\u0019><w-\u001b8h\u0003)!\u0017\r^1T_V\u00148-\u001a\t\u0003'bk\u0011\u0001\u0016\u0006\u0003+Z\u000b1a]9m\u0015\u00059\u0016!\u00026bm\u0006D\u0018BA-U\u0005)!\u0015\r^1T_V\u00148-\u001a\u000b\u00037r\u0003\"!\u000b\u0004\t\u000bEC\u0001\u0019\u0001*\u0002\r\u0015tw-\u001b8f+\u0005y\u0006C\u00011d\u001b\u0005\t'B\u00012 \u0003\u0011iW\r^1\n\u0005\u0011\f'AB#oO&tW-A\u0004f]\u001eLg.\u001a\u0011\u0002\u001dM\fH\u000eV=qK6\u000b\u0007\u000f]5oOV\t\u0001\u000e\u0005\u0002jU6\tq$\u0003\u0002l?\t)B)\u001a4bk2$8+\u001d7UsB,W*\u00199qS:<\u0017aD:rYRK\b/Z'baBLgn\u001a\u0011\u0002\u000fMDwn^*rYV\tq\u000e\u0005\u0002.a&\u0011\u0011O\f\u0002\b\u0005>|G.Z1o\u0003-\u0019\bn\\<Tc2|F%Z9\u0015\u0005\t#\bb\u0002$\u000f\u0003\u0003\u0005\ra\\\u0001\tg\"|woU9mA\u00051QO\\5rk\u0016,\"\u0001\u001f@\u0015\u000be\fy!a\n\u0011\u00075RH0\u0003\u0002|]\t1q\n\u001d;j_:\u0004\"! @\r\u0001\u00111q\u0010\u0005b\u0001\u0003\u0003\u0011\u0011\u0001V\t\u0005\u0003\u0007\tI\u0001E\u0002.\u0003\u000bI1!a\u0002/\u0005\u001dqu\u000e\u001e5j]\u001e\u00042!LA\u0006\u0013\r\tiA\f\u0002\u0004\u0003:L\bBB+\u0011\u0001\u0004\t\t\u0002\u0005\u0003\u0002\u0014\u0005\u0005b\u0002BA\u000b\u0003;\u00012!a\u0006/\u001b\t\tIBC\u0002\u0002\u001c\u001d\na\u0001\u0010:p_Rt\u0014bAA\u0010]\u00051\u0001K]3eK\u001aLA!a\t\u0002&\t11\u000b\u001e:j]\u001eT1!a\b/\u0011\u001d\tI\u0003\u0005a\u0001\u0003W\ta\u0001]1sC6\u001c\b#B\u0017\u0002.\u0005%\u0011bAA\u0018]\tQAH]3qK\u0006$X\r\u001a \u0002\u0017E,XM]=G_JLe\u000e\u001e\u000b\u0005\u0003k\ti\u0004\u0005\u0003.u\u0006]\u0002cA\u0017\u0002:%\u0019\u00111\b\u0018\u0003\u0007%sG\u000f\u0003\u0004V#\u0001\u0007\u0011\u0011C\u0001\rcV,'/\u001f$pe2{gn\u001a\u000b\u0005\u0003\u0007\nY\u0005\u0005\u0003.u\u0006\u0015\u0003cA\u0017\u0002H%\u0019\u0011\u0011\n\u0018\u0003\t1{gn\u001a\u0005\u0007+J\u0001\r!!\u0005\u0002\u001b\u001d,GoQ8o]\u0016\u001cG/[8o)\t\t\t\u0006\u0005\u0003\u0002T\u0005]SBAA+\u0015\t)F(\u0003\u0003\u0002Z\u0005U#AC\"p]:,7\r^5p]\u0006I1\u000f^1uK6,g\u000e\u001e\u000b\u0005\u0003?\n)\u0007E\u0002*\u0003CJ1!a\u0019\u001e\u0005%\u0019F/\u0019;f[\u0016tG\u000f\u0003\u0004V)\u0001\u0007\u0011\u0011\u0003\u000b\u0007\u0003S\n\t)a!\u0011\r\u0005-\u0014QOA>\u001d\u0011\ti'!\u001d\u000f\t\u0005]\u0011qN\u0005\u0002_%\u0019\u00111\u000f\u0018\u0002\u000fA\f7m[1hK&!\u0011qOA=\u0005\r\u0019V-\u001d\u0006\u0004\u0003gr\u0003#B\u0017\u0002~\u0005%\u0011bAA@]\t)\u0011I\u001d:bs\"1Q+\u0006a\u0001\u0003#Aq!!\u000b\u0016\u0001\u0004\tY\u0003\u0006\u0004\u0002j\u0005\u001d\u0015\u0011\u0012\u0005\u0007+Z\u0001\r!!\u0005\t\u000f\u0005-e\u00031\u0001\u0002\u000e\u000611/\u001a;uKJ\u0004b!LAH\u0003'\u0013\u0015bAAI]\tIa)\u001e8di&|g.\r\t\u0005\u0003'\n)*\u0003\u0003\u0002\u0018\u0006U#!\u0005)sKB\f'/\u001a3Ti\u0006$X-\\3oi\u00061Q\u000f\u001d3bi\u0016$b!a\u000e\u0002\u001e\u0006}\u0005BB+\u0018\u0001\u0004\t\t\u0002C\u0004\u0002*]\u0001\r!a\u000b\u0015\r\u0005]\u00121UAS\u0011\u0019)\u0006\u00041\u0001\u0002\u0012!9\u00111\u0012\rA\u0002\u00055\u0015!\u00022bi\u000eDG\u0003CAV\u0003[\u000by+a0\u0011\r\u0005-\u0014QOA\u001c\u0011\u0019)\u0016\u00041\u0001\u0002\u0012!9\u0011\u0011W\rA\u0002\u0005M\u0016!\u00023bi\u0006\u001c\bCBA6\u0003k\n)\f\r\u0003\u00028\u0006m\u0006#B\u0017\u0002~\u0005e\u0006cA?\u0002<\u0012a\u0011QXAX\u0003\u0003\u0005\tQ!\u0001\u0002\u0002\t\u0019q\fJ\u0019\t\u000f\u0005\u0005\u0017\u00041\u0001\u0002,\u0006)A/\u001f9fg\u00069!/\u001a;ie><Hc\u0002\"\u0002H\u0006E\u00171\u001b\u0005\b\u0003\u0013T\u0002\u0019AAf\u0003\u0015\u0019\u0017-^:f!\u0011\t\u0019&!4\n\t\u0005=\u0017Q\u000b\u0002\r'FcU\t_2faRLwN\u001c\u0005\u0007+j\u0001\r!!\u0005\t\u000f\u0005%\"\u00041\u0001\u0002,\u0005a1m\u001c8wKJ$Hk\\*fcR!\u0011\u0011NAm\u0011\u001d\tYn\u0007a\u0001\u0003;\f!A]:\u0011\t\u0005M\u0013q\\\u0005\u0005\u0003C\f)FA\u0005SKN,H\u000e^*fi\u0002")
public class JdbcExecutor
implements Logging {
    private final DataSource dataSource;
    private final Engine engine;
    private final DefaultSqlTypeMapping sqlTypeMapping;
    private boolean showSql;
    private final Logger logger;

    public static void oracleTimestampMethod_$eq(Method method) {
        JdbcExecutor$.MODULE$.oracleTimestampMethod_$eq(method);
    }

    public static Method oracleTimestampMethod() {
        return JdbcExecutor$.MODULE$.oracleTimestampMethod();
    }

    public Logger logger() {
        return this.logger;
    }

    public void org$beangle$commons$logging$Logging$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    public Engine engine() {
        return this.engine;
    }

    public DefaultSqlTypeMapping sqlTypeMapping() {
        return this.sqlTypeMapping;
    }

    public boolean showSql() {
        return this.showSql;
    }

    public void showSql_$eq(boolean x$1) {
        this.showSql = x$1;
    }

    public <T> Option<T> unique(String sql, Seq<Object> params) {
        Seq<Object[]> rs = this.query(sql, params);
        return rs.isEmpty() ? None$.MODULE$ : new Some(Predef$.MODULE$.genericArrayOps(rs.head()).head());
    }

    public Option<Object> queryForInt(String sql) {
        None$ none$;
        Option num = this.unique(sql, (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[0]));
        Option option = num;
        if (option instanceof Some) {
            Some some = (Some)option;
            Number n = (Number)some.value();
            none$ = new Some((Object)BoxesRunTime.boxToInteger((int)n.intValue()));
        } else if (None$.MODULE$.equals(option)) {
            none$ = None$.MODULE$;
        } else {
            throw new MatchError(option);
        }
        return none$;
    }

    public Option<Object> queryForLong(String sql) {
        None$ none$;
        Option num = this.unique(sql, (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[0]));
        Option option = num;
        if (option instanceof Some) {
            Some some = (Some)option;
            Number n = (Number)some.value();
            none$ = new Some((Object)BoxesRunTime.boxToLong((long)n.longValue()));
        } else if (None$.MODULE$.equals(option)) {
            none$ = None$.MODULE$;
        } else {
            throw new MatchError(option);
        }
        return none$;
    }

    public Connection getConnection() {
        return this.dataSource.getConnection();
    }

    public Statement statement(String sql) {
        return new Statement(sql, this);
    }

    public Seq<Object[]> query(String sql, Seq<Object> params) {
        return this.query(sql, TypeParamSetter$.MODULE$.apply(this.sqlTypeMapping(), params));
    }

    public Seq<Object[]> query(String sql, Function1<PreparedStatement, BoxedUnit> setter) {
        Seq<Object[]> seq;
        if (this.showSql()) {
            Predef$.MODULE$.println((Object)new StringBuilder(13).append("JdbcExecutor:").append(sql).toString());
        }
        Connection conn = this.getConnection();
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            try {
                stmt = conn.prepareStatement(sql);
                setter.apply((Object)stmt);
                rs = stmt.executeQuery();
                seq = this.convertToSeq(rs);
            }
            catch (SQLException e) {
                this.rethrow(e, sql, (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[0]));
                seq = List$.MODULE$.empty();
            }
        }
        finally {
            if (rs != null) {
                rs.close();
            }
            if (stmt != null) {
                stmt.close();
            }
            conn.close();
        }
        return seq;
    }

    public int update(String sql, Seq<Object> params) {
        return this.update(sql, TypeParamSetter$.MODULE$.apply(this.sqlTypeMapping(), params));
    }

    public int update(String sql, Function1<PreparedStatement, BoxedUnit> setter) {
        if (this.showSql()) {
            Predef$.MODULE$.println((Object)new StringBuilder(13).append("JdbcExecutor:").append(sql).toString());
        }
        PreparedStatement stmt = null;
        Connection conn = this.getConnection();
        if (conn.getAutoCommit()) {
            conn.setAutoCommit(false);
        }
        int rows = 0;
        try {
            try {
                stmt = conn.prepareStatement(sql);
                setter.apply((Object)stmt);
                rows = stmt.executeUpdate();
                stmt.close();
                stmt = null;
                conn.commit();
            }
            catch (SQLException e) {
                conn.rollback();
                this.rethrow(e, sql, (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[0]));
            }
        }
        finally {
            if (stmt != null) {
                stmt.close();
            }
            conn.close();
        }
        return rows;
    }

    public Seq<Object> batch(String sql, Seq<Object> datas, Seq<Object> types) {
        if (this.showSql()) {
            Predef$.MODULE$.println((Object)new StringBuilder(13).append("JdbcExecutor:").append(sql).toString());
        }
        ObjectRef stmt = ObjectRef.create(null);
        Connection conn = this.getConnection();
        if (conn.getAutoCommit()) {
            conn.setAutoCommit(false);
        }
        ListBuffer rows = new ListBuffer();
        ObjectRef curParam = ObjectRef.create(null);
        try {
            try {
                stmt.elem = conn.prepareStatement(sql);
                datas.foreach((Function1 & Serializable & scala.Serializable)param -> {
                    JdbcExecutor.$anonfun$batch$1(curParam, stmt, types, param);
                    return BoxedUnit.UNIT;
                });
                rows.$plus$plus$eq((TraversableOnce)new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(((PreparedStatement)stmt.elem).executeBatch())));
                conn.commit();
            }
            catch (BatchUpdateException be) {
                conn.rollback();
                this.rethrow(be.getNextException(), sql, (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{(Seq)curParam.elem}));
            }
            catch (SQLException e) {
                conn.rollback();
                this.rethrow(e, sql, (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{(Seq)curParam.elem}));
            }
        }
        finally {
            ((PreparedStatement)stmt.elem).close();
            conn.close();
        }
        return rows.toList();
    }

    public void rethrow(SQLException cause, String sql, Seq<Object> params) {
        String causeMessage = cause.getMessage();
        if (causeMessage == null) {
            causeMessage = "";
        }
        StringBuffer msg = new StringBuffer(causeMessage);
        msg.append(" Query: ").append(sql).append(" Parameters: ");
        StringBuffer stringBuffer = params == null ? msg.append("[]") : msg.append(Strings$.MODULE$.join(params, ","));
        SQLException e = new SQLException(msg.toString(), cause.getSQLState(), cause.getErrorCode());
        e.setNextException(cause);
        throw e;
    }

    private Seq<Object[]> convertToSeq(ResultSet rs) {
        ResultSetMetaData meta = rs.getMetaData();
        int cols = meta.getColumnCount();
        ListBuffer rows = new ListBuffer();
        String string = meta.getColumnName(1);
        String string2 = "_row_nr_";
        int start = !(string != null ? !string.equals(string2) : string2 != null) ? 1 : 0;
        int rowlength = cols - start;
        while (rs.next()) {
            Object[] row = new Object[rowlength];
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(start), cols).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                Object v = rs.getObject(i + 1);
                if (v != null && meta.getColumnType(i + 1) == 93 && !(v instanceof Timestamp)) {
                    if (JdbcExecutor$.MODULE$.oracleTimestampMethod() != null) {
                        v = JdbcExecutor$.MODULE$.oracleTimestampMethod().invoke(v, new Object[0]);
                    } else {
                        throw new Exception(new StringBuilder(48).append("Cannot translate ").append(v.getClass()).append("timestamp to java.sql.Timestamp").toString());
                    }
                }
                row$1[i - start$1] = v;
            });
            rows.$plus$eq((Object)row);
        }
        rs.close();
        return rows;
    }

    public static final /* synthetic */ void $anonfun$batch$1(ObjectRef curParam$1, ObjectRef stmt$1, Seq types$1, Object param) {
        curParam$1.elem = Predef$.MODULE$.genericWrapArray(param);
        ParamSetter$.MODULE$.setParams((PreparedStatement)stmt$1.elem, (Seq<Object>)Predef$.MODULE$.genericWrapArray(param), (Seq<Object>)types$1);
        ((PreparedStatement)stmt$1.elem).addBatch();
    }

    public JdbcExecutor(DataSource dataSource) {
        this.dataSource = dataSource;
        Logging.$init$((Logging)this);
        this.engine = Engines$.MODULE$.forDataSource(dataSource);
        this.sqlTypeMapping = new DefaultSqlTypeMapping(this.engine());
        this.showSql = false;
    }
}

