/*
 * Decompiled with CFR 0.152.
 */
package org.beangle.data.jdbc.dialect;

import java.io.Serializable;
import org.beangle.commons.lang.ClassLoaders$;
import org.beangle.commons.lang.Strings$;
import org.beangle.data.jdbc.dialect.DB2Dialect;
import org.beangle.data.jdbc.dialect.DerbyDialect;
import org.beangle.data.jdbc.dialect.Dialect;
import org.beangle.data.jdbc.dialect.H2Dialect;
import org.beangle.data.jdbc.dialect.HSQLDialect;
import org.beangle.data.jdbc.dialect.MySQLDialect;
import org.beangle.data.jdbc.dialect.OracleDialect;
import org.beangle.data.jdbc.dialect.PostgreSQLDialect;
import org.beangle.data.jdbc.dialect.SQLServerDialect;
import org.beangle.data.jdbc.vendor.VendorInfo;
import org.beangle.data.jdbc.vendor.Vendors$;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.mutable.HashMap;
import scala.runtime.BoxesRunTime;
import scala.runtime.NonLocalReturnControl;

public final class Dialects$ {
    public static Dialects$ MODULE$;
    private final HashMap<VendorInfo, List<Dialect>> registeredDialects;

    static {
        new Dialects$();
    }

    public HashMap<VendorInfo, List<Dialect>> registeredDialects() {
        return this.registeredDialects;
    }

    public Option<Dialect> getDialect(VendorInfo vendor, String version) {
        None$ none$;
        Object object = new Object();
        try {
            this.registeredDialects().get((Object)vendor).foreach((Function1 & Serializable & scala.Serializable)dialects -> {
                throw new NonLocalReturnControl(object, (Object)dialects.find((Function1 & Serializable & scala.Serializable)d -> BoxesRunTime.boxToBoolean((boolean)d.support(version))));
            });
            none$ = None$.MODULE$;
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                none$ = (Option)ex.value();
            }
            throw ex;
        }
        return none$;
    }

    public void register(VendorInfo product, Seq<Dialect> dialects) {
        this.registeredDialects().put((Object)product, (Object)dialects.toList());
    }

    public Dialect forName(String dialectName) {
        String name = Strings$.MODULE$.capitalize(dialectName);
        name = name.replace("sql", "SQL");
        return (Dialect)ClassLoaders$.MODULE$.newInstance("org.beangle.data.jdbc.dialect." + name + "Dialect", ClassLoaders$.MODULE$.newInstance$default$2());
    }

    private Dialects$() {
        MODULE$ = this;
        this.registeredDialects = new HashMap();
        this.register(Vendors$.MODULE$.oracle(), (Seq<Dialect>)Predef$.MODULE$.wrapRefArray((Object[])new Dialect[]{new OracleDialect()}));
        this.register(Vendors$.MODULE$.db2(), (Seq<Dialect>)Predef$.MODULE$.wrapRefArray((Object[])new Dialect[]{new DB2Dialect()}));
        this.register(Vendors$.MODULE$.derby(), (Seq<Dialect>)Predef$.MODULE$.wrapRefArray((Object[])new Dialect[]{new DerbyDialect()}));
        this.register(Vendors$.MODULE$.h2(), (Seq<Dialect>)Predef$.MODULE$.wrapRefArray((Object[])new Dialect[]{new H2Dialect()}));
        this.register(Vendors$.MODULE$.hsql(), (Seq<Dialect>)Predef$.MODULE$.wrapRefArray((Object[])new Dialect[]{new HSQLDialect()}));
        this.register(Vendors$.MODULE$.mysql(), (Seq<Dialect>)Predef$.MODULE$.wrapRefArray((Object[])new Dialect[]{new MySQLDialect()}));
        this.register(Vendors$.MODULE$.postgresql(), (Seq<Dialect>)Predef$.MODULE$.wrapRefArray((Object[])new Dialect[]{new PostgreSQLDialect()}));
        this.register(Vendors$.MODULE$.sqlserver(), (Seq<Dialect>)Predef$.MODULE$.wrapRefArray((Object[])new Dialect[]{new SQLServerDialect()}));
    }
}

