/*
 * Decompiled with CFR 0.152.
 */
package org.beangle.data.jdbc.engine;

import java.io.Serializable;
import org.beangle.commons.collection.Collections$;
import org.beangle.commons.lang.Strings$;
import org.beangle.data.jdbc.engine.Dialect;
import org.beangle.data.jdbc.engine.Engine;
import org.beangle.data.jdbc.engine.Options;
import org.beangle.data.jdbc.meta.Column;
import org.beangle.data.jdbc.meta.ForeignKey;
import org.beangle.data.jdbc.meta.Identifier;
import org.beangle.data.jdbc.meta.Index;
import org.beangle.data.jdbc.meta.PrimaryKey;
import org.beangle.data.jdbc.meta.Sequence;
import org.beangle.data.jdbc.meta.SqlType;
import org.beangle.data.jdbc.meta.Table;
import org.beangle.data.jdbc.meta.UniqueKey;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.Iterable;
import scala.collection.IterableOnceOps;
import scala.collection.Iterator;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.StringBuilder;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;

public interface AbstractDialect
extends Dialect {
    public static void $init$(AbstractDialect $this) {
        $this.options_$eq(new Options());
    }

    public Options options();

    public void options_$eq(Options var1);

    public static String createTable$(AbstractDialect $this, Table table) {
        return $this.createTable(table);
    }

    @Override
    default public String createTable(Table table) {
        StringBuilder buf = new StringBuilder("create table").append(' ').append(table.qualifiedName()).append(" (");
        Iterator iter = table.columns().iterator();
        while (iter.hasNext()) {
            boolean useUniqueConstraint;
            Column col = (Column)iter.next();
            buf.append(col.name().toLiteral((Engine)((Object)this))).append(' ');
            buf.append(col.sqlType().name());
            col.defaultValue().foreach((Function1 & Serializable)dv -> buf.append(" default ").append(dv));
            if (!col.nullable()) {
                buf.append(" not null");
            }
            boolean bl = useUniqueConstraint = col.unique() && (!col.nullable() || this.options().create().table().supportsNullUnique());
            if (useUniqueConstraint && this.options().create().table().supportsUnique()) {
                buf.append(" unique");
            }
            if (col.hasCheck() && this.options().create().table().supportsColumnCheck()) {
                buf.append(" check (").append((String)col.check().get()).append(")");
            }
            if (!this.options().comment().supportsCommentOn()) {
                col.comment().foreach((Function1 & Serializable)c -> buf.append(" comment '" + c + "'"));
            }
            if (!iter.hasNext()) continue;
            buf.append(", ");
        }
        buf.append(')');
        if (!this.options().comment().supportsCommentOn()) {
            table.comment().foreach((Function1 & Serializable)c -> buf.append(" comment '" + c + "'"));
        }
        return buf.toString();
    }

    public static String dropTable$(AbstractDialect $this, String table) {
        return $this.dropTable(table);
    }

    @Override
    default public String dropTable(String table) {
        return Strings$.MODULE$.replace(this.options().drop().table().sql(), "{name}", table);
    }

    public static Option commentOnColumn$(AbstractDialect $this, Table table, Column column, Option comment) {
        return $this.commentOnColumn(table, column, (Option<String>)comment);
    }

    @Override
    default public Option<String> commentOnColumn(Table table, Column column, Option<String> comment) {
        return this.options().comment().supportsCommentOn() ? Some$.MODULE$.apply((Object)("comment on column " + table.qualifiedName() + '.' + column.name().toLiteral(table.engine()) + " is '" + comment.getOrElse(AbstractDialect::commentOnColumn$$anonfun$1) + "'")) : None$.MODULE$;
    }

    public static Option commentOnTable$(AbstractDialect $this, String table, Option comment) {
        return $this.commentOnTable(table, (Option<String>)comment);
    }

    @Override
    default public Option<String> commentOnTable(String table, Option<String> comment) {
        return this.options().comment().supportsCommentOn() ? Some$.MODULE$.apply((Object)("comment on table " + table + " is '" + comment.getOrElse(AbstractDialect::commentOnTable$$anonfun$1) + "'")) : None$.MODULE$;
    }

    public static List commentsOnTable$(AbstractDialect $this, Table table, boolean includeMissing) {
        return $this.commentsOnTable(table, includeMissing);
    }

    @Override
    default public List<String> commentsOnTable(Table table, boolean includeMissing) {
        List list;
        if (this.options().comment().supportsCommentOn()) {
            Buffer comments = Collections$.MODULE$.newBuffer();
            String tableName = table.qualifiedName();
            ObjectRef tableComment = ObjectRef.create((Object)((String)table.commentAndModule().getOrElse(() -> AbstractDialect.$anonfun$1(tableName))));
            if (includeMissing) {
                comments.$plus$eq((Object)("comment on table " + tableName + " is '" + (String)tableComment.elem + "'"));
                table.columns().foreach((Function1 & Serializable)c -> (Buffer)comments.$plus$eq((Object)("comment on column " + tableName + '.' + c.name() + " is '" + c.comment().getOrElse(() -> AbstractDialect.commentsOnTable$$anonfun$4$$anonfun$1(c)) + "'")));
            } else {
                table.comment().foreach((Function1 & Serializable)c -> (Buffer)comments.$plus$eq((Object)("comment on table " + tableName + " is '" + (String)tableComment$1.elem + "'")));
                table.columns().foreach((Function1)(JProcedure1 & Serializable)c -> c.comment().foreach((Function1 & Serializable)cc -> (Buffer)comments.$plus$eq((Object)("comment on column " + tableName + '.' + c.name() + " is '" + cc + "'"))));
            }
            list = comments.toList();
        } else {
            list = package$.MODULE$.List().empty();
        }
        return list;
    }

    public static List alterTableAddColumn$(AbstractDialect $this, Table table, Column col) {
        return $this.alterTableAddColumn(table, col);
    }

    @Override
    default public List<String> alterTableAddColumn(Table table, Column col) {
        Buffer buf = Collections$.MODULE$.newBuffer();
        ObjectRef sql = ObjectRef.create((Object)("alter table " + table.qualifiedName() + " add column " + col.name() + " " + col.sqlType().name()));
        col.defaultValue().foreach((Function1)(JProcedure1 & Serializable)v -> {
            if (col.sqlType().isStringType()) {
                String string = (String)sql$1.elem + (" default '" + v + "''");
                sql$1.elem = string;
            } else {
                String string = (String)sql$1.elem + (" default " + v);
                sql$1.elem = string;
            }
        });
        if (this.options().create().table().supportsColumnCheck()) {
            col.check().foreach((Function1)(JProcedure1 & Serializable)c -> {
                String string = (String)sql$2.elem + (" check " + c);
                sql$2.elem = string;
            });
        }
        buf.$plus$eq((Object)((String)sql.elem));
        if (!col.nullable()) {
            buf.$plus$eq((Object)this.alterTableModifyColumnSetNotNull(table, col));
        }
        return buf.toList();
    }

    public static String alterTableRenameColumn$(AbstractDialect $this, Table table, Column col, String newName) {
        return $this.alterTableRenameColumn(table, col, newName);
    }

    @Override
    default public String alterTableRenameColumn(Table table, Column col, String newName) {
        String renameClause = this.options().alter().table().renameColumn();
        renameClause = Strings$.MODULE$.replace(renameClause, "{oldcolumn}", col.name().toLiteral(table.engine()));
        renameClause = Strings$.MODULE$.replace(renameClause, "{newcolumn}", newName);
        renameClause = Strings$.MODULE$.replace(renameClause, "{type}", col.sqlType().name());
        return "alter table " + table.qualifiedName() + " " + renameClause;
    }

    public static String alterTableDropColumn$(AbstractDialect $this, Table table, Column col) {
        return $this.alterTableDropColumn(table, col);
    }

    @Override
    default public String alterTableDropColumn(Table table, Column col) {
        String alterClause = this.options().alter().table().dropColumn();
        alterClause = Strings$.MODULE$.replace(alterClause, "{column}", col.name().toLiteral(table.engine()));
        return "alter table " + table.qualifiedName() + " " + alterClause;
    }

    public static String alterTableModifyColumnSetNotNull$(AbstractDialect $this, Table table, Column col) {
        return $this.alterTableModifyColumnSetNotNull(table, col);
    }

    @Override
    default public String alterTableModifyColumnSetNotNull(Table table, Column col) {
        String alterClause = this.options().alter().table().setNotNull();
        alterClause = Strings$.MODULE$.replace(alterClause, "{column}", col.name().toLiteral(table.engine()));
        alterClause = Strings$.MODULE$.replace(alterClause, "{type}", col.sqlType().name());
        return "alter table " + table.qualifiedName() + " " + alterClause;
    }

    public static String alterTableModifyColumnDropNotNull$(AbstractDialect $this, Table table, Column col) {
        return $this.alterTableModifyColumnDropNotNull(table, col);
    }

    @Override
    default public String alterTableModifyColumnDropNotNull(Table table, Column col) {
        String alterClause = this.options().alter().table().dropNotNull();
        alterClause = Strings$.MODULE$.replace(alterClause, "{column}", col.name().toLiteral(table.engine()));
        alterClause = Strings$.MODULE$.replace(alterClause, "{type}", col.sqlType().name());
        return "alter table " + table.qualifiedName() + " " + alterClause;
    }

    public static String alterTableModifyColumnDefault$(AbstractDialect $this, Table table, Column col, Option v) {
        return $this.alterTableModifyColumnDefault(table, col, (Option<String>)v);
    }

    @Override
    default public String alterTableModifyColumnDefault(Table table, Column col, Option<String> v) {
        String string;
        Option<String> option = v;
        if (option instanceof Some) {
            string = this.options().alter().table().setDefault();
        } else if (None$.MODULE$.equals(option)) {
            string = this.options().alter().table().dropNotNull();
        } else {
            throw new MatchError(option);
        }
        String alterClause = string;
        alterClause = Strings$.MODULE$.replace(alterClause, "{column}", col.name().toLiteral(table.engine()));
        Object value2 = (String)v.getOrElse(AbstractDialect::$anonfun$2);
        if (col.sqlType().isStringType()) {
            value2 = "'" + (String)value2 + "'";
        }
        alterClause = Strings$.MODULE$.replace(alterClause, "{value}", (String)value2);
        return "alter table " + table.qualifiedName() + " " + alterClause;
    }

    public static String alterTableModifyColumnType$(AbstractDialect $this, Table table, Column col, SqlType sqlType) {
        return $this.alterTableModifyColumnType(table, col, sqlType);
    }

    @Override
    default public String alterTableModifyColumnType(Table table, Column col, SqlType sqlType) {
        String alterClause = this.options().alter().table().changeType();
        alterClause = Strings$.MODULE$.replace(alterClause, "{column}", col.name().toLiteral(table.engine()));
        alterClause = Strings$.MODULE$.replace(alterClause, "{type}", sqlType.name());
        return "alter table " + table.qualifiedName() + " " + alterClause;
    }

    public static String alterTableAddForeignKey$(AbstractDialect $this, ForeignKey fk) {
        return $this.alterTableAddForeignKey(fk);
    }

    @Override
    default public String alterTableAddForeignKey(ForeignKey fk) {
        Predef$.MODULE$.require(fk.name() != null && fk.table() != null && fk.referencedTable() != null);
        Predef$.MODULE$.require(fk.referencedColumns().nonEmpty(), AbstractDialect::alterTableAddForeignKey$$anonfun$1);
        Predef$.MODULE$.require(fk.columns().nonEmpty(), () -> AbstractDialect.alterTableAddForeignKey$$anonfun$2(fk));
        Engine engine = fk.table().engine();
        List referencedColumnNames = ((ListBuffer)fk.referencedColumns().map((Function1 & Serializable)x -> x.toLiteral(engine))).toList();
        String result = "alter table " + fk.table().qualifiedName() + this.foreignKeySql(fk.literalName(), (Iterable<String>)fk.columnNames(), fk.referencedTable().qualifiedName(), (Iterable<String>)referencedColumnNames);
        return fk.cascadeDelete() && this.options().constraint().supportsCascadeDelete() ? result + " on delete cascade" : result;
    }

    public static String alterTableAddPrimaryKey$(AbstractDialect $this, Table table, PrimaryKey pk) {
        return $this.alterTableAddPrimaryKey(table, pk);
    }

    @Override
    default public String alterTableAddPrimaryKey(Table table, PrimaryKey pk) {
        String alterClause = this.options().alter().table().addPrimaryKey();
        alterClause = Strings$.MODULE$.replace(alterClause, "{name}", pk.name().toLiteral(table.engine()));
        alterClause = Strings$.MODULE$.replace(alterClause, "{column-list}", this.nameList((Iterable<Identifier>)pk.columns(), table.engine()));
        return "alter table " + table.qualifiedName() + " " + alterClause;
    }

    public static String alterTableDropPrimaryKey$(AbstractDialect $this, Table table, PrimaryKey pk) {
        return $this.alterTableDropPrimaryKey(table, pk);
    }

    @Override
    default public String alterTableDropPrimaryKey(Table table, PrimaryKey pk) {
        return this.alterTableDropConstraint(table, pk.name().toLiteral(table.engine()));
    }

    public static String alterTableDropConstraint$(AbstractDialect $this, Table table, String name) {
        return $this.alterTableDropConstraint(table, name);
    }

    @Override
    default public String alterTableDropConstraint(Table table, String name) {
        String alterClause = this.options().alter().table().dropConstraint();
        alterClause = Strings$.MODULE$.replace(alterClause, "{name}", name);
        return "alter table " + table.qualifiedName() + " " + alterClause;
    }

    public static String alterTableAddUnique$(AbstractDialect $this, UniqueKey fk) {
        return $this.alterTableAddUnique(fk);
    }

    @Override
    default public String alterTableAddUnique(UniqueKey fk) {
        Predef$.MODULE$.require(fk.name() != null && fk.table() != null);
        Predef$.MODULE$.require(fk.columns().nonEmpty(), () -> AbstractDialect.alterTableAddUnique$$anonfun$1(fk));
        Engine engine = fk.table().engine();
        return "alter table " + fk.table().qualifiedName() + " add constraint " + fk.literalName() + " unique (" + this.nameList((Iterable<Identifier>)fk.columns(), engine) + ")";
    }

    public static Tuple2 limit$(AbstractDialect $this, String query, int offset, int size) {
        return $this.limit(query, offset, size);
    }

    @Override
    default public Tuple2<String, List<Object>> limit(String query, int offset, int size) {
        Tuple2 tuple2;
        int limitOrMax;
        boolean hasOffset = offset > 0;
        int n = limitOrMax = this.options().limit().offsetPattern() == null ? offset + size : size;
        if (hasOffset) {
            List params = this.options().limit().bindInReverseOrder() ? (List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{limitOrMax, offset})) : (List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{offset, limitOrMax}));
            tuple2 = Tuple2$.MODULE$.apply((Object)Strings$.MODULE$.replace(this.options().limit().offsetPattern(), "{}", query), (Object)params);
        } else {
            tuple2 = Tuple2$.MODULE$.apply((Object)Strings$.MODULE$.replace(this.options().limit().pattern(), "{}", query), package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{limitOrMax})));
        }
        return tuple2;
    }

    public static String createSequence$(AbstractDialect $this, Sequence seq) {
        return $this.createSequence(seq);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    default public String createSequence(Sequence seq) {
        void var2_2;
        if (!this.options().sequence().supports()) {
            return null;
        }
        String sql = this.options().sequence().createSql();
        sql = sql.replace("{name}", seq.qualifiedName());
        sql = sql.replace("{start}", String.valueOf(seq.current() + 1L));
        sql = sql.replace("{increment}", String.valueOf(seq.increment()));
        sql = sql.replace("{cache}", String.valueOf(seq.cache()));
        sql = sql.replace("{cycle}", seq.cycle() ? "cycle" : "");
        return var2_2;
    }

    public static String dropSequence$(AbstractDialect $this, Sequence seq) {
        return $this.dropSequence(seq);
    }

    @Override
    default public String dropSequence(Sequence seq) {
        if (!this.options().sequence().supports()) {
            return null;
        }
        return this.options().sequence().dropSql().replace("{name}", seq.qualifiedName());
    }

    public static String createIndex$(AbstractDialect $this, Index i) {
        return $this.createIndex(i);
    }

    @Override
    default public String createIndex(Index i) {
        StringBuilder buf = new StringBuilder("create").append(i.unique() ? " unique" : "").append(" index ").append(i.literalName()).append(" on ").append(i.table().qualifiedName()).append(" (");
        Iterator iter = i.columns().iterator();
        while (iter.hasNext()) {
            buf.append(iter.next());
            if (!iter.hasNext()) continue;
            buf.append(", ");
        }
        buf.append(")");
        return buf.toString();
    }

    public static String dropIndex$(AbstractDialect $this, Index i) {
        return $this.dropIndex(i);
    }

    @Override
    default public String dropIndex(Index i) {
        return i.table().schema().name().value().length() > 0 ? "drop index " + i.table().schema().name().toString() + "." + i.literalName() : "drop index " + i.literalName();
    }

    public static String insert$(AbstractDialect $this, Table table) {
        return $this.insert(table);
    }

    @Override
    default public String insert(Table table) {
        StringBuilder sb = new StringBuilder("insert into ");
        sb.$plus$plus$eq(table.qualifiedName());
        sb.$plus$eq((Object)BoxesRunTime.boxToCharacter((char)'('));
        sb.$plus$plus$eq(table.quotedColumnNames().mkString(","));
        sb.$plus$plus$eq(") values(");
        sb.$plus$plus$eq(StringOps$.MODULE$.$times$extension(Predef$.MODULE$.augmentString("?,"), table.columns().size()));
        sb.setCharAt(sb.length() - 1, ')');
        return sb.mkString();
    }

    public static String query$(AbstractDialect $this, Table table) {
        return $this.query(table);
    }

    @Override
    default public String query(Table table) {
        StringBuilder sb = new StringBuilder();
        sb.append("select ");
        table.quotedColumnNames().foreach((Function1 & Serializable)columnName -> sb.append(columnName).append(','));
        sb.deleteCharAt(sb.length() - 1);
        sb.append(" from ").append(table.qualifiedName());
        return sb.toString();
    }

    public static String foreignKeySql$(AbstractDialect $this, String constraintName, Iterable foreignKey, String referencedTable, Iterable primaryKey) {
        return $this.foreignKeySql(constraintName, (Iterable<String>)foreignKey, referencedTable, (Iterable<String>)primaryKey);
    }

    default public String foreignKeySql(String constraintName, Iterable<String> foreignKey, String referencedTable, Iterable<String> primaryKey) {
        StringBuffer res = new StringBuffer(30);
        res.append(" add constraint ").append(constraintName).append(" foreign key (").append(Strings$.MODULE$.join(foreignKey, ", ")).append(") references ").append(referencedTable);
        if (primaryKey.nonEmpty()) {
            res.append(" (").append(Strings$.MODULE$.join(primaryKey, ", ")).append(')');
        }
        return res.toString();
    }

    private String nameList(Iterable<Identifier> seq, Engine engine) {
        return ((IterableOnceOps)seq.map((Function1 & Serializable)_$1 -> _$1.toLiteral(engine))).mkString(",");
    }

    public static boolean supportSequence$(AbstractDialect $this) {
        return $this.supportSequence();
    }

    @Override
    default public boolean supportSequence() {
        return this.options().sequence() != null;
    }

    private static String commentOnColumn$$anonfun$1() {
        return "";
    }

    private static String commentOnTable$$anonfun$1() {
        return "";
    }

    private static String $anonfun$1(String tableName$1) {
        return tableName$1 + "?";
    }

    private static String commentsOnTable$$anonfun$4$$anonfun$1(Column c$1) {
        return c$1.name() + "?";
    }

    private static String $anonfun$2() {
        return "null";
    }

    private static String alterTableAddForeignKey$$anonfun$1() {
        return " reference columns is empty.";
    }

    private static String alterTableAddForeignKey$$anonfun$2(ForeignKey fk$1) {
        return fk$1.name() + " column's size should greate than 0";
    }

    private static String alterTableAddUnique$$anonfun$1(UniqueKey fk$2) {
        return fk$2.name() + " column's size should greate than 0";
    }
}

