/*
 * Decompiled with CFR 0.152.
 */
package org.beangle.data.jdbc.engine;

import java.io.Serializable;
import org.beangle.commons.lang.Strings$;
import org.beangle.data.jdbc.engine.AbstractEngine;
import org.beangle.data.jdbc.engine.Options;
import org.beangle.data.jdbc.engine.Version$;
import org.beangle.data.jdbc.meta.Column;
import org.beangle.data.jdbc.meta.Index;
import org.beangle.data.jdbc.meta.Table;
import scala.Function1;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.Tuple3;
import scala.Tuple3$;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.collection.mutable.StringBuilder;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;

public class SQLServer
extends AbstractEngine {
    public SQLServer(String v) {
        super(Version$.MODULE$.apply(v));
        this.registerReserved("t-sql.txt");
        Object[] objectArray = new Tuple2[22];
        Integer n = (Integer)Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1));
        objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)n, (Object)"char($l)");
        Integer n2 = (Integer)Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)12));
        objectArray[1] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)n2, (Object)"varchar(MAX)");
        Integer n3 = (Integer)Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)-9));
        objectArray[2] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)n3, (Object)"nvarchar(MAX)");
        Integer n4 = (Integer)Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)-7));
        objectArray[3] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)n4, (Object)"bit");
        Integer n5 = (Integer)Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)16));
        objectArray[4] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)n5, (Object)"bit");
        Integer n6 = (Integer)Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)-6));
        objectArray[5] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)n6, (Object)"smallint");
        Integer n7 = (Integer)Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)5));
        objectArray[6] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)n7, (Object)"smallint");
        Integer n8 = (Integer)Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)4));
        objectArray[7] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)n8, (Object)"int");
        Integer n9 = (Integer)Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)-5));
        objectArray[8] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)n9, (Object)"bigint");
        Integer n10 = (Integer)Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)6));
        objectArray[9] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)n10, (Object)"float");
        Integer n11 = (Integer)Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)8));
        objectArray[10] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)n11, (Object)"double precision");
        Integer n12 = (Integer)Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)3));
        objectArray[11] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)n12, (Object)"double precision");
        Integer n13 = (Integer)Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2));
        objectArray[12] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)n13, (Object)"numeric($p,$s)");
        Integer n14 = (Integer)Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)91));
        objectArray[13] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)n14, (Object)"date");
        Integer n15 = (Integer)Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)92));
        objectArray[14] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)n15, (Object)"time");
        Integer n16 = (Integer)Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)93));
        objectArray[15] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)n16, (Object)"datetime2");
        Integer n17 = (Integer)Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)-2));
        objectArray[16] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)n17, (Object)"binary");
        Integer n18 = (Integer)Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)-3));
        objectArray[17] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)n18, (Object)"varbinary(MAX)");
        Integer n19 = (Integer)Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)-1));
        objectArray[18] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)n19, (Object)"text");
        Integer n20 = (Integer)Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)-4));
        objectArray[19] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)n20, (Object)"varbinary(MAX)");
        Integer n21 = (Integer)Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2004));
        objectArray[20] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)n21, (Object)"varbinary(MAX)");
        Integer n22 = (Integer)Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2005));
        objectArray[21] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)n22, (Object)"varchar(MAX)");
        this.registerTypes((Seq<Tuple2<Object, String>>)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
        this.registerTypes2((Seq<Tuple3<Object, Object, String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple3[]{Tuple3$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)12), (Object)BoxesRunTime.boxToInteger((int)8000), (Object)"varchar($l)"), Tuple3$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)-3), (Object)BoxesRunTime.boxToInteger((int)8000), (Object)"varbinary($l)"), Tuple3$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)-9), (Object)BoxesRunTime.boxToInteger((int)4000), (Object)"nvarchar($l)")}));
        this.options().comment().supportsCommentOn_$eq(false);
        this.options().sequence().supports_$eq(false);
        this.options().alter((Function1<Options.AlterOption, BoxedUnit>)(JProcedure1 & Serializable)a -> {
            a.table().changeType_$eq("alter {column} {type}");
            a.table().setDefault_$eq("add constraint {column}_dflt default {value} for {column}");
            a.table().dropDefault_$eq("drop constraint {column}_dflt");
            a.table().setNotNull_$eq("alter column {column} {type} not null");
            a.table().dropNotNull_$eq("alter column {column} {type}");
            a.table().addColumn_$eq("add {column} {type}");
            a.table().dropColumn_$eq("drop column {column}");
            a.table().renameColumn_$eq("EXEC sp_rename '{table}.{oldcolumn}', '{newcolumn}', 'COLUMN'");
            a.table().addPrimaryKey_$eq("add constraint {name} primary key ({column-list})");
            a.table().dropConstraint_$eq("drop constraint {name}");
        });
        this.options().validate();
    }

    @Override
    public Tuple2<String, List<Object>> limit(String querySql, int offset, int limit) {
        StringBuilder sb = new StringBuilder(querySql);
        int orderByIndex = querySql.toLowerCase().indexOf("order by");
        CharSequence orderby = "order by current_timestmap";
        if (orderByIndex > 0) {
            orderby = sb.subSequence(orderByIndex, sb.length());
        }
        if (orderByIndex > 0) {
            sb.delete(orderByIndex, orderByIndex + orderby.length());
        }
        this.replaceDistinctWithGroupBy(sb);
        this.insertRowNumberFunction(sb, orderby);
        sb.insert(0, "with query as (").append(") select * from query ");
        sb.append("where _rownum_ between ? and ?");
        return Tuple2$.MODULE$.apply((Object)sb.toString(), package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{offset + 1, offset + limit})));
    }

    @Override
    public String alterTableRenameColumn(Table table, Column col, String newName) {
        String renameClause = this.options().alter().table().renameColumn();
        renameClause = Strings$.MODULE$.replace(renameClause, "{oldcolumn}", col.name().toLiteral(table.engine()));
        renameClause = Strings$.MODULE$.replace(renameClause, "{newcolumn}", newName);
        renameClause = Strings$.MODULE$.replace(renameClause, "{table}", table.qualifiedName());
        return renameClause;
    }

    public void replaceDistinctWithGroupBy(StringBuilder sql) {
        int distinctIndex = sql.indexOf("distinct");
        if (distinctIndex > 0) {
            sql.delete(distinctIndex, distinctIndex + "distinct".length() + 1);
            sql.append(" group by").append(this.getSelectFieldsWithoutAliases(sql));
        }
    }

    public void insertRowNumberFunction(StringBuilder sql, CharSequence orderby) {
        int fromIndex = sql.toString().toLowerCase().indexOf("from");
        sql.insert(fromIndex, ",ROW_NUMBER() OVER (" + orderby + ") as _rownum_ ");
    }

    public String getSelectFieldsWithoutAliases(StringBuilder sql) {
        String select = sql.substring(sql.indexOf("select") + "select".length(), sql.indexOf("from"));
        return this.stripAliases(select);
    }

    public String stripAliases(String str) {
        return str.replaceAll("\\sas[^,]+(,?)", "$1");
    }

    @Override
    public String dropIndex(Index i) {
        return "drop index " + i.table().qualifiedName() + "." + i.literalName();
    }

    @Override
    public String defaultSchema() {
        return "dbo";
    }

    @Override
    public String name() {
        return "Microsoft SQL Server";
    }
}

