/*
 * Decompiled with CFR 0.152.
 */
package org.beangle.data.jdbc.meta;

import java.io.File;
import java.io.Serializable;
import org.beangle.commons.collection.Collections$;
import org.beangle.commons.io.Files$;
import org.beangle.data.jdbc.engine.Engine;
import org.beangle.data.jdbc.meta.Column;
import org.beangle.data.jdbc.meta.Database;
import org.beangle.data.jdbc.meta.DatabaseDiff;
import org.beangle.data.jdbc.meta.ForeignKey;
import org.beangle.data.jdbc.meta.Index;
import org.beangle.data.jdbc.meta.NameDiff;
import org.beangle.data.jdbc.meta.NameDiff$;
import org.beangle.data.jdbc.meta.PrimaryKey;
import org.beangle.data.jdbc.meta.Schema;
import org.beangle.data.jdbc.meta.SchemaDiff;
import org.beangle.data.jdbc.meta.Serializer$;
import org.beangle.data.jdbc.meta.SqlType;
import org.beangle.data.jdbc.meta.Table;
import org.beangle.data.jdbc.meta.TableDiff;
import org.beangle.data.jdbc.meta.UniqueKey;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.Map;
import scala.collection.Set;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.HashSet;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.function.JProcedure1;

public final class Diff$
implements Serializable {
    public static final Diff$ MODULE$ = new Diff$();

    private Diff$() {
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(Diff$.class);
    }

    public void main(String[] args) {
        if (args.length < 3) {
            Predef$.MODULE$.println((Object)"Usage:Diff database1.xml database2.xml /path/to/diff.sql");
            return;
        }
        File dbFile1 = new File(args[0]);
        File dbFile2 = new File(args[1]);
        if (!dbFile1.exists()) {
            Predef$.MODULE$.println((Object)("Cannot load " + dbFile1.getAbsolutePath()));
            return;
        }
        if (!dbFile2.exists()) {
            Predef$.MODULE$.println((Object)("Cannot load " + dbFile2.getAbsolutePath()));
            return;
        }
        Database db1 = Serializer$.MODULE$.fromXml(Files$.MODULE$.readString(dbFile1, Files$.MODULE$.readString$default$2()));
        Database db2 = Serializer$.MODULE$.fromXml(Files$.MODULE$.readString(dbFile2, Files$.MODULE$.readString$default$2()));
        DatabaseDiff diff = this.diff(db1, db2);
        Iterable<String> sqls = this.sql(diff);
        Files$.MODULE$.writeString(new File(args[2]), sqls.toBuffer().append((Object)"").mkString(";\n"), Files$.MODULE$.writeString$default$3());
    }

    public DatabaseDiff diff(Database older, Database newer) {
        Engine engine = newer.engine();
        Engine engine2 = older.engine();
        if (engine == null ? engine2 != null : !engine.equals(engine2)) {
            throw new RuntimeException("Cannot diff different engines(" + newer.engine().name() + " and " + older.engine().name() + ").");
        }
        scala.collection.immutable.Set newSchemaSet = ((IterableOnceOps)newer.schemas().keySet().map((Function1 & Serializable)_$1 -> _$1.value())).toSet();
        scala.collection.immutable.Set oldSchemaSet = ((IterableOnceOps)older.schemas().keySet().map((Function1 & Serializable)_$2 -> _$2.value())).toSet();
        scala.collection.immutable.Set newSchemas = (scala.collection.immutable.Set)newSchemaSet.diff((Set)oldSchemaSet);
        scala.collection.immutable.Set removedSchemas = (scala.collection.immutable.Set)oldSchemaSet.diff((Set)newSchemaSet);
        scala.collection.immutable.Set updateSchemas = (scala.collection.immutable.Set)newSchemaSet.intersect((Set)oldSchemaSet);
        scala.collection.mutable.Map schemaDiffs = Collections$.MODULE$.newMap();
        updateSchemas.foreach((Function1)(JProcedure1 & Serializable)s -> {
            Schema oldSchema = older.getOrCreateSchema((String)s);
            Schema newSchema = newer.getOrCreateSchema((String)s);
            scala.collection.immutable.Set oldTableSet = ((IterableOnceOps)oldSchema.tables().keySet().map((Function1 & Serializable)_$3 -> _$3.value())).toSet();
            scala.collection.immutable.Set newTableSet = ((IterableOnceOps)newSchema.tables().keySet().map((Function1 & Serializable)_$4 -> _$4.value())).toSet();
            scala.collection.immutable.Set newTables = (scala.collection.immutable.Set)newTableSet.diff((Set)oldTableSet);
            scala.collection.immutable.Set removedTables = (scala.collection.immutable.Set)oldTableSet.diff((Set)newTableSet);
            scala.collection.immutable.Set updateTables = (scala.collection.immutable.Set)newTableSet.intersect((Set)oldTableSet);
            scala.collection.mutable.Map tableDiffs = Collections$.MODULE$.newMap();
            updateTables.foreach((Function1)(JProcedure1 & Serializable)t -> {
                Table oldT = (Table)oldSchema.getTable((String)t).orNull((.less.colon.less)$less$colon$less$.MODULE$.refl());
                Table newT = (Table)newSchema.getTable((String)t).orNull((.less.colon.less)$less$colon$less$.MODULE$.refl());
                this.diff(oldT, newT, newer.engine()).foreach((Function1 & Serializable)td -> tableDiffs.put(t, td));
            });
            if (!(newTables.isEmpty() && removedTables.isEmpty() && tableDiffs.isEmpty())) {
                SchemaDiff schemaDiff = new SchemaDiff(oldSchema, newSchema);
                schemaDiff.tableDiffs_$eq((scala.collection.immutable.Map<String, TableDiff>)tableDiffs.toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()));
                schemaDiff.tables_$eq(NameDiff$.MODULE$.apply((scala.collection.immutable.Set<String>)newTables, (scala.collection.immutable.Set<String>)removedTables, (scala.collection.immutable.Set<Tuple2<String, String>>)Predef$.MODULE$.Set().empty(), (scala.collection.immutable.Set<String>)tableDiffs.keySet().toSet()));
                schemaDiffs.put(s, (Object)schemaDiff);
            }
        });
        DatabaseDiff dbDiff = new DatabaseDiff(older, newer);
        if (!(newSchemas.isEmpty() && removedSchemas.isEmpty() && schemaDiffs.isEmpty())) {
            dbDiff.schemas_$eq(NameDiff$.MODULE$.apply((scala.collection.immutable.Set<String>)newSchemas, (scala.collection.immutable.Set<String>)removedSchemas, (scala.collection.immutable.Set<Tuple2<String, String>>)Predef$.MODULE$.Set().empty(), (scala.collection.immutable.Set<String>)schemaDiffs.keySet().toSet()));
            dbDiff.schemaDiffs_$eq((scala.collection.immutable.Map<String, SchemaDiff>)schemaDiffs.toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()));
        }
        return dbDiff;
    }

    public Option<TableDiff> diff(Table older, Table newer, Engine engine) {
        TableDiff table = new TableDiff(older, newer);
        Option<PrimaryKey> option = newer.primaryKey();
        Option<PrimaryKey> option2 = older.primaryKey();
        if (option == null ? option2 != null : !option.equals(option2)) {
            table.hasPrimaryKey_$eq(true);
        }
        Option option3 = newer.comment();
        Option option4 = older.comment();
        if (option3 == null ? option4 != null : !option3.equals(option4)) {
            table.hasComment_$eq(true);
        }
        scala.collection.immutable.Map oldColMap = ((IterableOnceOps)older.columns().map((Function1 & Serializable)c -> Tuple2$.MODULE$.apply((Object)c.name().toLiteral(engine), c))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        scala.collection.immutable.Map newColMap = ((IterableOnceOps)newer.columns().map((Function1 & Serializable)c -> Tuple2$.MODULE$.apply((Object)c.name().toLiteral(engine), c))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        NameDiff columnDiff = this.nameDiff((scala.collection.immutable.Set<String>)oldColMap.keySet(), (scala.collection.immutable.Set<String>)newColMap.keySet(), (Map<String, Object>)oldColMap, (Map<String, Object>)newColMap);
        HashSet renameColumnPairs = new HashSet();
        columnDiff.newer().foreach((Function1)(JProcedure1 & Serializable)nc -> {
            Column newColumn = newer.column((String)nc);
            older.columns().find((Function1 & Serializable)x -> {
                Option option = x.comment();
                Option option2 = newColumn.comment();
                return !(option != null ? !option.equals(option2) : option2 != null);
            }).foreach((Function1)(JProcedure1 & Serializable)oldColumn -> {
                if (columnDiff.removed().contains((Object)oldColumn.name().toLiteral(engine))) {
                    String string = (String)Predef$.MODULE$.ArrowAssoc((Object)oldColumn.name().toLiteral(engine));
                    renameColumnPairs.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)newColumn.name().toLiteral(engine)));
                }
            });
        });
        if (renameColumnPairs.nonEmpty()) {
            table.columns_$eq(NameDiff$.MODULE$.apply((scala.collection.immutable.Set<String>)((scala.collection.immutable.Set)columnDiff.newer().$minus$minus((IterableOnce)renameColumnPairs.map((Function1 & Serializable)_$5 -> (String)_$5._2()))), (scala.collection.immutable.Set<String>)((scala.collection.immutable.Set)columnDiff.removed().$minus$minus((IterableOnce)renameColumnPairs.map((Function1 & Serializable)_$6 -> (String)_$6._1()))), (scala.collection.immutable.Set<Tuple2<String, String>>)renameColumnPairs.toSet(), columnDiff.updated()));
        } else {
            table.columns_$eq(columnDiff);
        }
        scala.collection.immutable.Map oldUkMap = ((IterableOnceOps)older.uniqueKeys().map((Function1 & Serializable)c -> Tuple2$.MODULE$.apply((Object)c.name().toLiteral(engine), c))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        scala.collection.immutable.Map newUkMap = ((IterableOnceOps)newer.uniqueKeys().map((Function1 & Serializable)c -> Tuple2$.MODULE$.apply((Object)c.name().toLiteral(engine), c))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        table.uniqueKeys_$eq(this.nameDiff((scala.collection.immutable.Set<String>)oldUkMap.keySet(), (scala.collection.immutable.Set<String>)newUkMap.keySet(), (Map<String, Object>)oldUkMap, (Map<String, Object>)newUkMap));
        scala.collection.immutable.Map oldFkMap = ((IterableOnceOps)older.foreignKeys().map((Function1 & Serializable)c -> Tuple2$.MODULE$.apply((Object)c.name().toLiteral(engine), c))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        scala.collection.immutable.Map newFkMap = ((IterableOnceOps)newer.foreignKeys().map((Function1 & Serializable)c -> Tuple2$.MODULE$.apply((Object)c.name().toLiteral(engine), c))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        table.foreignKeys_$eq(this.nameDiff((scala.collection.immutable.Set<String>)oldFkMap.keySet(), (scala.collection.immutable.Set<String>)newFkMap.keySet(), (Map<String, Object>)oldFkMap, (Map<String, Object>)newFkMap));
        scala.collection.immutable.Map oldIdxMap = ((IterableOnceOps)older.indexes().map((Function1 & Serializable)c -> Tuple2$.MODULE$.apply((Object)c.name().toLiteral(engine), c))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        scala.collection.immutable.Map newIdxMap = ((IterableOnceOps)newer.indexes().map((Function1 & Serializable)c -> Tuple2$.MODULE$.apply((Object)c.name().toLiteral(engine), c))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        table.indexes_$eq(this.nameDiff((scala.collection.immutable.Set<String>)oldIdxMap.keySet(), (scala.collection.immutable.Set<String>)newIdxMap.keySet(), (Map<String, Object>)oldIdxMap, (Map<String, Object>)newIdxMap));
        return table.isEmpty() ? None$.MODULE$ : Some$.MODULE$.apply((Object)table);
    }

    private NameDiff nameDiff(scala.collection.immutable.Set<String> oldNames, scala.collection.immutable.Set<String> newNames, Map<String, Object> oldDatas, Map<String, Object> newDatas) {
        scala.collection.immutable.Set updated = (scala.collection.immutable.Set)oldNames.intersect(newNames).filter((Function1 & Serializable)n -> !BoxesRunTime.equals((Object)newDatas.apply(n), (Object)oldDatas.apply(n)));
        return NameDiff$.MODULE$.apply((scala.collection.immutable.Set<String>)((scala.collection.immutable.Set)newNames.diff(oldNames)), (scala.collection.immutable.Set<String>)((scala.collection.immutable.Set)oldNames.diff(newNames)), (scala.collection.immutable.Set<Tuple2<String, String>>)Predef$.MODULE$.Set().empty(), (scala.collection.immutable.Set<String>)updated);
    }

    /*
     * WARNING - void declaration
     */
    public Iterable<String> sql(DatabaseDiff diff) {
        void var2_2;
        if (diff.isEmpty()) {
            return package$.MODULE$.List().empty();
        }
        Buffer sb = Collections$.MODULE$.newBuffer();
        Engine engine = diff.newer().engine();
        diff.schemas().newer().foreach((Function1 & Serializable)n -> (Buffer)sb.$plus$eq((Object)("create schema " + n)));
        diff.schemas().removed().foreach((Function1 & Serializable)n -> (Buffer)sb.$plus$eq((Object)("DROP schema " + n + " cascade")));
        diff.schemaDiffs().foreach((Function1)(JProcedure1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String schema = (String)tuple2._1();
            SchemaDiff sdf = (SchemaDiff)tuple2._2();
            sdf.tables().removed().foreach((Function1 & Serializable)t -> (Buffer)sb.$plus$eq((Object)engine.dropTable(((Table)diff.older().getTable(schema, (String)t).get()).qualifiedName())));
            sdf.tables().newer().foreach((Function1)(JProcedure1 & Serializable)t -> {
                Table tb = (Table)diff.newer().getTable(schema, (String)t).get();
                sb.$plus$eq((Object)engine.createTable(tb));
                sb.$plus$plus$eq(engine.commentsOnTable(tb, false));
                tb.primaryKey().foreach((Function1 & Serializable)pk -> (Buffer)sb.$plus$eq((Object)engine.alterTableAddPrimaryKey(tb, (PrimaryKey)pk)));
                tb.uniqueKeys().foreach((Function1 & Serializable)uk -> (Buffer)sb.$plus$eq((Object)engine.alterTableAddUnique((UniqueKey)uk)));
                tb.indexes().foreach((Function1 & Serializable)idx -> (Buffer)sb.$plus$eq((Object)engine.createIndex((Index)idx)));
                tb.foreignKeys().foreach((Function1 & Serializable)fk -> (Buffer)sb.$plus$eq((Object)engine.alterTableAddForeignKey((ForeignKey)fk)));
            });
            sdf.tableDiffs().foreach((Function1)(JProcedure1 & Serializable)x$12 -> {
                TableDiff tdf;
                Tuple2 tuple2 = x$12;
                if (tuple2 != null) {
                    tdf = (TableDiff)tuple2._2();
                    if (tdf.hasComment()) {
                        sb.$plus$plus$eq(engine.commentOnTable(tdf.older().qualifiedName(), (Option<String>)tdf.newer().comment()));
                    }
                    tdf.columns().removed().foreach((Function1 & Serializable)c -> (Buffer)sb.$plus$eq((Object)engine.alterTableDropColumn(tdf.older(), tdf.older().column((String)c))));
                    tdf.columns().newer().foreach((Function1 & Serializable)c -> (Buffer)sb.$plus$plus$eq(engine.alterTableAddColumn(tdf.newer(), tdf.newer().column((String)c))));
                    tdf.columns().renamed().foreach((Function1 & Serializable)x$1 -> {
                        Column nCol;
                        Column oCol;
                        Tuple2 tuple2 = x$1;
                        if (tuple2 != null) {
                            String o = (String)tuple2._1();
                            String n = (String)tuple2._2();
                            oCol = tdf.older().column(o);
                            nCol = tdf.newer().column(n);
                            SqlType sqlType = nCol.sqlType();
                            SqlType sqlType2 = oCol.sqlType();
                            if (sqlType == null ? sqlType2 != null : !((Object)sqlType).equals(sqlType2)) {
                                sb.$plus$eq((Object)engine.alterTableModifyColumnType(tdf.older(), oCol, nCol.sqlType()));
                            }
                            Option<String> option = nCol.defaultValue();
                            Option<String> option2 = oCol.defaultValue();
                            if (option == null ? option2 != null : !option.equals(option2)) {
                                sb.$plus$eq((Object)engine.alterTableModifyColumnDefault(tdf.older(), oCol, nCol.defaultValue()));
                            }
                            if (nCol.nullable() != oCol.nullable()) {
                                if (nCol.nullable()) {
                                    sb.$plus$eq((Object)engine.alterTableModifyColumnDropNotNull(tdf.newer(), nCol));
                                } else {
                                    sb.$plus$eq((Object)engine.alterTableModifyColumnSetNotNull(tdf.newer(), nCol));
                                }
                            }
                        } else {
                            throw new MatchError((Object)tuple2);
                        }
                        return (Buffer)sb.$plus$eq((Object)engine.alterTableRenameColumn(tdf.older(), oCol, nCol.name().toLiteral(engine)));
                    });
                    tdf.columns().updated().foreach((Function1)(JProcedure1 & Serializable)c -> {
                        Column oCol = tdf.older().column((String)c);
                        Column nCol = tdf.newer().column((String)c);
                        SqlType sqlType = nCol.sqlType();
                        SqlType sqlType2 = oCol.sqlType();
                        if (sqlType == null ? sqlType2 != null : !((Object)sqlType).equals(sqlType2)) {
                            sb.$plus$eq((Object)engine.alterTableModifyColumnType(tdf.older(), oCol, nCol.sqlType()));
                        }
                        Option<String> option = nCol.defaultValue();
                        Option<String> option2 = oCol.defaultValue();
                        if (option == null ? option2 != null : !option.equals(option2)) {
                            sb.$plus$eq((Object)engine.alterTableModifyColumnDefault(tdf.older(), oCol, nCol.defaultValue()));
                        }
                        if (nCol.nullable() != oCol.nullable()) {
                            if (nCol.nullable()) {
                                sb.$plus$eq((Object)engine.alterTableModifyColumnDropNotNull(tdf.newer(), nCol));
                            } else {
                                sb.$plus$eq((Object)engine.alterTableModifyColumnSetNotNull(tdf.newer(), nCol));
                            }
                        }
                        Option option3 = nCol.comment();
                        Option option4 = oCol.comment();
                        if (option3 == null ? option4 != null : !option3.equals(option4)) {
                            sb.$plus$plus$eq(engine.commentOnColumn(tdf.older(), oCol, (Option<String>)nCol.comment()));
                        }
                    });
                    if (tdf.hasPrimaryKey()) {
                        if (tdf.older().primaryKey().nonEmpty()) {
                            sb.$plus$eq((Object)engine.alterTableDropPrimaryKey(tdf.older(), (PrimaryKey)tdf.older().primaryKey().get()));
                        }
                        if (tdf.newer().primaryKey().nonEmpty()) {
                            sb.$plus$eq((Object)engine.alterTableAddPrimaryKey(tdf.newer(), (PrimaryKey)tdf.newer().primaryKey().get()));
                        }
                    }
                } else {
                    throw new MatchError((Object)tuple2);
                }
                tdf.foreignKeys().removed().foreach((Function1 & Serializable)fk -> (Buffer)sb.$plus$eq((Object)engine.alterTableDropConstraint(tdf.older(), (String)fk)));
                tdf.foreignKeys().updated().foreach((Function1 & Serializable)fk -> {
                    sb.$plus$eq((Object)engine.alterTableDropConstraint(tdf.older(), (String)fk));
                    return (Buffer)sb.$plus$eq((Object)engine.alterTableAddForeignKey((ForeignKey)tdf.newer().getForeignKey((String)fk).get()));
                });
                tdf.foreignKeys().newer().foreach((Function1 & Serializable)fk -> (Buffer)sb.$plus$eq((Object)engine.alterTableAddForeignKey((ForeignKey)tdf.newer().getForeignKey((String)fk).get())));
                tdf.uniqueKeys().removed().foreach((Function1 & Serializable)uk -> (Buffer)sb.$plus$eq((Object)engine.alterTableDropConstraint(tdf.older(), (String)uk)));
                tdf.uniqueKeys().updated().foreach((Function1 & Serializable)uk -> {
                    sb.$plus$eq((Object)engine.alterTableDropConstraint(tdf.older(), (String)uk));
                    return (Buffer)sb.$plus$eq((Object)engine.alterTableAddUnique((UniqueKey)tdf.newer().getUniqueKey((String)uk).get()));
                });
                tdf.uniqueKeys().newer().foreach((Function1 & Serializable)uk -> (Buffer)sb.$plus$eq((Object)engine.alterTableAddUnique((UniqueKey)tdf.newer().getUniqueKey((String)uk).get())));
                tdf.indexes().removed().foreach((Function1 & Serializable)idx -> (Buffer)sb.$plus$eq((Object)engine.dropIndex((Index)tdf.older().getIndex((String)idx).get())));
                tdf.indexes().updated().foreach((Function1 & Serializable)idx -> {
                    sb.$plus$eq((Object)engine.dropIndex((Index)tdf.older().getIndex((String)idx).get()));
                    return (Buffer)sb.$plus$eq((Object)engine.createIndex((Index)tdf.newer().getIndex((String)idx).get()));
                });
                tdf.indexes().newer().foreach((Function1 & Serializable)idx -> (Buffer)sb.$plus$eq((Object)engine.createIndex((Index)tdf.newer().getIndex((String)idx).get())));
            });
        });
        return var2_2;
    }
}

