/*
 * Decompiled with CFR 0.152.
 */
package org.beangle.data.jdbc.meta;

import java.io.Serializable;
import org.beangle.data.jdbc.internal.XmlNode;
import org.beangle.data.jdbc.internal.XmlNode$;
import org.beangle.data.jdbc.meta.Database;
import org.beangle.data.jdbc.meta.Identifier;
import org.beangle.data.jdbc.meta.Schema;
import org.beangle.data.jdbc.meta.Serializer$;
import org.beangle.data.jdbc.meta.Table;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.Iterable;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.ListBuffer;
import scala.math.Ordering$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;

public final class Serializer {
    public static Database fromXml(String string) {
        return Serializer$.MODULE$.fromXml(string);
    }

    public static String toXml(Database database) {
        return Serializer$.MODULE$.toXml(database);
    }

    private static class Exporter {
        private final Database db;

        public Exporter(Database db) {
            this.db = db;
        }

        public String toXml() {
            XmlNode dbNode = XmlNode$.MODULE$.apply("db", (Seq<Tuple2<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Tuple2$.MODULE$.apply((Object)"engine", (Object)this.db.engine().name()), Tuple2$.MODULE$.apply((Object)"version", (Object)this.db.version())}));
            if (this.db.schemas().nonEmpty()) {
                XmlNode schemasNode = dbNode.createChild("schemas", (Seq<Tuple2<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[0]));
                Buffer schemaNames = (Buffer)this.db.schemas().keys().toBuffer().sorted(Ordering$.MODULE$.ordered(Predef$.MODULE$.$conforms()));
                schemaNames.foreach((Function1)(JProcedure1 & Serializable)schemaName -> {
                    Schema schema = (Schema)this.db.schemas().apply(schemaName);
                    if (schema.tables().nonEmpty() || schema.sequences().nonEmpty()) {
                        XmlNode schemaNode = schemasNode.createChild("schema", (Seq<Tuple2<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Tuple2$.MODULE$.apply((Object)"name", (Object)this.identifier2String((Identifier)schemaName))}));
                        if (schema.tables().nonEmpty()) {
                            XmlNode tablesNode = schemaNode.createChild("tables", (Seq<Tuple2<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[0]));
                            ((IterableOnceOps)schema.tables().values().toBuffer().sorted(Ordering$.MODULE$.ordered(Predef$.MODULE$.$conforms()))).foreach((Function1)(JProcedure1 & Serializable)table -> this.appendXml((Table)table, tablesNode));
                        }
                    }
                });
            }
            return dbNode.toXml();
        }

        private void appendXml(Table table, XmlNode tablesNode) {
            Object[] objectArray = new Tuple2[1];
            String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"name");
            objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)this.identifier2String(table.name()));
            XmlNode tableNode = tablesNode.createChild("table", (Seq<Tuple2<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
            tableNode.attr("comment", table.commentAndModule());
            XmlNode columnsNode = tableNode.createChild("columns", (Seq<Tuple2<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[0]));
            ListBuffer columns = (ListBuffer)table.columns().sortWith((Function2 & Serializable)(c1, c2) -> {
                boolean bl;
                String string = c1.name().value();
                String string2 = "id";
                if (!(string != null ? !string.equals(string2) : string2 != null)) {
                    bl = true;
                } else {
                    String string3 = c2.name().value();
                    String string4 = "id";
                    bl = !(string3 != null ? !string3.equals(string4) : string4 != null) ? false : c1.name().value().compareTo(c2.name().value()) < 0;
                }
                return bl;
            });
            columns.foreach((Function1 & Serializable)col -> {
                XmlNode colNode = columnsNode.createChild("column", (Seq<Tuple2<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[0]));
                colNode.attr("name", this.identifier2String(col.name()));
                colNode.attr("type", col.sqlType().name());
                if (!col.nullable()) {
                    colNode.attr("nullable", BoxesRunTime.boxToBoolean((boolean)col.nullable()).toString());
                }
                if (col.unique()) {
                    colNode.attr("unique", BoxesRunTime.boxToBoolean((boolean)col.unique()).toString());
                }
                colNode.attr("check", col.check());
                colNode.attr("defaultValue", col.defaultValue());
                return colNode.attr("comment", (Option<String>)col.comment());
            });
            table.primaryKey().foreach((Function1 & Serializable)pk -> {
                XmlNode pkNode = tableNode.createChild("primary-key", (Seq<Tuple2<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[0]));
                if (pk.name() != null && !pk.name().value().isBlank()) {
                    pkNode.attr("name", this.identifier2String(pk.name()));
                }
                return pkNode.attr("columns", this.collectNames((Iterable<Identifier>)pk.columns()));
            });
            if (table.foreignKeys().nonEmpty()) {
                XmlNode fkNodes = tableNode.createChild("foreign-keys", (Seq<Tuple2<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[0]));
                table.foreignKeys().foreach((Function1)(JProcedure1 & Serializable)fk -> {
                    Object[] objectArray = new Tuple2[1];
                    String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"name");
                    objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)this.identifier2String(fk.name()));
                    XmlNode fkNode = fkNodes.createChild("foreign-key", (Seq<Tuple2<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
                    fkNode.attr("column", this.collectNames((Iterable<Identifier>)fk.columns()));
                    fkNode.attr("referenced-table", fk.referencedTable().qualifiedName());
                    fkNode.attr("referenced-column", this.collectNames((Iterable<Identifier>)fk.referencedColumns()));
                    if (fk.cascadeDelete()) {
                        fkNode.attr("cascade-delete", "true");
                    }
                    if (!fk.enabled()) {
                        fkNode.attr("enabled", "false");
                    }
                });
            }
            if (table.uniqueKeys().nonEmpty()) {
                XmlNode ukNodes = tableNode.createChild("unique-keys", (Seq<Tuple2<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[0]));
                table.uniqueKeys().foreach((Function1)(JProcedure1 & Serializable)uk -> {
                    Object[] objectArray = new Tuple2[1];
                    String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"name");
                    objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)this.identifier2String(uk.name()));
                    XmlNode ukNode = ukNodes.createChild("unique-key", (Seq<Tuple2<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
                    ukNode.attr("columns", this.collectNames((Iterable<Identifier>)uk.columns()));
                    if (!uk.enabled()) {
                        ukNode.attr("enabled", BoxesRunTime.boxToBoolean((boolean)uk.enabled()).toString());
                    }
                });
            }
            if (table.indexes().nonEmpty()) {
                XmlNode idxNodes = tableNode.createChild("indexes", (Seq<Tuple2<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[0]));
                table.indexes().foreach((Function1)(JProcedure1 & Serializable)idx -> {
                    Object[] objectArray = new Tuple2[1];
                    String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"name");
                    objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)this.identifier2String(idx.name()));
                    XmlNode idxNode = idxNodes.createChild("index", (Seq<Tuple2<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
                    idxNode.attr("columns", this.collectNames((Iterable<Identifier>)idx.columns()));
                    if (idx.unique()) {
                        idxNode.attr("unique", BoxesRunTime.boxToBoolean((boolean)idx.unique()).toString());
                    }
                });
            }
        }

        public String collectNames(Iterable<Identifier> cols) {
            return ((IterableOnceOps)cols.map((Function1 & Serializable)_$1 -> _$1.toLiteral(this.db.engine()))).mkString(",");
        }

        public String identifier2String(Identifier i) {
            return i.toLiteral(this.db.engine());
        }
    }
}

