/*
 * Decompiled with CFR 0.152.
 */
package org.beangle.data.jdbc.meta;

import java.io.Serializable;
import org.beangle.commons.lang.Strings$;
import org.beangle.data.jdbc.engine.Engine;
import org.beangle.data.jdbc.meta.Column;
import org.beangle.data.jdbc.meta.Column$;
import org.beangle.data.jdbc.meta.Comment;
import org.beangle.data.jdbc.meta.Constraint$;
import org.beangle.data.jdbc.meta.ForeignKey;
import org.beangle.data.jdbc.meta.Identifier;
import org.beangle.data.jdbc.meta.Identifier$;
import org.beangle.data.jdbc.meta.Index;
import org.beangle.data.jdbc.meta.PrimaryKey;
import org.beangle.data.jdbc.meta.Schema;
import org.beangle.data.jdbc.meta.SqlType;
import org.beangle.data.jdbc.meta.Table$;
import org.beangle.data.jdbc.meta.TableRef;
import org.beangle.data.jdbc.meta.UniqueKey;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Some$;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.collection.mutable.ListBuffer;
import scala.math.Ordered;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;

public class Table
implements Ordered<Table>,
Cloneable,
Comment {
    private Option comment;
    private Schema schema;
    private Identifier name;
    private boolean phantom;
    private Option primaryKey;
    private final ListBuffer columns;
    private final ListBuffer uniqueKeys;
    private final ListBuffer foreignKeys;
    private final ListBuffer indexes;
    private Option module;

    public static Table apply(Schema schema, String string) {
        return Table$.MODULE$.apply(schema, string);
    }

    public static String qualify(Schema schema, Identifier identifier) {
        return Table$.MODULE$.qualify(schema, identifier);
    }

    public static String qualify(String string, String string2) {
        return Table$.MODULE$.qualify(string, string2);
    }

    public Table(Schema schema, Identifier name) {
        this.schema = schema;
        this.name = name;
        Ordered.$init$((Ordered)this);
        Comment.$init$(this);
        this.primaryKey = None$.MODULE$;
        this.columns = new ListBuffer();
        this.uniqueKeys = new ListBuffer();
        this.foreignKeys = new ListBuffer();
        this.indexes = new ListBuffer();
        this.module = None$.MODULE$;
    }

    public Option comment() {
        return this.comment;
    }

    public void comment_$eq(Option x$1) {
        this.comment = x$1;
    }

    public Schema schema() {
        return this.schema;
    }

    public void schema_$eq(Schema x$1) {
        this.schema = x$1;
    }

    public Identifier name() {
        return this.name;
    }

    public void name_$eq(Identifier x$1) {
        this.name = x$1;
    }

    public boolean phantom() {
        return this.phantom;
    }

    public void phantom_$eq(boolean x$1) {
        this.phantom = x$1;
    }

    public Option<PrimaryKey> primaryKey() {
        return this.primaryKey;
    }

    public void primaryKey_$eq(Option<PrimaryKey> x$1) {
        this.primaryKey = x$1;
    }

    public ListBuffer<Column> columns() {
        return this.columns;
    }

    public ListBuffer<UniqueKey> uniqueKeys() {
        return this.uniqueKeys;
    }

    public ListBuffer<ForeignKey> foreignKeys() {
        return this.foreignKeys;
    }

    public ListBuffer<Index> indexes() {
        return this.indexes;
    }

    public Option<String> module() {
        return this.module;
    }

    public void module_$eq(Option<String> x$1) {
        this.module = x$1;
    }

    public Engine engine() {
        return this.schema().database().engine();
    }

    public boolean hasQuotedIdentifier() {
        return this.name().quoted() || this.columns().exists((Function1 & Serializable)_$2 -> _$2.name().quoted()) || this.indexes().exists((Function1 & Serializable)_$3 -> _$3.name().quoted()) || this.uniqueKeys().exists((Function1 & Serializable)_$4 -> _$4.name().quoted()) || this.foreignKeys().exists((Function1 & Serializable)_$5 -> _$5.name().quoted());
    }

    public List<String> quotedColumnNames() {
        Engine e = this.engine();
        return this.columns().result().map((Function1 & Serializable)_$6 -> _$6.name().toLiteral(e));
    }

    public String qualifiedName() {
        return Table$.MODULE$.qualify(this.schema(), this.name());
    }

    public Table attach(Engine engine) {
        this.columns().foreach((Function1)(JProcedure1 & Serializable)col -> {
            SqlType st = col.sqlType();
            col.sqlType_$eq(engine.toType(st.code(), BoxesRunTime.unboxToInt((Object)st.precision().getOrElse(Table::attach$$anonfun$6$$anonfun$1)), BoxesRunTime.unboxToInt((Object)st.scale().getOrElse(Table::attach$$anonfun$7$$anonfun$2))));
            col.name_$eq(col.name().attach(engine));
        });
        this.name_$eq(this.name().attach(engine));
        this.primaryKey().foreach((Function1)(JProcedure1 & Serializable)pk -> pk.attach(engine));
        this.foreignKeys().foreach((Function1)(JProcedure1 & Serializable)fk -> fk.attach(engine));
        this.uniqueKeys().foreach((Function1)(JProcedure1 & Serializable)uk -> uk.attach(engine));
        this.indexes().foreach((Function1)(JProcedure1 & Serializable)idx -> idx.attach(engine));
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public Table clone(Schema newschema) {
        void var2_2;
        Table t = this.clone();
        Schema oldSchema = t.schema();
        t.foreignKeys().foreach((Function1)(JProcedure1 & Serializable)fk -> {
            Schema schema = fk.referencedTable().schema();
            Schema schema2 = oldSchema;
            if (!(schema != null ? !schema.equals(schema2) : schema2 != null)) {
                fk.referencedTable().schema_$eq(newschema);
            }
        });
        t.schema_$eq(newschema);
        t.attach(t.engine());
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public Table clone() {
        void var1_1;
        Table tb = new Table(this.schema(), this.name());
        tb.comment_$eq(this.comment());
        tb.module_$eq(this.module());
        this.columns().foreach((Function1 & Serializable)col -> tb.add(col.clone()));
        this.primaryKey().foreach((Function1)(JProcedure1 & Serializable)pk -> {
            PrimaryKey npk = pk.clone();
            npk.table_$eq(tb);
            tb.primaryKey_$eq((Option<PrimaryKey>)Some$.MODULE$.apply((Object)npk));
        });
        this.foreignKeys().foreach((Function1 & Serializable)fk -> tb.add(fk.clone()));
        this.uniqueKeys().foreach((Function1 & Serializable)uk -> tb.add(uk.clone()));
        this.indexes().foreach((Function1 & Serializable)idx -> tb.add(idx.clone()));
        return var1_1;
    }

    public void toCase(boolean lower) {
        this.name_$eq(this.name().toCase(lower));
        this.columns().foreach((Function1)(JProcedure1 & Serializable)col -> col.toCase(lower));
        this.primaryKey().foreach((Function1)(JProcedure1 & Serializable)pk -> pk.toCase(lower));
        this.foreignKeys().foreach((Function1)(JProcedure1 & Serializable)fk -> fk.toCase(lower));
        this.uniqueKeys().foreach((Function1)(JProcedure1 & Serializable)uk -> uk.toCase(lower));
        this.indexes().foreach((Function1)(JProcedure1 & Serializable)idx -> idx.toCase(lower));
    }

    public int compare(Table o) {
        return this.qualifiedName().compareTo(o.qualifiedName());
    }

    private boolean hasPrimaryKey() {
        return this.primaryKey().isDefined();
    }

    public String toString() {
        return Table$.MODULE$.qualify(this.schema(), this.name());
    }

    public Column column(String columnName) {
        return (Column)this.columns().find((Function1 & Serializable)f -> {
            String string = f.name().toLiteral(this.engine());
            String string2 = columnName;
            return !(string != null ? !string.equals(string2) : string2 != null);
        }).get();
    }

    public Option<Column> getColumn(String columnName) {
        return this.columns().find((Function1 & Serializable)f -> {
            String string = f.name().toLiteral(this.engine());
            String string2 = columnName;
            return !(string != null ? !string.equals(string2) : string2 != null);
        });
    }

    public boolean columnExits(Identifier columnName) {
        return this.columns().exists((Function1 & Serializable)f -> {
            Identifier identifier = f.name();
            Identifier identifier2 = columnName;
            return !(identifier != null ? !((Object)identifier).equals(identifier2) : identifier2 != null);
        });
    }

    public Option<ForeignKey> getForeignKey(String keyName) {
        return this.foreignKeys().find((Function1 & Serializable)f -> {
            String string = f.name().toLiteral(this.engine());
            String string2 = keyName;
            return !(string != null ? !string.equals(string2) : string2 != null);
        });
    }

    public Option<UniqueKey> getUniqueKey(String keyName) {
        return this.uniqueKeys().find((Function1 & Serializable)f -> {
            String string = f.name().toLiteral(this.engine());
            String string2 = keyName;
            return !(string != null ? !string.equals(string2) : string2 != null);
        });
    }

    public UniqueKey createUniqueKey(String keyName, Seq<String> columnNames) {
        Engine eng = this.engine();
        UniqueKey uk = new UniqueKey(this, Identifier$.MODULE$.apply("uk_temp", Identifier$.MODULE$.$lessinit$greater$default$2()));
        columnNames.foreach((Function1)(JProcedure1 & Serializable)colName -> uk.addColumn(eng.toIdentifier((String)colName)));
        if (Strings$.MODULE$.isBlank((CharSequence)keyName)) {
            uk.name_$eq(eng.toIdentifier(Constraint$.MODULE$.autoname(uk)));
        } else {
            uk.name_$eq(eng.toIdentifier(keyName));
        }
        this.add(uk);
        return uk;
    }

    public Index createIndex(String indexName, boolean unique, Seq<String> columnNames) {
        Index index = new Index(this, Identifier$.MODULE$.apply("indx_temp", Identifier$.MODULE$.$lessinit$greater$default$2()));
        Engine eng = this.engine();
        columnNames.foreach((Function1)(JProcedure1 & Serializable)colName -> index.addColumn(eng.toIdentifier((String)colName)));
        index.unique_$eq(unique);
        if (Strings$.MODULE$.isBlank((CharSequence)indexName)) {
            index.name_$eq(eng.toIdentifier(Constraint$.MODULE$.autoname(index)));
        } else {
            index.name_$eq(eng.toIdentifier(indexName));
        }
        this.indexes().$plus$eq((Object)index);
        return index;
    }

    public PrimaryKey createPrimaryKey(String keyName, Seq<String> columnNames) {
        PrimaryKey primaryKey;
        Engine egn = this.engine();
        if (columnNames.size() == 1) {
            primaryKey = new PrimaryKey(this, Identifier$.MODULE$.empty(), egn.toIdentifier((String)columnNames.head()));
        } else {
            PrimaryKey pk2 = new PrimaryKey(this, Identifier$.MODULE$.empty(), null);
            columnNames.foreach((Function1)(JProcedure1 & Serializable)cn -> {
                Identifier cnName = egn.toIdentifier((String)cn);
                this.columns().foreach((Function1)(JProcedure1 & Serializable)c -> {
                    Identifier identifier = c.name();
                    Identifier identifier2 = cnName;
                    if (!(identifier != null ? !((Object)identifier).equals(identifier2) : identifier2 != null)) {
                        pk2.addColumn((Column)c);
                    }
                });
            });
            primaryKey = pk2;
        }
        PrimaryKey pk = primaryKey;
        pk.name_$eq(this.engine().toIdentifier(Strings$.MODULE$.isBlank((CharSequence)keyName) ? Constraint$.MODULE$.autoname(pk) : keyName));
        this.primaryKey_$eq((Option<PrimaryKey>)Some$.MODULE$.apply((Object)pk));
        pk.columns().foreach((Function1)(JProcedure1 & Serializable)c -> this.column(c.toLiteral(this.engine())).nullable_$eq(false));
        return pk;
    }

    public ForeignKey createForeignKey(String keyName, String columnName, TableRef refTable, String refencedColumn) {
        Engine eng = this.engine();
        ForeignKey fk = new ForeignKey(this, Identifier$.MODULE$.apply("fk_temp", Identifier$.MODULE$.$lessinit$greater$default$2()), eng.toIdentifier(columnName));
        fk.refer(refTable, (Seq<Identifier>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Identifier[]{eng.toIdentifier(refencedColumn)}));
        fk.name_$eq(Strings$.MODULE$.isNotBlank((CharSequence)keyName) ? this.engine().toIdentifier(keyName) : this.engine().toIdentifier(Constraint$.MODULE$.autoname(fk)));
        return this.add(fk);
    }

    public ForeignKey createForeignKey(String keyName, String columnName, Table refTable) {
        ForeignKey fk;
        Engine eng = this.engine();
        Option<PrimaryKey> option = refTable.primaryKey();
        if (option instanceof Some) {
            PrimaryKey pk = (PrimaryKey)((Some)option).value();
            fk = new ForeignKey(this, Identifier$.MODULE$.apply("fk_temp", Identifier$.MODULE$.$lessinit$greater$default$2()), eng.toIdentifier(columnName));
            fk.refer(refTable, (Seq<Identifier>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Identifier[]{(Identifier)pk.columns().head()}));
            if (Strings$.MODULE$.isBlank((CharSequence)keyName)) {
                fk.name_$eq(eng.toIdentifier(Constraint$.MODULE$.autoname(fk)));
            } else {
                fk.name_$eq(eng.toIdentifier(keyName));
            }
        } else {
            if (None$.MODULE$.equals(option)) {
                throw new RuntimeException("Cannot refer on a table without primary key");
            }
            throw new MatchError(option);
        }
        return this.add(fk);
    }

    public ForeignKey add(ForeignKey key) {
        key.table_$eq(this);
        this.foreignKeys().$plus$eq((Object)key);
        return key;
    }

    public UniqueKey add(UniqueKey key) {
        key.table_$eq(this);
        this.uniqueKeys().$plus$eq((Object)key);
        return key;
    }

    public Column add(Column column) {
        this.columns().find((Function1 & Serializable)_$7 -> {
            Identifier identifier = _$7.name();
            Identifier identifier2 = column.name();
            return !(identifier != null ? !((Object)identifier).equals(identifier2) : identifier2 != null);
        }).foreach((Function1 & Serializable)elem -> this.columns().subtractOne(elem));
        this.columns().$plus$eq((Object)column);
        return column;
    }

    public void add(Seq<Column> cols) {
        cols.foreach((Function1 & Serializable)col -> {
            this.columns().find((Function1 & Serializable)_$8 -> {
                Identifier identifier = _$8.name();
                Identifier identifier2 = col.name();
                return !(identifier != null ? !((Object)identifier).equals(identifier2) : identifier2 != null);
            }).foreach((Function1 & Serializable)elem -> this.columns().subtractOne(elem));
            return (ListBuffer)this.columns().$plus$eq(col);
        });
    }

    public Index add(Index index) {
        index.table_$eq(this);
        this.indexes().$plus$eq((Object)index);
        return index;
    }

    public Column createColumn(String name, SqlType sqlType) {
        Engine egn = this.engine();
        Column col = new Column(egn.toIdentifier(name), sqlType, Column$.MODULE$.$lessinit$greater$default$3());
        this.add(col);
        return col;
    }

    public Column createColumn(String name, String typeName) {
        Engine egn = this.engine();
        Column col = new Column(egn.toIdentifier(name), egn.toType(typeName), Column$.MODULE$.$lessinit$greater$default$3());
        this.add(col);
        return col;
    }

    public Option<Index> getIndex(String indexName) {
        return this.indexes().find((Function1 & Serializable)f -> {
            String string = f.name().value();
            String string2 = indexName;
            return !(string != null ? !string.equals(string2) : string2 != null);
        });
    }

    public void updateSchema(Schema newSchema) {
        Schema oldSchema = this.schema();
        this.schema_$eq(newSchema);
        this.foreignKeys().foreach((Function1)(JProcedure1 & Serializable)fk -> {
            if (fk.referencedTable() != null) {
                Schema schema = fk.referencedTable().schema();
                Schema schema2 = oldSchema;
                if (!(schema != null ? !schema.equals(schema2) : schema2 != null)) {
                    fk.referencedTable().schema_$eq(newSchema);
                }
            }
        });
    }

    public void updateCommentAndModule(String newComment) {
        if (Strings$.MODULE$.isBlank((CharSequence)newComment)) {
            this.comment_$eq((Option)None$.MODULE$);
            this.module_$eq((Option<String>)None$.MODULE$);
        } else if (newComment.contains("@")) {
            this.comment_$eq((Option)Some$.MODULE$.apply((Object)Strings$.MODULE$.substringBefore(newComment, "@")));
            this.module_$eq((Option<String>)Some$.MODULE$.apply((Object)Strings$.MODULE$.substringAfter(newComment, "@")));
        } else {
            this.comment_$eq((Option)Some$.MODULE$.apply((Object)newComment));
            this.module_$eq((Option<String>)None$.MODULE$);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Option<String> commentAndModule() {
        Option option;
        Option option2 = this.comment();
        if (option2 instanceof Some) {
            String c = (String)((Some)option2).value();
            Option<String> option3 = this.module();
            if (option3 instanceof Some) {
                String m = (String)((Some)option3).value();
                option = Some$.MODULE$.apply((Object)(c + "@" + m));
                return option;
            } else {
                if (!None$.MODULE$.equals(option3)) throw new MatchError(option3);
                option = this.comment();
            }
            return option;
        } else {
            if (!None$.MODULE$.equals(option2)) throw new MatchError((Object)option2);
            option = this.comment();
        }
        return option;
    }

    private static final int attach$$anonfun$6$$anonfun$1() {
        return 0;
    }

    private static final int attach$$anonfun$7$$anonfun$2() {
        return 0;
    }
}

