/*
 * Decompiled with CFR 0.152.
 */
package org.beangle.data.jdbc.query;

import java.io.Serializable;
import java.sql.BatchUpdateException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.beangle.commons.collection.page.PageLimit;
import org.beangle.commons.lang.Strings$;
import org.beangle.commons.logging.Logging;
import org.beangle.data.jdbc.DefaultSqlTypeMapping;
import org.beangle.data.jdbc.engine.Engine;
import org.beangle.data.jdbc.engine.Engines$;
import org.beangle.data.jdbc.query.JdbcExecutor$;
import org.beangle.data.jdbc.query.ParamSetter$;
import org.beangle.data.jdbc.query.ResultSetIterator;
import org.beangle.data.jdbc.query.Statement;
import org.beangle.data.jdbc.query.TypeParamSetter$;
import org.slf4j.Logger;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.collection.Seq;
import scala.collection.SeqOps;
import scala.collection.immutable.ArraySeq;
import scala.collection.immutable.ArraySeq$;
import scala.collection.immutable.List;
import scala.collection.mutable.ListBuffer;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.function.JProcedure1;
import scala.runtime.java8.JFunction1;

public class JdbcExecutor
implements Logging {
    private Logger logger;
    private final DataSource dataSource;
    private final Engine engine;
    private final DefaultSqlTypeMapping sqlTypeMapping;
    private boolean showSql;
    private int fetchSize;

    public static Object[] convert(ResultSet resultSet, int[] nArray) {
        return JdbcExecutor$.MODULE$.convert(resultSet, nArray);
    }

    public JdbcExecutor(DataSource dataSource) {
        this.dataSource = dataSource;
        Logging.$init$((Logging)this);
        this.engine = Engines$.MODULE$.forDataSource(dataSource);
        this.sqlTypeMapping = new DefaultSqlTypeMapping(this.engine);
        this.showSql = false;
        this.fetchSize = 1000;
        Statics.releaseFence();
    }

    public Logger logger() {
        return this.logger;
    }

    public void org$beangle$commons$logging$Logging$_setter_$logger_$eq(Logger x$0) {
        this.logger = x$0;
    }

    public DefaultSqlTypeMapping sqlTypeMapping() {
        return this.sqlTypeMapping;
    }

    public boolean showSql() {
        return this.showSql;
    }

    public void showSql_$eq(boolean x$1) {
        this.showSql = x$1;
    }

    public int fetchSize() {
        return this.fetchSize;
    }

    public void fetchSize_$eq(int x$1) {
        this.fetchSize = x$1;
    }

    public <T> Option<T> unique(String sql, scala.collection.immutable.Seq<Object> params) {
        None$ none$;
        Seq<Object[]> rs = this.query(sql, params);
        if (rs.isEmpty()) {
            none$ = None$.MODULE$;
        } else {
            Object[] o = (Object[])rs.head();
            Object object = Predef$.MODULE$.genericArrayOps((Object)o);
            none$ = Some$.MODULE$.apply(ArrayOps$.MODULE$.head$extension(object));
        }
        return none$;
    }

    public Option<Object> queryForInt(String sql) {
        None$ none$;
        Option num = this.unique(sql, (scala.collection.immutable.Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[0]));
        Option option = num;
        if (option instanceof Some) {
            Number n = (Number)((Some)option).value();
            none$ = Some$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)n.intValue()));
        } else if (None$.MODULE$.equals(option)) {
            none$ = None$.MODULE$;
        } else {
            throw new MatchError(option);
        }
        return none$;
    }

    public Option<Object> queryForLong(String sql) {
        None$ none$;
        Option num = this.unique(sql, (scala.collection.immutable.Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[0]));
        Option option = num;
        if (option instanceof Some) {
            Number n = (Number)((Some)option).value();
            none$ = Some$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)n.longValue()));
        } else if (None$.MODULE$.equals(option)) {
            none$ = None$.MODULE$;
        } else {
            throw new MatchError(option);
        }
        return none$;
    }

    public <T> T useConnection(Function1<Connection, T> f) {
        Object object;
        try (Connection conn = this.dataSource.getConnection();){
            object = f.apply((Object)conn);
        }
        return (T)object;
    }

    public Statement statement(String sql) {
        return new Statement(sql, this);
    }

    public ResultSetIterator iterate(String sql, scala.collection.immutable.Seq<Object> params) {
        if (this.showSql()) {
            Predef$.MODULE$.println((Object)("JdbcExecutor:" + sql));
        }
        Connection conn = this.dataSource.getConnection();
        conn.setAutoCommit(false);
        PreparedStatement stmt = conn.prepareStatement(sql);
        stmt.setFetchSize(this.fetchSize());
        TypeParamSetter$.MODULE$.apply(this.sqlTypeMapping(), (Seq<Object>)params).apply(stmt);
        ResultSet rs = stmt.executeQuery();
        return new ResultSetIterator(rs);
    }

    public Seq<Object[]> query(String sql, scala.collection.immutable.Seq<Object> params) {
        return this.query(sql, TypeParamSetter$.MODULE$.apply(this.sqlTypeMapping(), (Seq<Object>)params));
    }

    public Seq<Object[]> query(String sql, Function1<PreparedStatement, BoxedUnit> setter) {
        if (this.showSql()) {
            Predef$.MODULE$.println((Object)("JdbcExecutor:" + sql));
        }
        return (Seq)this.useConnection((Function1 & Serializable)conn -> {
            PreparedStatement stmt = conn.prepareStatement(sql);
            setter.apply((Object)stmt);
            return new ResultSetIterator(stmt.executeQuery()).listAll();
        });
    }

    public Seq<Object[]> fetch(String sql, PageLimit limit, scala.collection.immutable.Seq<Object> params) {
        return this.fetch(sql, limit, TypeParamSetter$.MODULE$.apply(this.sqlTypeMapping(), (Seq<Object>)params));
    }

    public Seq<Object[]> fetch(String sql, PageLimit limit, Function1<PreparedStatement, BoxedUnit> setter) {
        Tuple2<String, List<Object>> rs = this.engine.limit(sql, limit.pageSize() * (limit.pageIndex() - 1), limit.pageSize());
        if (this.showSql()) {
            Predef$.MODULE$.println((Object)("JdbcExecutor:" + rs._1()));
        }
        return (Seq)this.useConnection((Function1 & Serializable)conn -> {
            PreparedStatement stmt = conn.prepareStatement((String)rs._1());
            setter.apply((Object)stmt);
            IntRef start = IntRef.create((int)(stmt.getParameterMetaData().getParameterCount() - ((SeqOps)rs._2()).size()));
            ((List)rs._2()).foreach((Function1)(JFunction1.mcVI.sp & Serializable)i -> {
                int n;
                stmt.setInt(start$1.elem + 1, i);
                start$1.elem = n = start$1.elem + 1;
            });
            return new ResultSetIterator(stmt.executeQuery()).listAll();
        });
    }

    public int update(String sql, scala.collection.immutable.Seq<Object> params) {
        return this.update(sql, TypeParamSetter$.MODULE$.apply(this.sqlTypeMapping(), (Seq<Object>)params));
    }

    public int update(String sql, Function1<PreparedStatement, BoxedUnit> setter) {
        if (this.showSql()) {
            Predef$.MODULE$.println((Object)("JdbcExecutor:" + sql));
        }
        PreparedStatement stmt = null;
        Connection conn = this.dataSource.getConnection();
        if (conn.getAutoCommit()) {
            conn.setAutoCommit(false);
        }
        int rows = 0;
        try {
            try {
                stmt = conn.prepareStatement(sql);
                setter.apply((Object)stmt);
                rows = stmt.executeUpdate();
                stmt.close();
                stmt = null;
                conn.commit();
            }
            catch (SQLException e) {
                conn.rollback();
                this.rethrow(e, sql, (scala.collection.immutable.Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[0]));
            }
        }
        finally {
            if (stmt != null) {
                stmt.close();
            }
            conn.close();
        }
        return rows;
    }

    public scala.collection.immutable.Seq<Object> batch(String sql, Seq<Object> datas, Seq<Object> types) {
        if (this.showSql()) {
            Predef$.MODULE$.println((Object)("JdbcExecutor:" + sql));
        }
        ObjectRef stmt = ObjectRef.create(null);
        Connection conn = this.dataSource.getConnection();
        if (conn.getAutoCommit()) {
            conn.setAutoCommit(false);
        }
        ListBuffer rows = new ListBuffer();
        ObjectRef curParam = ObjectRef.create(null);
        try {
            try {
                PreparedStatement preparedStatement = conn.prepareStatement(sql);
                stmt.elem = preparedStatement;
                datas.foreach((Function1)(JProcedure1 & Serializable)param -> {
                    ArraySeq arraySeq = ArraySeq$.MODULE$.unsafeWrapArray(param);
                    curParam$1.elem = arraySeq;
                    ParamSetter$.MODULE$.setParams((PreparedStatement)stmt$2.elem, (Seq<Object>)Predef$.MODULE$.genericWrapArray(param), types);
                    ((PreparedStatement)stmt$2.elem).addBatch();
                });
                rows.$plus$plus$eq((IterableOnce)Predef$.MODULE$.wrapIntArray(((PreparedStatement)stmt.elem).executeBatch()));
                conn.commit();
            }
            catch (BatchUpdateException be) {
                conn.rollback();
                this.rethrow(be.getNextException(), sql, (scala.collection.immutable.Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{(scala.collection.immutable.Seq)curParam.elem}));
            }
            catch (SQLException e) {
                conn.rollback();
                this.rethrow(e, sql, (scala.collection.immutable.Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{(scala.collection.immutable.Seq)curParam.elem}));
            }
        }
        finally {
            ((PreparedStatement)stmt.elem).close();
            conn.close();
        }
        return rows.toList();
    }

    public void rethrow(SQLException cause, String sql, scala.collection.immutable.Seq<Object> params) {
        String causeMessage = cause.getMessage();
        if (causeMessage == null) {
            causeMessage = "";
        }
        StringBuffer msg = new StringBuffer(causeMessage);
        msg.append(" Query: ").append(sql).append(" Parameters: ");
        StringBuffer stringBuffer = params == null ? msg.append("[]") : msg.append(Strings$.MODULE$.join(params, ","));
        SQLException e = new SQLException(msg.toString(), cause.getSQLState(), cause.getErrorCode());
        e.setNextException(cause);
        throw e;
    }
}

